/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.check.service.impl;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.workflow.engine.bpm.check.model.ProcessCheckResult;
import com.jxdinfo.hussar.workflow.engine.bpm.check.service.ProcessCheckService;
import com.jxdinfo.hussar.workflow.engine.bpm.check.util.ParallelRelationshipCheckUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmFormdesignProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.BpmWorkflowTranslateUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.WorkFlow;
import com.jxdinfo.hussar.workflow.engine.bpm.translate.util.BpmTranslateUtil;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import com.jxdinfo.hussar.workflow.engine.flowmodel.BpmNodeTypeUtil;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowModel;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowObject;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowVariables;
import com.jxdinfo.hussar.workflow.engine.flowmodel.enums.BpmNodeTypeEnum;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.util.FormBpmnUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.runtime.Execution;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class ProcessCheckServiceImpl
implements ProcessCheckService {
    @Autowired
    private LcdpBpmProperties lcdpBpmProperties;
    @Resource
    private RuntimeService runtimeService;
    @Resource
    private HistoryService historyService;
    @Autowired
    private BpmFormdesignProperties bpmFormdesignProperties;
    @Autowired
    private BpmConstantProperties bpmConstantProperties;
    private static final List<String> CHECK_VARIABLE_NODE_TYPE_LIST = new ArrayList<String>();
    private static final List<String> CHECK_CHANGE_NODE_TYPE_LIST = new ArrayList<String>();
    public static final String GOD_AXE_CHECK = "0";
    public static final String BPM_DESIGNER_CHECK = "1";
    public static final String NO_CODE_CHECK = "2";
    public static final String IMPORT_CHECK = "3";
    private static final Map<String, Set<String>> checkMap = new HashMap<String, Set<String>>();
    private static final String VARIABLE_CHECK = "VARIABLE_CHECK";
    private static final String BPM_DESIGN_VARIABLE_CHECK = "BPM_DESIGN_VARIABLE_CHECK";
    private static final String PARALLEL_RELATIONSHIP_CHECK = "PARALLEL_RELATIONSHIP_CHECK";
    private static final String RUNNING_TASK_CHANGE_CHECK = "RUNNING_TASK_CHANGE_CHECK";

    public ApiResponse<String> checkWorkflow(WorkFlow workFlow, WorkFlow oldWorkFlow, String checkType) {
        ApiResponse<String> response;
        if (this.runtimeService.createProcessInstanceQuery().processDefinitionId(oldWorkFlow.getProcDefId()).count() == 0L) {
            ProcessCheckResult processCheckResult;
            if ((checkMap.get(checkType).contains(BPM_DESIGN_VARIABLE_CHECK) && "base".equals(this.lcdpBpmProperties.getTenantType()) || checkMap.get(checkType).contains(VARIABLE_CHECK)) && (processCheckResult = this.getProcessCheckResult(workFlow, oldWorkFlow, null, checkType)).isUserNewVariable()) {
                return ApiResponse.fail((int)BpmExceptionCodeEnum.UPDATE_PROCESS_WITH_VARIABLES.getCode(), (String)BpmExceptionCodeEnum.UPDATE_PROCESS_WITH_VARIABLES.getMessage());
            }
            return ApiResponse.success((String)BpmTranslateUtil.getResponseSuccess());
        }
        Map<String, Set<String>> runningNodeProcessCountMsg = null;
        if (checkMap.get(checkType).contains(RUNNING_TASK_CHANGE_CHECK)) {
            runningNodeProcessCountMsg = this.getRunningNodeProcessCountMsg(oldWorkFlow.getProcDefId());
        }
        if (checkMap.get(checkType).contains(PARALLEL_RELATIONSHIP_CHECK) && !(response = this.checkPrallelRelationShip(workFlow, oldWorkFlow)).isSuccess()) {
            return response;
        }
        if (checkMap.get(checkType).contains(RUNNING_TASK_CHANGE_CHECK) || checkMap.get(checkType).contains(VARIABLE_CHECK) || checkMap.get(checkType).contains(BPM_DESIGN_VARIABLE_CHECK)) {
            ProcessCheckResult processCheckResult = this.getProcessCheckResult(workFlow, oldWorkFlow, runningNodeProcessCountMsg, checkType);
            if (processCheckResult.getErrorProcessInstance() > 0) {
                StringBuilder stringBuilder = new StringBuilder();
                StringBuilder chageAndDeleteStringBuilder = new StringBuilder();
                Map errorNodeNameMap = processCheckResult.getErrorNodeNameMap();
                Map deleteNodeMap = processCheckResult.getDeleteNodeMap();
                Integer errorProcessInstance = processCheckResult.getErrorProcessInstance();
                for (String key : deleteNodeMap.keySet()) {
                    chageAndDeleteStringBuilder.append(String.format(this.bpmConstantProperties.getDeleteNodeAffectProcess(), HussarUtils.isNotEmpty(errorNodeNameMap.get(key)) ? errorNodeNameMap.get(key) : key, errorProcessInstance));
                }
                Map changeNodeMap = processCheckResult.getChangeNodeMap();
                for (String key : changeNodeMap.keySet()) {
                    chageAndDeleteStringBuilder.append(String.format(this.bpmConstantProperties.getChangeNodeAffectProcess(), HussarUtils.isNotEmpty(errorNodeNameMap.get(key)) ? errorNodeNameMap.get(key) : key, errorProcessInstance));
                }
                if (IMPORT_CHECK.equals(checkType)) {
                    stringBuilder.append(String.format(this.bpmConstantProperties.getImportAffectedProcess(), errorProcessInstance));
                }
                stringBuilder.append((CharSequence)chageAndDeleteStringBuilder);
                return ApiResponse.fail((String)stringBuilder.toString());
            }
            if (processCheckResult.isUserNewVariable()) {
                return ApiResponse.fail((int)BpmExceptionCodeEnum.UPDATE_PROCESS_WITH_VARIABLES.getCode(), (String)BpmExceptionCodeEnum.UPDATE_PROCESS_WITH_VARIABLES.getMessage());
            }
        }
        return ApiResponse.success((String)BpmTranslateUtil.getResponseSuccess());
    }

    private ApiResponse<String> checkPrallelRelationShip(WorkFlow workFlow, WorkFlow oldWorkFlow) {
        FlowModel flowModel = (FlowModel)JSON.parseObject((String)workFlow.getData(), FlowModel.class);
        FlowModel oldFlowModel = (FlowModel)JSON.parseObject((String)oldWorkFlow.getData(), FlowModel.class);
        ApiResponse<String> response = ParallelRelationshipCheckUtil.checkWorkflowNodes(flowModel.getSlots(), oldFlowModel.getSlots());
        if (!response.isSuccess()) {
            return response;
        }
        for (FlowObject flowObject : flowModel.getSlots().getElement()) {
            if (!BpmNodeTypeUtil.isSubProcess((String)flowObject.getName())) continue;
            FlowObject oldSubProcess = null;
            for (FlowObject object : oldFlowModel.getSlots().getElement()) {
                if (!flowObject.getId().equals(object.getId())) continue;
                oldSubProcess = object;
                break;
            }
            if (oldSubProcess == null || (response = ParallelRelationshipCheckUtil.checkWorkflowNodes(flowObject.getSlots(), oldSubProcess.getSlots())).isSuccess()) continue;
            return response;
        }
        return response;
    }

    private ProcessCheckResult getProcessCheckResult(WorkFlow workFlow, WorkFlow oldWorkFlow, Map<String, Set<String>> runningNodeProcessCountMsg, String checkType) {
        ProcessCheckResult result = new ProcessCheckResult();
        FlowModel flowModel = (FlowModel)JSON.parseObject((String)workFlow.getData(), FlowModel.class);
        FlowModel oldFlowModel = (FlowModel)JSON.parseObject((String)oldWorkFlow.getData(), FlowModel.class);
        HashMap<String, FlowObject> nodeMap = new HashMap<String, FlowObject>();
        List elements = flowModel.getSlots().getElement();
        for (FlowObject flowObject : elements) {
            nodeMap.put(flowObject.getId(), flowObject);
            if (!BpmNodeTypeUtil.isSubProcess((String)flowObject.getName())) continue;
            List subProcessNodeList = flowObject.getSlots().getElement();
            Iterator iterator = subProcessNodeList.iterator();
            while (iterator.hasNext()) {
                FlowObject subProcessNode = (FlowObject)iterator.next();
                nodeMap.put(subProcessNode.getId(), subProcessNode);
            }
        }
        HashMap<String, FlowObject> oldNodeMap = new HashMap<String, FlowObject>();
        List oldElements = oldFlowModel.getSlots().getElement();
        for (FlowObject flowObject : oldElements) {
            oldNodeMap.put(flowObject.getId(), flowObject);
            if (!BpmNodeTypeUtil.isSubProcess((String)flowObject.getName())) continue;
            List subProcessNodeList = flowObject.getSlots().getElement();
            for (FlowObject flowObject2 : subProcessNodeList) {
                oldNodeMap.put(flowObject2.getId(), flowObject2);
            }
        }
        if (checkMap.get(checkType).contains(RUNNING_TASK_CHANGE_CHECK) && runningNodeProcessCountMsg != null) {
            HashSet<String> errorProcessInstance = new HashSet<String>();
            HashSet<String> translateIds = new HashSet<String>();
            boolean needTranslate = BpmWorkflowTranslateUtil.getIsEnable();
            for (String string : runningNodeProcessCountMsg.keySet()) {
                Set<String> errorProcessInsIds;
                FlowObject oldFlowObject = (FlowObject)oldNodeMap.get(string);
                FlowObject newFlowObject = (FlowObject)nodeMap.get(string);
                if (oldFlowObject == null) continue;
                if (newFlowObject == null) {
                    errorProcessInsIds = runningNodeProcessCountMsg.get(oldFlowObject.getId());
                    errorProcessInstance.addAll(errorProcessInsIds);
                    result.getDeleteNodeMap().put(oldFlowObject.getId(), errorProcessInsIds.size());
                    if (needTranslate && HussarUtils.isNotEmpty((Object)oldFlowObject.getProps().getNodeNameTranslateId())) {
                        translateIds.add(oldFlowObject.getProps().getNodeNameTranslateId());
                        result.getErrorNodeNameMap().put(oldFlowObject.getId(), oldFlowObject.getProps().getNodeNameTranslateId());
                        continue;
                    }
                    result.getErrorNodeNameMap().put(oldFlowObject.getId(), oldFlowObject.getProps().getFlowName());
                    continue;
                }
                if (oldFlowObject.getProps().getFlowCountersign() == null || oldFlowObject.getProps().getFlowCountersign().isCountersign() == newFlowObject.getProps().getFlowCountersign().isCountersign()) continue;
                errorProcessInsIds = runningNodeProcessCountMsg.get(oldFlowObject.getId());
                errorProcessInstance.addAll(errorProcessInsIds);
                result.getChangeNodeMap().put(oldFlowObject.getId(), errorProcessInsIds.size());
                if (needTranslate && HussarUtils.isNotEmpty((Object)oldFlowObject.getProps().getNodeNameTranslateId())) {
                    translateIds.add(oldFlowObject.getProps().getNodeNameTranslateId());
                    result.getErrorNodeNameMap().put(oldFlowObject.getId(), oldFlowObject.getProps().getNodeNameTranslateId());
                    continue;
                }
                result.getErrorNodeNameMap().put(oldFlowObject.getId(), oldFlowObject.getProps().getFlowName());
            }
            if (needTranslate && !translateIds.isEmpty()) {
                Map translateMap = BpmWorkflowTranslateUtil.getTranslateNameMap(new ArrayList(translateIds));
                for (Object nodeId : result.getErrorNodeNameMap().keySet()) {
                    if (translateMap.get(result.getErrorNodeNameMap().get(nodeId)) == null) continue;
                    result.getErrorNodeNameMap().put(nodeId, translateMap.get(result.getErrorNodeNameMap().get(nodeId)));
                }
            }
            result.setErrorProcessInstance(Integer.valueOf(errorProcessInstance.size()));
        }
        if (checkMap.get(checkType).contains(BPM_DESIGN_VARIABLE_CHECK) && "base".equals(this.lcdpBpmProperties.getTenantType()) || checkMap.get(checkType).contains(VARIABLE_CHECK)) {
            Set<String> nodeVariableNames;
            String newTableName = null;
            HashSet<String> processVariableNames = new HashSet<String>();
            HashMap nodeVariableMap = new HashMap();
            HashMap<String, String> callActivityTables = new HashMap<String, String>();
            List list = flowModel.getProps().getUseVariables();
            if (list != null) {
                for (FlowVariables flowVariables : list) {
                    processVariableNames.add(flowVariables.getVariable());
                    if (newTableName != null || flowVariables.getTable() == null) continue;
                    newTableName = flowVariables.getTable();
                }
            }
            for (FlowObject flowObject : nodeMap.values()) {
                if (!CHECK_VARIABLE_NODE_TYPE_LIST.contains(flowObject.getName())) continue;
                HashSet<String> nodeVariableNames2 = new HashSet<String>();
                ArrayList<FlowVariables> functionUserVariables = new ArrayList<FlowVariables>();
                FormBpmnUtil.getFunctionMessage(flowObject.getProps(), new HashMap<String, String>(), functionUserVariables);
                ArrayList<FlowVariables> nodeVariables = flowObject.getProps().getUseVariables();
                if (nodeVariables == null) {
                    nodeVariables = new ArrayList<FlowVariables>();
                }
                nodeVariables.addAll(functionUserVariables);
                for (FlowVariables flowVariables : nodeVariables) {
                    nodeVariableNames2.add(flowVariables.getVariable());
                    if (newTableName != null || flowVariables.getTable() == null) continue;
                    newTableName = flowVariables.getTable();
                }
                nodeVariableNames2.addAll(processVariableNames);
                if (!nodeVariableNames2.isEmpty()) {
                    nodeVariableMap.put(flowObject.getId(), nodeVariableNames2);
                }
                if (!BpmNodeTypeUtil.isCallActivity((String)flowObject.getName())) continue;
                callActivityTables.put(flowObject.getId(), flowObject.getProps().getCallActivityTable() != null ? flowObject.getProps().getCallActivityTable().getTableId() : "");
            }
            String oldTableName = null;
            HashSet<String> oldProcessVariableNames = new HashSet<String>();
            HashMap<String, Set<String>> oldNodeVariableMap = new HashMap<String, Set<String>>();
            HashMap<String, String> oldCallActivityTables = new HashMap<String, String>();
            List oldProcessVariables = oldFlowModel.getProps().getUseVariables();
            if (oldProcessVariables != null) {
                for (FlowVariables flowVariables : oldProcessVariables) {
                    oldProcessVariableNames.add(flowVariables.getVariable());
                    if (oldTableName != null || flowVariables.getTable() == null) continue;
                    oldTableName = flowVariables.getTable();
                }
            }
            for (FlowObject flowObject : oldNodeMap.values()) {
                if (!CHECK_VARIABLE_NODE_TYPE_LIST.contains(flowObject.getName())) continue;
                nodeVariableNames = new HashSet();
                ArrayList<FlowVariables> functionUserVariables = new ArrayList<FlowVariables>();
                FormBpmnUtil.getFunctionMessage(flowObject.getProps(), new HashMap<String, String>(), functionUserVariables);
                ArrayList<FlowVariables> nodeVariables = flowObject.getProps().getUseVariables();
                if (nodeVariables == null) {
                    nodeVariables = new ArrayList<FlowVariables>();
                }
                nodeVariables.addAll(functionUserVariables);
                for (FlowVariables flowVariables : nodeVariables) {
                    nodeVariableNames.add(flowVariables.getVariable());
                    if (oldTableName != null || flowVariables.getTable() == null) continue;
                    oldTableName = flowVariables.getTable();
                }
                nodeVariableNames.addAll(oldProcessVariableNames);
                if (!nodeVariableNames.isEmpty()) {
                    oldNodeVariableMap.put(flowObject.getId(), nodeVariableNames);
                }
                if (!BpmNodeTypeUtil.isCallActivity((String)flowObject.getName())) continue;
                oldCallActivityTables.put(flowObject.getId(), flowObject.getProps().getCallActivityTable() != null ? flowObject.getProps().getCallActivityTable().getTableId() : "");
            }
            if (newTableName != null && !newTableName.equals(oldTableName)) {
                result.setUserNewVariable(true);
                return result;
            }
            if (checkMap.get(checkType).contains(VARIABLE_CHECK)) {
                for (String nodeId : callActivityTables.keySet()) {
                    if (((String)callActivityTables.get(nodeId)).equals(oldCallActivityTables.get(nodeId))) continue;
                    result.setUserNewVariable(true);
                    return result;
                }
            }
            for (String nodeId : nodeVariableMap.keySet()) {
                if (this.bpmFormdesignProperties.getOfflineLr().booleanValue()) {
                    if (oldNodeVariableMap.get(nodeId) != null) continue;
                    result.setUserNewVariable(true);
                    return result;
                }
                nodeVariableNames = (Set)nodeVariableMap.get(nodeId);
                nodeVariableNames.removeAll(oldNodeVariableMap.get(nodeId) != null ? (Collection)oldNodeVariableMap.get(nodeId) : new HashSet());
                if (nodeVariableNames.isEmpty()) continue;
                result.setUserNewVariable(true);
                return result;
            }
        }
        return result;
    }

    private Map<String, Set<String>> getRunningNodeProcessCountMsg(String procDefId) {
        List list = this.runtimeService.createExecutionQuery().processDefinitionId(procDefId).list();
        HashMap<String, Set<String>> runningNodeProcessCountMsg = new HashMap<String, Set<String>>();
        List historicList = this.historyService.createHistoricProcessInstanceQuery().isEmulation(BPM_DESIGNER_CHECK).processDefinitionId(procDefId).list();
        HashSet<String> executionIdsToRemove = new HashSet<String>();
        block0: for (Execution execution2 : list) {
            for (HistoricProcessInstance historicProcessInstance : historicList) {
                if (!historicProcessInstance.getId().equals(execution2.getProcessInstanceId())) continue;
                executionIdsToRemove.add(execution2.getId());
                continue block0;
            }
        }
        list.removeIf(execution -> executionIdsToRemove.contains(execution.getId()));
        for (Execution execution2 : list) {
            if (execution2.getActivityId() == null) continue;
            runningNodeProcessCountMsg.computeIfAbsent(execution2.getActivityId(), k -> new HashSet()).add(execution2.getProcessInstanceId());
        }
        return runningNodeProcessCountMsg;
    }

    static {
        CHECK_VARIABLE_NODE_TYPE_LIST.add(BpmNodeTypeEnum.BPM_USER.getType());
        CHECK_VARIABLE_NODE_TYPE_LIST.add(BpmNodeTypeEnum.BPM_CALL_ACTIVITY.getType());
        CHECK_VARIABLE_NODE_TYPE_LIST.add(BpmNodeTypeEnum.BPM_SUB_PROCESS.getType());
        CHECK_CHANGE_NODE_TYPE_LIST.add(BpmNodeTypeEnum.BPM_USER.getType());
        CHECK_CHANGE_NODE_TYPE_LIST.add(BpmNodeTypeEnum.BPM_CALL_ACTIVITY.getType());
        CHECK_CHANGE_NODE_TYPE_LIST.add(BpmNodeTypeEnum.BPM_SUB_PROCESS.getType());
        CHECK_VARIABLE_NODE_TYPE_LIST.add(BpmNodeTypeEnum.BPM_USER.getVisitType());
        CHECK_VARIABLE_NODE_TYPE_LIST.add(BpmNodeTypeEnum.BPM_CALL_ACTIVITY.getVisitType());
        CHECK_VARIABLE_NODE_TYPE_LIST.add(BpmNodeTypeEnum.BPM_SUB_PROCESS.getVisitType());
        CHECK_CHANGE_NODE_TYPE_LIST.add(BpmNodeTypeEnum.BPM_USER.getVisitType());
        CHECK_CHANGE_NODE_TYPE_LIST.add(BpmNodeTypeEnum.BPM_CALL_ACTIVITY.getVisitType());
        CHECK_CHANGE_NODE_TYPE_LIST.add(BpmNodeTypeEnum.BPM_SUB_PROCESS.getVisitType());
        HashSet<String> godAxeCheck = new HashSet<String>();
        godAxeCheck.add(VARIABLE_CHECK);
        godAxeCheck.add(PARALLEL_RELATIONSHIP_CHECK);
        godAxeCheck.add(RUNNING_TASK_CHANGE_CHECK);
        checkMap.put(GOD_AXE_CHECK, godAxeCheck);
        HashSet<String> bpmDesignCheck = new HashSet<String>();
        bpmDesignCheck.add(BPM_DESIGN_VARIABLE_CHECK);
        bpmDesignCheck.add(PARALLEL_RELATIONSHIP_CHECK);
        bpmDesignCheck.add(RUNNING_TASK_CHANGE_CHECK);
        checkMap.put(BPM_DESIGNER_CHECK, bpmDesignCheck);
        HashSet<String> noCodeCheck = new HashSet<String>();
        noCodeCheck.add(PARALLEL_RELATIONSHIP_CHECK);
        noCodeCheck.add(RUNNING_TASK_CHANGE_CHECK);
        checkMap.put(NO_CODE_CHECK, noCodeCheck);
        HashSet<String> importCheck = new HashSet<String>();
        importCheck.add(PARALLEL_RELATIONSHIP_CHECK);
        importCheck.add(RUNNING_TASK_CHANGE_CHECK);
        checkMap.put(IMPORT_CHECK, importCheck);
    }
}

