/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.wfdtoprocess.visitor;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowModel;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowObject;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowPageMsg;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowProps;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowSequence;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowVariables;
import com.jxdinfo.hussar.workflow.engine.flowmodel.MultiUser;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.util.FormBpmnUtil;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.visitor.FormObjectVisitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.Activity;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowElementsContainer;
import org.activiti.bpmn.model.MultiInstanceLoopCharacteristics;
import org.activiti.bpmn.model.UserTask;
import org.springframework.stereotype.Component;

@Component(value="com.jxdinfo.workflow.User")
public class UserTaskVisitor
implements FormObjectVisitor {
    @Override
    public void visit(FlowObject flowObject, FlowElementsContainer process, FlowModel flowModel, FlowObject processModel) {
        String dueDate;
        UserTask userTask = new UserTask();
        FlowProps flowProps = flowObject.getProps();
        userTask.setName(flowProps.getFlowName());
        userTask.setId(flowObject.getId());
        userTask.setDocumentation(flowProps.getFlowDescription());
        Map jsonObject = flowProps.getFormAddress();
        if (jsonObject != null) {
            JSONObject object = new JSONObject();
            for (Map.Entry entry : jsonObject.entrySet()) {
                FlowPageMsg value = (FlowPageMsg)entry.getValue();
                if (value == null) continue;
                object.put((String)entry.getKey(), (Object)value.getUrl());
            }
            userTask.setFormKey(JSON.toJSONString((Object)object));
        }
        if (HussarUtils.isNotEmpty((Object)(dueDate = flowProps.getDueDate()))) {
            userTask.setDueDate(dueDate);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        ArrayList<FlowVariables> functionUserVariables = new ArrayList<FlowVariables>();
        FormBpmnUtil.getFunctionMessage(flowObject.getProps(), map, functionUserVariables);
        FormBpmnUtil.assigneeInstall(flowObject, (Activity)userTask, map);
        FormBpmnUtil.ccInstall(flowObject, (Activity)userTask, map);
        FormBpmnUtil.extendHandle(flowObject, userTask);
        if (HussarUtils.isNotEmpty((Object)flowObject.getProps().getFlowCountersign())) {
            this.counterSign(flowObject, userTask);
        }
        ArrayList<String> pathIds = new ArrayList<String>();
        List flowSequences = processModel.getSlots().getPath();
        for (FlowSequence flowSequence : flowSequences) {
            pathIds.add(flowSequence.getId());
        }
        FormBpmnUtil.addTaskListener(userTask, flowObject);
        ArrayList<FlowVariables> useVariables = flowProps.getUseVariables();
        List modelUseVariables = flowModel.getProps().getUseVariables();
        boolean flag = false;
        if (HussarUtils.isNotEmpty((Object)modelUseVariables)) {
            flag = true;
        }
        if (HussarUtils.isEmpty((Object)useVariables)) {
            useVariables = new ArrayList<FlowVariables>();
        }
        if (HussarUtils.isNotEmpty(functionUserVariables)) {
            useVariables.addAll(functionUserVariables);
        }
        FormBpmnUtil.addExeListener((FlowElement)userTask, useVariables, pathIds, flag);
        FormBpmnUtil.addExecutionListener((Activity)userTask, flowObject);
        process.addFlowElement((FlowElement)userTask);
    }

    private void counterSign(FlowObject flowObject, UserTask userTask) {
        MultiUser multiUser = flowObject.getProps().getFlowCountersign();
        if (multiUser.isCountersign()) {
            MultiInstanceLoopCharacteristics multiInstanceLoopCharacteristics = new MultiInstanceLoopCharacteristics();
            multiInstanceLoopCharacteristics.setSequential(false);
            multiInstanceLoopCharacteristics.setInputDataItem("multi");
            if ("radio".equals(multiUser.getCountersignType())) {
                multiInstanceLoopCharacteristics.setCompletionCondition("${nrOfCompletedInstances/nrOfInstances >= " + multiUser.getCountersignNumByRatio() / 100.0 + " }");
            }
            if ("count".equals(multiUser.getCountersignType())) {
                multiInstanceLoopCharacteristics.setCompletionCondition("${nrOfCompletedInstances == " + multiUser.getCountersignNumByCount() + " }");
            }
            userTask.setLoopCharacteristics(multiInstanceLoopCharacteristics);
        }
    }
}

