/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.general.calendar.service.ISysCalendarRefService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.datasource.support.service.DynamicDatasourceService;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import com.jxdinfo.hussar.workflow.activiti.model.BpmActHiProcinst;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.dao.ActivityRedisTimerMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.model.TimeOutModel;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.util.TimeOutHandleUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.Process;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
@HussarTokenDs
public class ActivityRedisTimerServiceImpl
implements ActivityRedisTimerService {
    private static Logger logger = LogManager.getLogger(ActivityRedisTimerServiceImpl.class);
    @Resource
    private ActivityRedisTimerMapper activityRedisTimerMapper;
    @Autowired
    private RedisTemplate redisTemplate;
    @Resource
    private ISysCalendarRefService sysCalendarRefService;
    @Autowired
    private DynamicDatasourceService dynamicDatasourceService;

    public void addTimeOutModel(TimeOutModel timeOutModel) {
        this.addTimeOutModel(timeOutModel, false);
    }

    private void addTimeOutModel(TimeOutModel timeOutModel, boolean isProcessTimeOutModel) {
        timeOutModel.setTcode(HussarContextHolder.getHussarTenant().getTenantCode());
        timeOutModel.setDataSourceName(this.dynamicDatasourceService.getCurrentDatasourceName());
        String id = String.valueOf(timeOutModel.getTaskId());
        if (isProcessTimeOutModel) {
            id = "global-" + id;
            timeOutModel.setMessageType("1");
        } else {
            timeOutModel.setMessageType("0");
        }
        if (TimeOutHandleUtil.isUseRedis()) {
            try {
                this.redisTemplate.opsForValue().set((Object)("bpm_activity:timer:task_Message:" + id), (Object)JSON.toJSONString((Object)timeOutModel));
                Set oldTask = this.redisTemplate.opsForZSet().rangeByScore((Object)"bpm_activity:timer:score_list", (double)timeOutModel.getDueTime().getTime(), (double)timeOutModel.getDueTime().getTime());
                if (HussarUtils.isEmpty((Object)oldTask)) {
                    this.redisTemplate.opsForZSet().add((Object)"bpm_activity:timer:score_list", (Object)id, (double)timeOutModel.getDueTime().getTime());
                } else {
                    this.redisTemplate.opsForZSet().add((Object)"bpm_activity:timer:score_list", (Object)((String)new ArrayList(oldTask).get(0) + "," + id), (double)timeOutModel.getDueTime().getTime());
                }
            }
            catch (Exception e) {
                logger.error("redis\u5b58\u50a8\u4efb\u52a1\u8d85\u65f6\u65b9\u6848\u4fe1\u606f\u5931\u8d25[taskId:{}]-->{}", new Object[]{timeOutModel.getTaskId(), e.toString()});
            }
            return;
        }
        this.activityRedisTimerMapper.insert(timeOutModel);
        HussarCacheUtil.put((String)"bpm_timer_activity", (Object)id, (Object)timeOutModel);
        Long time = timeOutModel.getDueTime().getTime();
        if (TimeOutHandleUtil.isGetList()) {
            TimeOutHandleUtil.getGetListTimeAddModel().add(time);
        } else {
            int index = 0;
            for (int i = 0; i < TimeOutHandleUtil.getTimeOutList().size() && TimeOutHandleUtil.getTimeOutList().get(i) < time; ++i) {
                index = i + 1;
            }
            TimeOutHandleUtil.getTimeOutList().add(index, time);
            TimeOutHandleUtil.orderTime();
        }
        TimeOutHandleUtil.getTimeOutMap().put(time, TimeOutHandleUtil.getTimeOutMap().get(time) == null ? id : TimeOutHandleUtil.getTimeOutMap().get(time) + "," + id);
    }

    public void delTimeOutModel(String taskId) {
        this.delTimeOutModel(taskId, false);
    }

    private void delTimeOutModel(String taskId, boolean isProcessTimeOutModel) {
        if (TimeOutHandleUtil.isUseRedis()) {
            try {
                if (taskId.contains(",")) {
                    String[] list = taskId.split(",");
                    for (int i = 0; i < list.length; ++i) {
                        list[i] = "bpm_activity:timer:task_Message:" + list[i];
                    }
                    this.redisTemplate.delete((Object)list);
                } else if (isProcessTimeOutModel) {
                    TimeOutModel timeOutModel;
                    this.redisTemplate.delete((Object)("bpm_activity:timer:task_Message:global-" + taskId));
                    Object model = this.redisTemplate.opsForValue().get((Object)("bpm_activity:timer:task_Message:" + taskId));
                    if (HussarUtils.isNotEmpty((Object)model) && (timeOutModel = (TimeOutModel)JSON.parseObject((String)String.valueOf(model), TimeOutModel.class)).getMessageType() == null && timeOutModel.getTimeOutType().startsWith("global-")) {
                        this.redisTemplate.delete((Object)("bpm_activity:timer:task_Message:" + taskId));
                    }
                } else {
                    TimeOutModel timeOutModel;
                    Object model = this.redisTemplate.opsForValue().get((Object)("bpm_activity:timer:task_Message:" + taskId));
                    if (HussarUtils.isNotEmpty((Object)model) && ((timeOutModel = (TimeOutModel)JSON.parseObject((String)String.valueOf(model), TimeOutModel.class)).getMessageType() != null || !timeOutModel.getTimeOutType().startsWith("global-"))) {
                        this.redisTemplate.delete((Object)("bpm_activity:timer:task_Message:" + taskId));
                    }
                }
            }
            catch (Exception e) {
                logger.error("redis\u5220\u9664\u8d85\u65f6\u4efb\u52a1\u4fe1\u606f\u5931\u8d25[key:{}{}]-->{}", new Object[]{"bpm_activity:timer:task_Message:", taskId, e.toString()});
            }
            return;
        }
        List<String> taskIds = Arrays.asList(taskId.split(","));
        List longTaskIds = taskIds.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(TimeOutModel::getTaskId, longTaskIds);
        if (isProcessTimeOutModel) {
            queryWrapper.eq(TimeOutModel::getMessageType, (Object)"1");
        } else {
            queryWrapper.eq(TimeOutModel::getMessageType, (Object)"0");
        }
        this.activityRedisTimerMapper.delete((Wrapper)queryWrapper);
        if (isProcessTimeOutModel) {
            HussarCacheUtil.evict((String)"bpm_timer_activity", (Object)("global-" + taskId));
        } else {
            for (String id : taskIds) {
                HussarCacheUtil.evict((String)"bpm_timer_activity", (Object)id);
            }
            if (TimeOutHandleUtil.isGetList()) {
                TimeOutHandleUtil.getGetListTimeDelModel().addAll(taskIds);
            }
        }
    }

    public void addGlobalTimeOutModel(BpmnModel bm, Map<String, Object> map) {
        List globalTimeOutStrategyElement;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String instanceId = "";
        Date createTime = null;
        String starter = "";
        Object processInsId = map.get("processInsId");
        Object cTime = map.get("createTime");
        Object tStarter = map.get("starter");
        if (HussarUtils.isNotEmpty((Object)processInsId)) {
            instanceId = processInsId.toString();
        }
        if (HussarUtils.isNotEmpty((Object)cTime)) {
            try {
                createTime = simpleDateFormat.parse(cTime.toString());
            }
            catch (ParseException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        if (HussarUtils.isNotEmpty((Object)tStarter)) {
            starter = tStarter.toString();
        }
        String globalDueDate = "";
        String globalTimeOutStrategy = "";
        String chosenDay = "";
        Date globalDueTime = null;
        Map extensionElementList = ((Process)bm.getProcesses().get(0)).getExtensionElements();
        List globalDueDateElement = (List)extensionElementList.get("globalDueDate");
        List chosenDayElement = (List)extensionElementList.get("chosenDay");
        if (HussarUtils.isNotEmpty((Object)globalDueDateElement) && HussarUtils.isNotEmpty(((ExtensionElement)globalDueDateElement.get(0)).getAttributes().get("globalDueDate"))) {
            globalDueDate = ((ExtensionAttribute)((List)((ExtensionElement)globalDueDateElement.get(0)).getAttributes().get("globalDueDate")).get(0)).getValue();
        }
        if (HussarUtils.isNotEmpty((Object)createTime) && HussarUtils.isNotEmpty((Object)globalDueDate)) {
            globalDueTime = new DateTime(createTime.getTime()).plus((ReadablePeriod)Period.parse((String)globalDueDate)).toDate();
            if (HussarUtils.isNotEmpty((Object)chosenDayElement) && HussarUtils.isNotEmpty(((ExtensionElement)chosenDayElement.get(0)).getAttributes().get("chosenDay")) && "workingDay".equals(chosenDay = ((ExtensionAttribute)((List)((ExtensionElement)chosenDayElement.get(0)).getAttributes().get("chosenDay")).get(0)).getValue())) {
                Instant instant = createTime.toInstant();
                LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
                LocalDateTime dueTime = this.sysCalendarRefService.getDueDateDefult(localDateTime, globalDueDate, true);
                ZonedDateTime zonedDateTime = dueTime.atZone(ZoneId.systemDefault());
                Instant instant2 = zonedDateTime.toInstant();
                globalDueTime = Date.from(instant2);
            }
        }
        if (HussarUtils.isNotEmpty(globalDueTime)) {
            if (Context.getCommandContext() != null) {
                HistoricProcessInstanceEntity historicProcessInstanceEntity = Context.getCommandContext().getHistoricProcessInstanceEntityManager().findHistoricProcessInstance(instanceId);
                historicProcessInstanceEntity.setDueDate(globalDueTime);
            } else {
                BpmActHiProcinst bpmActHiProcinst = new BpmActHiProcinst();
                bpmActHiProcinst.setId(Long.valueOf((String)processInsId));
                bpmActHiProcinst.setDueDate(globalDueTime);
                bpmActHiProcinst.updateById();
            }
        }
        if (HussarUtils.isNotEmpty((Object)(globalTimeOutStrategyElement = (List)extensionElementList.get("globalTimeOutStrategy"))) && HussarUtils.isNotEmpty(((ExtensionElement)globalTimeOutStrategyElement.get(0)).getAttributes().get("globalTimeOutStrategy"))) {
            globalTimeOutStrategy = ((ExtensionAttribute)((List)((ExtensionElement)globalTimeOutStrategyElement.get(0)).getAttributes().get("globalTimeOutStrategy")).get(0)).getValue();
        }
        if (HussarUtils.isNotEmpty((Object)globalTimeOutStrategy)) {
            globalTimeOutStrategy = "global-" + globalTimeOutStrategy;
        }
        if (HussarUtils.isNotEmpty((Object)globalDueTime) && HussarUtils.isNotEmpty((Object)globalTimeOutStrategy) && HussarUtils.isNotEmpty((Object)instanceId)) {
            TimeOutModel timeOutModel = new TimeOutModel();
            timeOutModel.setTaskId(Long.valueOf(Long.parseLong(instanceId)));
            timeOutModel.setAssignee(starter);
            timeOutModel.setCreateTime(createTime);
            timeOutModel.setDueTime(globalDueTime);
            timeOutModel.setTimeOutType(globalTimeOutStrategy);
            if (timeOutModel.getTimeOutType().startsWith("global-http")) {
                map.remove("type");
                timeOutModel.setMap(JSON.toJSONString(map));
            }
            this.addTimeOutModel(timeOutModel, true);
        }
    }

    public void delGlobalTimeOutModel(Map<String, Object> map) {
        String instanceId = "";
        Object processInsId = map.get("processInsId");
        if (HussarUtils.isNotEmpty((Object)processInsId)) {
            instanceId = processInsId.toString();
        }
        if (HussarUtils.isNotEmpty((Object)instanceId)) {
            this.delTimeOutModel(instanceId, true);
        }
    }

    public void updateTimeOutModel(String taskId, String assignee, String userId, int type) {
        if (TimeOutHandleUtil.isUseRedis()) {
            try {
                Object model = this.redisTemplate.opsForValue().get((Object)("bpm_activity:timer:task_Message:" + taskId));
                if (HussarUtils.isNotEmpty((Object)model)) {
                    this.redisTemplate.opsForValue().set((Object)("bpm_activity:timer:task_Message:" + taskId), (Object)JSON.toJSONString((Object)this.getTimeOutAssignee((TimeOutModel)JSON.parseObject((String)String.valueOf(model), TimeOutModel.class), assignee, userId, type)));
                }
            }
            catch (Exception e) {
                logger.error("redis\u66f4\u65b0\u4efb\u52a1\u8d85\u65f6\u65b9\u6848\u4fe1\u606f\u53c2\u4e0e\u8005\u5931\u8d25[taskId:{}]-->{}", new Object[]{taskId, e.toString()});
            }
            return;
        }
        TimeOutModel timeOutModel = (TimeOutModel)HussarCacheUtil.get((String)"bpm_timer_activity", (Object)taskId);
        if (timeOutModel != null) {
            this.activityRedisTimerMapper.updateById(this.getTimeOutAssignee(timeOutModel, assignee, userId, type));
            HussarCacheUtil.put((String)"bpm_timer_activity", (Object)taskId, (Object)timeOutModel);
        }
    }

    private TimeOutModel getTimeOutAssignee(TimeOutModel timeOutModel, String assignee, String userId, int type) {
        String users;
        String string = users = timeOutModel.getAssignee() == null ? "" : timeOutModel.getAssignee();
        if (type == 0) {
            ArrayList<String> userList = new ArrayList<String>(Arrays.asList(users.split(",")));
            if (userId != null) {
                userList.remove(userId);
            }
            if (assignee != null) {
                userList = new ArrayList<String>(userList);
                userList.addAll(new ArrayList<String>(Arrays.asList(assignee.split(","))));
            }
            userList = new ArrayList<String>(new HashSet<String>(userList));
            timeOutModel.setAssignee(String.join((CharSequence)",", userList));
        } else {
            timeOutModel.setAssignee(assignee);
        }
        return timeOutModel;
    }
}

