/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.platform.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.CharsetUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.ResourceUtil;
import com.jxdinfo.hussar.platform.core.utils.id.UUID;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.WorkFlow;
import com.jxdinfo.hussar.workflow.engine.bpm.platform.dto.AddWorkflowDto;
import com.jxdinfo.hussar.workflow.engine.bpm.platform.service.IBpmDesignerService;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.model.SysActProcessFile;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import com.jxdinfo.hussar.workflow.godaxe.model.GodAxeModelService;
import com.jxdinfo.hussar.workflow.manage.engine.DefinitionEngineService;
import java.nio.charset.Charset;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class BpmDesignerServiceImpl
implements IBpmDesignerService {
    private final GodAxeModelService godAxeModelService;
    private final SysActProcessFileService sysActProcessFileService;
    private static final String BPM_TEMPLATE_RESOURCE = "bpm/template/bpm_template.json";

    public BpmDesignerServiceImpl(GodAxeModelService godAxeModelService, SysActProcessFileService sysActProcessFileService) {
        this.godAxeModelService = godAxeModelService;
        this.sysActProcessFileService = sysActProcessFileService;
    }

    public ApiResponse<?> saveWorkflow(WorkFlow workFlow) {
        this.godAxeModelService.saveByBpmDesigner(workFlow);
        workFlow.setData(null);
        return ApiResponse.success((Object)workFlow, (String)BpmExceptionCodeEnum.SUCCESS_SAVE.getMessage());
    }

    public ApiResponse<?> addWorkflow(WorkFlow workFlow) {
        List list = this.sysActProcessFileService.list((Wrapper)new LambdaQueryWrapper().eq(SysActProcessFile::getProcessKey, (Object)workFlow.getIdentity()));
        if (HussarUtils.isNotEmpty((Object)list)) {
            return ApiResponse.fail((String)BpmExceptionCodeEnum.SAME_IDENTITY.getMessage());
        }
        this.godAxeModelService.saveByBpmDesigner(workFlow);
        workFlow.setData(null);
        return ApiResponse.success((Object)workFlow, (String)BpmExceptionCodeEnum.SUCCESS_SAVE.getMessage());
    }

    public ApiResponse<?> addWorkflow(AddWorkflowDto addWorkflowDto) {
        if (HussarUtils.isEmpty((Object)addWorkflowDto.getProcessKey()) || HussarUtils.isEmpty((Object)addWorkflowDto.getProcessName())) {
            throw new BpmException(BpmExceptionCodeEnum.NULL_IDENTITY_OR_NAME);
        }
        List list = this.sysActProcessFileService.list((Wrapper)new LambdaQueryWrapper().eq(SysActProcessFile::getProcessKey, (Object)addWorkflowDto.getProcessKey()));
        if (HussarUtils.isNotEmpty((Object)list)) {
            throw new BpmException(BpmExceptionCodeEnum.SAME_IDENTITY);
        }
        String bpmTemplate = ResourceUtil.readStr((String)BPM_TEMPLATE_RESOURCE, (Charset)CharsetUtil.CHARSET_UTF_8);
        WorkFlow workFlow = (WorkFlow)JSON.parseObject((String)bpmTemplate, WorkFlow.class);
        workFlow.setId(UUID.randomUUID().toString());
        workFlow.setName(addWorkflowDto.getProcessName());
        workFlow.setIdentity(addWorkflowDto.getProcessKey());
        this.godAxeModelService.saveByBpmDesigner(workFlow);
        workFlow.setData(null);
        return ApiResponse.success((Object)workFlow, (String)BpmExceptionCodeEnum.SUCCESS_SAVE.getMessage());
    }

    public ApiResponse<?> publishNewVersion(WorkFlow workFlow) {
        boolean flag = DefinitionEngineService.queryIsPublish((String)workFlow.getIdentity());
        if (!flag && HussarUtils.isNotEmpty((Object)workFlow.getProcessTag())) {
            return ApiResponse.fail((String)BpmExceptionCodeEnum.ERROR_PUBLISH_PROCESS_ON_ORGAN.getMessage());
        }
        if (HussarUtils.isEmpty((Object)workFlow.getProcessTag())) {
            this.godAxeModelService.saveAndPublishWorkflow(workFlow, null, true);
        } else {
            this.godAxeModelService.saveWorkflowAboutOrgan(workFlow, null, null, null, null, true, true);
        }
        workFlow.setData(null);
        return ApiResponse.success((Object)workFlow);
    }

    public ApiResponse<?> publishWorkflow(WorkFlow workFlow) {
        WorkFlow workFlowOnOrgan;
        if (!DefinitionEngineService.queryIsPublish((String)workFlow.getIdentity())) {
            if (HussarUtils.isNotEmpty((Object)workFlow.getProcessTag())) {
                return ApiResponse.fail((String)BpmExceptionCodeEnum.ERROR_PUBLISH_PROCESS_ON_ORGAN.getMessage());
            }
            return this.publishNewVersion(workFlow);
        }
        ApiResponse response = null;
        if (HussarUtils.isNotEmpty((Object)workFlow.getProcessTag()) && (workFlowOnOrgan = this.godAxeModelService.getFileByProcessKeyAndProcessIdAndOrganId(workFlow.getIdentity(), workFlow.getProcessTag())) == null) {
            response = this.godAxeModelService.saveWorkflowAboutOrgan(workFlow, null, null, null, null, true, true);
        }
        if (response == null) {
            response = this.godAxeModelService.updateProcess(workFlow, null, false);
        }
        workFlow.setData(null);
        if (response.isSuccess()) {
            return ApiResponse.success((Object)workFlow, (String)BpmExceptionCodeEnum.SUCCESS_SAVE.getMessage());
        }
        return response;
    }

    public ApiResponse<?> forcePublishWorkflow(WorkFlow workFlow) {
        ApiResponse response = this.godAxeModelService.forcePublishProcess(workFlow);
        workFlow.setData(null);
        if (response.isSuccess()) {
            return ApiResponse.success((Object)workFlow, (String)BpmExceptionCodeEnum.SUCCESS_SAVE.getMessage());
        }
        return response;
    }

    public ApiResponse<?> compatiblePublishWorkflow(WorkFlow workFlow) {
        ApiResponse response = this.godAxeModelService.compatiblePublishProcess(workFlow);
        workFlow.setData(null);
        if (response.isSuccess()) {
            return ApiResponse.success((Object)workFlow, (String)BpmExceptionCodeEnum.SUCCESS_SAVE.getMessage());
        }
        return response;
    }

    public ApiResponse<?> updateProcessKey(String oldProcessKey, String processKey) {
        this.godAxeModelService.updateWorkflowProcessKey(processKey, oldProcessKey);
        return ApiResponse.success();
    }
}

