/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.message.push.service;

import com.jxdinfo.hussar.msg.common.model.MsgAppAccessBean;
import com.jxdinfo.hussar.msg.dingtalk.dto.DingTalkSendDto;
import com.jxdinfo.hussar.msg.push.dto.AppImSendTextDto;
import com.jxdinfo.hussar.msg.push.dto.AppPushSendDto;
import com.jxdinfo.hussar.msg.push.dto.CpSendDto;
import com.jxdinfo.hussar.msg.push.dto.MailSendDto;
import com.jxdinfo.hussar.msg.push.dto.MpSendDto;
import com.jxdinfo.hussar.msg.push.dto.SmsSendDto;
import com.jxdinfo.hussar.msg.push.service.PushMsgService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import com.jxdinfo.hussar.workflow.engine.bpm.message.model.BpmActMsgDetail;
import com.jxdinfo.hussar.workflow.engine.bpm.message.push.unifiedinterface.PushMsgAbstractHandlerService;
import com.jxdinfo.hussar.workflow.engine.bpm.message.util.BpmMsgConstant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import me.chanjar.weixin.mp.bean.template.WxMpTemplateData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PushHussarMessageHandlerServiceImpl
extends PushMsgAbstractHandlerService {
    private static final Logger logger = LoggerFactory.getLogger(PushHussarMessageHandlerServiceImpl.class);
    @Autowired(required=false)
    private PushMsgService pushMsgService;

    @Override
    public void pushMsgEmail(BpmActMsgDetail bpmActMsgDetail) {
        if (HussarUtils.isEmpty((Object)this.pushMsgService)) {
            return;
        }
        MailSendDto msgMailSendDto = new MailSendDto();
        msgMailSendDto.setSceneCode(bpmActMsgDetail.getSceneCode());
        ArrayList receiveName = new ArrayList();
        ArrayList receiveMail = new ArrayList();
        bpmActMsgDetail.getReceive().forEach(o -> {
            Map map = (Map)bpmActMsgDetail.getUserMsg().get(o);
            if (HussarUtils.isNotEmpty(map.get("email"))) {
                receiveName.add(map.get("userName"));
                receiveMail.add(map.get("email"));
            }
        });
        if (receiveName.isEmpty()) {
            return;
        }
        msgMailSendDto.setReciverName(String.join((CharSequence)";", receiveName));
        msgMailSendDto.setReciverMail(String.join((CharSequence)";", receiveMail));
        HashMap mailParms = new HashMap();
        bpmActMsgDetail.getMessageData().keySet().forEach(o -> mailParms.put(o, bpmActMsgDetail.getMessageData().get(o)));
        msgMailSendDto.setMailParams(mailParms);
        msgMailSendDto.setMailContent(bpmActMsgDetail.getMessage());
        msgMailSendDto.setMailSubject(bpmActMsgDetail.getMessageType());
        msgMailSendDto.setAppId(bpmActMsgDetail.getAppId());
        msgMailSendDto.setAppSecret(bpmActMsgDetail.getAppSecret());
        this.fillTestTenantCode((MsgAppAccessBean)msgMailSendDto);
        try {
            this.pushMsgService.sendBatchMailMsg(msgMailSendDto);
        }
        catch (Exception e) {
            logger.error("\u6d41\u7a0b[{}]\uff0c{}\uff0c\u90ae\u4ef6\u53d1\u9001\u5f02\u5e38\uff1a", new Object[]{bpmActMsgDetail.getProcessKey(), bpmActMsgDetail.getMessageType(), e});
        }
    }

    @Override
    public void pushMsgSms(BpmActMsgDetail bpmActMsgDetail) {
        if (HussarUtils.isEmpty((Object)this.pushMsgService)) {
            return;
        }
        SmsSendDto createDto = new SmsSendDto();
        createDto.setSceneCode(bpmActMsgDetail.getSceneCode());
        ArrayList phoneNumbers = new ArrayList();
        bpmActMsgDetail.getReceive().forEach(o -> {
            String phoneNumber = (String)((Map)bpmActMsgDetail.getUserMsg().get(o)).get("mobile");
            if (HussarUtils.isNotEmpty((Object)phoneNumber)) {
                phoneNumbers.add(phoneNumber);
            }
        });
        if (phoneNumbers.isEmpty()) {
            return;
        }
        createDto.setPhoneNumbers(phoneNumbers);
        createDto.setAliyunParams(bpmActMsgDetail.getMessageData());
        createDto.setAppId(bpmActMsgDetail.getAppId());
        createDto.setAppSecret(bpmActMsgDetail.getAppSecret());
        this.fillTestTenantCode((MsgAppAccessBean)createDto);
        try {
            this.pushMsgService.sendSmsMsg(createDto);
        }
        catch (Exception e) {
            logger.error("\u6d41\u7a0b[{}]\uff0c{}\uff0c\u77ed\u4fe1\u53d1\u9001\u5f02\u5e38\uff1a", new Object[]{bpmActMsgDetail.getProcessKey(), bpmActMsgDetail.getMessageType(), e});
        }
    }

    @Override
    public void pushMsgMp(BpmActMsgDetail bpmActMsgDetail) {
        if (HussarUtils.isEmpty((Object)this.pushMsgService)) {
            return;
        }
        MpSendDto createDto = new MpSendDto();
        createDto.setSceneCode(bpmActMsgDetail.getSceneCode());
        createDto.setReceiver(bpmActMsgDetail.getReceive());
        ArrayList<WxMpTemplateData> data = new ArrayList<WxMpTemplateData>();
        WxMpTemplateData wxMpTemplateData = new WxMpTemplateData();
        wxMpTemplateData.setName("first");
        wxMpTemplateData.setValue("\u60a8\u597d\uff0c\u60a8\u6536\u5230\u4e00\u6761" + bpmActMsgDetail.getMessageType());
        wxMpTemplateData.setColor("#6959CD");
        data.add(wxMpTemplateData);
        wxMpTemplateData.setName("keynote1");
        wxMpTemplateData.setValue(bpmActMsgDetail.getProcessName());
        wxMpTemplateData.setColor("#6959CD");
        data.add(wxMpTemplateData);
        wxMpTemplateData.setName("keynote2");
        wxMpTemplateData.setValue(bpmActMsgDetail.getProcessName());
        wxMpTemplateData.setColor("#6959CD");
        data.add(wxMpTemplateData);
        String remarkContent = this.convertRegex(bpmActMsgDetail.getMessage(), bpmActMsgDetail.getMessageData());
        wxMpTemplateData.setName("remark");
        wxMpTemplateData.setValue(remarkContent.substring(remarkContent.indexOf(",") + 1));
        wxMpTemplateData.setColor("#6959CD");
        data.add(wxMpTemplateData);
        createDto.setData(data);
        createDto.setAppId(bpmActMsgDetail.getAppId());
        createDto.setAppSecret(bpmActMsgDetail.getAppSecret());
        createDto.setMpParams(bpmActMsgDetail.getMessageData());
        this.fillTestTenantCode((MsgAppAccessBean)createDto);
        try {
            this.pushMsgService.sendMpMsg(createDto);
        }
        catch (Exception e) {
            logger.error("\u6d41\u7a0b[{}]\uff0c{}\uff0c\u5fae\u4fe1\u516c\u4f17\u53f7\u63a8\u9001\u5f02\u5e38\uff1a", new Object[]{bpmActMsgDetail.getProcessKey(), bpmActMsgDetail.getMessageType(), e});
        }
    }

    @Override
    public void pushDingTalkMsg(BpmActMsgDetail bpmActMsgDetail) {
        if (HussarUtils.isEmpty((Object)bpmActMsgDetail)) {
            return;
        }
        DingTalkSendDto sendDto = new DingTalkSendDto();
        sendDto.setSceneCode(bpmActMsgDetail.getSceneCode());
        sendDto.setReceiver(bpmActMsgDetail.getReceive());
        sendDto.setData(this.convertRegex(bpmActMsgDetail.getMessage(), bpmActMsgDetail.getMessageData()));
        sendDto.setAppId(bpmActMsgDetail.getAppId());
        sendDto.setAppSecret(bpmActMsgDetail.getAppSecret());
        try {
            this.pushMsgService.sendDingTalkMsg(sendDto);
        }
        catch (Exception e) {
            logger.error("\u6d41\u7a0b[{}]\uff0c{}\uff0c\u9489\u9489\u63a8\u9001\u5f02\u5e38\uff1a", new Object[]{bpmActMsgDetail.getProcessKey(), bpmActMsgDetail.getMessageType(), e});
        }
    }

    @Override
    public void pushMsgAppIm(BpmActMsgDetail bpmActMsgDetail) {
        if (HussarUtils.isEmpty((Object)this.pushMsgService)) {
            return;
        }
        AppImSendTextDto createDto = new AppImSendTextDto();
        createDto.setSceneCode(bpmActMsgDetail.getSceneCode());
        createDto.setReceiver(bpmActMsgDetail.getReceive());
        createDto.setText(this.convertRegex(bpmActMsgDetail.getMessage(), bpmActMsgDetail.getMessageData()));
        createDto.setAppId(bpmActMsgDetail.getAppId());
        createDto.setAppSecret(bpmActMsgDetail.getAppSecret());
        HashMap imParms = new HashMap();
        bpmActMsgDetail.getMessageData().keySet().forEach(o -> imParms.put(o, bpmActMsgDetail.getMessageData().get(o)));
        createDto.setImParams(imParms);
        this.fillTestTenantCode((MsgAppAccessBean)createDto);
        try {
            this.pushMsgService.sendAppImTextMsg(createDto);
        }
        catch (Exception e) {
            logger.error("\u6d41\u7a0b[{}]\uff0c{}\uff0cAppIm\u63a8\u9001\u5f02\u5e38\uff1a", new Object[]{bpmActMsgDetail.getProcessKey(), bpmActMsgDetail.getMessageType(), e});
        }
    }

    @Override
    public void pushMsgApp(BpmActMsgDetail bpmActMsgDetail) {
        if (HussarUtils.isEmpty((Object)this.pushMsgService)) {
            return;
        }
        AppPushSendDto createDto = new AppPushSendDto();
        createDto.setTitle(bpmActMsgDetail.getMessageType());
        createDto.setAudienceType(BpmMsgConstant.AUDIENCE_TYPE_TOKEN);
        createDto.setReceiver(bpmActMsgDetail.getReceive());
        createDto.setPlatform(BpmMsgConstant.PLATFORM_ALL);
        createDto.setContent(this.convertRegex(bpmActMsgDetail.getMessage(), bpmActMsgDetail.getMessageData()));
        createDto.setAngleMark(Integer.valueOf(1));
        createDto.setActionType(BpmMsgConstant.ACTION_TYPE_APP);
        createDto.setAppId(bpmActMsgDetail.getAppId());
        createDto.setAppSecret(bpmActMsgDetail.getAppSecret());
        createDto.setSceneCode(bpmActMsgDetail.getSceneCode());
        createDto.setAppParams(bpmActMsgDetail.getMessageData());
        this.fillTestTenantCode((MsgAppAccessBean)createDto);
        try {
            this.pushMsgService.sendAppMsg(createDto);
        }
        catch (Exception e) {
            logger.error("\u6d41\u7a0b[{}]\uff0c{}\uff0cAPP\u63a8\u9001\u5f02\u5e38\uff1a", new Object[]{bpmActMsgDetail.getProcessKey(), bpmActMsgDetail.getMessageType(), e});
        }
    }

    @Override
    public void pushMsgCp(BpmActMsgDetail bpmActMsgDetail) {
        if (HussarUtils.isEmpty((Object)this.pushMsgService)) {
            return;
        }
        CpSendDto createDto = new CpSendDto();
        createDto.setSceneCode(bpmActMsgDetail.getSceneCode());
        createDto.setReceiver(bpmActMsgDetail.getReceive());
        createDto.setData(this.convertRegex(bpmActMsgDetail.getMessage(), bpmActMsgDetail.getMessageData()));
        createDto.setAppId(bpmActMsgDetail.getAppId());
        createDto.setAppSecret(bpmActMsgDetail.getAppSecret());
        createDto.setCpParams(bpmActMsgDetail.getMessageData());
        this.fillTestTenantCode((MsgAppAccessBean)createDto);
        try {
            this.pushMsgService.sendCpMsg(createDto);
        }
        catch (Exception e) {
            logger.error("\u6d41\u7a0b[{}]\uff0c{}\uff0c\u4f01\u4e1a\u5fae\u4fe1\u63a8\u9001\u5f02\u5e38\uff1a", new Object[]{bpmActMsgDetail.getProcessKey(), bpmActMsgDetail.getMessageType(), e});
        }
    }

    private String convertRegex(String source, Map<String, String> data) {
        String target = source;
        if (HussarUtils.isNotEmpty(data)) {
            for (String key : data.keySet()) {
                target = target.replaceAll("\\#\\{" + key + "\\}", HussarUtils.isNotEmpty((Object)data.get(key)) ? data.get(key) : "");
            }
        }
        return target;
    }

    private void fillTestTenantCode(MsgAppAccessBean msgAppAccessBean) {
        if (HussarUtils.isNotEmpty((Object)HussarContextHolder.getHussarTenant())) {
            msgAppAccessBean.setTenantCode(HussarContextHolder.getHussarTenant().getTenantCode());
        } else {
            logger.error("\u83b7\u53d6\u5f53\u524d\u79df\u6237\u7f16\u7801\u5931\u8d25");
        }
    }
}

