/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.flowtask.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.CompatibleCodeUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.FlowTaskQueryModel;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.model.SysActExtendProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.service.ISysActExtendPropertiesService;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.dao.FlowTaskMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.model.FlowProcess;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.model.FlowTask;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.service.IFlowTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.taskmanage.vo.TaskManagerQueryVo;
import com.jxdinfo.hussar.workflow.engine.constant.TaskSourceFlag;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class FlowTaskServiceImpl
implements IFlowTaskService {
    @Resource
    private FlowTaskMapper flowTaskMapper;
    @Autowired
    private IAssigneeChooseService iAssigneeChooseService;
    @Autowired
    private LcdpBpmProperties lcdpBpmProperties;
    @Autowired
    private ISysActExtendPropertiesService extendPropertiesService;
    @Value(value="${hussar.bpm.use-security-level}")
    Boolean isUseSecurityLevel;

    public ApiResponse<Page<TaskManagerQueryVo>> todoList(Page<FlowTask> pages, FlowTaskQueryModel flowTaskQueryModel) {
        Object variables2;
        if (HussarUtils.isEmpty((Object)flowTaskQueryModel.getDateTime())) {
            flowTaskQueryModel.setDateTime(new Date());
        }
        long todoTotal = this.flowTaskMapper.countTodoTotal(flowTaskQueryModel);
        if (HussarUtils.isEmpty(pages)) {
            pages = new Page();
        } else if (HussarUtils.isNotEmpty(pages) && (HussarUtils.isEmpty((Object)pages.getCurrent()) || HussarUtils.isEmpty((Object)pages.getSize()))) {
            pages = new Page(1L, 10L);
        }
        pages.setSearchCount(false);
        pages.setOptimizeCountSql(false);
        pages.setTotal(todoTotal);
        if (todoTotal == 0L) {
            return ApiResponse.success((Object)new Page(pages.getCurrent(), pages.getSize(), 0L));
        }
        List<FlowTask> todoList = this.flowTaskMapper.todoList((Page<FlowTask>)pages, flowTaskQueryModel);
        ArrayList<Long> taskIds = new ArrayList<Long>();
        ArrayList<Long> processInsIds = new ArrayList<Long>();
        for (FlowTask flowTask : todoList) {
            taskIds.add(Long.parseLong(flowTask.getTaskId()));
            processInsIds.add(Long.parseLong(flowTask.getProcessInsId()));
        }
        List<Object> allVariables = new ArrayList();
        List<Object> processList = new ArrayList();
        if (!todoList.isEmpty()) {
            processInsIds = new ArrayList(new HashSet(processInsIds));
            processInsIds.remove(null);
            if (processInsIds.isEmpty()) {
                processInsIds = null;
            }
            processList = this.flowTaskMapper.getProcInstMsg(processInsIds);
            allVariables = this.flowTaskMapper.getAllToDoVariables(taskIds, null);
            allVariables.addAll(this.flowTaskMapper.getAllToDoVariables(null, processInsIds));
        }
        HashMap<String, ArrayList<Object>> taskVariablesMap = new HashMap<String, ArrayList<Object>>();
        HashMap<String, ArrayList<Object>> processVariablesMap = new HashMap<String, ArrayList<Object>>();
        for (Object variables2 : allVariables) {
            List<Object> list;
            if (variables2.getTaskId() == null) {
                list = (ArrayList<Object>)processVariablesMap.get(variables2.getProcessInsId());
                if (list == null) {
                    list = new ArrayList<Object>();
                }
                list.add(variables2);
                processVariablesMap.put(variables2.getProcessInsId(), (ArrayList<Object>)list);
                continue;
            }
            list = (List)taskVariablesMap.get(variables2.getTaskId());
            if (list == null) {
                list = new ArrayList();
            }
            list.add(variables2);
            taskVariablesMap.put(variables2.getTaskId(), (ArrayList<Object>)list);
        }
        HashMap<String, FlowProcess> processMap = new HashMap<String, FlowProcess>();
        for (FlowProcess flowProcess : processList) {
            processMap.put(flowProcess.getProcessInsId(), flowProcess);
        }
        variables2 = todoList.iterator();
        while (variables2.hasNext()) {
            FlowTask flowTask;
            flowTask.setTaskVariables(taskVariablesMap.get((flowTask = (FlowTask)variables2.next()).getTaskId()) == null ? new ArrayList() : (List)taskVariablesMap.get(flowTask.getTaskId()));
            flowTask.setProcessVariables(processVariablesMap.get(flowTask.getProcessInsId()) == null ? new ArrayList() : (List)processVariablesMap.get(flowTask.getProcessInsId()));
            FlowProcess flowProcess = (FlowProcess)processMap.get(flowTask.getProcessInsId());
            flowTask.setBusinessId(flowProcess.getBusinessId());
            flowTask.setProcessStartUserId(flowProcess.getProcessStartUserId());
            flowTask.setProcessStartTime(flowProcess.getProcessStartTime());
            flowTask.setProcessEndTime(flowProcess.getProcessEndTime());
        }
        ArrayList<TaskManagerQueryVo> resultData = new ArrayList<TaskManagerQueryVo>();
        ArrayList<String> userIds = new ArrayList<String>();
        for (FlowTask flowTask : todoList) {
            TaskManagerQueryVo taskManagerQueryVo = new TaskManagerQueryVo();
            taskManagerQueryVo.setTaskId(HussarUtils.isNotEmpty((Object)flowTask.getTaskState()) ? flowTask.getTaskId() + ":" + flowTask.getOwner() : flowTask.getTaskId());
            taskManagerQueryVo.setTaskDefinitionName(flowTask.getName());
            taskManagerQueryVo.setAssigneeId(flowTask.getUserId());
            taskManagerQueryVo.setProcessDefinitionId(flowTask.getProcessDefinitionId());
            taskManagerQueryVo.setProcessKey(flowTask.getProcessKey());
            taskManagerQueryVo.setProcessName(flowTask.getProcessDefinitionName());
            taskManagerQueryVo.setTaskDefinitionKey(flowTask.getTaskDefinitionKey());
            taskManagerQueryVo.setProcessInsId(flowTask.getProcessInsId());
            taskManagerQueryVo.setStartTime(flowTask.getStartTime());
            taskManagerQueryVo.setProcessStartTime(flowTask.getProcessStartTime());
            taskManagerQueryVo.setBusinessId(flowTask.getBusinessId());
            taskManagerQueryVo.setFormKey(flowTask.getFormKey());
            taskManagerQueryVo.setIsNoticeTask(flowTask.getIsNoticeTask());
            taskManagerQueryVo.setTaskState(flowTask.getTaskState());
            taskManagerQueryVo.setOwner(flowTask.getOwner());
            taskManagerQueryVo.setProcessStartUserId(flowTask.getProcessStartUserId());
            taskManagerQueryVo.setFormAddress((Map)JSON.parse((String)flowTask.getFormKey()));
            taskManagerQueryVo.setTimeoutState(flowTask.getTimeoutState());
            taskManagerQueryVo.setSuspensionState(String.valueOf(flowTask.getSuspensionState()));
            taskManagerQueryVo.setAssistInitiator(flowTask.getAssistInitiator());
            taskManagerQueryVo.setTaskType(flowTask.getTaskType());
            if (taskManagerQueryVo.getFormAddress() != null) {
                taskManagerQueryVo.setWeb((String)taskManagerQueryVo.getFormAddress().get("web"));
                taskManagerQueryVo.setMobile((String)taskManagerQueryVo.getFormAddress().get("mobile"));
                taskManagerQueryVo.setUni((String)taskManagerQueryVo.getFormAddress().get("uni"));
            }
            taskManagerQueryVo.setVariables(flowTask.getProcessVariableMap());
            Map taskVariables = flowTask.getTaskVariableMap();
            taskVariables.putAll(CompatibleCodeUtil.resetVariable(flowTask, (FlowProcess)processMap.get(flowTask.getProcessInsId())));
            taskManagerQueryVo.setTaskVariables(taskVariables);
            taskManagerQueryVo.setMessage(flowTask.getTodoConfiguration());
            taskManagerQueryVo.setTaskSourceFlag(flowTask.getTaskSourceFlag());
            taskManagerQueryVo.setSendUser(flowTask.getSendUser());
            userIds.add(String.valueOf(taskManagerQueryVo.getSendUser()));
            userIds.add(String.valueOf(taskManagerQueryVo.getAssigneeId()));
            userIds.add(String.valueOf(taskManagerQueryVo.getOwner()));
            userIds.add(String.valueOf(taskManagerQueryVo.getProcessStartUserId()));
            resultData.add(taskManagerQueryVo);
        }
        Map finalUsers = this.iAssigneeChooseService.getUserListByUserId(userIds);
        Iterator<Object> iterator = resultData.iterator();
        while (iterator.hasNext()) {
            TaskManagerQueryVo taskManagerQueryVo;
            taskManagerQueryVo.setSendUserName(finalUsers.get((taskManagerQueryVo = (TaskManagerQueryVo)iterator.next()).getSendUser()) == null ? "" : (String)finalUsers.get(taskManagerQueryVo.getSendUser()));
            taskManagerQueryVo.setAssigneeName(finalUsers.get(taskManagerQueryVo.getAssigneeId()) == null ? "" : (String)finalUsers.get(taskManagerQueryVo.getAssigneeId()));
            taskManagerQueryVo.setOwnerName(finalUsers.get(taskManagerQueryVo.getOwner()) == null ? "" : (String)finalUsers.get(taskManagerQueryVo.getOwner()));
            taskManagerQueryVo.setProcessStartUserName(finalUsers.get(taskManagerQueryVo.getProcessStartUserId()) == null ? "" : (String)finalUsers.get(taskManagerQueryVo.getProcessStartUserId()));
        }
        Page page = new Page(pages.getCurrent(), pages.getSize(), pages.getTotal());
        page.setRecords(resultData);
        return ApiResponse.success((Object)page);
    }

    public ApiResponse<Page<TaskManagerQueryVo>> doneList(Page<FlowTask> pages, FlowTaskQueryModel flowTaskQueryModel) {
        if (this.isUseSecurityLevel.booleanValue()) {
            Integer securityLevel = null;
            String userId = flowTaskQueryModel.getUserId();
            if (HussarUtils.isEmpty((Object)userId)) {
                userId = flowTaskQueryModel.getMandator();
            }
            if (HussarUtils.isNotEmpty((Object)userId)) {
                securityLevel = this.iAssigneeChooseService.getSecurityLevel(userId, null);
            }
            flowTaskQueryModel.setSecurityLevel(securityLevel);
        }
        long todoTotal = this.flowTaskMapper.countDoneTotal(flowTaskQueryModel);
        if (HussarUtils.isEmpty((Object)pages)) {
            pages = new Page();
        } else if (HussarUtils.isNotEmpty((Object)pages) && (HussarUtils.isEmpty((Object)pages.getCurrent()) || HussarUtils.isEmpty((Object)pages.getSize()))) {
            pages = new Page(1L, 10L);
        }
        pages.setSearchCount(false);
        pages.setOptimizeCountSql(false);
        pages.setTotal(todoTotal);
        if (todoTotal == 0L) {
            return ApiResponse.success((Object)new Page(pages.getCurrent(), pages.getSize(), 0L));
        }
        List<FlowTask> doneList = this.flowTaskMapper.doneList((Page<FlowTask>)pages, flowTaskQueryModel);
        ArrayList<Long> taskIds = new ArrayList<Long>();
        ArrayList<Long> processInsIds = new ArrayList<Long>();
        HashSet<String> procDefIds = new HashSet<String>();
        for (FlowTask flowTask : doneList) {
            taskIds.add(Long.parseLong(flowTask.getTaskId()));
            processInsIds.add(Long.parseLong(flowTask.getProcessInsId()));
            procDefIds.add(flowTask.getProcessDefinitionId());
        }
        List<Object> allVariables = new ArrayList();
        List<Object> processList = new ArrayList();
        List extendProperties = new ArrayList();
        if (!doneList.isEmpty()) {
            processInsIds = new ArrayList(new HashSet(processInsIds));
            processInsIds.remove(null);
            if (processInsIds.isEmpty()) {
                processInsIds = null;
            }
            processList = this.flowTaskMapper.getProcInstMsg(processInsIds);
            allVariables = this.flowTaskMapper.getAllVariables(null, processInsIds);
            allVariables.addAll(this.flowTaskMapper.getAllVariables(taskIds, null));
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.in(SysActExtendProperties::getProcDefId, procDefIds);
            extendProperties = this.extendPropertiesService.list((Wrapper)lambdaQueryWrapper);
        }
        HashMap<String, ArrayList<Object>> taskVariablesMap = new HashMap<String, ArrayList<Object>>();
        HashMap<String, ArrayList<Object>> processVariablesMap = new HashMap<String, ArrayList<Object>>();
        for (Object variables : allVariables) {
            List<Object> list;
            if (variables.getTaskId() == null) {
                list = (ArrayList<Object>)processVariablesMap.get(variables.getProcessInsId());
                if (list == null) {
                    list = new ArrayList<Object>();
                }
                list.add(variables);
                processVariablesMap.put(variables.getProcessInsId(), (ArrayList<Object>)list);
                continue;
            }
            list = (List)taskVariablesMap.get(variables.getTaskId());
            if (list == null) {
                list = new ArrayList();
            }
            list.add(variables);
            taskVariablesMap.put(variables.getTaskId(), (ArrayList<Object>)list);
        }
        HashMap<String, Object> extendPropertiesMap = new HashMap<String, Object>();
        for (Object sysActExtendProperties : extendProperties) {
            extendPropertiesMap.put(sysActExtendProperties.getProcDefId() + ":" + sysActExtendProperties.getTaskDefKey(), sysActExtendProperties);
        }
        HashMap<String, FlowProcess> processMap = new HashMap<String, FlowProcess>();
        for (FlowProcess flowProcess : processList) {
            processMap.put(flowProcess.getProcessInsId(), flowProcess);
        }
        for (FlowTask flowTask : doneList) {
            SysActExtendProperties formDetailKeyMsg = (SysActExtendProperties)extendPropertiesMap.get(flowTask.getProcessDefinitionId() + ":" + flowTask.getTaskDefinitionKey());
            if (formDetailKeyMsg != null) {
                if ("2".equals(flowTask.getTaskType())) {
                    flowTask.setFormDetail(formDetailKeyMsg.getAssistFormDetailKey());
                } else {
                    flowTask.setFormDetail(formDetailKeyMsg.getFormDetailKey());
                }
            }
            flowTask.setTaskVariables(taskVariablesMap.get(flowTask.getTaskId()) == null ? new ArrayList() : (List)taskVariablesMap.get(flowTask.getTaskId()));
            flowTask.setProcessVariables(processVariablesMap.get(flowTask.getProcessInsId()) == null ? new ArrayList() : (List)processVariablesMap.get(flowTask.getProcessInsId()));
            FlowProcess flowProcess = (FlowProcess)processMap.get(flowTask.getProcessInsId());
            flowTask.setBusinessId(flowProcess.getBusinessId());
            flowTask.setProcessStartUserId(flowProcess.getProcessStartUserId());
            flowTask.setProcessStartTime(flowProcess.getProcessStartTime());
            flowTask.setProcessEndTime(flowProcess.getProcessEndTime());
        }
        Page page = new Page(pages.getCurrent(), pages.getSize(), pages.getTotal());
        page.setRecords(this.hisTasksToVo(doneList, processMap));
        return ApiResponse.success((Object)page);
    }

    private List<TaskManagerQueryVo> hisTasksToVo(List<FlowTask> lists, Map<String, FlowProcess> processMap) {
        ArrayList<TaskManagerQueryVo> list = new ArrayList<TaskManagerQueryVo>();
        ArrayList<String> userIds = new ArrayList<String>();
        Map finalUsers = new HashMap();
        ArrayList<String> ids = new ArrayList<String>();
        if (HussarUtils.isNotEmpty(lists)) {
            for (FlowTask flowTask : lists) {
                Map taskVariables = flowTask.getTaskVariableMap();
                if (HussarUtils.isNotEmpty((Object)flowTask.getSendUser())) {
                    userIds.add(flowTask.getSendUser());
                }
                userIds.add(flowTask.getUserId());
                userIds.add(flowTask.getProcessStartUserId());
                ids.add(flowTask.getTaskDefinitionKey());
            }
            finalUsers = this.iAssigneeChooseService.getUserListByUserId(userIds);
        }
        if (HussarUtils.isNotEmpty(lists)) {
            for (FlowTask flowTask : lists) {
                TaskManagerQueryVo taskManagerQueryVo = new TaskManagerQueryVo();
                Map variables = flowTask.getProcessVariableMap();
                Map taskVariables = flowTask.getTaskVariableMap();
                taskManagerQueryVo.setTaskId(flowTask.getTaskId());
                taskManagerQueryVo.setIsNoticeTask(flowTask.getIsNoticeTask());
                taskManagerQueryVo.setTaskDefinitionName(flowTask.getName());
                taskManagerQueryVo.setAssigneeId(flowTask.getUserId());
                taskManagerQueryVo.setAssigneeName((String)finalUsers.get(flowTask.getUserId()));
                taskManagerQueryVo.setProcessDefinitionId(flowTask.getProcessDefinitionId());
                taskManagerQueryVo.setProcessKey(flowTask.getProcessKey());
                taskManagerQueryVo.setProcessName(flowTask.getProcessDefinitionName());
                taskManagerQueryVo.setTaskDefinitionKey(flowTask.getTaskDefinitionKey());
                taskManagerQueryVo.setProcessInsId(flowTask.getProcessInsId());
                taskManagerQueryVo.setStartTime(flowTask.getStartTime());
                taskManagerQueryVo.setEndTime(flowTask.getEndTime());
                taskManagerQueryVo.setProcessStartTime(flowTask.getProcessStartTime());
                taskManagerQueryVo.setProcessEndTime(flowTask.getProcessEndTime());
                taskManagerQueryVo.setBusinessId(flowTask.getBusinessId());
                taskManagerQueryVo.setVariables(variables);
                taskManagerQueryVo.setOwner(flowTask.getOwner());
                taskManagerQueryVo.setTaskState(flowTask.getTaskState());
                taskVariables.putAll(CompatibleCodeUtil.resetVariable(flowTask, processMap.get(flowTask.getProcessInsId())));
                taskManagerQueryVo.setTaskVariables(taskVariables);
                String taskSourceFlag = flowTask.getTaskSourceFlag();
                taskManagerQueryVo.setTaskSourceFlag(taskSourceFlag);
                String scope = taskSourceFlag;
                taskManagerQueryVo.setAssistInitiator(flowTask.getAssistInitiator());
                taskManagerQueryVo.setTaskType(flowTask.getTaskType());
                scope = TaskSourceFlag.isReject((String)scope) ? "\u5df2\u9a73\u56de" : "\u5df2\u5b8c\u6210";
                taskManagerQueryVo.setState(scope);
                taskManagerQueryVo.setSendUser(flowTask.getSendUser());
                taskManagerQueryVo.setSendUserName((String)finalUsers.get(flowTask.getSendUser()));
                taskManagerQueryVo.setProcessStartUserId(flowTask.getProcessStartUserId());
                taskManagerQueryVo.setProcessStartUserName((String)finalUsers.get(taskManagerQueryVo.getProcessStartUserId()));
                taskManagerQueryVo.setMessage(flowTask.getTodoConfiguration());
                taskManagerQueryVo.setFormKey(flowTask.getFormKey());
                String formDetail = flowTask.getFormDetail();
                taskManagerQueryVo.setFormDetailKey(formDetail);
                if (HussarUtils.isNotEmpty((Object)formDetail)) {
                    JSONObject object = JSON.parseObject((String)formDetail);
                    taskManagerQueryVo.setWeb(object.getString("web"));
                    taskManagerQueryVo.setMobile(object.getString("mobile"));
                    taskManagerQueryVo.setUni(object.getString("uni"));
                }
                list.add(taskManagerQueryVo);
            }
        }
        return list;
    }
}

