/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bsp.exception;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.message.model.BpmActMsgDetail;
import com.jxdinfo.hussar.workflow.engine.bpm.message.service.BpmMsgPushService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.SysActAssignee;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysActAssigneeService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.ExceptionMessageProperties;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionMessageParam;
import com.jxdinfo.hussar.workflow.manage.util.BpmSpringContextHolder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BpmExceptionPushUtil {
    private static final Logger logger = LoggerFactory.getLogger(BpmExceptionPushUtil.class);
    private static final ExceptionMessageProperties messageProperties = (ExceptionMessageProperties)BpmSpringContextHolder.getBean(ExceptionMessageProperties.class);
    private static final BpmMsgPushService msgPushService = (BpmMsgPushService)BpmSpringContextHolder.getBean(BpmMsgPushService.class);
    private static final SysActAssigneeService sysActAssigneeService = (SysActAssigneeService)BpmSpringContextHolder.getBean(SysActAssigneeService.class);
    private static final IAssigneeChooseService assigneeChooseService = (IAssigneeChooseService)BpmSpringContextHolder.getBean(IAssigneeChooseService.class);
    private static final String SUCCESS_SEND_EXCEPTION_MESSAGE_PLEASE_WAIT = " \u5f02\u5e38\u5df2\u901a\u77e5\uff0c\u8bf7\u7b49\u5f85\u7ba1\u7406\u5458\u5904\u7406";

    private BpmExceptionPushUtil() {
    }

    public static void pushExceptionMessage(BpmException bpmException) {
        String message;
        if (Boolean.TRUE.equals(bpmException.isPushMessage()) && messageProperties.isEnableMessageService()) {
            String exceptionReceiverCondition;
            BpmExceptionMessageParam bpmExceptionMessageParam = bpmException.getBpmExceptionMessageParam();
            String processKey = bpmExceptionMessageParam.getProcessKey();
            SysActAssignee exceptionReceiver = sysActAssigneeService.queryExceptionReceiver(bpmExceptionMessageParam);
            String exceptionMessageType = exceptionReceiver.getMessageType();
            String string = exceptionReceiverCondition = exceptionReceiver.getContent() == null ? "" : new String(exceptionReceiver.getContent(), StandardCharsets.UTF_8);
            if (HussarUtils.isEmpty((Object)exceptionMessageType)) {
                bpmException.setPushMessage(false);
            }
            ArrayList receiverList = HussarUtils.isEmpty((Object)exceptionReceiverCondition) ? new ArrayList() : assigneeChooseService.getCandidateUser(exceptionReceiverCondition, processKey, null, new HashMap());
            logger.info("\u5f02\u5e38\u6d88\u606f\u53d1\u9001\u7c7b\u578b\uff1a{}", (Object)exceptionReceiver);
            logger.info("\u5f02\u5e38\u6d88\u606f\u63a5\u6536\u4eba\uff1a{}", receiverList);
            ArrayList<BpmActMsgDetail> bpmActMsgDetailList = new ArrayList<BpmActMsgDetail>();
            HashMap<String, String> messageData = new HashMap<String, String>();
            BpmActMsgDetail bpmActMsgDetail = new BpmActMsgDetail();
            bpmActMsgDetail.setSceneCode("exception");
            bpmActMsgDetail.setReceive(receiverList);
            bpmActMsgDetail.setChannelType(exceptionMessageType);
            bpmActMsgDetail.setProcessDefinitionId(bpmExceptionMessageParam.getProcessDefinitionId());
            bpmActMsgDetail.setProcessKey(processKey);
            bpmActMsgDetail.setProcessName(bpmExceptionMessageParam.getProcessName());
            bpmActMsgDetail.setTaskDefKey(bpmExceptionMessageParam.getTaskDefinitionKey());
            bpmActMsgDetail.setTaskDefName(bpmExceptionMessageParam.getTaskDefinitionName());
            messageData.put("processName", bpmExceptionMessageParam.getProcessName());
            messageData.put("expType", bpmException.getMessage());
            messageData.put("processKey", processKey);
            messageData.put("taskKey", bpmExceptionMessageParam.getTaskDefinitionKey());
            messageData.put("taskName", bpmExceptionMessageParam.getTaskDefinitionName());
            bpmActMsgDetail.setMessageData(messageData);
            bpmActMsgDetailList.add(bpmActMsgDetail);
            msgPushService.pushMessage(bpmActMsgDetailList);
            bpmException.setPushMessageSuccess(true);
        }
        if (HussarUtils.isNotEmpty((Object)(message = BpmExceptionPushUtil.getSuccessSendExceptionMessagePleaseWait(bpmException)))) {
            bpmException.setMessage(bpmException.getMessage() + message);
        }
    }

    public static String getSuccessSendExceptionMessagePleaseWait(BpmException bpmException) {
        if (Boolean.TRUE.equals(bpmException.isPushMessage()) && messageProperties.isEnableMessageService() && bpmException.isPushMessageSuccess()) {
            return SUCCESS_SEND_EXCEPTION_MESSAGE_PLEASE_WAIT;
        }
        return "";
    }
}

