/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.wfdtoprocess.visitor;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowModel;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowObject;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowSequence;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowVariables;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.util.FormBpmnUtil;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.visitor.FormObjectVisitor;
import java.util.ArrayList;
import java.util.List;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowElementsContainer;
import org.activiti.bpmn.model.InclusiveGateway;
import org.springframework.stereotype.Component;

@Component(value="com.jxdinfo.workflow.Inclusive")
public class InclusiveGatewayVisitor
implements FormObjectVisitor {
    @Override
    public void visit(FlowObject flowObject, FlowElementsContainer process, FlowModel flowModel, FlowObject processModel) {
        InclusiveGateway inclusiveGateway = new InclusiveGateway();
        inclusiveGateway.setId(flowObject.getId());
        inclusiveGateway.setDocumentation(flowObject.getProps().getFlowDescription());
        inclusiveGateway.setName(flowObject.getProps().getFlowName());
        if (HussarUtils.isNotEmpty((Object)flowObject.getPreviousId())) {
            inclusiveGateway.addExtensionElement(FormBpmnUtil.addExtensionElement("previousId", flowObject.getPreviousId()));
            ArrayList<String> pathIds = new ArrayList<String>();
            List flowSequences = processModel.getSlots().getPath();
            for (FlowSequence flowSequence : flowSequences) {
                pathIds.add(flowSequence.getId());
            }
            ArrayList<FlowVariables> useVariables = flowObject.getProps().getUseVariables();
            boolean flag = false;
            if (HussarUtils.isNotEmpty((Object)useVariables)) {
                flag = true;
            } else {
                useVariables = new ArrayList<FlowVariables>();
            }
            FormBpmnUtil.addExeListener((FlowElement)inclusiveGateway, useVariables, pathIds, flag);
        }
        process.addFlowElement((FlowElement)inclusiveGateway);
    }
}

