/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.processentrust.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.ProcessActionCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.ProcessNodeCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.processentrust.dao.SysActEntrustMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.processentrust.dto.TransferTaskDto;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.service.impl.ActivityRedisTimerServiceImpl;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.model.SysActUrgeTask;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.service.ISysActUrgeTaskService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.TaskService;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class AsynEntrustServiceImpl {
    @Resource
    SysActEntrustMapper sysActEntrustMapper;
    @Resource
    private TaskService taskService;
    @Resource
    private ProcessEngine processEngine;
    @Autowired
    private ISysActUrgeTaskService urgeTaskService;
    @Autowired
    private ActivityRedisTimerServiceImpl activityRedisTimerService;
    @Autowired
    private DataPushService dataPushService;

    public void transferTask(String userId, String mandator, String processKey, Collection<String> taskDefKey) {
        ArrayList<String> taskIds = new ArrayList<String>();
        HashSet<String> processInsIds = new HashSet<String>();
        HashSet<String> processDefinitionIdList = new HashSet<String>();
        HashMap<String, String> taskProcDefIdMap = new HashMap<String, String>();
        List<TransferTaskDto> transferTaskDtoList = this.sysActEntrustMapper.getTransferTask(mandator, processKey, taskDefKey);
        HashMap<String, List> procTaskMap = new HashMap<String, List>();
        if (HussarUtils.isNotEmpty(transferTaskDtoList)) {
            ArrayList<Long> longTaskIds = new ArrayList<Long>();
            for (TransferTaskDto transferTaskDto : transferTaskDtoList) {
                taskIds.add(transferTaskDto.getTaskId());
                procTaskMap.computeIfAbsent(transferTaskDto.getProcessInsId(), e -> new ArrayList()).add(transferTaskDto.getTaskId());
                processInsIds.add(transferTaskDto.getProcessInsId());
                longTaskIds.add(Long.parseLong(transferTaskDto.getTaskId()));
                Task task2 = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(transferTaskDto.getTaskId())).singleResult();
                String processDefinitionId = task2.getProcessDefinitionId();
                processDefinitionIdList.add(processDefinitionId);
                taskProcDefIdMap.put(task2.getId(), processDefinitionId);
            }
            this.sysActEntrustMapper.transferTask(userId, mandator, longTaskIds);
        }
        List tasks = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().taskAssignee(mandator)).processDefinitionKey(processKey)).list();
        tasks.removeIf(task -> !taskDefKey.contains(task.getTaskDefinitionKey()));
        this.processEngine.getManagementService().executeCommand(commandContext -> {
            for (Task task : tasks) {
                processInsIds.add(task.getProcessInstanceId());
                TaskEntity taskEntity = commandContext.getTaskEntityManager().findTaskById(task.getId());
                taskEntity.setAssignee(null);
                ((TaskEntity)task).addCandidateUser(userId, mandator, "1", null);
                taskIds.add(task.getId());
                procTaskMap.computeIfAbsent(task.getProcessInstanceId(), e -> new ArrayList()).add(task.getId());
            }
            for (String processInsId : processInsIds) {
                new ProcessActionCmd(processInsId).execute(commandContext);
                new ProcessNodeCmd(processInsId).execute(commandContext);
            }
            return null;
        });
        this.urgeTaskService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(SysActUrgeTask::getTaskState, (Object)"1")).set(SysActUrgeTask::getReceiveUser, (Object)userId)).set(SysActUrgeTask::getOwner, (Object)mandator)).eq(SysActUrgeTask::getReceiveUser, (Object)mandator)).eq(SysActUrgeTask::getProcDefKey, (Object)processKey)).in(HussarUtils.isNotEmpty(taskDefKey), SysActUrgeTask::getTaskDefKey, taskDefKey)).isNull(SysActUrgeTask::getTaskState)).isNull(SysActUrgeTask::getOwner));
        taskIds.forEach(taskId -> this.activityRedisTimerService.updateTimeOutModel((String)taskId, userId, mandator, 1));
        if (this.dataPushService.isDataPush(processDefinitionIdList)) {
            this.dataPushService.transferTask(new DataPush().setProcessKey(processKey).setTaskIds(taskIds).setProcTaskMap(procTaskMap).setUserId(userId).setConsignor(mandator).setProcessDefinitionIdList(processDefinitionIdList).setTaskState("1").setTaskProcDefIdMap(taskProcDefIdMap));
        }
    }

    public void transferProcessTask(String userId, String mandator, Collection<String> processKey) {
        ArrayList<String> taskIds = new ArrayList<String>();
        HashSet<String> processInsIds = new HashSet<String>();
        HashSet<String> processDefinitionIdList = new HashSet<String>();
        HashMap<String, String> taskProcDefIdMap = new HashMap<String, String>();
        List<TransferTaskDto> transferTaskDtoList = this.sysActEntrustMapper.getTransferProcessTask(mandator, processKey);
        HashMap<String, List> procTaskMap = new HashMap<String, List>();
        if (!transferTaskDtoList.isEmpty()) {
            ArrayList<Long> longTaskIds = new ArrayList<Long>();
            for (TransferTaskDto transferTaskDto : transferTaskDtoList) {
                taskIds.add(transferTaskDto.getTaskId());
                procTaskMap.computeIfAbsent(transferTaskDto.getProcessInsId(), e -> new ArrayList()).add(transferTaskDto.getTaskId());
                processInsIds.add(transferTaskDto.getProcessInsId());
                longTaskIds.add(Long.parseLong(transferTaskDto.getTaskId()));
                Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(transferTaskDto.getTaskId())).singleResult();
                String processDefinitionId = task.getProcessDefinitionId();
                processDefinitionIdList.add(processDefinitionId);
                taskProcDefIdMap.put(task.getId(), processDefinitionId);
            }
            this.sysActEntrustMapper.transferTask(userId, mandator, longTaskIds);
        }
        List tasks = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().taskAssignee(mandator)).processDefinitionKeyIn(new ArrayList<String>(processKey))).list();
        this.processEngine.getManagementService().executeCommand(commandContext -> {
            for (Task task : tasks) {
                processInsIds.add(task.getProcessInstanceId());
                TaskEntity taskEntity = commandContext.getTaskEntityManager().findTaskById(task.getId());
                taskEntity.setAssignee(null);
                ((TaskEntity)task).addCandidateUser(userId, mandator, "1");
                taskIds.add(task.getId());
                procTaskMap.computeIfAbsent(task.getProcessInstanceId(), e -> new ArrayList()).add(task.getId());
            }
            for (String processInsId : processInsIds) {
                new ProcessActionCmd(processInsId).execute(commandContext);
                new ProcessNodeCmd(processInsId).execute(commandContext);
            }
            return null;
        });
        this.urgeTaskService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(SysActUrgeTask::getTaskState, (Object)"1")).set(SysActUrgeTask::getReceiveUser, (Object)userId)).set(SysActUrgeTask::getOwner, (Object)mandator)).eq(SysActUrgeTask::getReceiveUser, (Object)mandator)).in(SysActUrgeTask::getProcDefKey, processKey)).isNull(SysActUrgeTask::getTaskState)).isNull(SysActUrgeTask::getOwner));
        taskIds.forEach(taskId -> this.activityRedisTimerService.updateTimeOutModel((String)taskId, userId, mandator, 1));
        if (this.dataPushService.isDataPush(processDefinitionIdList)) {
            DataPush dataPush = new DataPush();
            dataPush.setTaskIds(taskIds);
            dataPush.setProcTaskMap(procTaskMap);
            dataPush.setUserId(userId);
            dataPush.setConsignor(mandator);
            dataPush.setTaskState("1");
            dataPush.setProcessKeys(new ArrayList<String>(processKey));
            dataPush.setProcessDefinitionIdList(processDefinitionIdList);
            dataPush.setTaskProcDefIdMap(taskProcDefIdMap);
            this.dataPushService.transferTask(dataPush);
        }
    }

    public void reTransferTask(List<String> taskIds, String userId) {
        HashSet processInsIds = new HashSet();
        this.processEngine.getManagementService().executeCommand(commandContext -> {
            for (String taskId : taskIds) {
                TaskEntity taskEntity = commandContext.getTaskEntityManager().findTaskById(taskId);
                processInsIds.add(taskEntity.getProcessInstanceId());
                if (taskEntity.getDueDate() == null) continue;
                taskEntity.getCandidates().forEach(identityLink -> {
                    if (userId.equals(identityLink.getMandator())) {
                        this.activityRedisTimerService.updateTimeOutModel(taskId, userId, identityLink.getUserId(), 1);
                    }
                });
            }
            return null;
        });
        List<Long> longList = taskIds.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        HashSet<String> processdefinitionIdList = new HashSet<String>();
        HashMap<String, String> consigneeMap = new HashMap<String, String>();
        HashMap<String, String> taskProcDefIdMap = new HashMap<String, String>();
        HashMap<String, List> procTaskMap = new HashMap<String, List>();
        for (String taskId : taskIds) {
            Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
            procTaskMap.computeIfAbsent(task.getProcessInstanceId(), e -> new ArrayList()).add(task.getId());
            String processDefinitionId = task.getProcessDefinitionId();
            processdefinitionIdList.add(processDefinitionId);
            List identityLinks = this.taskService.getIdentityLinksType(taskId);
            String consignor = null;
            for (IdentityLink identityLink : identityLinks) {
                if (!HussarUtils.isNotEmpty((Object)identityLink.getMandator()) || !userId.equals(identityLink.getMandator())) continue;
                consignor = identityLink.getUserId();
                break;
            }
            consigneeMap.put(taskId, consignor);
            taskProcDefIdMap.put(taskId, processDefinitionId);
        }
        this.sysActEntrustMapper.reTransferTask(longList, userId);
        this.processEngine.getManagementService().executeCommand(commandContext -> {
            for (String processInsId : processInsIds) {
                new ProcessActionCmd(processInsId).execute(commandContext);
                new ProcessNodeCmd(processInsId).execute(commandContext);
            }
            return null;
        });
        this.urgeTaskService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(SysActUrgeTask::getTaskState, null)).set(SysActUrgeTask::getReceiveUser, (Object)userId)).set(SysActUrgeTask::getOwner, null)).in(SysActUrgeTask::getTaskId, longList));
        if (this.dataPushService.isDataPush(processdefinitionIdList)) {
            this.dataPushService.reTransferTask(new DataPush().setTaskIds(taskIds).setProcTaskMap(procTaskMap).setUserId(userId).setConsigneeMap(consigneeMap).setProcessDefinitionIdList(processdefinitionIdList).setTaskProcDefIdMap(taskProcDefIdMap).setTaskState("1"));
        }
    }
}

