/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.message.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.msg.push.dto.AppServiceDto;
import com.jxdinfo.hussar.msg.push.service.PushMsgService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import com.jxdinfo.hussar.workflow.assignee.model.BpmUserInfoVo;
import com.jxdinfo.hussar.workflow.common.InstallResult;
import com.jxdinfo.hussar.workflow.config.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.message.model.BpmActMsgDetail;
import com.jxdinfo.hussar.workflow.engine.bpm.message.push.config.BpmMsgProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.message.service.BpmMsgPushMessageService;
import com.jxdinfo.hussar.workflow.engine.bpm.message.service.BpmMsgPushService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.SysActAssignee;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysActAssigneeService;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.manage.util.BpmSpringContextHolder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.engine.RepositoryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.ServletRequestAttributes;

@HussarTokenDs
@Service
public class BpmMsgPushServiceImpl
implements BpmMsgPushService {
    private static final Logger logger = LoggerFactory.getLogger(BpmMsgPushServiceImpl.class);
    @Autowired
    private SysActAssigneeService sysActAssigneeService;
    @Autowired
    private IAssigneeChooseService iAssigneeChooseService;
    @Autowired
    private BpmMsgProperties bpmMsgProperties;
    @Autowired(required=false)
    private PushMsgService pushMsgService;
    @Autowired
    private BpmMsgPushMessageService bpmMsgPushMessageService;
    @Autowired
    private LcdpBpmProperties lcdpBpmProperties;

    public void pushMessage(List<BpmActMsgDetail> bpmActMsgDetailList) {
        if (!this.lcdpBpmProperties.isEnableMessageService()) {
            return;
        }
        this.setAppIdAndAppSecret(bpmActMsgDetailList);
        for (BpmActMsgDetail bpmActMsgDetail : bpmActMsgDetailList) {
            if (HussarUtils.isEmpty((Object)bpmActMsgDetail.getChannelType())) {
                this.setChannelType(bpmActMsgDetail);
                if (HussarUtils.isEmpty((Object)bpmActMsgDetail.getChannelType())) break;
            }
            if (!this.verifyInputMessage(bpmActMsgDetail)) break;
            this.setMessageData(bpmActMsgDetail);
            this.setUserMsg(bpmActMsgDetail);
            String connName = HussarContextHolder.getConnName();
            String tenantCode = HussarContextHolder.getHussarTenant().getTenantCode();
            ServletRequestAttributes newServletRequestAttributes = HussarContextHolder.getNewServletRequestAttributes((String)tenantCode);
            this.bpmMsgPushMessageService.pushMessageAsync(bpmActMsgDetail, newServletRequestAttributes, tenantCode, connName);
        }
    }

    private void setAppIdAndAppSecret(List<BpmActMsgDetail> bpmActMsgDetailList) {
        if (HussarUtils.isNotEmpty(bpmActMsgDetailList)) {
            String appId = this.bpmMsgProperties.getAppId();
            String appSecret = this.bpmMsgProperties.getAppSecret();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            for (BpmActMsgDetail bpmActMsgDetail : bpmActMsgDetailList) {
                bpmActMsgDetail.setAppId(appId);
                bpmActMsgDetail.setAppSecret(appSecret);
                bpmActMsgDetail.setCurrentTime(sdf.format(new Date()));
            }
        }
    }

    private boolean verifyInputMessage(BpmActMsgDetail bpmActMsgDetail) {
        if (HussarUtils.isEmpty((Object)bpmActMsgDetail.getSceneCode())) {
            logger.error("\u7f3a\u5c11\u573a\u666f\u7c7b\u578b\uff01");
            return false;
        }
        if (HussarUtils.isEmpty((Object)bpmActMsgDetail.getProcessKey())) {
            logger.error("\u7f3a\u5c11\u6d41\u7a0b\u6807\u8bc6\uff01");
            return false;
        }
        if (HussarUtils.isEmpty((Object)bpmActMsgDetail.getReceive())) {
            logger.error("\u6d41\u7a0b[{}],{},\u7f3a\u5c11\u7528\u6237id\uff01", (Object)bpmActMsgDetail.getProcessKey(), (Object)bpmActMsgDetail.getSceneCode());
            return false;
        }
        return true;
    }

    private void setUserMsg(BpmActMsgDetail bpmActMsgDetail) {
        List bpmUserInfoVos = this.iAssigneeChooseService.getUserMsgByUserIds(bpmActMsgDetail.getReceive());
        logger.info("\u83b7\u53d6\u6d88\u606f\u53d1\u9001\u4eba\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)bpmUserInfoVos));
        HashMap<String, Object> userMsg = new HashMap<String, Object>();
        for (BpmUserInfoVo bpmUserInfoVo : bpmUserInfoVos) {
            userMsg.put(bpmUserInfoVo.getId(), JSON.parseObject((String)JSON.toJSONString((Object)bpmUserInfoVo), Map.class));
        }
        bpmActMsgDetail.setUserMsg(userMsg);
    }

    private void setMessageData(BpmActMsgDetail bpmActMsgDetail) {
        Map<Object, Object> messageData = new HashMap();
        switch (bpmActMsgDetail.getSceneCode()) {
            case "todo": {
                bpmActMsgDetail.setMessage("\u60a8\u4e8e#{currentTime}\u6536\u5230#{processName}\u6d41\u7a0b\u7684\u5f85\u529e\u4efb\u52a1\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002");
                bpmActMsgDetail.setMessageType("\u5f85\u529e\u63d0\u9192");
                messageData = this.assembleMessageData(bpmActMsgDetail);
                bpmActMsgDetail.setMessageData(messageData);
                bpmActMsgDetail.setSceneCode(this.bpmMsgProperties.getTodoSceneCode());
                break;
            }
            case "reject": {
                bpmActMsgDetail.setMessage("\u60a8\u4e8e#{currentTime}\u6536\u5230#{processName}\u6d41\u7a0b\u7684\u9a73\u56de\u4efb\u52a1\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002");
                bpmActMsgDetail.setMessageType("\u9a73\u56de\u63d0\u9192");
                messageData = this.assembleMessageData(bpmActMsgDetail);
                bpmActMsgDetail.setMessageData(messageData);
                bpmActMsgDetail.setSceneCode(this.bpmMsgProperties.getRejectSceneCode());
                break;
            }
            case "reminders": {
                bpmActMsgDetail.setMessage("\u60a8\u4e8e#{currentTime}\u6536\u5230#{processName}\u6d41\u7a0b\uff0c#{taskName}\u4efb\u52a1\u7684\u50ac\u529e\u6d88\u606f\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002");
                bpmActMsgDetail.setMessageType("\u50ac\u529e\u63d0\u9192");
                messageData = this.assembleMessageData(bpmActMsgDetail);
                bpmActMsgDetail.setMessageData(messageData);
                bpmActMsgDetail.setSceneCode(this.bpmMsgProperties.getRemindersSceneCode());
                break;
            }
            case "entrust": {
                Map msgData = bpmActMsgDetail.getMessageData();
                msgData.put("currentTime", bpmActMsgDetail.getCurrentTime());
                bpmActMsgDetail.setMessageData(msgData);
                bpmActMsgDetail.setMessage("\u60a8\u4e8e#{currentTime}\u6536\u5230#{processName}\u6d41\u7a0b\u7684\u59d4\u6258\uff0c\u59d4\u6258\u65f6\u95f4#{startTime}\u81f3#{endTime}\uff0c\u540e\u7eed\u76f8\u5173\u4efb\u52a1\u8bf7\u53ca\u65f6\u5904\u7406\u3002");
                bpmActMsgDetail.setMessageType("\u59d4\u6258\u63d0\u9192");
                bpmActMsgDetail.setSceneCode(this.bpmMsgProperties.getEntrustSceneCode());
                break;
            }
            case "complete": {
                bpmActMsgDetail.setMessage("\u60a8\u63d0\u4ea4\u7684#{processName}\u6d41\u7a0b\u5df2\u4e8e#{currentTime}\u5ba1\u6279\u5b8c\u6210\uff0c\u8bf7\u53ca\u65f6\u67e5\u770b\u6d41\u7a0b\u7ed3\u679c\u3002");
                bpmActMsgDetail.setMessageType("\u6d41\u7a0b\u5b8c\u6210\u63d0\u9192");
                messageData = this.assembleMessageData(bpmActMsgDetail);
                bpmActMsgDetail.setMessageData(messageData);
                bpmActMsgDetail.setSceneCode(this.bpmMsgProperties.getCompleteSceneCode());
                break;
            }
            case "terminated": {
                bpmActMsgDetail.setMessage("\u60a8\u63d0\u4ea4\u7684#{processName}\u6d41\u7a0b\u5df2\u4e8e#{currentTime}\u7ec8\u6b62\uff0c\u8bf7\u53ca\u65f6\u67e5\u770b\u6d41\u7a0b\u7ed3\u679c\u3002");
                bpmActMsgDetail.setMessageType("\u6d41\u7a0b\u7ec8\u6b62\u63d0\u9192");
                messageData = this.assembleMessageData(bpmActMsgDetail);
                bpmActMsgDetail.setMessageData(messageData);
                bpmActMsgDetail.setSceneCode(this.bpmMsgProperties.getTerminatedSceneCode());
                break;
            }
            case "exception": {
                bpmActMsgDetail.setMessage("#{processName} \u6d41\u7a0b\u5728\u8fd0\u884c\u65f6\u53d1\u751f\u5f02\u5e38\uff0c\u5f02\u5e38\u7c7b\u578b\uff1a#{expType}\uff0c\u6d41\u7a0b\u6807\u8bc6\uff1a#{processKey}\uff0c\u8282\u70b9\u6807\u8bc6\uff1a#{taskKey}\uff0c \u8282\u70b9\u540d\uff1a#{taskName}\uff0c\u8bf7\u53ca\u65f6\u6392\u67e5\u5904\u7406\u3002");
                bpmActMsgDetail.setMessageType("\u6d41\u7a0b\u5f02\u5e38\u63d0\u9192");
                bpmActMsgDetail.setSceneCode(this.bpmMsgProperties.getExceptionSceneCode());
                break;
            }
        }
    }

    public Map<String, String> assembleMessageData(BpmActMsgDetail bpmActMsgDetail) {
        HashMap<String, String> messageData = new HashMap<String, String>();
        messageData.put("processName", bpmActMsgDetail.getProcessName());
        messageData.put("title", bpmActMsgDetail.getProcessTitle());
        messageData.put("subTitle", bpmActMsgDetail.getDataDetail());
        messageData.put("webFormAddress", bpmActMsgDetail.getWebFormAddress());
        messageData.put("mobileFormAddress", bpmActMsgDetail.getMobileFormAddress());
        messageData.put("webFromDetailAddress", bpmActMsgDetail.getWebFormDetailAddress());
        messageData.put("mobileFormDetailAddress", bpmActMsgDetail.getMobileFormDetailAddress());
        messageData.put("businessId", bpmActMsgDetail.getBusinessId());
        messageData.put("taskId", bpmActMsgDetail.getTaskId());
        messageData.put("processDefinitionKey", bpmActMsgDetail.getProcessKey());
        messageData.put("taskDefinitionKey", bpmActMsgDetail.getTaskDefKey());
        messageData.put("portalAppId", bpmActMsgDetail.getPortalAppId());
        messageData.put("formId", bpmActMsgDetail.getFormId());
        messageData.put("processInstanceId", bpmActMsgDetail.getProcessInstanceId());
        messageData.put("tabType", bpmActMsgDetail.getTabType());
        messageData.put("taskName", bpmActMsgDetail.getTaskDefName());
        messageData.put("currentTime", bpmActMsgDetail.getCurrentTime());
        return messageData;
    }

    private void setChannelType(BpmActMsgDetail bpmActMsgDetail) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysActAssignee::getProcDefKey, (Object)bpmActMsgDetail.getProcessKey());
        if (HussarUtils.isEmpty((Object)bpmActMsgDetail.getTaskDefKey())) {
            queryWrapper.isNull(SysActAssignee::getTaskDefKey);
        } else {
            queryWrapper.eq(SysActAssignee::getTaskDefKey, (Object)bpmActMsgDetail.getTaskDefKey());
        }
        int version = Integer.parseInt(bpmActMsgDetail.getProcessDefinitionId().split(":")[1]);
        ((LambdaQueryWrapper)queryWrapper.eq(SysActAssignee::getContentType, (Object)"defaultAssign")).eq(SysActAssignee::getProcessVersion, (Object)version);
        SysActAssignee sysActAssignee = (SysActAssignee)this.sysActAssigneeService.getOne((Wrapper)queryWrapper);
        if (HussarUtils.isNotEmpty((Object)sysActAssignee)) {
            bpmActMsgDetail.setChannelType(sysActAssignee.getMessageType());
        } else {
            bpmActMsgDetail.setChannelType(null);
        }
        if (HussarUtils.isEmpty((Object)bpmActMsgDetail.getChannelType())) {
            if (HussarUtils.isEmpty((Object)bpmActMsgDetail.getProcessDefinitionId())) {
                logger.error("\u6d88\u606f\u63a8\u9001\uff0c\u7f3a\u5c11\u6d41\u7a0b\u5b9a\u4e49id\uff01");
                return;
            }
            RepositoryService repositoryService = (RepositoryService)BpmSpringContextHolder.getBean(RepositoryService.class);
            BpmnModel bm = repositoryService.getBpmnModel(bpmActMsgDetail.getProcessDefinitionId());
            if (HussarUtils.isEmpty((Object)bpmActMsgDetail.getTaskDefKey())) {
                String target = "";
                for (FlowElement flowElement : ((Process)bm.getProcesses().get(0)).getFlowElements()) {
                    if (!(flowElement instanceof StartEvent)) continue;
                    target = ((SequenceFlow)((StartEvent)flowElement).getOutgoingFlows().get(0)).getTargetRef();
                    break;
                }
                for (FlowElement flowElement : ((Process)bm.getProcesses().get(0)).getFlowElements()) {
                    if (!flowElement.getId().equals(target) || flowElement.getExtensionElements().get("messageType") == null) continue;
                    List list = (List)((ExtensionElement)((List)flowElement.getExtensionElements().get("messageType")).get(0)).getAttributes().get("messageType");
                    bpmActMsgDetail.setChannelType(HussarUtils.isNotEmpty((Object)list) ? ((ExtensionAttribute)list.get(0)).getValue() : null);
                    break;
                }
            } else {
                Map extensionElementsNode = bm.getFlowElement(bpmActMsgDetail.getTaskDefKey()).getExtensionElements();
                if (extensionElementsNode.get("messageType") != null) {
                    List list = (List)((ExtensionElement)((List)extensionElementsNode.get("messageType")).get(0)).getAttributes().get("messageType");
                    bpmActMsgDetail.setChannelType(HussarUtils.isNotEmpty((Object)list) ? ((ExtensionAttribute)list.get(0)).getValue() : null);
                }
            }
        }
    }

    public BpmResponseResult getBpmActChannel(String sceneCategory) {
        if (HussarUtils.isEmpty((Object)this.pushMsgService) || !this.lcdpBpmProperties.isEnableMessageService()) {
            return InstallResult.success();
        }
        AppServiceDto appServiceDto = new AppServiceDto();
        appServiceDto.setAppId(this.bpmMsgProperties.getAppId());
        appServiceDto.setAppSecret(this.bpmMsgProperties.getAppSecret());
        appServiceDto.setSceneCategory(sceneCategory);
        try {
            return InstallResult.success((JSONArray)JSON.parseArray((String)JSON.toJSONString((Object)this.pushMsgService.getAppService(appServiceDto))));
        }
        catch (HussarException e) {
            return InstallResult.fail((String)("\u67e5\u8be2\u6d88\u606f\u63d0\u9192\u65b9\u5f0f\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }
}

