/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.manage.engine.upgrade;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.workflow.common.InstallResult;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.SaveBatchEntrustDto;
import com.jxdinfo.hussar.workflow.engine.bpm.entrust.CommissionedQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.entrust.EntrustAddDto;
import com.jxdinfo.hussar.workflow.engine.bpm.entrust.EntrustQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.entrust.EntrustStatusUpdateDto;
import com.jxdinfo.hussar.workflow.engine.bpm.entrust.EntrustUpdateDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processentrust.service.ISysActEntrustService;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.upgrade.StandardSysActEntrustApiService;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StandardSysActEntrustWorkflowApiService
implements StandardSysActEntrustApiService {
    @Autowired
    private ISysActEntrustService sysActEntrustService;

    public BpmResponseResult queryEntrust(EntrustQueryDto entrustQueryDto) {
        Page pages = new Page((long)entrustQueryDto.getPage().intValue(), (long)entrustQueryDto.getSize().intValue());
        return this.sysActEntrustService.list(pages, entrustQueryDto.getUserId(), entrustQueryDto.getProcessKey(), entrustQueryDto.getState(), entrustQueryDto.getStartTime(), entrustQueryDto.getEndTime());
    }

    public BpmResponseResult addEntrust(EntrustAddDto entrustAddDto) {
        return this.sysActEntrustService.add(entrustAddDto.getProcessKey(), entrustAddDto.getTaskDefinitionKey(), entrustAddDto.getMandator(), entrustAddDto.getMandatary(), entrustAddDto.getState(), entrustAddDto.getStartTime(), entrustAddDto.getEndTime(), entrustAddDto.getIsTransferTask(), entrustAddDto.getMessageType());
    }

    public BpmResponseResult addBatchEntrust(SaveBatchEntrustDto entrustBatchAddDto) {
        return this.sysActEntrustService.addBatch(String.join((CharSequence)",", entrustBatchAddDto.getProcessKey()), entrustBatchAddDto.getMandator(), entrustBatchAddDto.getMandatary(), entrustBatchAddDto.getState(), entrustBatchAddDto.getStartTime(), entrustBatchAddDto.getEndTime(), entrustBatchAddDto.getIsTransferTask(), entrustBatchAddDto.getMessageType());
    }

    public BpmResponseResult deleteEntrust(String tEntrustId) {
        ArrayList<String> tEntrustIds = new ArrayList<String>(Arrays.asList(tEntrustId.split(",")));
        List longList = tEntrustIds.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        this.sysActEntrustService.removeByIds(longList);
        return InstallResult.getResult((String)"1", (String)BpmExceptionCodeEnum.DELETE_SUCCESS.getMessage(), null);
    }

    public BpmResponseResult updateEntrust(EntrustUpdateDto entrustUpdateDto) {
        return this.sysActEntrustService.update(entrustUpdateDto.getId(), entrustUpdateDto.getMandatary(), (Date)Timestamp.valueOf(entrustUpdateDto.getStartTime()), (Date)Timestamp.valueOf(entrustUpdateDto.getEndTime()), entrustUpdateDto.getMessageType());
    }

    public BpmResponseResult detailEntrust(String tEntrustId) {
        JSONArray jsonArray = new JSONArray();
        jsonArray.add(this.sysActEntrustService.getById((Serializable)Long.valueOf(Long.parseLong(tEntrustId))));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    public BpmResponseResult updateEntrustState(EntrustStatusUpdateDto entrustStatusUpdateDto) {
        BpmResponseResult bpmResponseResult = this.sysActEntrustService.updateState(entrustStatusUpdateDto.gettEntrustId(), entrustStatusUpdateDto.getState());
        if (bpmResponseResult.isSuccess()) {
            if ("1".equals(entrustStatusUpdateDto.getState())) {
                return InstallResult.getResult((String)"1", (String)BpmExceptionCodeEnum.SUCCESS_START.getMessage(), null);
            }
            return InstallResult.getResult((String)"1", (String)BpmExceptionCodeEnum.SUCCESS_STOP.getMessage(), null);
        }
        return bpmResponseResult;
    }

    public BpmResponseResult queryCommissionedInfo(CommissionedQueryDto commissionedQueryDto) {
        return this.sysActEntrustService.queryCommissionedInfo(commissionedQueryDto.getUserId(), commissionedQueryDto.getProcessKey(), commissionedQueryDto.getMandator(), (Date)Timestamp.valueOf(commissionedQueryDto.getStartTime()), (Date)Timestamp.valueOf(commissionedQueryDto.getEndTime()), String.valueOf(commissionedQueryDto.getPage()), String.valueOf(commissionedQueryDto.getSize()));
    }
}

