/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.manage.bpm.customform.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import com.jxdinfo.hussar.workflow.engine.bpm.customform.model.CustomForm;
import com.jxdinfo.hussar.workflow.engine.bpm.customform.service.ICustomFormService;
import com.jxdinfo.hussar.workflow.engine.bpm.customform.vo.CategoryAndFormTreeVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u4e09\u65b9\u8868\u5355"})
@RequestMapping(value={"/bpm/formInfo"})
public class CustomFormController {
    @Autowired
    private ICustomFormService customFormService;

    @PostMapping(value={"/add"})
    @ApiOperation(value="\u65b0\u589e\u8868\u5355", notes="\u65b0\u589e\u8868\u5355")
    @AuditLog(moduleName="\u8868\u5355\u7ba1\u7406", eventDesc="\u65b0\u589e\u8868\u5355", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    @CheckPermission(value={"bpm:formInfo:add"})
    public ApiResponse<String> add(@RequestBody CustomForm customForm) {
        return ApiResponse.status((boolean)this.customFormService.add(customForm));
    }

    @PostMapping(value={"/update"})
    @ApiOperation(value="\u4fee\u6539\u8868\u5355", notes="\u4fee\u6539\u8868\u5355")
    @AuditLog(moduleName="\u8868\u5355\u7ba1\u7406", eventDesc="\u4fee\u6539\u8868\u5355", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    @CheckPermission(value={"bpm:formInfo:update"})
    public ApiResponse<String> update(@RequestBody CustomForm customForm) {
        return ApiResponse.status((boolean)this.customFormService.update(customForm));
    }

    @PostMapping(value={"/delete"})
    @ApiOperation(value="\u5220\u9664\u8868\u5355", notes="\u5220\u9664\u8868\u5355")
    @AuditLog(moduleName="\u8868\u5355\u7ba1\u7406", eventDesc="\u5220\u9664\u8868\u5355", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    @CheckPermission(value={"bpm:formInfo:delete"})
    public ApiResponse<String> update(@RequestBody Long formId) {
        return ApiResponse.status((boolean)this.customFormService.delete(formId));
    }

    @GetMapping(value={"/detail"})
    @ApiOperation(value="\u8868\u5355\u8be6\u60c5\u67e5\u8be2", notes="\u8868\u5355\u8be6\u60c5\u67e5\u8be2")
    @AuditLog(moduleName="\u8868\u5355\u7ba1\u7406", eventDesc="\u8868\u5355\u8be6\u60c5\u67e5\u8be2", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"bpm:formInfo:detail"})
    public ApiResponse<CustomForm> detail(Long formId) {
        return ApiResponse.success((Object)this.customFormService.detail(formId));
    }

    @GetMapping(value={"/queryCustomFormByName"})
    @ApiOperation(value="\u8868\u5355\u67e5\u8be2", notes="\u8868\u5355\u67e5\u8be2")
    @AuditLog(moduleName="\u8868\u5355\u7ba1\u7406", eventDesc="\u8868\u5355\u67e5\u8be2", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"bpm:formInfo:queryCustomFormByName"})
    public ApiResponse<IPage<CustomForm>> queryCustomFormByName(Page<CustomForm> page, Long categoryId, String formName) {
        return ApiResponse.success((Object)this.customFormService.queryCustomFormByName(page, categoryId, formName));
    }

    @GetMapping(value={"/queryCategoryAndFormTree"})
    @ApiOperation(value="\u8868\u5355\u53ca\u5206\u7c7b\u6811\u61d2\u52a0\u8f7d\u67e5\u8be2", notes="\u8868\u5355\u53ca\u5206\u7c7b\u6811\u61d2\u52a0\u8f7d\u67e5\u8be2")
    @AuditLog(moduleName="\u8868\u5355\u7ba1\u7406", eventDesc="\u8868\u5355\u53ca\u5206\u7c7b\u6811\u61d2\u52a0\u8f7d\u67e5\u8be2", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<CategoryAndFormTreeVo>> categoryAndFormTree(Long parentId) {
        return ApiResponse.success((Object)this.customFormService.categoryAndFormTree(parentId));
    }

    @GetMapping(value={"/fullCategoryAndFormTree"})
    @ApiOperation(value="\u8868\u5355\u53ca\u5206\u7c7b\u6811\u5168\u67e5\u8be2", notes="\u8868\u5355\u53ca\u5206\u7c7b\u6811\u5168\u67e5\u8be2")
    @AuditLog(moduleName="\u8868\u5355\u7ba1\u7406", eventDesc="\u8868\u5355\u53ca\u5206\u7c7b\u6811\u5168\u67e5\u8be2", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<CategoryAndFormTreeVo>> fullCategoryAndFormTree() {
        return ApiResponse.success((Object)this.customFormService.categoryAndFormTree());
    }

    @GetMapping(value={"/categoryAndFormList"})
    @ApiOperation(value="\u8868\u5355\u53ca\u5206\u7c7b\u5217\u8868\u5168\u67e5\u8be2", notes="\u8868\u5355\u53ca\u5206\u7c7b\u5217\u8868\u5168\u67e5\u8be2")
    @AuditLog(moduleName="\u8868\u5355\u7ba1\u7406", eventDesc="\u8868\u5355\u53ca\u5206\u7c7b\u5217\u8868\u5168\u67e5\u8be2", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<CategoryAndFormTreeVo>> categoryAndFormList() {
        return ApiResponse.success((Object)this.customFormService.categoryAndFormList());
    }

    @GetMapping(value={"/queryCategoryAndFormTreeByFormName"})
    @ApiOperation(value="\u8868\u5355\u53ca\u5206\u7c7b\u6811\u6a21\u7cca\u67e5\u8be2", notes="\u8868\u5355\u53ca\u5206\u7c7b\u6811\u6a21\u7cca\u67e5\u8be2")
    @AuditLog(moduleName="\u8868\u5355\u7ba1\u7406", eventDesc="\u8868\u5355\u53ca\u5206\u7c7b\u6811\u6a21\u7cca\u67e5\u8be2", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<CategoryAndFormTreeVo>> queryCategoryAndFormTreeByFormName(String formName) {
        return ApiResponse.success((Object)this.customFormService.queryCategoryAndFormTreeByFormName(formName));
    }
}

