/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.extend;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.general.calendar.service.ISysCalendarRefService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.activiti.dao.BpmActHiActinstMapper;
import com.jxdinfo.hussar.workflow.activiti.dao.BpmActHiVarinstMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.candidateuser.model.CandidateUser;
import com.jxdinfo.hussar.workflow.engine.bpm.candidateuser.service.ICandidateUserService;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.model.SysActCcTask;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.service.ISysActCcTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.model.ConfigUser;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.AnalyticalModelUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.CommonCodeUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.WorkflowBpmUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dao.TaskEngineMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.JumpInfo;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.impl.TaskEngineServiceImpl;
import com.jxdinfo.hussar.workflow.engine.bpm.extend.ExtendCallActivityBehavior;
import com.jxdinfo.hussar.workflow.engine.bpm.extend.ExtendSubProcessActivityBehavior;
import com.jxdinfo.hussar.workflow.engine.bpm.message.model.BpmActMsgDetail;
import com.jxdinfo.hussar.workflow.engine.bpm.message.service.BpmMsgPushService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.WorkFlow;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.model.TimeOutModel;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import com.jxdinfo.hussar.workflow.engine.constant.BpmAttribute;
import com.jxdinfo.hussar.workflow.engine.constant.BpmHistoryTask;
import com.jxdinfo.hussar.workflow.engine.constant.TaskSourceFlag;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowModel;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowObject;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowPageMsg;
import com.jxdinfo.hussar.workflow.manage.bpm.constant.SubProcessInfo;
import com.jxdinfo.hussar.workflow.manage.util.BpmSpringContextHolder;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.CallActivity;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SubProcess;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.delegate.BpmnError;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.ExecutionListener;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.delegate.VariableScope;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.ParallelMultiInstanceBehavior;
import org.activiti.engine.impl.bpmn.helper.ErrorPropagation;
import org.activiti.engine.impl.bpmn.listener.DelegateExpressionExecutionListener;
import org.activiti.engine.impl.bpmn.parser.FieldDeclaration;
import org.activiti.engine.impl.calendar.BusinessCalendar;
import org.activiti.engine.impl.cfg.IdGenerator;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.db.DbSqlSession;
import org.activiti.engine.impl.db.PersistentObject;
import org.activiti.engine.impl.el.ExpressionManager;
import org.activiti.engine.impl.el.FixedValue;
import org.activiti.engine.impl.el.JuelExpression;
import org.activiti.engine.impl.el.ParsingElContext;
import org.activiti.engine.impl.javax.el.ELContext;
import org.activiti.engine.impl.javax.el.PropertyNotFoundException;
import org.activiti.engine.impl.javax.el.ValueExpression;
import org.activiti.engine.impl.juel.ExpressionFactoryImpl;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.HistoricActivityInstanceEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntityManager;
import org.activiti.engine.impl.pvm.PvmActivity;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.task.TaskDefinition;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendParallelMultiInstanceBehavior
extends ParallelMultiInstanceBehavior {
    private static final String VARIABLE_NAME = "multiInstanceAssignee";
    private static final String USER_ID = "userId";
    private static ISysActCcTaskService iSysActCcTaskService = (ISysActCcTaskService)BpmSpringContextHolder.getSpringContext().getBean(ISysActCcTaskService.class);
    private static RepositoryService repositoryService = (RepositoryService)BpmSpringContextHolder.getSpringContext().getBean(RepositoryService.class);
    private static ActivityRedisTimerService activityRedisTimer = (ActivityRedisTimerService)BpmSpringContextHolder.getSpringContext().getBean(ActivityRedisTimerService.class);
    private static ICandidateUserService candidateUserService = (ICandidateUserService)BpmSpringContextHolder.getSpringContext().getBean(ICandidateUserService.class);
    private static TaskEngineMapper taskEngineMapper = (TaskEngineMapper)BpmSpringContextHolder.getSpringContext().getBean(TaskEngineMapper.class);
    private static HistoryService historyService = (HistoryService)BpmSpringContextHolder.getSpringContext().getBean(HistoryService.class);
    private static DataPushService dataPushService = (DataPushService)BpmSpringContextHolder.getSpringContext().getBean(DataPushService.class);
    private static BpmMsgPushService msgPushService = (BpmMsgPushService)BpmSpringContextHolder.getSpringContext().getBean(BpmMsgPushService.class);
    private static ISysCalendarRefService sysCalendarRefService = (ISysCalendarRefService)BpmSpringContextHolder.getSpringContext().getBean(ISysCalendarRefService.class);
    private static SysActProcessFileService sysActProcessFileService = (SysActProcessFileService)BpmSpringContextHolder.getSpringContext().getBean(SysActProcessFileService.class);
    private static BpmActHiActinstMapper bpmActHiActinstMapper = (BpmActHiActinstMapper)BpmSpringContextHolder.getBean(BpmActHiActinstMapper.class);
    private static BpmActHiVarinstMapper bpmActHiVarinstMapper = (BpmActHiVarinstMapper)BpmSpringContextHolder.getBean(BpmActHiVarinstMapper.class);
    private static BpmConstantProperties bpmConstantProperties = (BpmConstantProperties)BpmSpringContextHolder.getBean(BpmConstantProperties.class);
    private final Logger logger = LoggerFactory.getLogger(ExtendParallelMultiInstanceBehavior.class);

    public ExtendParallelMultiInstanceBehavior(ActivityImpl activity, AbstractBpmnActivityBehavior originalActivityBehavior) {
        super(activity, originalActivityBehavior);
    }

    protected void createInstances(ActivityExecution execution) throws Exception {
        int nrOfInstances;
        List timeOutElement;
        String isEmulation = Context.getCommandContext().getHistoricProcessInstanceEntityManager().findHistoricProcessInstance(execution.getProcessInstanceId()).getIsEmulation();
        if (HussarUtils.isNotEmpty((Object)isEmulation)) {
            ((ExecutionEntity)execution).addTempVariable("call_activity_info", (Object)JSONArray.parseArray((String)JSON.toJSONString(execution.getVariables().get(((ExecutionEntity)execution).getActivityId()))));
        }
        if (this.innerActivityBehavior instanceof ExtendCallActivityBehavior) {
            this.callActivitiCreateListener((ExecutionEntity)execution);
        }
        boolean flag = "callActivity".equals(execution.getActivity().getProperty("type")) || "subProcess".equals(execution.getActivity().getProperty("type"));
        BpmnModel bm = repositoryService.getBpmnModel(execution.getProcessDefinitionId());
        String timeOutStrategy = null;
        FlowElement element = bm.getFlowElement(execution.getActivity().getId());
        if (!flag && HussarUtils.isNotEmpty((Object)(timeOutElement = (List)element.getExtensionElements().get("TimeOutStrategy"))) && HussarUtils.isNotEmpty((Object)((ExtensionElement)timeOutElement.get(0)).getAttributes())) {
            timeOutStrategy = ((ExtensionAttribute)((List)((ExtensionElement)timeOutElement.get(0)).getAttributes().get("TimeOutStrategy")).get(0)).getValue();
        }
        ArrayList<String> messageType = new ArrayList<String>();
        List<ConfigUser> users = this.getUser(bm, execution, flag, messageType);
        String appointAssignee = this.getAppointAssignee(flag, users);
        int n = nrOfInstances = users == null ? 0 : users.size();
        if (nrOfInstances == 0 && ((Process)bm.getProcesses().get(0)).getFlowElement(((ExecutionEntity)execution).getActivityId()) instanceof SubProcess) {
            HistoricActivityInstanceEntity historicActivityInstance = Context.getCommandContext().getHistoryManager().findActivityInstance((ExecutionEntity)execution);
            historicActivityInstance.setSubProcessKey("");
            historicActivityInstance.setCycleCount(Integer.valueOf(0));
        }
        HashMap<String, Object> map = new HashMap();
        if (!flag && !TaskSourceFlag.isRevoke((String)BpmAttribute.getTaskSourceFlag(execution))) {
            map = AnalyticalModelUtil.getCcUser(bm, execution);
        }
        this.setLoopVariable(execution, "nrOfInstances", nrOfInstances);
        this.setLoopVariable(execution, "nrOfCompletedInstances", 0);
        this.setLoopVariable(execution, "nrOfActiveInstances", nrOfInstances);
        ArrayList<ActivityExecution> concurrentExecutions = new ArrayList<ActivityExecution>();
        for (int loopCounter = 0; loopCounter < nrOfInstances; ++loopCounter) {
            ActivityExecution concurrentExecution = execution.createExecution();
            concurrentExecution.setActive(true);
            concurrentExecution.setConcurrent(true);
            concurrentExecution.setScope(false);
            concurrentExecutions.add(concurrentExecution);
            this.logLoopDetails(concurrentExecution, "initialized", loopCounter, 0, nrOfInstances, nrOfInstances);
        }
        ArrayList<String> userList = new ArrayList<String>();
        ArrayList<TaskEntity> skipTaskEntityList = new ArrayList<TaskEntity>();
        Date date = Context.getProcessEngineConfiguration().getClock().getCurrentTime();
        for (int loopCounter = 0; loopCounter < nrOfInstances; ++loopCounter) {
            ActivityExecution concurrentExecution = (ActivityExecution)concurrentExecutions.get(loopCounter);
            if (!concurrentExecution.isActive() || concurrentExecution.isEnded() || !concurrentExecution.getParent().isActive() || concurrentExecution.getParent().isEnded()) continue;
            this.setLoopVariable(concurrentExecution, this.getCollectionElementIndexVariable(), loopCounter);
            TaskEntity taskEntity = null;
            taskEntity = loopCounter == 0 ? this.executeBpmOriginalBehavior(concurrentExecution, loopCounter, users, flag, userList, timeOutStrategy, map, date, appointAssignee) : this.executeBpmOriginalBehavior(concurrentExecution, loopCounter, users, flag, userList, timeOutStrategy, null, date, appointAssignee);
            if (taskEntity == null) continue;
            skipTaskEntityList.add(taskEntity);
        }
        if (!flag) {
            execution.removeVariable("TimeOutStrategy");
        }
        if (!concurrentExecutions.isEmpty()) {
            ExecutionEntity executionEntity = (ExecutionEntity)execution;
            executionEntity.setActive(false);
        }
        if (!flag) {
            Boolean notNeedCheckAssignee = (Boolean)Context.getCommandContext().getAttribute("notNeedCheckAssignee");
            if (notNeedCheckAssignee != null && !notNeedCheckAssignee.booleanValue() && HussarUtils.isEmpty(users)) {
                throw new BpmException(BpmExceptionCodeEnum.NULL_ASSIGNEE);
            }
            List receiveUser = new ArrayList();
            if (HussarUtils.isNotEmpty(users)) {
                receiveUser = ConfigUser.getAllOwner(ArrayList::new, users);
                receiveUser.removeAll(userList);
            }
            if (!TaskSourceFlag.isRevoke((String)BpmAttribute.getTaskSourceFlag(execution)) && HussarUtils.isNotEmpty(receiveUser) && nrOfInstances != 0 && !"main_process_start".equals(BpmAttribute.getTaskSourceFlag(execution))) {
                ArrayList<BpmActMsgDetail> bpmActMsgDetailList = new ArrayList<BpmActMsgDetail>();
                BpmActMsgDetail bpmActMsgDetail = new BpmActMsgDetail();
                bpmActMsgDetail.setProcessKey(((ExecutionEntity)execution).getProcessDefinitionKey());
                bpmActMsgDetail.setProcessName(((ExecutionEntity)execution).getProcessDefinition().getName());
                bpmActMsgDetail.setProcessDefinitionId(((ExecutionEntity)execution).getProcessDefinition().getId());
                bpmActMsgDetail.setTaskDefKey(((ExecutionEntity)execution).getActivityId());
                bpmActMsgDetail.setTaskDefName(execution.getCurrentActivityName());
                bpmActMsgDetail.setReceive(receiveUser);
                bpmActMsgDetail.setChannelType(HussarUtils.isNotEmpty(messageType) ? (String)messageType.get(0) : null);
                if (TaskSourceFlag.isReject((String)BpmAttribute.getTaskSourceFlag(execution))) {
                    bpmActMsgDetail.setSceneCode("reject");
                } else {
                    bpmActMsgDetail.setSceneCode("todo");
                }
                if (HussarUtils.isNotEmpty((Object)BaseSecurityUtil.getUser())) {
                    bpmActMsgDetail.setTenantId(BaseSecurityUtil.getUser().getTenantId());
                }
                bpmActMsgDetailList.add(bpmActMsgDetail);
                msgPushService.pushMessage(bpmActMsgDetailList);
            }
            if (HussarUtils.isNotEmpty(skipTaskEntityList)) {
                for (TaskEntity taskEntity : skipTaskEntityList) {
                    taskEntity.setSendUser(taskEntity.getAssignee());
                    taskEntity.setTaskSourceFlag("skip");
                    Context.getCommandContext().addAttribute("skipOrSatisfied", (Object)"skip");
                    taskEntity.complete(null, false);
                    String skipOrSatisfied = (String)Context.getCommandContext().getAttribute("skipOrSatisfied");
                    Context.getCommandContext().addAttribute("skipOrSatisfied", null);
                    HashSet<String> processDefinitionIdList = new HashSet<String>();
                    processDefinitionIdList.add(taskEntity.getProcessDefinitionId());
                    if (dataPushService.isDataPush(processDefinitionIdList)) {
                        DataPush dataPush = new DataPush();
                        dataPush.setBusinessKey(taskEntity.getProcessInstance().getBusinessKey());
                        dataPush.setProcessKey(taskEntity.getProcessInstance().getProcessDefinitionKey());
                        dataPush.setProcessInsId(taskEntity.getProcessInstanceId());
                        dataPush.setTaskId(taskEntity.getId());
                        dataPush.setTaskDefinitionKey(taskEntity.getTaskDefinitionKey());
                        dataPush.setTaskDefinitionName(taskEntity.getName());
                        dataPush.setUrl(taskEntity.getFormKey());
                        dataPush.setStartDate(taskEntity.getCreateTime());
                        dataPush.setUserId(taskEntity.getAssignee());
                        dataPush.setEndDate(new Date());
                        dataPush.setProcessDefinitionId(taskEntity.getProcessDefinitionId());
                        dataPushService.completeDataPush(dataPush);
                    }
                    if (!HussarUtils.isNotEmpty((Object)skipOrSatisfied) || !"satisfied".equals(skipOrSatisfied)) continue;
                    break;
                }
            }
        }
        if (nrOfInstances == 0) {
            this.leave(execution);
        }
    }

    private String getAppointAssignee(boolean flag, List<ConfigUser> users) {
        String appointAssignee = null;
        if (!flag) {
            appointAssignee = ConfigUser.getAppointAssignee(users);
        }
        return appointAssignee;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected TaskEntity executeBpmOriginalBehavior(ActivityExecution execution, int loopCounter, List<ConfigUser> collection, boolean flag, List<String> userList, String timeOutStrategy, Map<String, Object> ccUserMap, Date date, String appointAssignee) throws Exception {
        ConfigUser value = null;
        if (collection != null && !collection.isEmpty()) {
            Iterator<ConfigUser> it = collection.iterator();
            for (int index = 0; index <= loopCounter; ++index) {
                value = it.next();
            }
        }
        if (loopCounter == 0) {
            if (!flag) return this.insertTask(execution, value, true, userList, timeOutStrategy, ccUserMap, date, appointAssignee);
            if (this.innerActivityBehavior instanceof ExtendSubProcessActivityBehavior) {
                ActivityExecution subProcessExecution = execution.createExecution();
                subProcessExecution.setActive(true);
                subProcessExecution.setConcurrent(false);
                subProcessExecution.setScope(true);
                this.innerActivityBehavior.execute(subProcessExecution);
                return null;
            } else {
                this.innerActivityBehavior.execute(execution);
            }
            return null;
        } else {
            if (!flag) return this.insertTask(execution, value, false, userList, timeOutStrategy, ccUserMap, date, appointAssignee);
            execution.executeActivity((PvmActivity)this.activity);
        }
        return null;
    }

    private void ccTask(Task task, List<String> users, String userId, ActivityExecution execution, BpmnModel bpmnModel) {
        if (users.isEmpty()) {
            return;
        }
        ArrayList<SysActCcTask> list = new ArrayList<SysActCcTask>();
        ProcessInstance processInstance = (ProcessInstance)execution.getProcessInstance();
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        if (processInstance != null) {
            List ccFormKeyList;
            Map ccFormKeyMap;
            List ccElement = (List)bpmnModel.getFlowElement(task.getTaskDefinitionKey()).getExtensionElements().get("ccFormKey");
            String formKey = null;
            if (ccElement != null && !ccElement.isEmpty() && (ccFormKeyMap = ((ExtensionElement)ccElement.get(0)).getAttributes()) != null && (ccFormKeyList = (List)ccFormKeyMap.get("ccFormKey")) != null && !ccFormKeyList.isEmpty()) {
                formKey = ((ExtensionAttribute)ccFormKeyList.get(0)).getValue();
            }
            for (String user : users) {
                SysActCcTask sysActCcTask = new SysActCcTask();
                sysActCcTask.setProcessInsId(Long.valueOf(Long.parseLong(task.getProcessInstanceId())));
                sysActCcTask.setProcName(((ExecutionEntity)processInstance).getProcessDefinition().getName());
                sysActCcTask.setTaskId(Long.valueOf(Long.parseLong(task.getId())));
                sysActCcTask.setTaskName(task.getName());
                sysActCcTask.setReceiveUser(user);
                sysActCcTask.setSendUser(userId);
                sysActCcTask.setSendTime(ts);
                sysActCcTask.setFormKey(formKey);
                sysActCcTask.setTaskDefKey(task.getTaskDefinitionKey());
                sysActCcTask.setProcDefKey(processInstance.getProcessDefinitionKey());
                sysActCcTask.setProcDefId(processInstance.getProcessDefinitionId());
                sysActCcTask.setBusinessId(execution.getProcessBusinessKey());
                sysActCcTask.setTaskState("0");
                sysActCcTask.setCcMoment("0");
                sysActCcTask.setToDoConfig(task.getTodoConfiguration());
                list.add(sysActCcTask);
            }
        }
        if (!list.isEmpty()) {
            iSysActCcTaskService.saveBatch(list);
        }
    }

    private JSONArray getRightActivity(JSONArray allCallActivityInfos, ActivityExecution execution) {
        JSONArray callActivityInfos = new JSONArray();
        for (Object allCallActivityInfo : allCallActivityInfos) {
            JSONObject object = (JSONObject)allCallActivityInfo;
            if (!HussarUtils.isEmpty((Object)object.get((Object)"taskDefinitionKey")) && !((ExecutionEntity)execution).getActivityId().equals(object.get((Object)"taskDefinitionKey"))) continue;
            callActivityInfos.add((Object)object);
        }
        return callActivityInfos;
    }

    protected DbSqlSession getDbSqlSession() {
        return this.getSession(DbSqlSession.class);
    }

    protected <T> T getSession(Class<T> sessionClass) {
        return (T)Context.getCommandContext().getSession(sessionClass);
    }

    private TaskEntity insertTask(ActivityExecution execution, ConfigUser configUser, boolean flag, List<String> userList, String timeOutStrategy, Map<String, Object> ccUserMap, Date date, String appointAssignee) {
        Object formKey;
        Object category;
        Object priority;
        HistoricTaskInstance lastComplete;
        TaskEntity task = TaskEntity.create((Date)date);
        task.setNewTask(true);
        task.setBpmExecution((DelegateExecution)execution);
        task.setProcessCycleCount(((ExecutionEntity)execution).getProcessCycleCount());
        Long multiId = (Long)BpmAttribute.getExecutionAttribute(execution, "multi_id");
        task.setMultiId(multiId == null ? Long.valueOf(execution.getParentId()) : multiId);
        task.setSuspensionState(((ExecutionEntity)execution).getProcessInstance().getSuspensionState());
        HashMap<String, Object> variable = (HashMap<String, Object>)execution.getProcessInstance().getTempVariable("processVariables");
        if (variable == null) {
            variable = new HashMap<String, Object>();
        }
        variable.putAll(execution.getProcessInstance().getVariables());
        task.setTodoConfiguration(AnalyticalModelUtil.getTodo(variable, AnalyticalModelUtil.getToDoConfiguration(execution.getProcessDefinitionId(), execution.getCurrentActivityId())));
        task.setCompleteType(BpmAttribute.getTaskSourceFlag(execution));
        JumpInfo jumpInfo = (JumpInfo)BpmAttribute.getContextAttribute("jump_info");
        task.setJumpInfo(JumpInfo.toJsonString((JumpInfo)jumpInfo));
        String allPrevNode = TaskSourceFlag.isRejectOrRevoke((String)BpmAttribute.getTaskSourceFlag(execution)) ? ((lastComplete = BpmHistoryTask.getLastComplete(execution.getProcessInstanceId(), execution.getSubProcessKey(), execution.getCurrentActivityId())) == null ? null : lastComplete.getAllPrevNode()) : ((ExecutionEntity)execution).getAllPrevNode();
        task.setAllPrevNode(allPrevNode);
        task.insert((ExecutionEntity)execution);
        if (jumpInfo != null && jumpInfo.isJumpExecution() && HussarUtils.isNotEmpty((Object)jumpInfo.getJumpFromExecutionInfo())) {
            task.setVariableLocal("jump_execution_info", (Object)jumpInfo.getJumpFromExecutionInfo());
        }
        task.setAppointAssignee(appointAssignee);
        TaskDefinition taskDefinition = (TaskDefinition)execution.getActivity().getProperty("taskDefinition");
        Expression activeNameExpression = null;
        Expression activeDescriptionExpression = null;
        Expression activeDueDateExpression = null;
        Expression activePriorityExpression = null;
        Expression activeCategoryExpression = null;
        Expression activeFormKeyExpression = null;
        Expression activeSkipExpression = null;
        Expression activeAssigneeExpression = null;
        Expression activeOwnerExpression = null;
        Set<Expression> activeCandidateUserExpressions = null;
        Set<Expression> activeCandidateGroupExpressions = null;
        if (Context.getProcessEngineConfiguration().isEnableProcessDefinitionInfoCache()) {
            ObjectNode taskElementProperties = Context.getBpmnOverrideElementProperties((String)execution.getActivity().getId(), (String)execution.getProcessDefinitionId());
            activeNameExpression = this.getActiveValue(taskDefinition.getNameExpression(), "userTaskName", taskElementProperties);
            taskDefinition.setNameExpression(activeNameExpression);
            activeDescriptionExpression = this.getActiveValue(taskDefinition.getDescriptionExpression(), "userTaskDescription", taskElementProperties);
            taskDefinition.setDescriptionExpression(activeDescriptionExpression);
            activeDueDateExpression = this.getActiveValue(taskDefinition.getDueDateExpression(), "userTaskDueDate", taskElementProperties);
            taskDefinition.setDueDateExpression(activeDueDateExpression);
            activePriorityExpression = this.getActiveValue(taskDefinition.getPriorityExpression(), "userTaskPriority", taskElementProperties);
            taskDefinition.setPriorityExpression(activePriorityExpression);
            activeCategoryExpression = this.getActiveValue(taskDefinition.getCategoryExpression(), "userTaskCategory", taskElementProperties);
            taskDefinition.setCategoryExpression(activeCategoryExpression);
            activeFormKeyExpression = this.getActiveValue(taskDefinition.getFormKeyExpression(), "userTaskFormKey", taskElementProperties);
            taskDefinition.setFormKeyExpression(activeFormKeyExpression);
            activeSkipExpression = this.getActiveValue(taskDefinition.getSkipExpression(), "taskSkipExpression", taskElementProperties);
            taskDefinition.setSkipExpression(activeSkipExpression);
            activeAssigneeExpression = this.getActiveValue(taskDefinition.getAssigneeExpression(), "userTaskAssignee", taskElementProperties);
            taskDefinition.setAssigneeExpression(activeAssigneeExpression);
            activeOwnerExpression = this.getActiveValue(taskDefinition.getOwnerExpression(), "userTaskOwner", taskElementProperties);
            taskDefinition.setOwnerExpression(activeOwnerExpression);
            activeCandidateUserExpressions = this.getActiveValueSet(taskDefinition.getCandidateUserIdExpressions(), "userTaskCandidateUsers", taskElementProperties);
            taskDefinition.setCandidateUserIdExpressions(activeCandidateUserExpressions);
            activeCandidateGroupExpressions = this.getActiveValueSet(taskDefinition.getCandidateGroupIdExpressions(), "userTaskCandidateGroups", taskElementProperties);
            taskDefinition.setCandidateGroupIdExpressions(activeCandidateGroupExpressions);
        } else {
            activeNameExpression = taskDefinition.getNameExpression();
            activeDescriptionExpression = taskDefinition.getDescriptionExpression();
            activeDueDateExpression = taskDefinition.getDueDateExpression();
            activePriorityExpression = taskDefinition.getPriorityExpression();
            activeCategoryExpression = taskDefinition.getCategoryExpression();
            activeFormKeyExpression = taskDefinition.getFormKeyExpression();
            activeSkipExpression = taskDefinition.getSkipExpression();
        }
        task.setTaskDefinition(taskDefinition);
        if (activeNameExpression != null) {
            String name = null;
            try {
                name = (String)activeNameExpression.getValue((VariableScope)execution);
            }
            catch (ActivitiException e2) {
                name = activeNameExpression.getExpressionText();
                LOGGER.warn("property not found in task name expression {}", (Object)e2.getMessage());
            }
            task.setName(name);
        }
        if (activeDescriptionExpression != null) {
            String description = null;
            try {
                description = (String)activeDescriptionExpression.getValue((VariableScope)execution);
            }
            catch (ActivitiException e3) {
                description = activeDescriptionExpression.getExpressionText();
                LOGGER.warn("property not found in task description expression {}", (Object)e3.getMessage());
            }
            task.setDescription(description);
        }
        BpmnModel bm = repositoryService.getBpmnModel(task.getProcessDefinitionId());
        if (activeDueDateExpression != null) {
            FlowElement element = bm.getFlowElement(execution.getActivity().getId());
            List chosenDayElement = (List)element.getExtensionElements().get("chosenDay");
            String chosenDay = null;
            if (HussarUtils.isNotEmpty((Object)chosenDayElement) && HussarUtils.isNotEmpty((Object)((ExtensionElement)chosenDayElement.get(0)).getAttributes())) {
                chosenDay = ((ExtensionAttribute)((List)((ExtensionElement)chosenDayElement.get(0)).getAttributes().get("chosenDay")).get(0)).getValue();
            }
            if ("workingDay".equals(chosenDay)) {
                Date nowDate = new Date();
                Instant instant = nowDate.toInstant();
                LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
                LocalDateTime dueTime = sysCalendarRefService.getDueDateDefult(localDateTime, String.valueOf(activeDueDateExpression), true);
                ZonedDateTime zonedDateTime = dueTime.atZone(ZoneId.systemDefault());
                Instant instant2 = zonedDateTime.toInstant();
                Date dueDate = Date.from(instant2);
                task.setDueDate(dueDate);
            } else {
                Object dueDate = activeDueDateExpression.getValue((VariableScope)execution);
                if (dueDate != null) {
                    if (dueDate instanceof Date) {
                        task.setDueDate((Date)dueDate);
                    } else if (dueDate instanceof String) {
                        BusinessCalendar businessCalendar = Context.getProcessEngineConfiguration().getBusinessCalendarManager().getBusinessCalendar(taskDefinition.getBusinessCalendarNameExpression().getValue((VariableScope)execution).toString());
                        task.setDueDate(businessCalendar.resolveDuedate((String)dueDate));
                    } else {
                        throw new ActivitiIllegalArgumentException("Due date expression does not resolve to a Date or Date string: " + activeDueDateExpression.getExpressionText());
                    }
                }
            }
        }
        if (activePriorityExpression != null && (priority = activePriorityExpression.getValue((VariableScope)execution)) != null) {
            if (priority instanceof String) {
                try {
                    task.setPriority(Integer.parseInt((String)priority));
                }
                catch (NumberFormatException e4) {
                    throw new ActivitiIllegalArgumentException("Priority does not resolve to a number: " + priority, (Throwable)e4);
                }
            } else if (priority instanceof Number) {
                task.setPriority(((Number)priority).intValue());
            } else {
                throw new ActivitiIllegalArgumentException("Priority expression does not resolve to a number: " + activePriorityExpression.getExpressionText());
            }
        }
        if (activeCategoryExpression != null && (category = activeCategoryExpression.getValue((VariableScope)execution)) != null) {
            if (category instanceof String) {
                task.setCategory((String)category);
            } else {
                throw new ActivitiIllegalArgumentException("Category expression does not resolve to a string: " + activeCategoryExpression.getExpressionText());
            }
        }
        if (activeFormKeyExpression != null && (formKey = activeFormKeyExpression.getValue((VariableScope)execution)) != null) {
            if (formKey instanceof String) {
                task.setFormKey((String)formKey);
            } else {
                throw new ActivitiIllegalArgumentException("FormKey expression does not resolve to a string: " + activeFormKeyExpression.getExpressionText());
            }
        }
        WorkFlow workFlow = sysActProcessFileService.getFileByProcessDefId(task.getProcessDefinitionId());
        FlowModel flowModel = (FlowModel)JSONObject.parseObject((String)workFlow.getData(), FlowModel.class);
        List list = flowModel.getSlots().getElement();
        for (FlowObject flowObject : list) {
            if (!task.getTaskDefinitionKey().equals(flowObject.getInstanceKey())) continue;
            Map flowPageMsgMap = flowObject.getProps().getFormDetailAddress();
            if (flowPageMsgMap == null) break;
            task.setFormId(((FlowPageMsg)flowPageMsgMap.get("web")).getId());
            break;
        }
        Map extensionElementsNode = bm.getFlowElement(task.getTaskDefinitionKey()).getExtensionElements();
        boolean skip = false;
        String repeatUser = null;
        if (extensionElementsNode.get("skiprepetition") != null) {
            String taskSourceFlag;
            String skipTypeValue = ((ExtensionAttribute)((List)((ExtensionElement)((List)extensionElementsNode.get("skiprepetition")).get(0)).getAttributes().get("skiprepetition")).get(0)).getValue();
            List hisTaskList = ((HistoricTaskInstanceQuery)historyService.createHistoricTaskInstanceQuery().processInstanceId(task.getProcessInstanceId())).listPage(0, 1);
            if (hisTaskList != null && !hisTaskList.isEmpty() && ((taskSourceFlag = BpmAttribute.getTaskSourceFlag(execution)) == null || TaskSourceFlag.isComplete((String)taskSourceFlag))) {
                List<String> skipList = Arrays.asList(skipTypeValue.split(","));
                if (skipList.contains("1") && configUser == null) {
                    if (HussarUtils.isNotEmpty((Object)task.getDueDate())) {
                        activityRedisTimer.delTimeOutModel(task.getId());
                    }
                    skip = true;
                }
                ArrayList<String> lastNodeAssignees = new ArrayList<String>();
                if (configUser != null) {
                    String lastActivityId;
                    if (skipList.contains("3")) {
                        List historicTaskInstances = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)historyService.createHistoricTaskInstanceQuery().processInstanceId(task.getProcessInstanceId())).subProcessKey(task.getSubProcessKey())).list();
                        historicTaskInstances.removeIf(historicTaskInstance -> historicTaskInstance.getEndTime() == null);
                        historicTaskInstances.sort(Comparator.comparing(HistoricTaskInstance::getEndTime).reversed());
                        Map<String, List<HistoricTaskInstance>> historicTaskInstancesMap = WorkflowBpmUtil.getListMap(historicTaskInstances, TaskInfo::getTaskDefinitionKey, null);
                        historicTaskInstancesMap.remove(execution.getCurrentActivityId());
                        ArrayList<HistoricTaskInstance> lastTask = new ArrayList<HistoricTaskInstance>();
                        for (List<HistoricTaskInstance> hiList : historicTaskInstancesMap.values()) {
                            if (HussarUtils.isNotEmpty(hiList) && hiList.get(0).getSubProcessKey() != null) {
                                Map<String, List<HistoricTaskInstance>> subProcessHistoricTaskInstancesMap = WorkflowBpmUtil.getListMap(hiList, HistoricTaskInstance::getSubProcessKey, null);
                                for (List<HistoricTaskInstance> subProcessHistoricTaskInstancesList : subProcessHistoricTaskInstancesMap.values()) {
                                    CommonCodeUtil.getLastTaskCompleted(subProcessHistoricTaskInstancesList, lastTask);
                                }
                                continue;
                            }
                            CommonCodeUtil.getLastTaskCompleted(hiList, lastTask);
                        }
                        if (HussarUtils.isNotEmpty(lastTask)) {
                            lastTask.sort(Comparator.comparing(HistoricTaskInstance::getEndTime).reversed());
                            for (HistoricTaskInstance historicTaskInstance2 : lastTask) {
                                String assignee = historicTaskInstance2.getOriginalAssignee();
                                if (!HussarUtils.isNotEmpty((Object)assignee)) continue;
                                lastNodeAssignees.add(assignee);
                            }
                        }
                    } else if (skipList.contains("2") && HussarUtils.isNotEmpty((Object)(lastActivityId = task.getAllPrevNode()))) {
                        List<String> lastTaskDefinitionKeyList = Arrays.asList(lastActivityId.split(","));
                        HistoricTaskInstanceQuery historicTaskInstanceQuery = (HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)historyService.createHistoricTaskInstanceQuery().processInstanceId(task.getProcessInstanceId())).subProcessKey(task.getSubProcessKey());
                        if (lastTaskDefinitionKeyList.size() > 1) {
                            historicTaskInstanceQuery.taskDefinitionKeys(lastTaskDefinitionKeyList);
                        } else {
                            historicTaskInstanceQuery.taskDefinitionKey(lastTaskDefinitionKeyList.get(0));
                        }
                        List historicTaskInstances = historicTaskInstanceQuery.list();
                        historicTaskInstances.removeIf(historicTaskInstance -> historicTaskInstance.getEndTime() == null);
                        historicTaskInstances.sort(Comparator.comparing(HistoricTaskInstance::getEndTime).reversed());
                        Map<String, List<HistoricTaskInstance>> historicTaskInstancesMap = WorkflowBpmUtil.getListMap(historicTaskInstances, TaskInfo::getTaskDefinitionKey, null);
                        ArrayList<HistoricTaskInstance> lastTask = new ArrayList<HistoricTaskInstance>();
                        for (List<HistoricTaskInstance> hisList : historicTaskInstancesMap.values()) {
                            CommonCodeUtil.getLastTaskCompleted(hisList, lastTask);
                        }
                        lastTask.sort(Comparator.comparing(HistoricTaskInstance::getEndTime).reversed());
                        lastTask.forEach(e -> lastNodeAssignees.add(e.getOriginalAssignee()));
                    }
                    Set<String> userIdList = ConfigUser.getAllUserId(Collections.singletonList(configUser));
                    for (String lastNodeAssignee : lastNodeAssignees) {
                        if (!userIdList.contains(lastNodeAssignee)) continue;
                        task.setAssignee(lastNodeAssignee);
                        skip = true;
                        repeatUser = lastNodeAssignee;
                        if (!HussarUtils.isNotEmpty((Object)task.getDueDate())) break;
                        activityRedisTimer.delTimeOutModel(task.getId());
                        break;
                    }
                }
            }
        }
        String delayToAssign = "";
        if (extensionElementsNode.get("delayToAssign") != null) {
            delayToAssign = ((ExtensionAttribute)((List)((ExtensionElement)((List)extensionElementsNode.get("delayToAssign")).get(0)).getAttributes().get("delayToAssign")).get(0)).getValue();
        }
        if (HussarUtils.isNotEmpty((Object)configUser)) {
            if (!"true".equals(delayToAssign)) {
                ConfigUser.recursionUser(user -> task.addCandidateUser(user.getUserId(), user.getOwner(), "1"), Collections.singletonList(configUser));
            } else {
                String taskId = task.getId();
                ArrayList candidateUserList = new ArrayList();
                ConfigUser.recursionUser(user -> {
                    CandidateUser tmp = new CandidateUser();
                    tmp.setTaskId(Long.valueOf(Long.parseLong(taskId)));
                    tmp.setAssignee(user.taskOwner());
                    candidateUserList.add(tmp);
                }, Collections.singletonList(configUser));
                candidateUserService.saveBatch(candidateUserList);
            }
        }
        task.fireEvent("create");
        if (HussarUtils.isNotEmpty(ccUserMap)) {
            List ccUsers = (List)ccUserMap.get("ccUser");
            String sendUserId = (String)ccUserMap.get("ccSendUser");
            if (HussarUtils.isNotEmpty((Object)ccUsers) && HussarUtils.isNotEmpty((Object)sendUserId)) {
                this.ccTask((Task)task, ccUsers, sendUserId, execution, bm);
            }
        }
        if (Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityEvent((ActivitiEventType)ActivitiEventType.TASK_CREATED, (Object)task));
        }
        if (!skip && HussarUtils.isNotEmpty((Object)task.getDueDate()) && HussarUtils.isNotEmpty((Object)timeOutStrategy)) {
            TimeOutModel timeOutModel = new TimeOutModel();
            timeOutModel.setTaskId(Long.valueOf(Long.parseLong(task.getId())));
            timeOutModel.setCreateTime(task.getCreateTime());
            timeOutModel.setDueTime(task.getDueDate());
            if (HussarUtils.isNotEmpty((Object)configUser)) {
                timeOutModel.setAssignee(String.join((CharSequence)",", ConfigUser.getAllOwner(Collections.singletonList(configUser))));
            }
            timeOutModel.setTimeOutType(timeOutStrategy);
            if (timeOutModel.getTimeOutType().startsWith("http") || "urging".equals(timeOutModel.getTimeOutType())) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("name", task.getName());
                map.put("processInsId", task.getProcessInstanceId());
                map.put("processDefinitionId", task.getProcessDefinitionId());
                map.put("taskDefinitionKey", task.getTaskDefinitionKey());
                map.put("formKey", task.getFormKey());
                map.put("businessId", execution.getProcessBusinessKey());
                map.put("processName", ((ExecutionEntity)execution).getProcessDefinition().getName());
                map.put("todoConfiguration", task.getTodoConfiguration());
                map.put("sendUser", task.getSendUser());
                timeOutModel.setMap(JSON.toJSONString(map));
            }
            activityRedisTimer.addTimeOutModel(timeOutModel);
        }
        if (flag) {
            String user2 = null;
            if (HussarUtils.isNotEmpty((Object)configUser)) {
                user2 = ConfigUser.getAllUserId(Collections.singletonList(configUser)).iterator().next();
            }
            this.insertActHiActinst(execution, user2, task);
        }
        task.fireEvent("start");
        if (skip) {
            if (HussarUtils.isNotEmpty(repeatUser)) {
                userList.add(repeatUser);
            }
            return task;
        }
        return null;
    }

    public void leave(ActivityExecution execution) {
        ExecutionEntity executionEntity;
        Context.getCommandContext().getHistoryManager().recordActivityEnd((ExecutionEntity)execution);
        ActivityExecution newExecution = execution;
        if (this.innerActivityBehavior instanceof ExtendSubProcessActivityBehavior) {
            executionEntity = (ExecutionEntity)execution;
            newExecution = execution.getParent();
            executionEntity.remove();
        }
        if (TaskEngineServiceImpl.getSubProcessRejectList().contains(execution.getProcessInstanceId() + ((ExecutionEntity)execution).getActivityId())) {
            return;
        }
        if (TaskEngineServiceImpl.getCallRejectList().contains(execution.getProcessInstanceId() + ((ExecutionEntity)execution).getActivityId())) {
            return;
        }
        int nrOfInstances = this.getLoopVariable(execution, "nrOfInstances");
        if (nrOfInstances == 0) {
            ((ExecutionEntity)execution).setAllPrevNode(((ExecutionEntity)execution).getActivityId());
            this.activityLeaveCcTask(execution);
            try {
                super.leave(execution);
            }
            catch (Exception e) {
                throw new PublicClientException(BpmExceptionCodeEnum.PROCESS_SUBMIT_FAIL.getMessage());
            }
        } else {
            int loopCounter = this.getLoopVariable(execution, this.getCollectionElementIndexVariable());
            int nrOfCompletedInstances = this.getLoopVariable(execution, "nrOfCompletedInstances") + 1;
            int nrOfActiveInstances = this.getLoopVariable(execution, "nrOfActiveInstances") - 1;
            if (newExecution.getParent() != null) {
                this.setLoopVariable(newExecution.getParent(), "nrOfCompletedInstances", nrOfCompletedInstances);
                this.setLoopVariable(newExecution.getParent(), "nrOfActiveInstances", nrOfActiveInstances);
            }
            this.logLoopDetails(newExecution, "instance completed", loopCounter, nrOfCompletedInstances, nrOfActiveInstances, nrOfInstances);
            executionEntity = (ExecutionEntity)newExecution;
            if (executionEntity.getParent() != null) {
                String currActivityId = executionEntity.getActivityId();
                if (executionEntity.getParent().getParent() != null) {
                    String skip = (String)Context.getCommandContext().getAttribute("skipOrSatisfied");
                    if (HussarUtils.isNotEmpty((Object)skip) && "skip".equals(skip)) {
                        String all_prev_node = executionEntity.getParent().getParent().getAllPrevNode();
                        executionEntity.getParent().getParent().setAllPrevNode(all_prev_node);
                    } else {
                        executionEntity.getParent().getParent().setAllPrevNode(currActivityId);
                    }
                }
                executionEntity.inactivate();
                executionEntity.getParent().forceUpdate();
                List joinedExecutions = executionEntity.findInactiveConcurrentExecutions(newExecution.getActivity());
                if (nrOfCompletedInstances >= nrOfInstances || this.completionConditionSatisfied(newExecution)) {
                    Context.getCommandContext().addAttribute("skipOrSatisfied", (Object)"satisfied");
                    ArrayList<ExecutionEntity> executionsToRemove = new ArrayList<ExecutionEntity>();
                    for (ActivityExecution childExecution : executionEntity.getParent().getExecutions()) {
                        if (!childExecution.isActive()) continue;
                        executionsToRemove.add((ExecutionEntity)childExecution);
                    }
                    ArrayList<String> updateTaskIds = new ArrayList<String>();
                    for (ExecutionEntity executionEntity2 : executionsToRemove) {
                        this.getExecutionAllTasks(updateTaskIds, executionEntity2);
                    }
                    StringBuilder taskIds = new StringBuilder();
                    for (String taskId : updateTaskIds) {
                        taskIds.append(",").append(taskId);
                    }
                    if (HussarUtils.isNotEmpty((Object)taskIds.toString())) {
                        activityRedisTimer.delTimeOutModel(taskIds.toString().substring(1));
                    }
                    if (HussarUtils.isNotEmpty(updateTaskIds)) {
                        List list = updateTaskIds.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
                        TaskEntityManager taskEntityManager = Context.getCommandContext().getTaskEntityManager();
                        String processKey = "";
                        String processDefinitionId = "";
                        for (String string : updateTaskIds) {
                            TaskEntity taskEntity = taskEntityManager.findTaskById(string);
                            processKey = taskEntity.getProcessDefinitionId().split(":")[0];
                            processDefinitionId = taskEntity.getProcessDefinitionId();
                            taskEntityManager.deleteTask(taskEntity, "", true, "");
                            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityWithVariablesEvent((ActivitiEventType)ActivitiEventType.TASK_COMPLETED, (Object)taskEntity, null, (boolean)false));
                        }
                        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
                        lambdaQueryWrapper.in(SysActCcTask::getTaskId, list);
                        iSysActCcTaskService.remove((Wrapper)lambdaQueryWrapper);
                        for (String taskId : updateTaskIds) {
                            Context.getCommandContext().getHistoricTaskInstanceEntityManager().deleteHistoricTaskInstanceById(taskId);
                        }
                        HashSet<String> hashSet = new HashSet<String>();
                        hashSet.add(processDefinitionId);
                        if (dataPushService.isDataPush(hashSet)) {
                            DataPush dataPush = new DataPush();
                            dataPush.setProcessKey(processKey);
                            dataPush.setProcessDefinitionId(processDefinitionId);
                            dataPush.setTaskIds(updateTaskIds);
                            dataPush.setProcessInsId(execution.getProcessInstanceId());
                            dataPushService.deleteMultiTask(dataPush);
                        }
                        List ccTasks = iSysActCcTaskService.list((Wrapper)new LambdaQueryWrapper().in(SysActCcTask::getTaskId, list));
                        String unDelTaskId = null;
                        HashSet<String> taskIdSet = new HashSet<String>(updateTaskIds);
                        List historicTaskInstanceList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)historyService.createHistoricTaskInstanceQuery().processInstanceId(execution.getProcessInstanceId())).taskDefinitionKey(execution.getActivity().getId())).list();
                        for (HistoricTaskInstance historicTaskInstance : historicTaskInstanceList) {
                            if (taskIdSet.contains(historicTaskInstance.getId())) continue;
                            unDelTaskId = historicTaskInstance.getId();
                        }
                        if (HussarUtils.isNotEmpty((Object)ccTasks) && HussarUtils.isNotEmpty(unDelTaskId)) {
                            iSysActCcTaskService.updateBatchById((Collection)ccTasks);
                            if (dataPushService.isDataPush(hashSet)) {
                                ArrayList<DataPush> dataPushList = new ArrayList<DataPush>();
                                for (SysActCcTask ccTask : ccTasks) {
                                    DataPush dataPush = new DataPush();
                                    dataPush.setUserId(ccTask.getReceiveUser());
                                    dataPush.setTaskId(unDelTaskId);
                                    dataPush.setStartDate((Date)ccTask.getSendTime());
                                    dataPush.setEndDate((Date)ccTask.getEndTime());
                                    dataPush.setCcMoment(ccTask.getCcMoment() == null ? "0" : ccTask.getCcMoment());
                                    dataPush.setProcessInsId(execution.getProcessInstanceId());
                                    dataPushList.add(dataPush);
                                }
                                dataPushService.addCcTask(dataPushList);
                            }
                        }
                    }
                    for (ExecutionEntity executionEntity3 : executionsToRemove) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Execution {} still active, but multi-instance is completed. Removing this execution.", (Object)executionEntity3);
                        }
                        executionEntity3.inactivate();
                        executionEntity3.deleteCascade("multi-instance completed");
                    }
                    this.activityLeaveCcTask(execution);
                    executionEntity.takeAll(executionEntity.getActivity().getOutgoingTransitions(), joinedExecutions);
                }
            } else {
                this.activityLeaveCcTask(execution);
                ((ExecutionEntity)execution).setAllPrevNode(((ExecutionEntity)execution).getActivityId());
                super.leave((ActivityExecution)executionEntity);
            }
        }
    }

    private void activityLeaveCcTask(ActivityExecution execution) {
        if ("callActivity".equals(execution.getActivity().getProperty("type")) || "subProcess".equals(execution.getActivity().getProperty("type"))) {
            return;
        }
        BpmnModel bm = repositoryService.getBpmnModel(execution.getProcessDefinitionId());
        Map<String, Object> ccUserMap = AnalyticalModelUtil.getCcEndUser(bm, execution);
        List ccUserIds = (List)ccUserMap.get("ccUser");
        String ccSendUser = (String)ccUserMap.get("ccSendUser");
        if (!ccUserIds.isEmpty()) {
            List ccFormKeyList;
            Map ccFormKeyMap;
            String processInsId = execution.getProcessInstanceId();
            String taskDefKey = execution.getCurrentActivityId();
            String subProcessKey = execution.getSubProcessKey();
            if (ccUserIds.isEmpty()) {
                return;
            }
            List hisTaskList = Context.getCommandContext().getTaskEntityManager().findAllHistoricTask(processInsId, taskDefKey, subProcessKey);
            hisTaskList.sort((o1, o2) -> o2.getEndTime().compareTo(o1.getEndTime()));
            List<String> userIds = AnalyticalModelUtil.getMultiInstanceUser(hisTaskList);
            HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)hisTaskList.get(0);
            ArrayList<SysActCcTask> list = new ArrayList<SysActCcTask>();
            ProcessInstance processInstance = (ProcessInstance)execution.getProcessInstance();
            Timestamp ts = new Timestamp(System.currentTimeMillis());
            List ccElement = (List)bm.getFlowElement(historicTaskInstance.getTaskDefinitionKey()).getExtensionElements().get("ccFormKey");
            String formKey = null;
            if (ccElement != null && !ccElement.isEmpty() && (ccFormKeyMap = ((ExtensionElement)ccElement.get(0)).getAttributes()) != null && (ccFormKeyList = (List)ccFormKeyMap.get("ccFormKey")) != null && !ccFormKeyList.isEmpty()) {
                formKey = ((ExtensionAttribute)ccFormKeyList.get(0)).getValue();
            }
            ArrayList<DataPush> dataPushList = new ArrayList<DataPush>();
            for (String user : ccUserIds) {
                DataPush dataPush = new DataPush();
                dataPush.setTaskId(historicTaskInstance.getId());
                dataPush.setUserId(user);
                dataPush.setCcMoment("1");
                dataPush.setStartDate((Date)ts);
                dataPush.setProcessInsId(execution.getProcessInstanceId());
                dataPushList.add(dataPush);
                SysActCcTask sysActCcTask = new SysActCcTask();
                sysActCcTask.setProcessInsId(Long.valueOf(Long.parseLong(historicTaskInstance.getProcessInstanceId())));
                sysActCcTask.setProcName(((ExecutionEntity)processInstance).getProcessDefinition().getName());
                sysActCcTask.setTaskId(Long.valueOf(Long.parseLong(historicTaskInstance.getId())));
                sysActCcTask.setTaskName(historicTaskInstance.getName());
                sysActCcTask.setReceiveUser(user);
                sysActCcTask.setSendUser(ccSendUser);
                sysActCcTask.setSendTime(ts);
                sysActCcTask.setFormKey(formKey);
                sysActCcTask.setTaskDefKey(historicTaskInstance.getTaskDefinitionKey());
                sysActCcTask.setProcDefKey(processInstance.getProcessDefinitionKey());
                sysActCcTask.setProcDefId(processInstance.getProcessDefinitionId());
                sysActCcTask.setBusinessId(execution.getProcessBusinessKey());
                sysActCcTask.setTaskState("0");
                sysActCcTask.setCcMoment("1");
                sysActCcTask.setToDoConfig(historicTaskInstance.getTodoConfiguration());
                if (userIds.contains(sysActCcTask.getReceiveUser())) {
                    sysActCcTask.setTaskState("1");
                    sysActCcTask.setEndTime(sysActCcTask.getSendTime());
                    dataPush.setEndDate((Date)sysActCcTask.getEndTime());
                }
                list.add(sysActCcTask);
            }
            dataPushService.addCcTask(dataPushList);
            if (!list.isEmpty()) {
                iSysActCcTaskService.saveBatch(list);
            }
        }
    }

    private void getExecutionAllTasks(List<String> taskIds, ExecutionEntity executionEntity) {
        block3: {
            block4: {
                block2: {
                    if (!HussarUtils.isNotEmpty((Object)executionEntity.getExecutions())) break block2;
                    for (ExecutionEntity execution : executionEntity.getExecutions()) {
                        this.getExecutionAllTasks(taskIds, execution);
                    }
                    break block3;
                }
                if (!HussarUtils.isNotEmpty((Object)executionEntity.getSubProcessInstance())) break block4;
                this.getExecutionAllTasks(taskIds, executionEntity.getSubProcessInstance());
                break block3;
            }
            if (!HussarUtils.isNotEmpty((Object)executionEntity.getTasks())) break block3;
            TaskEntityManager taskEntityManager = Context.getCommandContext().getTaskEntityManager();
            for (TaskEntity taskEntity : executionEntity.getTasks()) {
                taskEntityManager.deleteTask(taskEntity, "", true, "");
                Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityWithVariablesEvent((ActivitiEventType)ActivitiEventType.TASK_COMPLETED, (Object)taskEntity, null, (boolean)false));
                taskIds.add(taskEntity.getId());
            }
        }
    }

    protected boolean completionConditionSatisfied(ActivityExecution execution) {
        ExpressionFactoryImpl expressionFactory = new ExpressionFactoryImpl();
        Object multiType = execution.getVariable("multi_type");
        if (HussarUtils.isNotEmpty((Object)multiType)) {
            ValueExpression valueExpression;
            JuelExpression expression;
            Object value;
            String condition = "";
            if ("0".equals(multiType.toString())) {
                condition = "${nrOfCompletedInstances/nrOfInstances >=" + Double.parseDouble(String.valueOf(execution.getVariable("multi_finish_condition"))) / 100.0 + "}";
            }
            if ("1".equals(multiType.toString())) {
                condition = "${nrOfCompletedInstances == " + Integer.parseInt(String.valueOf(execution.getVariable("multi_finish_condition"))) + " }";
            }
            if (!((value = (expression = new JuelExpression(valueExpression = expressionFactory.createValueExpression((ELContext)new ParsingElContext(), condition, Object.class), condition)).getValue((VariableScope)execution)) instanceof Boolean)) {
                throw new ActivitiIllegalArgumentException("completionCondition '" + expression.getExpressionText() + "' does not evaluate to a boolean value");
            }
            Boolean booleanValue = (Boolean)value;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Completion condition of multi-instance satisfied: {}", (Object)booleanValue);
            }
            return booleanValue;
        }
        if (this.completionConditionExpression != null) {
            Object value = this.completionConditionExpression.getValue((VariableScope)execution);
            if (!(value instanceof Boolean)) {
                throw new ActivitiIllegalArgumentException("completionCondition '" + this.completionConditionExpression.getExpressionText() + "' does not evaluate to a boolean value");
            }
            Boolean booleanValue = (Boolean)value;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Completion condition of multi-instance satisfied: {}", (Object)booleanValue);
            }
            return booleanValue;
        }
        return false;
    }

    private void insertActHiActinst(ActivityExecution execution, String userId, TaskEntity task) {
        IdGenerator idGenerator = Context.getProcessEngineConfiguration().getIdGenerator();
        String processDefinitionId = execution.getProcessDefinitionId();
        String processInsId = execution.getProcessInstanceId();
        String executionId = execution.getId();
        HistoricActivityInstanceEntity historicActivityInstance = new HistoricActivityInstanceEntity();
        historicActivityInstance.setId(idGenerator.getNextId());
        historicActivityInstance.setProcessDefinitionId(processDefinitionId);
        historicActivityInstance.setProcessInstanceId(processInsId);
        historicActivityInstance.setExecutionId(executionId);
        historicActivityInstance.setActivityId(execution.getActivity().getId());
        historicActivityInstance.setActivityName((String)execution.getActivity().getProperty("name"));
        historicActivityInstance.setActivityType((String)execution.getActivity().getProperty("type"));
        historicActivityInstance.setStartTime(Context.getProcessEngineConfiguration().getClock().getCurrentTime());
        historicActivityInstance.setAssignee(userId);
        historicActivityInstance.setTaskId(task.getId());
        String separatedVariable = execution.getSubProcessKey();
        if (HussarUtils.isNotEmpty((Object)separatedVariable)) {
            Integer cycleCount = ((ExecutionEntity)execution).getCycleCount();
            historicActivityInstance.setSubProcessKey(separatedVariable);
            historicActivityInstance.setCycleCount(cycleCount);
        }
        historicActivityInstance.setProcessCycleCount(((ExecutionEntity)execution).getProcessCycleCount());
        this.getDbSqlSession().insert((PersistentObject)historicActivityInstance);
    }

    protected Expression getActiveValue(Expression originalValue, String propertyName, ObjectNode taskElementProperties) {
        JsonNode overrideValueNode;
        Object activeValue = originalValue;
        if (taskElementProperties != null && (overrideValueNode = taskElementProperties.get(propertyName)) != null) {
            activeValue = overrideValueNode.isNull() ? null : Context.getProcessEngineConfiguration().getExpressionManager().createExpression(overrideValueNode.asText());
        }
        return activeValue;
    }

    protected Set<Expression> getActiveValueSet(Set<Expression> originalValues, String propertyName, ObjectNode taskElementProperties) {
        JsonNode overrideValuesNode;
        Set<Expression> activeValues = originalValues;
        if (taskElementProperties != null && (overrideValuesNode = taskElementProperties.get(propertyName)) != null) {
            if (overrideValuesNode.isNull() || !overrideValuesNode.isArray() || overrideValuesNode.isEmpty()) {
                activeValues = null;
            } else {
                ExpressionManager expressionManager = Context.getProcessEngineConfiguration().getExpressionManager();
                activeValues = new HashSet<Expression>();
                for (JsonNode valueNode : overrideValuesNode) {
                    activeValues.add(expressionManager.createExpression(valueNode.asText()));
                }
            }
        }
        return activeValues;
    }

    protected List<ConfigUser> getUser(BpmnModel bm, ActivityExecution execution, boolean flag, List<String> messageType) {
        List<ConfigUser> configUserList;
        ArrayList<ConfigUser> collection = new ArrayList<ConfigUser>();
        if (flag) {
            FlowElement flowElement = ((Process)bm.getProcesses().get(0)).getFlowElement(((ExecutionEntity)execution).getActivityId());
            if (flowElement instanceof CallActivity) {
                JSONArray callActivityInfos = null;
                JSONArray allCallActivityInfos = BpmAttribute.getCallActivityInfo(execution);
                if (HussarUtils.isNotEmpty((Object)allCallActivityInfos)) {
                    callActivityInfos = this.getRightActivity(allCallActivityInfos, execution);
                }
                if (HussarUtils.isNotEmpty(callActivityInfos)) {
                    for (Object object : callActivityInfos) {
                        collection.add(null);
                    }
                    return collection;
                }
                List<Object> list = new ArrayList();
                CallActivity callActivity = (CallActivity)flowElement;
                String processDefinitionJson = callActivity.getCalledElement();
                if (HussarUtils.isNotEmpty((Object)processDefinitionJson)) {
                    list = Arrays.asList(processDefinitionJson.split(","));
                }
                for (int i = 0; i < list.size(); ++i) {
                    collection.add(null);
                }
                return collection;
            }
            if (flowElement instanceof SubProcess) {
                String subProcessVariable;
                FlowElement element = bm.getFlowElement(execution.getActivity().getId());
                List instanceModeNode = (List)element.getExtensionElements().get("instanceMode");
                String instanceMode = ((ExtensionAttribute)((List)((ExtensionElement)instanceModeNode.get(0)).getAttributes().get("instanceMode")).get(0)).getValue();
                if (instanceMode.equals("assignee")) {
                    String appointMsg;
                    Map subProcessRejectAppointMsg = (Map)Context.getCommandContext().getAttribute("subProcessRejectAppointMsg");
                    if (subProcessRejectAppointMsg != null && (appointMsg = (String)subProcessRejectAppointMsg.get(execution.getCurrentActivityId())) != null) {
                        PvmActivity activity = execution.getActivity();
                        ActivityImpl initialActivity = (ActivityImpl)activity.getProperty("initial");
                        if (initialActivity == null) {
                            throw new ActivitiException("No initial activity found for subprocess " + execution.getActivity().getId());
                        }
                        String firstNodeId = ((PvmTransition)initialActivity.getOutgoingTransitions().get(0)).getDestination().getId();
                        List subProcessInfos = new ArrayList<SubProcessInfo>();
                        List historicTaskInstances = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)historyService.createHistoricTaskInstanceQuery().processInstanceId(execution.getProcessInstanceId())).taskDefinitionKey(firstNodeId)).taskVariableValueNotEquals("old_appoint_assignee", null)).includeTaskLocalVariables()).orderByHistoricTaskInstanceEndTime().desc()).list();
                        for (String msg : appointMsg.split(",")) {
                            SubProcessInfo subProcessInfo = new SubProcessInfo();
                            subProcessInfo.setSubProcessSeparateVariable(msg);
                            List<String> user = this.getSubProcessOldAssignee(historicTaskInstances, firstNodeId, activity.getId(), msg);
                            if (user == null) {
                                user = new ArrayList<String>();
                            }
                            if (user.isEmpty()) {
                                user.add(msg);
                            }
                            subProcessInfo.setAssignee(user);
                            subProcessInfos.add(subProcessInfo);
                        }
                        Context.getCommandContext().addAttribute("subProcessStartInfo" + execution.getCurrentActivityId(), subProcessInfos);
                        this.subProcessCreateListener((ExecutionEntity)execution, true);
                        subProcessInfos = (List)Context.getCommandContext().getAttribute("subProcessStartInfo" + execution.getCurrentActivityId());
                        if (HussarUtils.isEmpty(subProcessInfos)) {
                            throw new PublicClientException("\u6d41\u7a0b\u8fd0\u8f6c\u5230" + execution.getCurrentActivityName() + "\u65f6\u5b50\u6d41\u7a0b\u542f\u52a8\u4fe1\u606f\u4e3a\u7a7a\uff0c\u7981\u6b62\u64cd\u4f5c");
                        }
                        for (int i = 0; i < subProcessInfos.size(); ++i) {
                            collection.add(null);
                        }
                        return collection;
                    }
                    List<ConfigUser> users = AnalyticalModelUtil.getConfigUser(bm, execution, false, null);
                    List subProcessInfos = new ArrayList<SubProcessInfo>();
                    for (ConfigUser user : users) {
                        SubProcessInfo subProcessInfo = new SubProcessInfo();
                        ArrayList<String> userList = new ArrayList<String>();
                        userList.add(user.getUserId());
                        subProcessInfo.setAssignee(userList);
                        subProcessInfo.setSubProcessSeparateVariable(user.getUserId());
                        subProcessInfos.add(subProcessInfo);
                    }
                    Context.getCommandContext().addAttribute("subProcessStartInfo" + execution.getCurrentActivityId(), subProcessInfos);
                    this.subProcessCreateListener((ExecutionEntity)execution, false);
                    subProcessInfos = (List)Context.getCommandContext().getAttribute("subProcessStartInfo" + execution.getCurrentActivityId());
                    if (HussarUtils.isEmpty(subProcessInfos)) {
                        throw new BpmException(BpmExceptionCodeEnum.NULL_SUB_PROCESS_INFORMATION.format(new Object[]{execution.getCurrentActivityName()}).getMessage());
                    }
                    for (int i = 0; i < subProcessInfos.size(); ++i) {
                        collection.add(null);
                    }
                    return collection;
                }
                ArrayList<Object> list = new ArrayList();
                List subProcessVariableConfigNode = (List)element.getExtensionElements().get("subProcessVariableConfig");
                String subProcessVariableConfig = ((ExtensionAttribute)((List)((ExtensionElement)subProcessVariableConfigNode.get(0)).getAttributes().get("subProcessVariableConfig")).get(0)).getValue();
                String string = subProcessVariable = execution.getVariable(subProcessVariableConfig) == null ? "" : String.valueOf(execution.getVariable(subProcessVariableConfig));
                if (subProcessVariable == null) {
                    throw new PropertyNotFoundException();
                }
                if (HussarUtils.isNotEmpty((Object)subProcessVariable)) {
                    list = new ArrayList<String>(new HashSet<String>(Arrays.asList(subProcessVariable.split(","))));
                }
                List subProcessInfos = new ArrayList<SubProcessInfo>();
                for (String variable : list) {
                    SubProcessInfo subProcessInfo = new SubProcessInfo();
                    subProcessInfo.setSubProcessSeparateVariable(variable);
                    subProcessInfos.add(subProcessInfo);
                }
                Context.getCommandContext().addAttribute("subProcessStartInfo" + execution.getCurrentActivityId(), subProcessInfos);
                this.subProcessCreateListener((ExecutionEntity)execution, false);
                subProcessInfos = (List)Context.getCommandContext().getAttribute("subProcessStartInfo" + execution.getCurrentActivityId());
                if (HussarUtils.isEmpty(subProcessInfos)) {
                    throw new BpmException(BpmExceptionCodeEnum.NULL_SUB_PROCESS_INFORMATION.format(new Object[]{execution.getCurrentActivityName()}).getMessage());
                }
                for (int i = 0; i < subProcessInfos.size(); ++i) {
                    collection.add(null);
                }
                return collection;
            }
        }
        if (HussarUtils.isEmpty(configUserList = AnalyticalModelUtil.getEntrustCandidateUser(bm, ((ExecutionEntity)execution).getActivityId(), execution, false, null, messageType))) {
            configUserList.add(null);
        }
        return configUserList;
    }

    protected void setSubProcessVariable(ActivityExecution entity, String subProcessVariable) {
        entity.addLocalTempVariable("sub_process_variable", (Object)subProcessVariable);
    }

    private List<String> getSubProcessOldAssignee(List<HistoricTaskInstance> historicTaskInstances, String taskDefinitionKey, String subProcessNodeId, String subProcessSeparateVariable) {
        Object oldAppointMessage;
        List<String> user = null;
        String subProcessKeyPrefix = subProcessNodeId + ":" + subProcessSeparateVariable + ":";
        List list = historicTaskInstances.stream().filter(o -> o.getSubProcessKey().startsWith(subProcessKeyPrefix)).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(list) && HussarUtils.isNotEmpty(oldAppointMessage = ((HistoricTaskInstance)list.get(0)).getTaskLocalVariables().get("old_appoint_assignee"))) {
            Map oldAppointAssigneeMap;
            Object oldAppointObject;
            user = oldAppointMessage instanceof HashMap ? (HussarUtils.isNotEmpty(oldAppointObject = (oldAppointAssigneeMap = (Map)oldAppointMessage).get(taskDefinitionKey)) ? (oldAppointObject instanceof List ? (List<String>)oldAppointObject : Arrays.asList(String.valueOf(oldAppointObject).split(","))) : null) : (oldAppointMessage instanceof List ? (List<String>)oldAppointMessage : Arrays.asList(String.valueOf(oldAppointMessage).split(",")));
        }
        return user;
    }

    public void execute(ActivityExecution execution) throws Exception {
        if (this.getLocalLoopVariable(execution, this.getCollectionElementIndexVariable()) == null) {
            try {
                this.createInstances(execution);
            }
            catch (BpmnError var3) {
                ErrorPropagation.propagateError((BpmnError)var3, (ActivityExecution)execution);
            }
        } else if (this.innerActivityBehavior instanceof ExtendSubProcessActivityBehavior) {
            ActivityExecution subProcessExecution = execution.createExecution();
            subProcessExecution.setActive(true);
            subProcessExecution.setConcurrent(false);
            subProcessExecution.setScope(true);
            this.innerActivityBehavior.execute(subProcessExecution);
        } else {
            this.innerActivityBehavior.execute(execution);
        }
    }

    private void callActivitiCreateListener(ExecutionEntity execution) {
        execution.setEventName("callActivityStart");
        List executionListeners = execution.getActivity().getExecutionListeners("callActivityStart");
        for (ExecutionListener executionListener : executionListeners) {
            try {
                executionListener.notify((DelegateExecution)execution);
            }
            catch (Exception e) {
                List fieldDeclarationList = ((DelegateExpressionExecutionListener)executionListener).getFieldDeclarations();
                boolean isAsyn = false;
                for (FieldDeclaration fieldDeclaration : fieldDeclarationList) {
                    if (!"isAsyn".equals(fieldDeclaration.getName()) || !Boolean.parseBoolean(((FixedValue)fieldDeclaration.getValue()).getExpressionText())) continue;
                    isAsyn = true;
                    break;
                }
                this.logger.error(e.getMessage(), (Throwable)e);
                if (isAsyn) continue;
                throw new PublicClientException(e.getMessage());
            }
        }
    }

    private void subProcessCreateListener(ExecutionEntity execution, boolean isOldSubProcessInfo) {
        if (isOldSubProcessInfo) {
            execution.setEventName("subProcessStartWithOldInfo");
        } else {
            execution.setEventName("subProcessStart");
        }
        List executionListeners = execution.getActivity().getExecutionListeners("subProcessStart");
        for (ExecutionListener executionListener : executionListeners) {
            try {
                executionListener.notify((DelegateExecution)execution);
            }
            catch (Exception e) {
                List fieldDeclarationList = ((DelegateExpressionExecutionListener)executionListener).getFieldDeclarations();
                boolean isAsyn = false;
                for (FieldDeclaration fieldDeclaration : fieldDeclarationList) {
                    if (!"isAsyn".equals(fieldDeclaration.getName()) || !Boolean.parseBoolean(((FixedValue)fieldDeclaration.getValue()).getExpressionText())) continue;
                    isAsyn = true;
                    break;
                }
                this.logger.error(e.getMessage(), (Throwable)e);
                if (isAsyn) continue;
                throw new PublicClientException(e.getMessage());
            }
        }
    }
}

