/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.MultiInstancePercentUtils;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.runtime.Execution;

public class SequentialMultiAssigneeCmd
implements Command<Void> {
    protected int usersChangeNum;
    protected String executionId;
    protected final String NUMBER_OF_INSTANCES = "nrOfInstances";
    protected final String NUMBER_OF_ACTIVE_INSTANCES = "nrOfActiveInstances";

    public SequentialMultiAssigneeCmd(String executionId, int usersChangeNum) {
        this.executionId = executionId;
        this.usersChangeNum = usersChangeNum;
    }

    public Void execute(CommandContext commandContext) {
        ProcessEngineConfigurationImpl pec = commandContext.getProcessEngineConfiguration();
        RuntimeService runtimeService = pec.getRuntimeService();
        Execution execution = (Execution)runtimeService.createExecutionQuery().executionId(this.executionId).singleResult();
        ExecutionEntity ee = (ExecutionEntity)execution;
        int nrOfInstances = MultiInstancePercentUtils.getLoopVariable(ee, "nrOfInstances");
        int nrOfActiveInstances = MultiInstancePercentUtils.getLoopVariable(ee, "nrOfActiveInstances");
        MultiInstancePercentUtils.setLoopVariable(ee, "nrOfInstances", nrOfInstances + this.usersChangeNum);
        MultiInstancePercentUtils.setLoopVariable(ee, "nrOfActiveInstances", nrOfActiveInstances + this.usersChangeNum);
        return null;
    }
}

