/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.common.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class WorkflowBpmUtil {
    public static <T, F> Map<String, List<T>> getListMap(List<T> list, Function<T, F> getKeyFunction, Function<T, Boolean> filterFunction) {
        if (list == null) {
            return new HashMap<String, List<T>>();
        }
        HashMap<String, List<T>> result = new HashMap<String, List<T>>();
        for (T t : list) {
            if (filterFunction != null && !filterFunction.apply(t).booleanValue()) continue;
            F key = getKeyFunction.apply(t);
            result.computeIfAbsent(key == null ? null : String.valueOf(key), o -> new ArrayList()).add(t);
        }
        return result;
    }

    public static <T, F> Map<String, T> getMap(List<T> list, Function<T, F> getKeyFunction, Function<T, Boolean> filterFunction) {
        if (list == null) {
            return new HashMap();
        }
        HashMap<String, T> result = new HashMap<String, T>();
        for (T t : list) {
            if (filterFunction != null && !filterFunction.apply(t).booleanValue()) continue;
            F key = getKeyFunction.apply(t);
            result.put(key == null ? null : String.valueOf(key), t);
        }
        return result;
    }

    public static <T, V, F> Map<String, V> getOtherMap(List<T> list, Function<T, F> getKeyFunction, Function<T, V> getValueFunction, Function<T, Boolean> filterFunction) {
        if (list == null) {
            return new HashMap();
        }
        HashMap<String, V> result = new HashMap<String, V>();
        for (T t : list) {
            if (filterFunction != null && !filterFunction.apply(t).booleanValue()) continue;
            F key = getKeyFunction.apply(t);
            V value = getValueFunction.apply(t);
            result.put(key == null ? null : String.valueOf(key), value);
        }
        return result;
    }

    public static <T> List<List<T>> getSqlIdList(Collection<T> collection) {
        ArrayList<T> list = collection instanceof List ? (ArrayList<T>)collection : new ArrayList<T>(collection);
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        int size = list.size();
        for (int i = 0; i < size; i += 1000) {
            result.add(list.subList(i, Math.min(i + 1000, size)));
        }
        return result;
    }
}

