/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.common.model;

import com.alibaba.fastjson.JSONArray;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.activiti.model.BpmActRuMultUser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class ConfigUser {
    public static final int CONFIG = 0;
    public static final int APPOINT = 1;
    private List<ConfigUser> configUserList;
    private String userId;
    private String owner;
    private int type;

    public List<ConfigUser> getConfigUserList() {
        return this.configUserList;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setConfigUserList(List<ConfigUser> configUserList) {
        this.configUserList = configUserList;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public boolean isGroupMulti() {
        return this.configUserList != null;
    }

    public boolean isEmpty() {
        return this.userId == null && this.configUserList == null;
    }

    private ConfigUser(String userId) {
        this.userId = userId;
    }

    private ConfigUser(List<ConfigUser> configUserList) {
        this.configUserList = configUserList;
    }

    public String taskOwner() {
        return this.getOwner() == null ? this.getUserId() : this.getOwner();
    }

    public void entrust(String userId) {
        if (this.isGroupMulti()) {
            throw new UnsupportedOperationException();
        }
        if (userId != null) {
            this.owner = this.userId;
            this.userId = userId;
        }
    }

    public static Set<String> getAllUserId(List<ConfigUser> configUserList) {
        return ConfigUser.getAllUserId(HashSet::new, configUserList);
    }

    public static <T extends Collection<String>> T getAllUserId(Supplier<T> supplier, List<ConfigUser> configUserList) {
        return ConfigUser.recursionAndCollectUser(supplier, ConfigUser::getUserId, configUserList);
    }

    public static Set<String> getAllOwner(List<ConfigUser> configUserList) {
        return ConfigUser.recursionAndCollectUser(HashSet::new, ConfigUser::taskOwner, configUserList);
    }

    public static <T extends Collection<String>> T getAllOwner(Supplier<T> supplier, List<ConfigUser> configUserList) {
        return ConfigUser.recursionAndCollectUser(supplier, ConfigUser::taskOwner, configUserList);
    }

    public static <R extends Collection<T>, T> R recursionAndCollectUser(Supplier<R> supplier, Function<ConfigUser, T> function, List<ConfigUser> configUserList) {
        return (R)((Collection)ConfigUser.recursionAndCollectUser(supplier, (r, configUser) -> r.add(function.apply((ConfigUser)configUser)), Function.identity(), configUserList));
    }

    public static <A, R> R recursionAndCollectUser(Supplier<A> supplier, BiConsumer<A, ConfigUser> function, Function<A, R> finisher, List<ConfigUser> configUserList) {
        Object temp = supplier.get();
        ConfigUser.recursionUser(configUser -> function.accept(temp, (ConfigUser)configUser), configUserList);
        return finisher.apply(temp);
    }

    public static void recursionUser(Consumer<ConfigUser> consumer, List<ConfigUser> configUserList) {
        for (ConfigUser configUser : configUserList) {
            if (configUser == null) {
                return;
            }
            if (configUser.getConfigUserList() == null) {
                consumer.accept(configUser);
                continue;
            }
            ConfigUser.recursionUser(consumer, configUser.getConfigUserList());
        }
    }

    public static void recursionUserAsTree(Consumer<ConfigUser> consumer, List<ConfigUser> configUserList) {
        for (ConfigUser configUser : configUserList) {
            consumer.accept(configUser);
        }
    }

    public static List<ConfigUser> buildConfigUser(List<String> userIdList, Consumer<ConfigUser> init) {
        HashSet<String> set = new HashSet<String>();
        ArrayList<ConfigUser> res = new ArrayList<ConfigUser>();
        for (String userId : userIdList) {
            if (!set.add(userId)) continue;
            ConfigUser configUser = new ConfigUser(userId);
            res.add(configUser);
            if (init == null) continue;
            init.accept(configUser);
        }
        return res;
    }

    public static List<ConfigUser> buildConfigUser(List<BpmActRuMultUser> userIdList) {
        HashSet<String> set = new HashSet<String>();
        ArrayList<ConfigUser> res = new ArrayList<ConfigUser>();
        for (BpmActRuMultUser bpmActRuMultUser : userIdList) {
            String owner = HussarUtils.isNotEmpty((Object)bpmActRuMultUser.getOwnerId()) ? bpmActRuMultUser.getOwnerId() : bpmActRuMultUser.getUserId();
            if (!set.add(owner)) continue;
            ConfigUser configUser = new ConfigUser(bpmActRuMultUser.getUserId());
            configUser.setOwner(bpmActRuMultUser.getOwnerId());
            res.add(configUser);
        }
        return res;
    }

    public static List<ConfigUser> buildGroupMultiConfigUser(List<String> userIdList) {
        ArrayList<ConfigUser> res = new ArrayList<ConfigUser>();
        for (String userIds : userIdList) {
            res.add(new ConfigUser(ConfigUser.buildConfigUser(Arrays.asList(userIds.split(",")), configUser -> configUser.setType(1))));
        }
        return res;
    }

    public static String getAppointAssignee(List<ConfigUser> users) {
        JSONArray appointArray = new JSONArray();
        ConfigUser.recursionUserAsTree(configUser -> {
            if (configUser == null) {
                return;
            }
            if (configUser.isGroupMulti()) {
                String appoint = ConfigUser.recursionAndCollectUser(() -> new StringJoiner(","), (stringJoiner, user) -> {
                    if (1 == user.getType()) {
                        stringJoiner.add(user.taskOwner());
                    }
                }, stringJoiner -> stringJoiner.length() == 0 ? null : stringJoiner.toString(), configUser.getConfigUserList());
                if (appoint != null) {
                    appointArray.add((Object)appoint);
                }
            } else if (1 == configUser.getType()) {
                appointArray.add((Object)configUser.taskOwner());
            }
        }, users);
        return appointArray.isEmpty() ? null : appointArray.toJSONString();
    }
}

