/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.cache;

import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.support.service.DynamicDatasourceService;
import java.io.Serializable;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.deploy.DeploymentCache;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.apache.commons.lang3.SerializationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HussarWorkflowProcessDefinitionCache
implements DeploymentCache<ProcessDefinitionEntity> {
    private final Logger logger = LoggerFactory.getLogger(HussarWorkflowProcessDefinitionCache.class);
    private static final String WORKFLOW_PROCESS_DEFINITION_CACHE = "workflow_process_definition_cache";
    private static final String DEFINITION_CACHE_CHARSET_NAME = "ISO-8859-1";
    @Autowired
    private DynamicDatasourceService dynamicDatasourceService;

    public ProcessDefinitionEntity get(String id) {
        ProcessDefinitionEntity processDefinitionEntity;
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext != null && (processDefinitionEntity = (ProcessDefinitionEntity)commandContext.getAttribute("ProcessDefinitionEntity_" + id)) != null) {
            return processDefinitionEntity;
        }
        String dataSourceName = this.dynamicDatasourceService.getCurrentDatasourceName();
        String string = (String)HussarCacheUtil.get((String)("workflow_process_definition_cache." + dataSourceName), (Object)id, String.class);
        ProcessDefinitionEntity processDefinitionEntity2 = null;
        if (string != null) {
            try {
                processDefinitionEntity2 = (ProcessDefinitionEntity)SerializationUtils.deserialize((byte[])string.getBytes(DEFINITION_CACHE_CHARSET_NAME));
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        if (commandContext != null) {
            commandContext.addAttribute("ProcessDefinitionEntity_" + id, (Object)processDefinitionEntity2);
        }
        return processDefinitionEntity2;
    }

    public void add(String id, ProcessDefinitionEntity object) {
        String dataSourceName = this.dynamicDatasourceService.getCurrentDatasourceName();
        String processDefinitionEntity = null;
        try {
            byte[] bytes = SerializationUtils.serialize((Serializable)object);
            processDefinitionEntity = new String(bytes, DEFINITION_CACHE_CHARSET_NAME);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        HussarCacheUtil.put((String)("workflow_process_definition_cache." + dataSourceName), (Object)id, (Object)processDefinitionEntity);
    }

    public void remove(String id) {
        String dataSourceName = this.dynamicDatasourceService.getCurrentDatasourceName();
        HussarCacheUtil.evict((String)("workflow_process_definition_cache." + dataSourceName), (Object)id);
    }

    public void clear() {
        String dataSourceName = this.dynamicDatasourceService.getCurrentDatasourceName();
        HussarCacheUtil.evictKeysLike((String)("workflow_process_definition_cache." + dataSourceName), (String)"*");
    }
}

