/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.workflow.assignee.dto.AssigneeChooseDto;
import com.jxdinfo.hussar.workflow.assignee.model.AssigneeManageInfoVo;
import com.jxdinfo.hussar.workflow.assignee.model.BpmTreeModel;
import com.jxdinfo.hussar.workflow.assignee.model.BpmUserInfoVo;
import com.jxdinfo.hussar.workflow.assignee.model.GetListInfoVo;
import com.jxdinfo.hussar.workflow.assignee.model.OrganUserTree;
import com.jxdinfo.hussar.workflow.assignee.service.IWorkflowAssigneeChooseService;
import com.jxdinfo.hussar.workflow.callback.assignee.service.IWorkflowCallbackAssigneeService;
import com.jxdinfo.hussar.workflow.callback.business.function.service.IWorkflowCallbackFunctionService;
import com.jxdinfo.hussar.workflow.config.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.bpmconfig.service.IBpmConfigService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.NodeAssigneeQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.function.model.SysActFunction;
import com.jxdinfo.hussar.workflow.engine.bpm.function.service.ISysActFunctionService;
import com.jxdinfo.hussar.workflow.engine.bpm.tenant.model.SysUser;
import com.jxdinfo.hussar.workflow.engine.bpm.tenant.service.ISysUserService;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.activiti.engine.HistoryService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.impl.identity.Authentication;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.TaskStateType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class AssigneeChooseServiceImpl
implements IAssigneeChooseService {
    @Autowired
    private LcdpBpmProperties lcdpBpmProperties;
    @Autowired
    private IWorkflowCallbackFunctionService workflowCallbackFunctionService;
    @Autowired
    private ISysActFunctionService sysActFunctionService;
    @Lazy
    @Resource
    private HistoryService historyService;
    @Autowired
    IWorkflowAssigneeChooseService workflowAssigneeChooseService;
    @Autowired
    private ISysUserService sysUserService;
    @Autowired
    private IWorkflowCallbackAssigneeService workflowCallbackAssigneeService;
    private final IBpmConfigService bpmConfigService;
    private static Logger logger = LogManager.getLogger(AssigneeChooseServiceImpl.class);
    private static final Pattern REGEX = Pattern.compile("\\@\\{([^@]|[^}]\\@)*\\}\\@");
    private static final String WORKFLOW_PLATFORM = "workflow-platform";
    private static final String TABLE_PREFIX = "table_prefix";

    public AssigneeChooseServiceImpl(IBpmConfigService bpmConfigService) {
        this.bpmConfigService = bpmConfigService;
    }

    private String getTablePrefix() {
        return this.bpmConfigService.getStringByKeyUseCache(TABLE_PREFIX);
    }

    public List<BpmTreeModel> userTree(String id, boolean isMainPost) {
        String tablePrefix = this.getTablePrefix();
        try {
            return this.workflowCallbackAssigneeService.userTree(id, isMainPost, tablePrefix);
        }
        catch (Exception e) {
            logger.error(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<OrganUserTree> userTreeForUserChoose(String id) {
        String tablePrefix = this.getTablePrefix();
        try {
            return this.workflowCallbackAssigneeService.userTreeForUserChoose(id, tablePrefix);
        }
        catch (Exception e) {
            logger.error(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public Page<OrganUserTree> queryUserTreeForUserChoose(Page<OrganUserTree> page, String organName) {
        String tablePrefix = this.getTablePrefix();
        try {
            return this.workflowCallbackAssigneeService.queryUserTreeForUserChoose(page, organName, tablePrefix);
        }
        catch (Exception e) {
            logger.error(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<BpmTreeModel> postTree(String id, String postId, boolean isMainPost) {
        String tablePrefix = this.getTablePrefix();
        try {
            return this.workflowCallbackAssigneeService.postTree(id, postId, isMainPost, tablePrefix);
        }
        catch (Exception e) {
            logger.error(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<BpmTreeModel> deptTree(String id, String organId, boolean isInterface) {
        String tablePrefix = this.getTablePrefix();
        try {
            return this.workflowCallbackAssigneeService.deptTree(id, organId, tablePrefix);
        }
        catch (Exception e) {
            logger.error(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<BpmTreeModel> roleTree(boolean isInterface) {
        String tablePrefix = this.getTablePrefix();
        try {
            return this.workflowCallbackAssigneeService.roleTree(tablePrefix);
        }
        catch (Exception e) {
            logger.error(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<BpmTreeModel> roleTree(String id, String roleId, boolean isInterface) {
        String tablePrefix = this.getTablePrefix();
        try {
            return this.workflowCallbackAssigneeService.roleTree(id, roleId, tablePrefix);
        }
        catch (Exception e) {
            logger.error(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<BpmTreeModel> userDetail(List<String> userIds, boolean isInterface) {
        String tablePrefix = this.getTablePrefix();
        try {
            return this.workflowCallbackAssigneeService.userDetail(userIds, tablePrefix);
        }
        catch (Exception e) {
            logger.error(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    private List<BpmTreeModel> userDeptDetail(String userId, boolean isInterface) {
        String tablePrefix = this.getTablePrefix();
        try {
            return this.workflowCallbackAssigneeService.userDeptDetail(userId, tablePrefix);
        }
        catch (Exception e) {
            logger.error(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public String getUserNames(List<String> userIds) {
        StringBuilder result = new StringBuilder();
        List<BpmTreeModel> list = this.userDetail(userIds, false);
        if (list != null && !list.isEmpty()) {
            for (BpmTreeModel bpmTreeModel : list) {
                result.append(bpmTreeModel.getLabel()).append(",");
            }
            result = new StringBuilder(result.substring(0, result.length() - 1));
        }
        if ((list == null || list.size() < userIds.size()) && WORKFLOW_PLATFORM.equals(this.lcdpBpmProperties.getDeploymentModel())) {
            HashMap<String, String> map = new HashMap<String, String>();
            List users = this.sysUserService.getSysUser();
            for (SysUser sysUser : users) {
                map.put(sysUser.getUserId(), sysUser.getUserName());
            }
            for (String userId : userIds) {
                String name = (String)map.get(userId);
                if (name == null) continue;
                if (list == null) {
                    result.append(name);
                    continue;
                }
                result.append(",").append(name);
            }
        }
        return result.toString();
    }

    public List<String> getEntrustUserNames(List<IdentityLink> userIds) {
        ArrayList<String> users = new ArrayList<String>();
        for (IdentityLink identityLink : userIds) {
            if (TaskStateType.isEntrust((IdentityLink)identityLink)) {
                users.add(identityLink.getUserId());
                users.add(identityLink.getMandator());
                continue;
            }
            users.add(identityLink.getUserId());
        }
        Map<String, String> map = this.getUserListByUserId(users);
        ArrayList<String> result = new ArrayList<String>();
        for (IdentityLink identityLink : userIds) {
            if (TaskStateType.isEntrust((IdentityLink)identityLink)) {
                result.add(map.get(identityLink.getUserId()) + "(" + map.get(identityLink.getMandator()) + ")");
                continue;
            }
            result.add(map.get(identityLink.getUserId()));
        }
        return result;
    }

    public List<Map<String, String>> getUserListByUserIdWithSelect(List<String> userList) {
        List<BpmTreeModel> list = this.userDetail(userList, true);
        ArrayList<Map<String, String>> resultList = new ArrayList<Map<String, String>>();
        if (list != null && !list.isEmpty()) {
            for (BpmTreeModel bpmTreeModel : list) {
                HashMap<String, String> mapSelect = new HashMap<String, String>(2);
                mapSelect.put("id", bpmTreeModel.getId());
                mapSelect.put("name", bpmTreeModel.getLabel());
                resultList.add(mapSelect);
            }
        }
        return resultList;
    }

    public Map<String, String> getUserListByUserId(List<String> userIds) {
        HashMap<String, String> map = new HashMap<String, String>();
        List<BpmTreeModel> list = this.userDetail(userIds, false);
        if (list != null && !list.isEmpty()) {
            for (BpmTreeModel bpmTreeModel : list) {
                map.put(bpmTreeModel.getId(), bpmTreeModel.getLabel());
            }
        }
        if ((list == null || list.size() < userIds.size()) && WORKFLOW_PLATFORM.equals(this.lcdpBpmProperties.getDeploymentModel())) {
            List users = this.sysUserService.getSysUser();
            for (SysUser sysUser : users) {
                map.put(sysUser.getUserId(), sysUser.getUserName());
            }
        }
        return map;
    }

    public List<String> getCandidateUser(String condition, String processKey, Integer securityLevel, Map<String, String> processInfo) {
        if (!this.lcdpBpmProperties.isUseSecurityLevel()) {
            securityLevel = null;
        }
        if (!processInfo.containsKey("workflowStarterUserId") && processInfo.containsKey("workflowProcessInsId")) {
            HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInfo.get("workflowProcessInsId")).singleResult();
            if (historicProcessInstance != null) {
                processInfo.put("workflowStarterUserId", historicProcessInstance.getStartUserId());
                if (!processInfo.containsKey("workflowBusinessId")) {
                    processInfo.put("workflowBusinessId", historicProcessInstance.getBusinessKey());
                }
            } else {
                processInfo.put("workflowStarterUserId", Authentication.getAuthenticatedUserId());
            }
        }
        Object serviceName = null;
        if (processKey != null) {
            processInfo.put("workflowProcessKey", processKey);
        }
        String tablePrefix = this.getTablePrefix();
        condition = this.getFunctionCondition(condition, processInfo);
        try {
            return this.workflowCallbackAssigneeService.getCandidateUsers(condition, securityLevel, tablePrefix);
        }
        catch (Exception e) {
            logger.error(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<BpmTreeModel> getCandidateUserWithParent(String condition, String processKey, Integer securityLevel, Map<String, String> processInfo) {
        if (!this.lcdpBpmProperties.isUseSecurityLevel()) {
            securityLevel = null;
        }
        if (!processInfo.containsKey("workflowStarterUserId") && processInfo.containsKey("workflowProcessInsId")) {
            HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInfo.get("workflowProcessInsId")).singleResult();
            if (historicProcessInstance != null) {
                processInfo.put("workflowStarterUserId", historicProcessInstance.getStartUserId());
                if (!processInfo.containsKey("workflowBusinessId")) {
                    processInfo.put("workflowBusinessId", historicProcessInstance.getBusinessKey());
                }
            } else {
                processInfo.put("workflowStarterUserId", Authentication.getAuthenticatedUserId());
            }
        }
        Object serviceName = null;
        if (processKey != null) {
            processInfo.put("workflowProcessKey", processKey);
        }
        String tablePrefix = this.getTablePrefix();
        condition = this.getFunctionCondition(condition, processInfo);
        try {
            return this.workflowCallbackAssigneeService.getCandidateUsersWithParent(condition, securityLevel, tablePrefix);
        }
        catch (Exception e) {
            logger.error(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    private String getFunctionCondition(String realCondition, Map<String, String> processInfo) {
        if (realCondition.contains("@{")) {
            Matcher matcher = REGEX.matcher(realCondition);
            while (matcher.find()) {
                String message = matcher.group().substring(1, matcher.group().length() - 1);
                CharSequence[] messages = message.split(":");
                for (int j = 0; j < messages.length; ++j) {
                    String str = messages[j];
                    if (j != messages.length - 1) {
                        if (str.lastIndexOf("','") == str.indexOf("','")) continue;
                        str = str.replace("','", ",");
                        int num = str.lastIndexOf(44);
                        messages[j] = str.substring(0, num) + "','" + str.substring(num + 1);
                        continue;
                    }
                    messages[j] = str.replace("','", ",");
                }
                message = String.join((CharSequence)":", messages);
                List<String> userList = this.functionUser((Map)JSON.parse((String)message), processInfo);
                StringBuilder users = new StringBuilder();
                String functionUsers = "";
                if (userList != null && !userList.isEmpty()) {
                    for (String user : userList) {
                        users.append(user).append("','");
                    }
                    functionUsers = users.toString().substring(0, users.toString().length() - 3);
                } else {
                    functionUsers = "";
                }
                realCondition = realCondition.replace(matcher.group(), functionUsers);
            }
        }
        return realCondition;
    }

    private List<String> functionUser(Map<String, Object> message, Map<String, String> processInfo) {
        String beanId = new ArrayList<String>(message.keySet()).get(0);
        if (beanId == null) {
            return new ArrayList<String>();
        }
        Map map = (Map)message.get(beanId);
        map.putAll(processInfo);
        SysActFunction function = this.sysActFunctionService.getFunctionByBeanId(beanId);
        if (HussarUtils.isEmpty((Object)function)) {
            throw new BpmException(BpmExceptionCodeEnum.ERROR_NO_EXIST_FUNCTION);
        }
        return this.workflowCallbackFunctionService.getFunctionResult(function, map);
    }

    public String getSameLevelDeptIdByUserId(String userId) {
        if (HussarUtils.isEmpty((Object)userId)) {
            return "";
        }
        String tablePrefix = this.getTablePrefix();
        try {
            return this.workflowCallbackAssigneeService.getSameLevelDeptIdByUserId(userId, tablePrefix);
        }
        catch (Exception e) {
            logger.error(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public String getSameLevelDeptIdByOrganId(String organId) {
        String tablePrefix = this.getTablePrefix();
        return this.workflowCallbackAssigneeService.getSameLevelDeptIdByOrganId(organId, tablePrefix);
    }

    public String getParentDeptIdByUserId(String userId) {
        if (HussarUtils.isEmpty((Object)userId)) {
            return "";
        }
        String tablePrefix = this.getTablePrefix();
        try {
            return this.workflowCallbackAssigneeService.getParentDeptIdByUserId(userId, tablePrefix);
        }
        catch (Exception e) {
            logger.error(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public String getDeptIdByUserIds(String userId) {
        if (HussarUtils.isEmpty((Object)userId)) {
            return "";
        }
        String tablePrefix = this.getTablePrefix();
        try {
            return this.workflowCallbackAssigneeService.getDeptIdByUserIds(userId, tablePrefix);
        }
        catch (Exception e) {
            logger.error(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public String getSameLevelDeptIdByUserIds(String userId) {
        if (HussarUtils.isEmpty((Object)userId)) {
            return "";
        }
        String tablePrefix = this.getTablePrefix();
        try {
            return this.workflowCallbackAssigneeService.getSameLevelDeptIdByUserIds(userId, tablePrefix);
        }
        catch (Exception e) {
            logger.error(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public String getParentDeptIdByUserIds(String userId) {
        if (HussarUtils.isEmpty((Object)userId)) {
            return "";
        }
        String tablePrefix = this.getTablePrefix();
        try {
            return this.workflowCallbackAssigneeService.getParentDeptIdByUserIds(userId, tablePrefix);
        }
        catch (Exception e) {
            logger.error(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public Integer getSecurityLevel(String userId, String url) {
        String tablePrefix = this.getTablePrefix();
        try {
            return this.workflowCallbackAssigneeService.getSecurityLevel(userId, tablePrefix);
        }
        catch (Exception e) {
            logger.error(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public String getStarterDept(String userId) {
        if (HussarUtils.isEmpty((Object)userId)) {
            return null;
        }
        List<BpmTreeModel> list = this.userDeptDetail(userId, true);
        StringBuilder stringBuilder = new StringBuilder();
        for (BpmTreeModel bpmTreeModel : list) {
            if (bpmTreeModel.getParentId() == null) continue;
            stringBuilder.append(",").append(bpmTreeModel.getParentId());
        }
        String result = stringBuilder.toString();
        if (result.length() > 0) {
            result = result.substring(1);
        }
        return result;
    }

    public List<BpmTreeModel> queryDeptTreeByDeptName(String organName) {
        if (HussarUtils.isEmpty((Object)organName)) {
            return new ArrayList<BpmTreeModel>();
        }
        String tablePrefix = this.getTablePrefix();
        try {
            return this.workflowCallbackAssigneeService.queryDeptTreeByDeptName(organName, tablePrefix);
        }
        catch (Exception e) {
            logger.error(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<BpmTreeModel> queryUserTreeByUserName(String organName) {
        if (HussarUtils.isEmpty((Object)organName)) {
            return new ArrayList<BpmTreeModel>();
        }
        String tablePrefix = this.getTablePrefix();
        try {
            return this.workflowCallbackAssigneeService.queryUserTreeByUserName(organName, tablePrefix);
        }
        catch (Exception e) {
            logger.error(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<BpmTreeModel> queryPostTreeByPostName(String postName) {
        if (HussarUtils.isEmpty((Object)postName)) {
            return new ArrayList<BpmTreeModel>();
        }
        String tablePrefix = this.getTablePrefix();
        try {
            return this.workflowCallbackAssigneeService.queryPostTreeByPostName(postName, tablePrefix);
        }
        catch (Exception e) {
            logger.error(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<BpmTreeModel> queryUserListByUserName(String organName) {
        if (HussarUtils.isEmpty((Object)organName)) {
            return new ArrayList<BpmTreeModel>();
        }
        String tablePrefix = this.getTablePrefix();
        try {
            return this.workflowCallbackAssigneeService.queryUserListByUserName(organName, tablePrefix);
        }
        catch (Exception e) {
            logger.error(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<BpmTreeModel> queryRoleTreeByRoleName(String roleName) {
        if (HussarUtils.isEmpty((Object)roleName)) {
            return new ArrayList<BpmTreeModel>();
        }
        String tablePrefix = this.getTablePrefix();
        try {
            return this.workflowCallbackAssigneeService.queryRoleTreeByRoleName(roleName, tablePrefix);
        }
        catch (Exception e) {
            logger.error(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<BpmTreeModel> queryUserTree(String organName) {
        if (HussarUtils.isEmpty((Object)organName)) {
            return new ArrayList<BpmTreeModel>();
        }
        String tablePrefix = this.getTablePrefix();
        try {
            return this.workflowCallbackAssigneeService.queryUserTree(organName, tablePrefix);
        }
        catch (Exception e) {
            logger.error(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public Page<BpmTreeModel> queryUserTreeByPage(Page<BpmTreeModel> pages, String organName) {
        String tablePrefix = this.getTablePrefix();
        try {
            return this.workflowCallbackAssigneeService.queryUserTreeByPage(pages, organName, tablePrefix);
        }
        catch (Exception e) {
            logger.error(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public Page<BpmTreeModel> queryUserListByPage(Page<BpmTreeModel> pages, BpmTreeModel bpmTreeModel) {
        String tablePrefix = this.getTablePrefix();
        try {
            return this.workflowCallbackAssigneeService.queryUserListByPage(pages, bpmTreeModel.getId(), bpmTreeModel.getType(), tablePrefix);
        }
        catch (Exception e) {
            logger.error(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<BpmTreeModel> queryDeptTreeByChildren(BpmTreeModel bpmTreeModel) {
        String tablePrefix = this.getTablePrefix();
        try {
            return this.workflowCallbackAssigneeService.queryDeptTreeByChildren(bpmTreeModel, tablePrefix);
        }
        catch (Exception e) {
            logger.error(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<BpmTreeModel> queryAssigneeAndDept(List<String> users, String organName) {
        String tablePrefix = this.getTablePrefix();
        try {
            return this.workflowCallbackAssigneeService.queryAssigneeAndDept(users, organName, tablePrefix);
        }
        catch (Exception e) {
            logger.error(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public Page<BpmTreeModel> queryNodeAssigneeListByPage(Page<BpmTreeModel> pages, List<String> users, NodeAssigneeQueryDto nodeAssigneeQueryDto) {
        String organId = nodeAssigneeQueryDto.getId();
        String type = nodeAssigneeQueryDto.getType();
        String tablePrefix = this.getTablePrefix();
        try {
            return this.workflowCallbackAssigneeService.queryNodeAssigneeListByPage(pages, users, organId, type, tablePrefix);
        }
        catch (Exception e) {
            logger.error(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public Page<BpmTreeModel> queryNodeAssigneeListWithParentByPage(Page<BpmTreeModel> pages, List<BpmTreeModel> users, NodeAssigneeQueryDto nodeAssigneeQueryDto) {
        String organId = nodeAssigneeQueryDto.getId();
        String type = nodeAssigneeQueryDto.getType();
        String organName = nodeAssigneeQueryDto.getOrganName();
        String tablePrefix = this.getTablePrefix();
        try {
            return this.workflowCallbackAssigneeService.queryNodeAssigneeListWithParentByPage(pages, users, organId, type, organName, tablePrefix);
        }
        catch (Exception e) {
            logger.error(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public IPage<BpmTreeModel> queryNodeAssigneeListWithPage(Page<BpmTreeModel> pages, List<String> users, NodeAssigneeQueryDto nodeAssigneeQueryDto) {
        String organId = nodeAssigneeQueryDto.getId();
        String organName = nodeAssigneeQueryDto.getOrganName();
        String type = nodeAssigneeQueryDto.getType();
        String tablePrefix = this.getTablePrefix();
        try {
            return this.workflowCallbackAssigneeService.queryNodeAssigneeListWithPage(pages, users, organId, organName, type, tablePrefix);
        }
        catch (Exception e) {
            logger.error(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<AssigneeChooseDto> getUserAndAccountListByUserId(List<String> userIds) {
        String tablePrefix = this.getTablePrefix();
        try {
            return this.workflowCallbackAssigneeService.getUserAndAccountListByUserId(userIds, tablePrefix);
        }
        catch (Exception e) {
            logger.error(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<BpmUserInfoVo> getUserMsgByUserIds(List<String> userIds) {
        if (HussarUtils.isEmpty(userIds)) {
            return new ArrayList<BpmUserInfoVo>();
        }
        String tablePrefix = this.getTablePrefix();
        try {
            return this.workflowCallbackAssigneeService.getUserMsgByUserIds(userIds, tablePrefix);
        }
        catch (Exception e) {
            logger.error(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public Page<BpmUserInfoVo> queryList(Page<BpmUserInfoVo> page, GetListInfoVo getListDto) {
        String tablePrefix = this.getTablePrefix();
        try {
            return this.workflowCallbackAssigneeService.queryList(page, getListDto, tablePrefix);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<AssigneeManageInfoVo> queryDept(String name) {
        String tablePrefix = this.getTablePrefix();
        return this.workflowCallbackAssigneeService.queryDept(name, tablePrefix);
    }

    public List<AssigneeManageInfoVo> queryRole(String name) {
        String tablePrefix = this.getTablePrefix();
        return this.workflowCallbackAssigneeService.queryRole(name, tablePrefix);
    }

    public List<AssigneeManageInfoVo> queryPost(String name) {
        String tablePrefix = this.getTablePrefix();
        return this.workflowCallbackAssigneeService.queryPost(name, tablePrefix);
    }

    public String queryPlatformModel() {
        String deploymentModel = this.lcdpBpmProperties.getDeploymentModel();
        if (WORKFLOW_PLATFORM.equals(deploymentModel)) {
            return this.lcdpBpmProperties.getAssigneeMode();
        }
        return deploymentModel;
    }

    public List<String> getAllParentOrganId(String userId, String organId) {
        String tablePrefix = this.getTablePrefix();
        return this.workflowCallbackAssigneeService.getAllParentOrganId(userId, organId, tablePrefix);
    }
}

