/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.wfdtoprocess.visitor;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowModel;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowObject;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowSequence;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowVariables;
import com.jxdinfo.hussar.workflow.engine.flowmodel.MultiUser;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.util.FormBpmnUtil;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.util.FormObjectVisitorBeanUtil;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.visitor.FormObjectVisitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.activiti.bpmn.model.Activity;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowElementsContainer;
import org.activiti.bpmn.model.GraphicInfo;
import org.activiti.bpmn.model.MultiInstanceLoopCharacteristics;
import org.activiti.bpmn.model.SubProcess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="com.jxdinfo.workflow.SubProcess")
public class SubProcessVisitor
implements FormObjectVisitor {
    private BpmnModel model;
    private final Logger logger = LoggerFactory.getLogger(SubProcessVisitor.class);

    @Override
    public void visit(FlowObject flowObject, FlowElementsContainer process, FlowModel flowModel, FlowObject processModel) {
        SubProcess subProcess = new SubProcess();
        subProcess.setId(flowObject.getId());
        subProcess.setName(flowObject.getProps().getFlowName());
        subProcess.setDocumentation(flowObject.getProps().getFlowDescription());
        FormBpmnUtil.createSequence(flowObject.getSlots().getPath(), flowObject.getSlots().getElement(), flowObject.getProcessKeyPath(), (FlowElementsContainer)subProcess, this.model);
        for (FlowObject element : flowObject.getSlots().getElement()) {
            element.setProcessKeyPath(flowObject.getProcessKeyPath());
            FormObjectVisitor formObjectVisitor = null;
            try {
                formObjectVisitor = FormObjectVisitorBeanUtil.getVisitorBean(element.getName());
            }
            catch (BpmException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            formObjectVisitor.visit(element, (FlowElementsContainer)subProcess, flowModel, flowObject);
            GraphicInfo graphicInfo = FormBpmnUtil.createGraphicInfo(element);
            this.model.addGraphicInfo(element.getId(), graphicInfo);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        ArrayList<FlowVariables> functionUserVariables = new ArrayList<FlowVariables>();
        FormBpmnUtil.getFunctionMessage(flowObject.getProps(), map, functionUserVariables);
        FormBpmnUtil.extendHandle(flowObject, subProcess, map);
        if (HussarUtils.isNotEmpty((Object)flowObject.getProps().getFlowCountersign())) {
            this.counterSign(flowObject, subProcess);
        }
        ArrayList<String> pathIds = new ArrayList<String>();
        List flowSequences = processModel.getSlots().getPath();
        for (FlowSequence flowSequence : flowSequences) {
            pathIds.add(flowSequence.getId());
        }
        ArrayList<FlowVariables> useVariables = flowObject.getProps().getUseVariables();
        if (HussarUtils.isEmpty((Object)useVariables)) {
            useVariables = new ArrayList<FlowVariables>();
        }
        if (HussarUtils.isNotEmpty(functionUserVariables)) {
            useVariables.addAll(functionUserVariables);
        }
        FormBpmnUtil.addExeListener((FlowElement)subProcess, useVariables, pathIds, false);
        FormBpmnUtil.addExecutionListener((Activity)subProcess, flowObject);
        process.addFlowElement((FlowElement)subProcess);
    }

    public void setModel(BpmnModel model) {
        this.model = model;
    }

    private void counterSign(FlowObject flowObject, SubProcess subProcess) {
        MultiUser multiUser = flowObject.getProps().getFlowCountersign();
        if (multiUser.isCountersign()) {
            MultiInstanceLoopCharacteristics multiInstanceLoopCharacteristics = new MultiInstanceLoopCharacteristics();
            multiInstanceLoopCharacteristics.setSequential(false);
            multiInstanceLoopCharacteristics.setInputDataItem("multi");
            if ("serial".equals(multiUser.getSequential())) {
                multiInstanceLoopCharacteristics.setSequential(true);
            }
            if ("radio".equals(multiUser.getCountersignType())) {
                multiInstanceLoopCharacteristics.setCompletionCondition("${nrOfCompletedInstances/nrOfInstances >= " + multiUser.getCountersignNumByRatio() / 100.0 + " }");
            }
            if ("count".equals(multiUser.getCountersignType())) {
                multiInstanceLoopCharacteristics.setCompletionCondition("${nrOfCompletedInstances == " + multiUser.getCountersignNumByCount() + " }");
            }
            subProcess.setLoopCharacteristics(multiInstanceLoopCharacteristics);
        }
    }
}

