/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.manage.engine.upgrade;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.common.InstallResult;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.IDefinitionEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.processdef.NodeInfQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processdef.ProcessDefActivateDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processdef.ProcessDefDeleteDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processdef.ProcessDefQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processdef.ProcessDefSuspendDto;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.upgrade.StandardDefinitionEngineApiService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class StandardDefinitionEngineWorkflowApiService
implements StandardDefinitionEngineApiService {
    @Lazy
    @Autowired
    private IDefinitionEngineService definitionEngineService;

    public BpmResponseResult queryProcessMainOrNew(String processKey) {
        return this.definitionEngineService.getProcessMainOrNew(processKey, null);
    }

    public BpmResponseResult queryProcessMainOrNew(String processKey, String organId) {
        return this.definitionEngineService.getProcessMainOrNew(processKey, organId);
    }

    public BpmResponseResult queryProcessDefList(ProcessDefQueryDto processDefQueryDto) {
        if (HussarUtils.isNotEmpty((Object)processDefQueryDto.getProcessKey())) {
            return this.definitionEngineService.getProcessDefList(processDefQueryDto.getProcessKey(), processDefQueryDto.getOrganId());
        }
        return this.definitionEngineService.queryProcessDefList(processDefQueryDto.getProcessName());
    }

    public BpmResponseResult activateProcessDefinition(ProcessDefActivateDto processDefActivateDto) {
        if (!HussarUtils.isEmpty((Object)processDefActivateDto.getProcessDefinitionId())) {
            return this.definitionEngineService.activateProcessDefinitionById(processDefActivateDto.getProcessDefinitionId());
        }
        return this.definitionEngineService.activateProcessByKeyAndVersion(processDefActivateDto.getProcessKey(), processDefActivateDto.getVersion(), processDefActivateDto.getOrganId());
    }

    public BpmResponseResult deleteProcessDefinition(ProcessDefDeleteDto processDefDeleteDto) {
        if (!HussarUtils.isEmpty((Object)processDefDeleteDto.getProcessDefinitionId())) {
            return this.definitionEngineService.deleteProcessDefinition(processDefDeleteDto.getProcessDefinitionId());
        }
        return this.definitionEngineService.deleteProcessDefinitionByKeyAndVersion(processDefDeleteDto.getProcessKey(), processDefDeleteDto.getVersion(), processDefDeleteDto.getOrganId());
    }

    public BpmResponseResult suspendProcessDefinition(ProcessDefSuspendDto processDefSuspendDto) {
        if (HussarUtils.isNotEmpty((Object)processDefSuspendDto.getProcessDefinitionId())) {
            return this.definitionEngineService.suspendProcessDefinitionById(processDefSuspendDto.getProcessDefinitionId());
        }
        return this.definitionEngineService.suspendProcessByKeyAndVersion(processDefSuspendDto.getProcessKey(), processDefSuspendDto.getVersion(), processDefSuspendDto.getOrganId());
    }

    public BpmResponseResult queryAllProcessDefinitions() {
        return this.definitionEngineService.queryProcess();
    }

    public BpmResponseResult queryAllNodeFormInfo(NodeInfQueryDto nodeInfQueryDto) {
        return this.definitionEngineService.queryAllNodeFormInfo(nodeInfQueryDto);
    }

    public BpmResponseResult queryPublishStatusByProcessKey(String processKey) {
        return InstallResult.success((Object)this.definitionEngineService.queryIsPublish(processKey));
    }

    public BpmResponseResult queryNodeInfo(NodeInfQueryDto nodeInfQueryDto) {
        return this.definitionEngineService.queryNodeInfoByProcessKeyAndVersion(nodeInfQueryDto.getProcessKey(), nodeInfQueryDto.getVersion(), nodeInfQueryDto.getOrganId());
    }

    public BpmResponseResult queryOrganProcessByProcessKey(String processKey) {
        return this.definitionEngineService.queryOrganProcessByProcessKey(processKey);
    }
}

