/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.wfdtoprocess.visitor;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowModel;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowObject;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowSequence;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowVariables;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.util.FormBpmnUtil;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.visitor.FormObjectVisitor;
import java.util.ArrayList;
import java.util.List;
import org.activiti.bpmn.model.ExclusiveGateway;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowElementsContainer;
import org.springframework.stereotype.Component;

@Component(value="com.jxdinfo.workflow.Exclusive")
public class ExclusiveGatewayVisitor
implements FormObjectVisitor {
    @Override
    public void visit(FlowObject flowObject, FlowElementsContainer process, FlowModel flowModel, FlowObject processModel) {
        ExclusiveGateway exclusiveGateway = new ExclusiveGateway();
        exclusiveGateway.setId(flowObject.getId());
        exclusiveGateway.setName(flowObject.getProps().getFlowName());
        exclusiveGateway.setDocumentation(flowObject.getProps().getFlowDescription());
        List outSeqList = flowObject.getGoOutPathes();
        for (String seq : outSeqList) {
            for (FlowObject element : processModel.getSlots().getPathAndElement()) {
                boolean isFlowDefault;
                if (!seq.equals(element.getInstanceKey()) || !(isFlowDefault = element.getProps().isFlowDefault())) continue;
                exclusiveGateway.setDefaultFlow(ExclusiveGatewayVisitor.getNodeId(seq, processModel.getSlots().getElement()));
            }
        }
        if (HussarUtils.isNotEmpty((Object)flowObject.getPreviousId())) {
            exclusiveGateway.addExtensionElement(FormBpmnUtil.addExtensionElement("previousId", flowObject.getPreviousId()));
            ArrayList<String> pathIds = new ArrayList<String>();
            List flowSequences = processModel.getSlots().getPath();
            for (FlowSequence flowSequence : flowSequences) {
                pathIds.add(flowSequence.getId());
            }
            ArrayList<FlowVariables> useVariables = flowObject.getProps().getUseVariables();
            boolean flag = false;
            if (HussarUtils.isNotEmpty((Object)useVariables)) {
                flag = true;
            } else {
                useVariables = new ArrayList<FlowVariables>();
            }
            FormBpmnUtil.addExeListener((FlowElement)exclusiveGateway, useVariables, pathIds, flag);
        }
        process.addFlowElement((FlowElement)exclusiveGateway);
    }

    private static String getNodeId(String key, List<FlowObject> element) {
        String nodeId = key;
        for (FlowObject flowObject : element) {
            if (!key.equals(flowObject.getInstanceKey())) continue;
            nodeId = flowObject.getNodeId();
            break;
        }
        return nodeId;
    }
}

