/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.constant;

import com.alibaba.fastjson.JSONArray;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.JumpInfo;
import com.jxdinfo.hussar.workflow.engine.constant.BpmAttribute;
import com.jxdinfo.hussar.workflow.engine.constant.TaskSourceFlag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.activiti.engine.HistoryService;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.impl.context.Context;

public class BpmHistoryTask {
    private static final HistoryService historyService = (HistoryService)SpringContextHolder.getBean(HistoryService.class);

    private static ProcessHistoryTaskModel getHistoryTaskList(String processInstId) {
        ProcessHistoryTaskModel historyTask;
        HashMap<String, ProcessHistoryTaskModel> historyTaskMap = (HashMap<String, ProcessHistoryTaskModel>)BpmAttribute.getContextAttribute("history_task");
        if (historyTaskMap == null) {
            historyTaskMap = new HashMap<String, ProcessHistoryTaskModel>();
            Context.getCommandContext().addAttribute("history_task", historyTaskMap);
        }
        if ((historyTask = (ProcessHistoryTaskModel)historyTaskMap.get(processInstId)) == null) {
            List historicTaskInstanceList = ((HistoricTaskInstanceQuery)historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstId)).list();
            historyTask = new ProcessHistoryTaskModel(historicTaskInstanceList);
            historyTaskMap.put(processInstId, historyTask);
        }
        return historyTask;
    }

    public static HistoricTaskInstance getLastComplete(String procInstId, String subProcessKey, String taskDefKey, Integer seqMultiCount) {
        ProcessHistoryTaskModel historyTaskList = BpmHistoryTask.getHistoryTaskList(procInstId);
        if (seqMultiCount != null) {
            return historyTaskList.findFirstEndTask(subProcessKey, taskDefKey, task -> TaskSourceFlag.NORMAL_COMPLETE.contains(task.getCompleteType()) && seqMultiCount.equals(task.getSeqMultiCount()));
        }
        return historyTaskList.findFirstEndTask(subProcessKey, taskDefKey, task -> TaskSourceFlag.NORMAL_COMPLETE.contains(task.getCompleteType()));
    }

    public static HistoricTaskInstance getLastComplete(String procInstId, String subProcessKey, String taskDefKey) {
        ProcessHistoryTaskModel historyTaskList = BpmHistoryTask.getHistoryTaskList(procInstId);
        return historyTaskList.findFirstEndTask(subProcessKey, taskDefKey, task -> TaskSourceFlag.NORMAL_COMPLETE.contains(task.getCompleteType()));
    }

    public static List<String> getLastAppoint(String procInstId, String subProcessKey, String taskDefKey) {
        HistoricTaskInstance firstTask = BpmHistoryTask.getLastComplete(procInstId, subProcessKey, taskDefKey);
        if (firstTask != null) {
            return firstTask.getAppointAssignee() == null ? null : JSONArray.parseArray((String)firstTask.getAppointAssignee(), String.class);
        }
        return null;
    }

    public static HistoricTaskInstance getLastRejectTask(String procInstId, String subProcessKey, String taskDefKey) {
        ProcessHistoryTaskModel historyTaskList = BpmHistoryTask.getHistoryTaskList(procInstId);
        return historyTaskList.findFirstEndTask(subProcessKey, taskDefKey, task -> TaskSourceFlag.isReject((String)task.getCompleteType()));
    }

    public static HistoricTaskInstance getRandomRunningFollow(String procInstId, String subProcessKey, String taskDefKey) {
        ProcessHistoryTaskModel historyTaskList = BpmHistoryTask.getHistoryTaskList(procInstId);
        if (subProcessKey != null) {
            return historyTaskList.findFirstRunningTask(subProcessKey, null, task -> task.getAllPrevNode() != null && Arrays.asList(task.getAllPrevNode().split(",")).contains(taskDefKey));
        }
        return historyTaskList.getAllHistoryTask().stream().filter(task -> task.getEndTime() == null && task.getAllPrevNode() != null && Arrays.asList(task.getAllPrevNode().split(",")).contains(taskDefKey)).findFirst().orElse(null);
    }

    public static HistoricTaskInstance getRandomRunningRejectFollow(String procInstId, String subProcessKey, String taskDefKey) {
        ProcessHistoryTaskModel historyTaskList = BpmHistoryTask.getHistoryTaskList(procInstId);
        Predicate<HistoricTaskInstance> rejectFrom = task -> {
            if (TaskSourceFlag.isReject((String)task.getCompleteType())) {
                JumpInfo jumpInfo = JumpInfo.toJumpInfo((String)task.getJumpInfo());
                if (jumpInfo == null) {
                    return false;
                }
                return jumpInfo.getJumpFrom().contains(taskDefKey);
            }
            return false;
        };
        if (subProcessKey != null) {
            return historyTaskList.findFirstRunningTask(subProcessKey, null, rejectFrom);
        }
        return historyTaskList.getAllHistoryTask().stream().filter(((Predicate<HistoricTaskInstance>)task -> task.getEndTime() == null).and(rejectFrom)).findFirst().orElse(null);
    }

    public static List<HistoricTaskInstance> findAllEndTask(String procInstId, String subProcessKey, String taskDefKey) {
        List<HistoricTaskInstance> allEndTask = BpmHistoryTask.getHistoryTaskList(procInstId).findAllEndTask(subProcessKey, taskDefKey);
        return allEndTask == null ? Collections.emptyList() : Collections.unmodifiableList(allEndTask);
    }

    public static List<HistoricTaskInstance> findAllTask(String procInstId) {
        List<HistoricTaskInstance> allEndTask = BpmHistoryTask.getHistoryTaskList(procInstId).getAllHistoryTask();
        return allEndTask == null ? Collections.emptyList() : Collections.unmodifiableList(allEndTask);
    }

    private static class ProcessHistoryTaskModel {
        protected final List<HistoricTaskInstance> allHistoryTask;
        private List<HistoricTaskInstance> orderedByEndTime;
        private Map<String, List<HistoricTaskInstance>> groupBySubProcessOrderedByEndTime;
        private Map<String, Map<String, List<HistoricTaskInstance>>> groupByNodeOrderedByEndTime;
        private List<HistoricTaskInstance> unfinished;
        private Map<String, List<HistoricTaskInstance>> groupBySubProcessUnfinished;
        private Map<String, Map<String, List<HistoricTaskInstance>>> groupByNodeUnfinished;

        public List<HistoricTaskInstance> getAllHistoryTask() {
            return this.allHistoryTask;
        }

        public ProcessHistoryTaskModel(List<HistoricTaskInstance> allHistoryTask) {
            if (allHistoryTask == null) {
                throw new UnsupportedOperationException();
            }
            this.allHistoryTask = allHistoryTask;
        }

        public List<HistoricTaskInstance> getOrderedByEndTime() {
            if (this.orderedByEndTime == null) {
                this.orderedByEndTime = this.getAllHistoryTask().stream().filter(task -> task.getEndTime() != null && task.getParentTaskId() == null).sorted(Comparator.comparing(HistoricTaskInstance::getEndTime).reversed()).collect(Collectors.toList());
            }
            return this.orderedByEndTime;
        }

        private void buildFinishedGroup() {
            this.groupByNodeOrderedByEndTime = new HashMap<String, Map<String, List<HistoricTaskInstance>>>();
            this.groupBySubProcessOrderedByEndTime = new HashMap<String, List<HistoricTaskInstance>>();
            List<HistoricTaskInstance> orderedByEndTime = this.getOrderedByEndTime();
            for (HistoricTaskInstance historicTaskInstance : orderedByEndTime) {
                this.groupByNodeOrderedByEndTime.computeIfAbsent(historicTaskInstance.getSubProcessKey(), k -> new HashMap()).computeIfAbsent(historicTaskInstance.getTaskDefinitionKey(), k -> new ArrayList()).add(historicTaskInstance);
                this.groupBySubProcessOrderedByEndTime.computeIfAbsent(historicTaskInstance.getSubProcessKey(), k -> new ArrayList()).add(historicTaskInstance);
            }
        }

        public Map<String, Map<String, List<HistoricTaskInstance>>> getGroupByNodeOrderedByEndTime() {
            if (this.groupByNodeOrderedByEndTime == null) {
                this.buildFinishedGroup();
            }
            return this.groupByNodeOrderedByEndTime;
        }

        public Map<String, List<HistoricTaskInstance>> getGroupBySubProcessOrderedByEndTime() {
            if (this.groupBySubProcessOrderedByEndTime == null) {
                this.buildFinishedGroup();
            }
            return this.groupBySubProcessOrderedByEndTime;
        }

        public List<HistoricTaskInstance> getUnfinished() {
            if (this.unfinished == null) {
                this.unfinished = this.getAllHistoryTask().stream().filter(task -> task.getEndTime() == null && task.getParentTaskId() == null).collect(Collectors.toList());
            }
            return this.unfinished;
        }

        private void buildUnfinishedGroup() {
            this.groupByNodeUnfinished = new HashMap<String, Map<String, List<HistoricTaskInstance>>>();
            this.groupBySubProcessUnfinished = new HashMap<String, List<HistoricTaskInstance>>();
            List<HistoricTaskInstance> unfinished = this.getUnfinished();
            for (HistoricTaskInstance historicTaskInstance : unfinished) {
                this.groupByNodeUnfinished.computeIfAbsent(historicTaskInstance.getSubProcessKey(), k -> new HashMap()).computeIfAbsent(historicTaskInstance.getTaskDefinitionKey(), k -> new ArrayList()).add(historicTaskInstance);
                this.groupBySubProcessUnfinished.computeIfAbsent(historicTaskInstance.getSubProcessKey(), k -> new ArrayList()).add(historicTaskInstance);
            }
        }

        public Map<String, List<HistoricTaskInstance>> getGroupBySubProcessUnfinished() {
            if (this.groupBySubProcessUnfinished == null) {
                this.buildUnfinishedGroup();
            }
            return this.groupBySubProcessUnfinished;
        }

        public Map<String, Map<String, List<HistoricTaskInstance>>> getGroupByNodeUnfinished() {
            if (this.groupByNodeUnfinished == null) {
                this.buildUnfinishedGroup();
            }
            return this.groupByNodeUnfinished;
        }

        public static HistoricTaskInstance findFirstTask(List<HistoricTaskInstance> historicTaskInstanceList, Predicate<HistoricTaskInstance> predicate) {
            if (historicTaskInstanceList == null) {
                return null;
            }
            Optional<HistoricTaskInstance> first = historicTaskInstanceList.stream().filter(predicate).findFirst();
            return first.orElse(null);
        }

        public HistoricTaskInstance findFirstEndTask(String subProcessKey, String taskDefKey, Predicate<HistoricTaskInstance> predicate) {
            Map<String, Map<String, List<HistoricTaskInstance>>> groupByNodeOrderedByEndTime = this.getGroupByNodeOrderedByEndTime();
            Map<String, List<HistoricTaskInstance>> subProcessTask = groupByNodeOrderedByEndTime.get(subProcessKey);
            if (subProcessTask != null) {
                List<HistoricTaskInstance> nodeTask = subProcessTask.get(taskDefKey);
                if (nodeTask == null && subProcessKey != null) {
                    return this.findFirstEndTask(null, taskDefKey, predicate);
                }
                return ProcessHistoryTaskModel.findFirstTask(nodeTask, predicate);
            }
            if (subProcessKey != null) {
                return this.findFirstEndTask(null, taskDefKey, predicate);
            }
            return null;
        }

        public List<HistoricTaskInstance> findAllEndTask(String subProcessKey, String taskDefKey) {
            Map<String, Map<String, List<HistoricTaskInstance>>> groupByNodeOrderedByEndTime = this.getGroupByNodeOrderedByEndTime();
            Map<String, List<HistoricTaskInstance>> subProcessTask = groupByNodeOrderedByEndTime.get(subProcessKey);
            if (subProcessTask != null) {
                List<HistoricTaskInstance> nodeTask = subProcessTask.get(taskDefKey);
                if (nodeTask == null && subProcessKey != null) {
                    return this.findAllEndTask(null, taskDefKey);
                }
                return nodeTask;
            }
            if (subProcessKey != null) {
                return this.findAllEndTask(null, taskDefKey);
            }
            return null;
        }

        public HistoricTaskInstance findFirstRunningTask(String subProcessKey, String taskDefKey, Predicate<HistoricTaskInstance> predicate) {
            List<HistoricTaskInstance> runningTasks = taskDefKey == null ? this.getRunningTasks(subProcessKey) : this.getRunningTasks(subProcessKey, taskDefKey);
            return ProcessHistoryTaskModel.findFirstTask(runningTasks, predicate);
        }

        public List<HistoricTaskInstance> getRunningTasks(String subProcessKey) {
            Map<String, List<HistoricTaskInstance>> groupBySubProcessUnfinished = this.getGroupBySubProcessUnfinished();
            return groupBySubProcessUnfinished.get(subProcessKey);
        }

        public List<HistoricTaskInstance> getRunningTasks(String subProcessKey, String taskDefKey) {
            Map<String, Map<String, List<HistoricTaskInstance>>> groupByNodeUnfinished = this.getGroupByNodeUnfinished();
            Map<String, List<HistoricTaskInstance>> subProcessTask = groupByNodeUnfinished.get(subProcessKey);
            if (subProcessTask != null) {
                List<HistoricTaskInstance> historicTaskInstanceList = subProcessTask.get(taskDefKey);
                if (historicTaskInstanceList == null && subProcessKey != null) {
                    return this.getRunningTasks(null, taskDefKey);
                }
                return historicTaskInstanceList;
            }
            if (subProcessKey != null) {
                return this.getRunningTasks(null, taskDefKey);
            }
            return null;
        }
    }
}

