/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.processtransfer.service.impl;

import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import com.jxdinfo.hussar.workflow.engine.bpm.processtransfer.vo.TransferProgressInfo;
import com.jxdinfo.hussar.workflow.engine.processtransfer.IProcessTransferService;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
public class AsyncTransferTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncTransferTask.class);
    public static final String TRANSFER_PROGRESS_INFO_CACHE = "transferProgressInfo";
    private static final long OVER_TIME = 86400L;
    @Autowired
    private IProcessTransferService processTransferService;

    @Async
    public void asyncTransferTask(Set<Long> identityLinkIdSet, Set<Long> taskIdLongSet, String mandatary, String userId, long transferId, String tcode, String dataSourceName, ServletRequestAttributes servletRequestAttributes) {
        RequestContextHolder.setRequestAttributes((RequestAttributes)servletRequestAttributes);
        HussarContextHolder.setTenant((String)dataSourceName, (String)tcode);
        int totalNum = identityLinkIdSet.size() + taskIdLongSet.size();
        for (Long taskId : taskIdLongSet) {
            try {
                this.processTransferService.transferSingleTaskByTaskId(taskId, mandatary, userId);
                this.success(transferId, totalNum);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                this.fail(transferId, totalNum);
            }
        }
        for (Long identityLinkId : identityLinkIdSet) {
            try {
                this.processTransferService.transferSingleTask(identityLinkId, mandatary, userId);
                this.success(transferId, totalNum);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                this.fail(transferId, totalNum);
            }
        }
        this.end(transferId, totalNum);
    }

    public void start(long transferId, int totalNum) {
        HussarCacheUtil.put((String)TRANSFER_PROGRESS_INFO_CACHE, (Object)transferId, (Object)new TransferProgressInfo().setTotalNum((long)totalNum), (long)86400L);
    }

    private void success(long transferId, int totalNum) {
        TransferProgressInfo transferProgressInfo = (TransferProgressInfo)HussarCacheUtil.get((String)TRANSFER_PROGRESS_INFO_CACHE, (Object)transferId);
        if (transferProgressInfo == null) {
            transferProgressInfo = new TransferProgressInfo().setTotalNum((long)totalNum);
        }
        transferProgressInfo.setSuccessNum(transferProgressInfo.getSuccessNum() + 1L);
        if (transferProgressInfo.getSuccessNum() + transferProgressInfo.getFailNum() >= (long)totalNum) {
            transferProgressInfo.setEnd(true);
        }
        HussarCacheUtil.put((String)TRANSFER_PROGRESS_INFO_CACHE, (Object)transferId, (Object)transferProgressInfo, (long)86400L);
    }

    private void fail(long transferId, int totalNum) {
        TransferProgressInfo transferProgressInfo = (TransferProgressInfo)HussarCacheUtil.get((String)TRANSFER_PROGRESS_INFO_CACHE, (Object)transferId);
        if (transferProgressInfo == null) {
            transferProgressInfo = new TransferProgressInfo().setTotalNum((long)totalNum);
        }
        transferProgressInfo.setFailNum(transferProgressInfo.getFailNum() + 1L);
        if (transferProgressInfo.getSuccessNum() + transferProgressInfo.getFailNum() >= (long)totalNum) {
            transferProgressInfo.setEnd(true);
        }
        HussarCacheUtil.put((String)TRANSFER_PROGRESS_INFO_CACHE, (Object)transferId, (Object)transferProgressInfo, (long)86400L);
    }

    private void end(long transferId, int totalNum) {
        TransferProgressInfo transferProgressInfo = (TransferProgressInfo)HussarCacheUtil.get((String)TRANSFER_PROGRESS_INFO_CACHE, (Object)transferId);
        if (transferProgressInfo == null) {
            transferProgressInfo = new TransferProgressInfo().setTotalNum((long)totalNum);
        }
        transferProgressInfo.setEnd(true);
        HussarCacheUtil.put((String)TRANSFER_PROGRESS_INFO_CACHE, (Object)transferId, (Object)transferProgressInfo, (long)86400L);
    }
}

