/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.migration.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jxdinfo.hussar.common.utils.IdempotentJsonUtils;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.workflow.activiti.dao.BpmActGeBytearrayMapper;
import com.jxdinfo.hussar.workflow.activiti.dao.BpmActReModelMapper;
import com.jxdinfo.hussar.workflow.activiti.model.BpmActGeBytearray;
import com.jxdinfo.hussar.workflow.activiti.model.BpmActReModel;
import com.jxdinfo.hussar.workflow.activiti.model.BpmActReProcdef;
import com.jxdinfo.hussar.workflow.activiti.service.IBpmActReProcdefService;
import com.jxdinfo.hussar.workflow.assignee.model.AssigneeManageInfoVo;
import com.jxdinfo.hussar.workflow.common.InstallResult;
import com.jxdinfo.hussar.workflow.config.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.check.service.impl.ProcessCheckServiceImpl;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.WorkflowBpmUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.config.WorkflowSnowflakeIDGenerator;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.dao.ProcessDefinitionsMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.model.DefinitionModel;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.model.ImportDefinitionModel;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.model.ProcessDefinitionModel;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.DeleteProcessDefinitionCacheCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.extend.ExtendBpmnJsonConverter;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.model.SysActExtendProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.service.impl.SysActExtendPropertiesServiceImpl;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.dto.WorkflowDumpDto;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.dto.WorkflowLoadDto;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.dto.WorkflowPreloadDto;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.dto.WorkflowQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.service.IWorkflowMigrationService;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.vo.WorkflowDumpVo;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.vo.WorkflowLoadVo;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.vo.WorkflowMigrationPreloadVo;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.vo.WorkflowQueryVo;
import com.jxdinfo.hussar.workflow.engine.bpm.model.dao.ModelMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.model.dao.WorkflowMigrationMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.ExportModel;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.SysActAssignee;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.SysActFormAuth;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.SysActHandleAuth;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.WorkFlow;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysActAssigneeService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysActFormAuthService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysActHandleAuthService;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.dao.SysActProcessFileMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.model.SysActProcessFile;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.workflow.engine.bpm.userdata.sync.service.SysBpmOrganService;
import com.jxdinfo.hussar.workflow.engine.flowmodel.BpmNodeTypeUtil;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.dao.Bpm2XMLMapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.activiti.bpmn.converter.BpmnXMLConverter;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.Process;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.repository.Model;
import org.activiti.explorer.util.XmlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class WorkflowMigrationServiceImpl
implements IWorkflowMigrationService {
    private static final Logger logger = LoggerFactory.getLogger(WorkflowMigrationServiceImpl.class);
    @Autowired
    private SysActAssigneeService sysActAssigneeService;
    @Autowired
    private SysActFormAuthService sysActFormAuthService;
    @Autowired
    private SysActExtendPropertiesServiceImpl sysActExtendPropertiesService;
    @Autowired
    private SysActProcessFileService sysActProcessFileService;
    @Autowired
    private ModelService modelService;
    @Autowired
    private SysActHandleAuthService handleAuthService;
    @Resource
    private ProcessDefinitionsMapper processDefinitionsMapper;
    @Resource
    private ProcessEngine processEngine;
    @Resource
    private ModelMapper modelMapper;
    @Resource
    private SysActProcessFileMapper sysActProcessFileMapper;
    @Resource
    private WorkflowMigrationMapper workflowMigrationMapper;
    @Resource
    private BpmActGeBytearrayMapper bpmActGeBytearrayMapper;
    @Resource
    private Bpm2XMLMapper bpm2XMLMapper;
    @Resource
    private RepositoryService repositoryService;
    @Autowired
    private ProcessCheckServiceImpl processCheckService;
    @Autowired
    private IAssigneeChooseService assigneeChooseService;
    @Resource
    private BpmActReModelMapper bpmActReModelMapper;
    @Autowired
    private WorkflowSnowflakeIDGenerator workflowSnowflakeIDGenerator;
    @Autowired
    private IBpmActReProcdefService bpmActReProcdefService;
    @Autowired
    private SysBpmOrganService sysBpmOrganService;
    @Autowired
    private LcdpBpmProperties lcdpBpmProperties;

    public List<WorkflowDumpVo> dump(List<WorkflowDumpDto> workflowDumpDtos) {
        List<String> processKeys = workflowDumpDtos.stream().map(WorkflowDumpDto::getProcessKey).collect(Collectors.toList());
        List<ExportModel> list = this.modelMapper.selectModelNames(processKeys);
        Map<String, String> serviceNameMap = WorkflowBpmUtil.getOtherMap(list, ExportModel::getBusinessId, ExportModel::getCategory, null);
        ArrayList<WorkflowDumpVo> workflowDumpVoList = new ArrayList<WorkflowDumpVo>();
        for (WorkflowDumpDto workflowDumpDto : workflowDumpDtos) {
            this.dumpFiles(workflowDumpVoList, workflowDumpDto, serviceNameMap);
            if (workflowDumpDto.getOrganModels() == null) continue;
            for (WorkflowDumpDto organModel : workflowDumpDto.getOrganModels()) {
                this.dumpFiles(workflowDumpVoList, organModel, serviceNameMap);
            }
        }
        return workflowDumpVoList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpFiles(List<WorkflowDumpVo> workflowDumpVoList, WorkflowDumpDto workflowDumpDto, Map<String, String> serviceNameMap) {
        WorkflowDumpVo workflowDumpVo;
        String processKey = workflowDumpDto.getProcessKey();
        int version = workflowDumpDto.getVersion();
        if (workflowDumpDto.getExportData().getAssigneeData().booleanValue()) {
            List sysActAssignees = this.sysActAssigneeService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActAssignee::getProcDefKey, (Object)processKey)).eq(SysActAssignee::getProcessVersion, (Object)version));
            workflowDumpVo = new WorkflowDumpVo(workflowDumpDto, IdempotentJsonUtils.toString((Object)sysActAssignees), "\u53c2\u4e0e\u8005.json", serviceNameMap.get(processKey));
            workflowDumpVoList.add(workflowDumpVo);
        }
        if (workflowDumpDto.getExportData().getFormAuthData().booleanValue()) {
            List sysActFormAuths = this.sysActFormAuthService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActFormAuth::getProcessKey, (Object)processKey)).and(wrapper -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(SysActFormAuth::getProcessVersion, (Object)version)).or()).isNull(SysActFormAuth::getProcessVersion);
            }));
            List result = sysActFormAuths.stream().filter(e -> e.getProcessVersion() != null).collect(Collectors.toList());
            if (result.isEmpty()) {
                result.addAll(sysActFormAuths);
            }
            WorkflowDumpVo workflowDumpVo2 = new WorkflowDumpVo(workflowDumpDto, IdempotentJsonUtils.toString(result), "\u8868\u5355\u6743\u9650.json", serviceNameMap.get(processKey));
            workflowDumpVoList.add(workflowDumpVo2);
        }
        if (workflowDumpDto.getExportData().getWorkflowData().booleanValue()) {
            List sysActExtendProperties = this.sysActExtendPropertiesService.list((Wrapper)new LambdaQueryWrapper().eq(SysActExtendProperties::getProcDefId, (Object)workflowDumpDto.getProcessDefId()));
            WorkflowDumpVo extendPropertiesDumpVo = new WorkflowDumpVo(workflowDumpDto, IdempotentJsonUtils.toString((Object)sysActExtendProperties), "\u62d3\u5c55.json", serviceNameMap.get(processKey));
            workflowDumpVoList.add(extendPropertiesDumpVo);
            List sysActProcessFiles = this.sysActProcessFileService.list((Wrapper)new LambdaQueryWrapper().eq(SysActProcessFile::getProcessId, (Object)workflowDumpDto.getProcessDefId()));
            this.removeProcessFileAssignee(sysActProcessFiles);
            WorkflowDumpVo sysActProcessFilesDumpVo = new WorkflowDumpVo(workflowDumpDto, IdempotentJsonUtils.toString((Object)sysActProcessFiles), "\u6d41\u7a0b\u6587\u4ef6.lcdpbpm", serviceNameMap.get(processKey));
            workflowDumpVoList.add(sysActProcessFilesDumpVo);
            InputStream resourceAsStream = null;
            ByteArrayOutputStream outputStream = null;
            String xmlByteString = null;
            try {
                int temp;
                resourceAsStream = this.processEngine.getProcessEngineConfiguration().getRepositoryService().getProcessModel(workflowDumpDto.getProcessDefId());
                outputStream = new ByteArrayOutputStream();
                byte[] bytes = new byte[2048];
                while ((temp = resourceAsStream.read(bytes)) != -1) {
                    outputStream.write(bytes, 0, temp);
                }
                byte[] finalBytes = outputStream.toByteArray();
                xmlByteString = new String(finalBytes);
            }
            catch (IOException e2) {
                logger.error(e2.getMessage(), (Throwable)e2);
            }
            finally {
                if (resourceAsStream != null) {
                    try {
                        resourceAsStream.close();
                    }
                    catch (IOException e3) {
                        logger.error(e3.getMessage(), (Throwable)e3);
                    }
                }
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException e4) {
                        logger.error(e4.getMessage(), (Throwable)e4);
                    }
                }
            }
            WorkflowDumpVo xmlDumpVo = new WorkflowDumpVo(workflowDumpDto, xmlByteString, "bpmn20.xml", serviceNameMap.get(processKey));
            workflowDumpVoList.add(xmlDumpVo);
        }
        if (workflowDumpDto.getExportData().getHandleAuthData().booleanValue()) {
            List handleAuthList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.handleAuthService.lambdaQuery().eq(SysActHandleAuth::getProcessKey, (Object)processKey)).eq(SysActHandleAuth::getProcessVersion, (Object)version)).list();
            workflowDumpVo = new WorkflowDumpVo(workflowDumpDto, IdempotentJsonUtils.toString((Object)handleAuthList), "\u8868\u5355\u6743\u9650.json", serviceNameMap.get(processKey));
            workflowDumpVoList.add(workflowDumpVo);
        }
    }

    public List<WorkflowMigrationPreloadVo> preload(List<WorkflowPreloadDto> workflowPreloadDtos) {
        ArrayList<WorkflowMigrationPreloadVo> result = new ArrayList<WorkflowMigrationPreloadVo>();
        List<String> processKeys = workflowPreloadDtos.stream().map(WorkflowPreloadDto::getProcessKey).collect(Collectors.toList());
        List<DefinitionModel> list = this.processDefinitionsMapper.getProcessMsgByProcessKeys(processKeys, null);
        Map<String, List<DefinitionModel>> definitionModelListMap = WorkflowBpmUtil.getListMap(list, DefinitionModel::getMykey, null);
        for (WorkflowPreloadDto workflowPreloadDto : workflowPreloadDtos) {
            List<DefinitionModel> models = definitionModelListMap.get(workflowPreloadDto.getProcessKey());
            if (models != null) {
                Map<String, Integer> organVersionMap = WorkflowBpmUtil.getOtherMap(models, DefinitionModel::getOrganId, e -> Integer.parseInt(e.getVersion()), null);
                Integer maxVersion = organVersionMap.values().stream().max(Integer::compareTo).get();
                WorkflowMigrationPreloadVo workflowMigrationPreloadVo = new WorkflowMigrationPreloadVo(workflowPreloadDto, organVersionMap.get(workflowPreloadDto.getOrganId()), false);
                if (HussarUtils.isEmpty((Object)workflowMigrationPreloadVo.getTenantVersion())) {
                    workflowMigrationPreloadVo.setTenantVersion(organVersionMap.get(null));
                }
                organVersionMap.remove(null);
                workflowMigrationPreloadVo.setOrganVersionMap(organVersionMap);
                workflowMigrationPreloadVo.setMaxVersion(maxVersion);
                if (workflowPreloadDto.getOrganModels() != null) {
                    List organInfo = this.assigneeChooseService.queryDept(null);
                    List organList = organInfo.stream().map(AssigneeManageInfoVo::getId).collect(Collectors.toList());
                    ArrayList<WorkflowMigrationPreloadVo> organModels = new ArrayList<WorkflowMigrationPreloadVo>();
                    HashSet organIdSet = new HashSet(organList);
                    for (WorkflowPreloadDto organModel : workflowPreloadDto.getOrganModels()) {
                        boolean isExist = organIdSet.contains(organModel.getOrganId());
                        organModels.add(new WorkflowMigrationPreloadVo(organModel, organVersionMap.get(organModel.getOrganId()), isExist));
                    }
                    workflowMigrationPreloadVo.setOrganModels(organModels);
                } else {
                    workflowMigrationPreloadVo.setOrganModels(new ArrayList());
                }
                result.add(workflowMigrationPreloadVo);
                continue;
            }
            WorkflowMigrationPreloadVo workflowMigrationPreloadVo = new WorkflowMigrationPreloadVo(workflowPreloadDto, Integer.valueOf(0), false);
            workflowMigrationPreloadVo.setOrganVersionMap(new HashMap());
            workflowMigrationPreloadVo.setMaxVersion(Integer.valueOf(0));
            if (workflowPreloadDto.getOrganModels() != null) {
                List organInfo = this.assigneeChooseService.queryDept(null);
                List organList = organInfo.stream().map(AssigneeManageInfoVo::getId).collect(Collectors.toList());
                HashSet organIdSet = new HashSet(organList);
                ArrayList<WorkflowMigrationPreloadVo> organModels = new ArrayList<WorkflowMigrationPreloadVo>();
                for (WorkflowPreloadDto organModel : workflowPreloadDto.getOrganModels()) {
                    boolean isExist = organIdSet.contains(organModel.getOrganId());
                    organModels.add(new WorkflowMigrationPreloadVo(organModel, Integer.valueOf(0), isExist));
                }
                workflowMigrationPreloadVo.setOrganModels(organModels);
            } else {
                workflowMigrationPreloadVo.setOrganModels(new ArrayList());
            }
            result.add(workflowMigrationPreloadVo);
        }
        return result;
    }

    @CacheEvict(value={"workflow_process_def_id", "workflow_process_real_version", "workflow_organ_process_model"}, allEntries=true)
    public List<WorkflowLoadVo> load(WorkflowLoadDto workflowLoadDto) {
        HashMap<String, String> overrideProcessDefIdMap = new HashMap<String, String>();
        Map importMap = workflowLoadDto.getImportMsgMap();
        Map serviceNameMap = workflowLoadDto.getServiceNameMap();
        HashMap<String, String> importResult = new HashMap<String, String>();
        if (importMap != null) {
            for (WorkflowMigrationPreloadVo workflowMigrationPreloadVo : importMap.values()) {
                this.importFile(workflowMigrationPreloadVo, workflowLoadDto, serviceNameMap, importResult, overrideProcessDefIdMap);
                if (workflowMigrationPreloadVo.getOrganModels() == null) continue;
                for (WorkflowMigrationPreloadVo organModel : workflowMigrationPreloadVo.getOrganModels()) {
                    this.importFile(organModel, workflowLoadDto, serviceNameMap, importResult, overrideProcessDefIdMap);
                }
            }
        }
        HashSet<String> errorImportKeySet = new HashSet<String>(importResult.keySet());
        ArrayList<Map<String, Object>> process = new ArrayList<Map<String, Object>>();
        HashMap<String, Integer> overrideProcessVersionMap = new HashMap<String, Integer>();
        for (WorkflowMigrationPreloadVo workflowMigrationPreloadVo : workflowLoadDto.getImportMsgMap().values()) {
            String processKey = workflowMigrationPreloadVo.getProcessKey();
            int importVersion = workflowMigrationPreloadVo.getImportVersion();
            String key = processKey + ":" + importVersion + ":";
            String importType = workflowMigrationPreloadVo.getImportType();
            if ("override".equals(importType)) {
                HashMap<String, Object> processMap = new HashMap<String, Object>();
                processMap.put("processKey", workflowMigrationPreloadVo.getProcessKey());
                processMap.put("version", workflowMigrationPreloadVo.getTenantVersion());
                overrideProcessVersionMap.put(key, workflowMigrationPreloadVo.getTenantVersion());
                process.add(processMap);
                continue;
            }
            if (!"unable".equals(importType)) continue;
            errorImportKeySet.add(key);
        }
        if (!process.isEmpty()) {
            List<ImportDefinitionModel> newProcessMap = this.processDefinitionsMapper.getProcessDefinitions(process);
            overrideProcessDefIdMap.putAll(WorkflowBpmUtil.getOtherMap(newProcessMap, e -> e.getProcessKey() + ":" + e.getProcessVersion() + ":", ImportDefinitionModel::getProcessDefinition, null));
        }
        for (Map.Entry entry : overrideProcessDefIdMap.entrySet()) {
            if (overrideProcessVersionMap.containsKey(entry.getKey())) continue;
            overrideProcessVersionMap.put((String)entry.getKey(), Integer.valueOf(((String)entry.getValue()).split(":")[1]));
        }
        this.importAssignee(workflowLoadDto, errorImportKeySet, overrideProcessVersionMap);
        this.importFormAuth(workflowLoadDto, errorImportKeySet, overrideProcessVersionMap);
        this.importHandleAuth(workflowLoadDto, errorImportKeySet, overrideProcessVersionMap);
        this.importExtendProperties(workflowLoadDto, errorImportKeySet, overrideProcessDefIdMap);
        ArrayList<WorkflowLoadVo> workflowLoadVos = new ArrayList<WorkflowLoadVo>();
        for (WorkflowMigrationPreloadVo workflowMigrationPreloadVo : workflowLoadDto.getImportMsgs()) {
            WorkflowLoadVo workflowLoadVo = new WorkflowLoadVo(workflowMigrationPreloadVo);
            if (importResult.containsKey(workflowLoadVo.getProcessKey() + ":" + workflowLoadVo.getImportVersion() + ":")) {
                workflowLoadVo.setImportResult("fail");
                workflowLoadVo.setFailReason((String)importResult.get(workflowLoadVo.getProcessKey() + ":" + workflowLoadVo.getImportVersion() + ":"));
            }
            if (workflowMigrationPreloadVo.getOrganModels() != null) {
                ArrayList<WorkflowLoadVo> organModels = new ArrayList<WorkflowLoadVo>();
                for (WorkflowMigrationPreloadVo organModel : workflowMigrationPreloadVo.getOrganModels()) {
                    organModels.add(new WorkflowLoadVo(organModel));
                }
                workflowLoadVo.setOrganModels(organModels);
            }
            workflowLoadVos.add(workflowLoadVo);
        }
        return workflowLoadVos;
    }

    private void importFile(WorkflowMigrationPreloadVo workflowMigrationPreloadVo, WorkflowLoadDto workflowLoadDto, Map<String, String> serviceNameMap, Map<String, String> importResult, Map<String, String> overrideProcessDefIdMap) {
        String processKey = workflowMigrationPreloadVo.getProcessKey();
        int importVersion = workflowMigrationPreloadVo.getImportVersion();
        String key = processKey + ":" + importVersion + ":";
        Map workflowFile = (Map)workflowLoadDto.getWorkflowFiles().get(key);
        if (workflowFile == null) {
            return;
        }
        String lcpbBpmFile = (String)workflowFile.get("\u6d41\u7a0b\u6587\u4ef6.lcdpbpm");
        String xml = (String)workflowFile.get("bpmn20.xml");
        String type = workflowMigrationPreloadVo.getImportType();
        if ("unable".equals(type)) {
            return;
        }
        ApiResponse<String> apiResponse = this.importModel(xml, lcpbBpmFile, serviceNameMap.get(processKey), HussarUtils.isNotEmpty((Object)workflowMigrationPreloadVo.getFinalOrganId()) ? workflowMigrationPreloadVo.getFinalOrganId() : workflowMigrationPreloadVo.getOrganId(), HussarUtils.isNotEmpty((Object)workflowMigrationPreloadVo.getFinalVersion()) ? workflowMigrationPreloadVo.getFinalVersion().intValue() : workflowMigrationPreloadVo.getImportVersion(), workflowMigrationPreloadVo.getRealVersion() == null ? workflowMigrationPreloadVo.getImportVersion() : workflowMigrationPreloadVo.getRealVersion().intValue(), "override".equals(type));
        if (!apiResponse.isSuccess()) {
            importResult.put(key, apiResponse.getMsg());
        } else {
            overrideProcessDefIdMap.put(key, apiResponse.getMsg());
        }
    }

    private void importAssignee(WorkflowLoadDto workflowLoadDto, Set<String> errorImportKeyList, Map<String, Integer> overrideProcessVersionMap) {
        ArrayList<String> importAssignee = new ArrayList<String>();
        for (Object workflow : workflowLoadDto.getImportMsgs()) {
            if (!workflow.getExportData().getAssigneeData().booleanValue() || errorImportKeyList.contains(workflow.getProcessKey() + ":" + workflow.getImportVersion() + ":")) continue;
            importAssignee.add(workflow.getProcessKey() + ":" + workflow.getImportVersion() + ":");
        }
        if (!importAssignee.isEmpty()) {
            LambdaQueryWrapper removeWrapper = new LambdaQueryWrapper();
            for (String key : importAssignee) {
                String[] keys = key.split(":");
                removeWrapper.or(wp -> {
                    wp.eq(SysActAssignee::getProcDefKey, (Object)keys[0]);
                    if (overrideProcessVersionMap.containsKey(key)) {
                        wp.eq(SysActAssignee::getProcessVersion, overrideProcessVersionMap.get(key));
                    } else {
                        wp.eq(SysActAssignee::getProcessVersion, (Object)Integer.valueOf(keys[1]));
                    }
                });
            }
            this.sysActAssigneeService.remove((Wrapper)removeWrapper);
            if (!workflowLoadDto.getAssigneeMsgs().isEmpty()) {
                ArrayList actAssignees = new ArrayList();
                for (String assignee : workflowLoadDto.getAssigneeMsgs()) {
                    List list = JSON.parseArray((String)assignee, SysActAssignee.class);
                    if (list.isEmpty()) continue;
                    String processKey = ((SysActAssignee)list.get(0)).getProcDefKey();
                    Integer version = ((SysActAssignee)list.get(0)).getProcessVersion();
                    String key = processKey + ":" + version + ":";
                    if (errorImportKeyList.contains(key)) continue;
                    if (overrideProcessVersionMap.containsKey(key)) {
                        list.forEach(sysActAssignee -> {
                            if (overrideProcessVersionMap.containsKey(sysActAssignee.getProcDefKey() + ":" + sysActAssignee.getProcessVersion() + ":")) {
                                sysActAssignee.setProcessVersion((Integer)overrideProcessVersionMap.get(sysActAssignee.getProcDefKey() + ":" + sysActAssignee.getProcessVersion() + ":"));
                            }
                        });
                    }
                    actAssignees.addAll(list);
                }
                if (!actAssignees.isEmpty()) {
                    for (SysActAssignee sysActAssignee2 : actAssignees) {
                        sysActAssignee2.setId(null);
                    }
                    this.sysActAssigneeService.saveBatch(actAssignees);
                }
            }
        }
    }

    private void importFormAuth(WorkflowLoadDto workflowLoadDto, Set<String> errorImportKeyList, Map<String, Integer> overrideProcessVersionMap) {
        ArrayList<String> importFormAuth = new ArrayList<String>();
        for (Object workflow : workflowLoadDto.getImportMsgs()) {
            if (!workflow.getExportData().getFormAuthData().booleanValue() || errorImportKeyList.contains(workflow.getProcessKey() + ":" + workflow.getImportVersion() + ":")) continue;
            importFormAuth.add(workflow.getProcessKey() + ":" + workflow.getImportVersion() + ":");
        }
        if (!importFormAuth.isEmpty()) {
            LambdaQueryWrapper removeWrapper = new LambdaQueryWrapper();
            for (String string : importFormAuth) {
                String[] keys = string.split(":");
                removeWrapper.or(wp -> {
                    wp.eq(SysActFormAuth::getProcessKey, (Object)keys[0]);
                    if (overrideProcessVersionMap.containsKey(string)) {
                        wp.eq(SysActFormAuth::getProcessVersion, overrideProcessVersionMap.get(string));
                    } else {
                        wp.eq(SysActFormAuth::getProcessVersion, (Object)keys[1]);
                    }
                });
            }
            if (!workflowLoadDto.getFormAuthMsgs().isEmpty()) {
                ArrayList formAuths = new ArrayList();
                for (String formAuth : workflowLoadDto.getFormAuthMsgs()) {
                    List list = JSON.parseArray((String)formAuth, SysActFormAuth.class);
                    if (list.isEmpty()) continue;
                    String processKey = ((SysActFormAuth)list.get(0)).getProcessKey();
                    Integer version = ((SysActFormAuth)list.get(0)).getProcessVersion();
                    String key = processKey + ":" + version + ":";
                    if (errorImportKeyList.contains(key)) continue;
                    if (overrideProcessVersionMap.containsKey(key)) {
                        list.forEach(sysActFormAuth -> {
                            if (overrideProcessVersionMap.containsKey(sysActFormAuth.getProcessKey() + ":" + sysActFormAuth.getProcessVersion() + ":")) {
                                sysActFormAuth.setProcessVersion((Integer)overrideProcessVersionMap.get(sysActFormAuth.getProcessKey() + ":" + sysActFormAuth.getProcessVersion() + ":"));
                            }
                        });
                    }
                    formAuths.addAll(list);
                }
                if (!formAuths.isEmpty()) {
                    for (String formAuth : formAuths) {
                        formAuth.setId(null);
                    }
                    List list = this.sysActFormAuthService.list((Wrapper)removeWrapper);
                    ArrayList<Long> removeIds = new ArrayList<Long>();
                    block4: for (SysActFormAuth sysActFormAuth2 : formAuths) {
                        for (SysActFormAuth oldFormAuth : list) {
                            if (!this.isSameFormAuthMsg(oldFormAuth, sysActFormAuth2)) continue;
                            removeIds.add(oldFormAuth.getId());
                            continue block4;
                        }
                    }
                    List removeIdList = WorkflowBpmUtil.getSqlIdList(removeIds);
                    for (List removeId : removeIdList) {
                        this.sysActFormAuthService.removeByIds(removeId);
                    }
                    this.sysActFormAuthService.saveBatch(formAuths);
                }
            }
        }
    }

    private boolean isSameFormAuthMsg(SysActFormAuth oldFormAuth, SysActFormAuth sysActFormAuth) {
        if (oldFormAuth.getProcessKey() == null ? sysActFormAuth.getProcessKey() != null : !oldFormAuth.getProcessKey().equals(sysActFormAuth.getProcessKey())) {
            return false;
        }
        if (oldFormAuth.getProcessVersion() == null ? sysActFormAuth.getProcessVersion() != null : !oldFormAuth.getProcessVersion().equals(sysActFormAuth.getProcessVersion())) {
            return false;
        }
        if (oldFormAuth.getTaskDefinitionKey() == null ? sysActFormAuth.getTaskDefinitionKey() != null : !oldFormAuth.getTaskDefinitionKey().equals(sysActFormAuth.getTaskDefinitionKey())) {
            return false;
        }
        if (oldFormAuth.getFormName() == null ? sysActFormAuth.getFormName() != null : !oldFormAuth.getFormName().equals(sysActFormAuth.getFormName())) {
            return false;
        }
        if (oldFormAuth.getFormType() == null ? sysActFormAuth.getFormType() != null : !oldFormAuth.getFormType().equals(sysActFormAuth.getFormType())) {
            return false;
        }
        return !(oldFormAuth.getFormState() == null ? sysActFormAuth.getFormState() != null : !oldFormAuth.getFormState().equals(sysActFormAuth.getFormState()));
    }

    private void importHandleAuth(WorkflowLoadDto workflowLoadDto, Set<String> errorImportKeyList, Map<String, Integer> overrideProcessVersionMap) {
        ArrayList<String> importHandleAuth = new ArrayList<String>();
        for (Object workflow : workflowLoadDto.getImportMsgs()) {
            if (!workflow.getExportData().getHandleAuthData().booleanValue() || errorImportKeyList.contains(workflow.getProcessKey() + ":" + workflow.getImportVersion() + ":")) continue;
            importHandleAuth.add(workflow.getProcessKey() + ":" + workflow.getImportVersion() + ":");
        }
        if (!importHandleAuth.isEmpty()) {
            LambdaQueryWrapper removeWrapper = new LambdaQueryWrapper();
            for (String string : importHandleAuth) {
                String[] keys = string.split(":");
                removeWrapper.or(wp -> {
                    wp.eq(SysActHandleAuth::getProcessKey, (Object)keys[0]);
                    if (overrideProcessVersionMap.containsKey(string)) {
                        wp.eq(SysActHandleAuth::getProcessVersion, overrideProcessVersionMap.get(string));
                    } else {
                        wp.eq(SysActHandleAuth::getProcessVersion, (Object)keys[1]);
                    }
                });
            }
            if (!workflowLoadDto.getHandleAuthMsgs().isEmpty()) {
                ArrayList handleAuths = new ArrayList();
                for (String handleAuth : workflowLoadDto.getHandleAuthMsgs()) {
                    List list = JSON.parseArray((String)handleAuth, SysActHandleAuth.class);
                    if (list.isEmpty()) continue;
                    String processKey = ((SysActHandleAuth)list.get(0)).getProcessKey();
                    Integer version = ((SysActHandleAuth)list.get(0)).getProcessVersion();
                    String key = processKey + ":" + version + ":";
                    if (errorImportKeyList.contains(key)) continue;
                    if (overrideProcessVersionMap.containsKey(key)) {
                        list.forEach(sysActHandleAuth -> {
                            if (overrideProcessVersionMap.containsKey(sysActHandleAuth.getProcessKey() + ":" + sysActHandleAuth.getProcessVersion() + ":")) {
                                sysActHandleAuth.setProcessVersion((Integer)overrideProcessVersionMap.get(sysActHandleAuth.getProcessKey() + ":" + sysActHandleAuth.getProcessVersion() + ":"));
                            }
                        });
                    }
                    handleAuths.addAll(list);
                }
                if (!handleAuths.isEmpty()) {
                    List list = this.handleAuthService.list((Wrapper)removeWrapper);
                    ArrayList<Long> removeIds = new ArrayList<Long>();
                    block3: for (SysActHandleAuth sysActFormAuth : handleAuths) {
                        for (SysActHandleAuth oldFormAuth : list) {
                            if (!this.isSameHandleAuth(oldFormAuth, sysActFormAuth)) continue;
                            removeIds.add(oldFormAuth.getId());
                            continue block3;
                        }
                    }
                    List removeIdList = WorkflowBpmUtil.getSqlIdList(removeIds);
                    for (List removeId : removeIdList) {
                        this.handleAuthService.removeByIds(removeId);
                    }
                    this.handleAuthService.saveBatch(handleAuths);
                }
            }
        }
    }

    private boolean isSameHandleAuth(SysActHandleAuth oldFormAuth, SysActHandleAuth sysActFormAuth) {
        if (oldFormAuth.getProcessKey() == null ? sysActFormAuth.getProcessKey() != null : !oldFormAuth.getProcessKey().equals(sysActFormAuth.getProcessKey())) {
            return false;
        }
        if (oldFormAuth.getProcessVersion() == null ? sysActFormAuth.getProcessVersion() != null : !oldFormAuth.getProcessVersion().equals(sysActFormAuth.getProcessVersion())) {
            return false;
        }
        if (oldFormAuth.getTaskDefinitionKey() == null ? sysActFormAuth.getTaskDefinitionKey() != null : !oldFormAuth.getTaskDefinitionKey().equals(sysActFormAuth.getTaskDefinitionKey())) {
            return false;
        }
        return !(oldFormAuth.getHandleType() == null ? sysActFormAuth.getHandleType() != null : !oldFormAuth.getHandleType().equals(sysActFormAuth.getHandleType()));
    }

    private void importExtendProperties(WorkflowLoadDto workflowLoadDto, Set<String> errorImportKeyList, Map<String, String> overrideProcessDefIdMap) {
        ArrayList newSysActExtendProperties = new ArrayList();
        ArrayList<String> importProcessIds = new ArrayList<String>();
        for (String extendPropertie : workflowLoadDto.getExpandMsgs()) {
            String procDefId;
            List extendProperties = JSON.parseArray((String)extendPropertie, SysActExtendProperties.class);
            if (HussarUtils.isEmpty((Object)extendProperties)) continue;
            String processId = ((SysActExtendProperties)extendProperties.get(0)).getProcDefId();
            String proDefKey = processId.split(":")[0];
            String[] processIds = processId.split(":");
            String key = processIds[0] + ":" + processIds[1] + ":";
            if (errorImportKeyList.contains(key)) continue;
            if (overrideProcessDefIdMap.containsKey(key)) {
                procDefId = overrideProcessDefIdMap.get(key);
                importProcessIds.add(procDefId);
                for (SysActExtendProperties sysActExtendProperties : extendProperties) {
                    sysActExtendProperties.setProcDefId(overrideProcessDefIdMap.get(key));
                    sysActExtendProperties.setId(null);
                }
            } else {
                procDefId = ((SysActExtendProperties)extendProperties.get(0)).getProcDefId();
                importProcessIds.add(procDefId);
                for (SysActExtendProperties sysActExtendProperties : extendProperties) {
                    sysActExtendProperties.setId(null);
                }
            }
            newSysActExtendProperties.addAll(extendProperties);
        }
        if (newSysActExtendProperties.isEmpty()) {
            return;
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.in(SysActExtendProperties::getProcDefId, importProcessIds);
        this.sysActExtendPropertiesService.remove((Wrapper)lambdaQueryWrapper);
        this.sysActExtendPropertiesService.saveBatch(newSysActExtendProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ApiResponse<String> importModel(String xml, String lcdpbpm, String serviceName, String organId, Integer finalVersion, Integer realVersion, boolean isOverride) {
        List oldSysActProcessFiles;
        String processKey;
        BpmnModel bpmnModel = null;
        XMLStreamReader xtr = null;
        try (ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes());){
            XMLInputFactory xif = XmlUtil.createSafeXmlInputFactory();
            xtr = xif.createXMLStreamReader(in);
            bpmnModel = new BpmnXMLConverter().convertToBpmnModel(xtr);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            ApiResponse apiResponse = ApiResponse.fail((String)e.getMessage());
            return apiResponse;
        }
        finally {
            if (xtr != null) {
                try {
                    xtr.close();
                }
                catch (XMLStreamException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        String impModelName = ((Process)bpmnModel.getProcesses().get(0)).getName();
        String modelKey = ((Process)bpmnModel.getProcesses().get(0)).getId();
        String identityId = this.modelMapper.getIdByIdentity(modelKey, organId);
        List sysActProcessFiles = JSON.parseArray((String)lcdpbpm, SysActProcessFile.class);
        ArrayList<SysActProcessFile> wfdList = new ArrayList<SysActProcessFile>();
        ArrayList<SysActProcessFile> metaList = new ArrayList<SysActProcessFile>();
        boolean needModify = false;
        String workFlowName = null;
        String workflowStyle = null;
        String processId = null;
        if (!isOverride) {
            List oldSysActProcessFiles2 = this.sysActProcessFileMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActProcessFile::getVersion, (Object)0)).eq(SysActProcessFile::getProcessKey, (Object)modelKey));
            for (SysActProcessFile sysActProcessFile : sysActProcessFiles) {
                if (HussarUtils.isNotEmpty((Object)oldSysActProcessFiles2)) {
                    for (SysActProcessFile oldSysActProcessFile : oldSysActProcessFiles2) {
                        if (!oldSysActProcessFile.getType().equals(sysActProcessFile.getType())) continue;
                        sysActProcessFile.setId(oldSysActProcessFile.getId());
                        sysActProcessFile.setVersion(Integer.valueOf(0));
                        if ("temp-wfd".equals(sysActProcessFile.getType()) || "wfd".equals(sysActProcessFile.getType())) {
                            wfdList.add(sysActProcessFile);
                            continue;
                        }
                        metaList.add(sysActProcessFile);
                    }
                    continue;
                }
                sysActProcessFile.setId(null);
                sysActProcessFile.setVersion(Integer.valueOf(0));
                if ("temp-wfd".equals(sysActProcessFile.getType()) || "wfd".equals(sysActProcessFile.getType())) {
                    wfdList.add(sysActProcessFile);
                    continue;
                }
                metaList.add(sysActProcessFile);
            }
            for (SysActProcessFile sysActProcessFile : metaList) {
                WorkFlow workFlow = (WorkFlow)JSON.parseObject((String)new String(sysActProcessFile.getContent(), StandardCharsets.UTF_8), WorkFlow.class);
                workflowStyle = workFlow.getWorkflowStyle();
                if (HussarUtils.isNotEmpty((Object)identityId)) {
                    workFlow.setModelId(Long.valueOf(identityId));
                }
                sysActProcessFile.setContent(JSONObject.toJSONString((Object)workFlow).getBytes(StandardCharsets.UTF_8));
                if (!HussarUtils.isNotEmpty((Object)identityId)) continue;
                sysActProcessFile.setModelId(Long.valueOf(identityId));
            }
            for (SysActProcessFile sysActProcessFile : wfdList) {
                if (!HussarUtils.isNotEmpty((Object)identityId)) continue;
                sysActProcessFile.setModelId(Long.valueOf(identityId));
            }
            ArrayList<SysActProcessFile> addList = new ArrayList<SysActProcessFile>();
            addList.addAll(wfdList);
            addList.addAll(metaList);
            for (SysActProcessFile sysActProcessFile : addList) {
                sysActProcessFile.setProcessId(null);
            }
            this.sysActProcessFileService.saveOrUpdateBatch(addList);
            if (HussarUtils.isEmpty((Object)identityId)) {
                if (HussarUtils.isNotEmpty((Object)organId)) {
                    LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
                    lambdaQueryWrapper.eq(BpmActReModel::getModelKey, (Object)modelKey);
                    lambdaQueryWrapper.isNull(BpmActReModel::getOrganId);
                    BpmActReModel model = (BpmActReModel)this.bpmActReModelMapper.selectOne((Wrapper)lambdaQueryWrapper);
                    identityId = this.workflowSnowflakeIDGenerator.getNextId();
                    BpmActReModel bpmActReModel = new BpmActReModel();
                    bpmActReModel.setId(Long.valueOf(Long.parseLong(identityId)));
                    bpmActReModel.setVersion(finalVersion);
                    bpmActReModel.setDeploymentId(null);
                    bpmActReModel.setMetaInfo(model.getMetaInfo());
                    bpmActReModel.setName(model.getName());
                    bpmActReModel.setModelKey(model.getModelKey());
                    bpmActReModel.setWorkflowStyle(workflowStyle);
                    bpmActReModel.setTenantId(model.getTenantId());
                    bpmActReModel.setRev(model.getRev());
                    bpmActReModel.setOrganId(organId);
                    bpmActReModel.setEditorSourceValueId(model.getEditorSourceValueId());
                    this.bpmActReModelMapper.insert(bpmActReModel);
                } else {
                    Model model = this.repositoryService.newModel();
                    ObjectNode modelObjectNode = new ObjectMapper().createObjectNode();
                    modelObjectNode.put("name", impModelName);
                    modelObjectNode.put("description", ((Process)bpmnModel.getProcesses().get(0)).getDocumentation());
                    modelObjectNode.put("revision", 1);
                    model.setMetaInfo(modelObjectNode.toString());
                    model.setName(impModelName);
                    model.setKey(modelKey);
                    model.setCategory(serviceName);
                    model.setWorkflowStyle(workflowStyle);
                    this.repositoryService.saveModel(model);
                    identityId = model.getId();
                }
            }
            ExtendBpmnJsonConverter extendBpmnJsonConverter = new ExtendBpmnJsonConverter();
            extendBpmnJsonConverter.updateConvertersToBpmnMap();
            extendBpmnJsonConverter.updateConvertersToJsonMap();
            ObjectNode editorNode = extendBpmnJsonConverter.convertToJson(bpmnModel);
            this.repositoryService.addModelEditorSource(identityId, editorNode.toString().getBytes(StandardCharsets.UTF_8));
            WorkFlow workFlow = this.sysActProcessFileService.getFileByProcessKeyAndProcessId(modelKey, null, false, Integer.valueOf(0), false);
            if (workFlow == null) {
                logger.error("{} \u6570\u636e\u7f3a\u5931", (Object)modelKey);
                throw new NullPointerException(modelKey + "\u6570\u636e\u7f3a\u5931");
            }
            workFlow.setModelId(Long.valueOf(Long.parseLong(identityId)));
            this.sysActProcessFileService.updateFile(workFlow, Integer.valueOf(0));
            if (HussarUtils.isNotEmpty((Object)organId)) {
                processId = this.modelService.deployModelAboutOrgan(workFlow, bpmnModel, identityId, organId, finalVersion, realVersion);
            } else {
                processId = this.modelService.deployModel(workFlow, Long.valueOf(Long.parseLong(identityId)), workFlow.getWorkflowStyle(), null, finalVersion, false);
                String newFinalVersion = processId.split(":")[1];
                if (!newFinalVersion.equals(String.valueOf(realVersion))) {
                    LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                    ((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.eq(BpmActReProcdef::getId, (Object)processId)).set(BpmActReProcdef::getMainProcess, (Object)4)).set(BpmActReProcdef::getRealVersion, (Object)realVersion);
                    this.bpmActReProcdefService.update((Wrapper)updateWrapper);
                }
            }
        } else {
            int overVersion;
            ApiResponse<String> apiResponse;
            processKey = ((SysActProcessFile)sysActProcessFiles.get(0)).getProcessKey();
            ArrayList<String> processKeys = new ArrayList<String>();
            processKeys.add(processKey);
            int n = Integer.parseInt(this.processDefinitionsMapper.getProcessMsgByProcessKeys(processKeys, organId).get(0).getVersion());
            oldSysActProcessFiles = this.sysActProcessFileMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActProcessFile::getVersion, (Object)n)).eq(SysActProcessFile::getProcessKey, (Object)modelKey));
            WorkFlow oldWorkflow = this.getWorkflow(oldSysActProcessFiles);
            WorkFlow newWorkflow = this.getWorkflow(sysActProcessFiles);
            if (oldWorkflow != null && newWorkflow != null && !(apiResponse = this.processCheckService.checkWorkflow(newWorkflow, oldWorkflow, "3")).isSuccess()) {
                return apiResponse;
            }
            List<DefinitionModel> mainProdef = this.processDefinitionsMapper.getMainProdef(processKey, organId);
            if (HussarUtils.isEmpty(mainProdef)) {
                mainProdef = this.processDefinitionsMapper.getOtherProdef(processKey, organId);
            }
            needModify = (overVersion = Integer.parseInt(mainProdef.get(0).getVersion())) == n;
            LambdaQueryWrapper removeWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActProcessFile::getProcessKey, (Object)modelKey)).eq(SysActProcessFile::getType, (Object)"temp-wfd");
            if (needModify) {
                Iterator removeTempVersions = new ArrayList<Integer>();
                removeTempVersions.add(n);
                removeTempVersions.add(0);
                removeWrapper.in(SysActProcessFile::getVersion, (Collection)((Object)removeTempVersions));
            } else {
                removeWrapper.eq(SysActProcessFile::getVersion, (Object)n);
            }
            this.sysActProcessFileMapper.delete((Wrapper)removeWrapper);
            for (SysActProcessFile file : sysActProcessFiles) {
                if (HussarUtils.isNotEmpty((Object)oldSysActProcessFiles)) {
                    for (SysActProcessFile oldSysActProcessFile : oldSysActProcessFiles) {
                        if (!oldSysActProcessFile.getType().equals(file.getType())) continue;
                        file.setId(oldSysActProcessFile.getId());
                        processId = String.valueOf(oldSysActProcessFile.getProcessId());
                        file.setProcessId(processId);
                        file.setVersion(Integer.valueOf(n));
                        if ("temp-wfd".equals(file.getType()) || "wfd".equals(file.getType())) {
                            wfdList.add(file);
                            continue;
                        }
                        metaList.add(file);
                    }
                    continue;
                }
                file.setId(null);
                file.setVersion(Integer.valueOf(n));
                if ("temp-wfd".equals(file.getType()) || "wfd".equals(file.getType())) {
                    wfdList.add(file);
                    continue;
                }
                metaList.add(file);
            }
            for (SysActProcessFile sysActProcessFile : metaList) {
                WorkFlow workFlow = (WorkFlow)JSON.parseObject((String)new String(sysActProcessFile.getContent(), StandardCharsets.UTF_8), WorkFlow.class);
                if (HussarUtils.isNotEmpty((Object)identityId)) {
                    workFlow.setModelId(Long.valueOf(identityId));
                    workFlow.setProcDefId(processId);
                }
                workFlowName = workFlow.getName();
                workflowStyle = workFlow.getWorkflowStyle();
                sysActProcessFile.setContent(JSONObject.toJSONString((Object)workFlow).getBytes(StandardCharsets.UTF_8));
                if (!HussarUtils.isNotEmpty((Object)identityId)) continue;
                sysActProcessFile.setModelId(Long.valueOf(identityId));
            }
            for (SysActProcessFile sysActProcessFile : wfdList) {
                if (!HussarUtils.isNotEmpty((Object)identityId)) continue;
                sysActProcessFile.setModelId(Long.valueOf(identityId));
            }
            ArrayList<SysActProcessFile> addList = new ArrayList<SysActProcessFile>();
            addList.addAll(wfdList);
            addList.addAll(metaList);
            this.sysActProcessFileService.saveOrUpdateBatch(addList);
            BpmActGeBytearray bpmActGeBytearray = new BpmActGeBytearray();
            bpmActGeBytearray.setBytes(new BpmnXMLConverter().convertToXML(bpmnModel));
            Long id = HussarUtils.isNotEmpty((Object)this.bpm2XMLMapper.getModelId(n, processKey)) ? this.bpm2XMLMapper.getModelId(n, processKey) : null;
            bpmActGeBytearray.setId(id);
            this.bpmActGeBytearrayMapper.updateById(bpmActGeBytearray);
            ExtendBpmnJsonConverter jsonConverter = new ExtendBpmnJsonConverter();
            jsonConverter.updateConvertersToBpmnMap();
            jsonConverter.updateConvertersToJsonMap();
            ObjectNode editorNode = jsonConverter.convertToJson(bpmnModel);
            this.repositoryService.addModelEditorSource(identityId, editorNode.toString().getBytes(StandardCharsets.UTF_8));
            this.processDefinitionsMapper.updateProcessName(processId, workFlowName, workflowStyle);
            this.processEngine.getManagementService().executeCommand((Command)new DeleteProcessDefinitionCacheCmd(processId));
            if (!finalVersion.equals(realVersion)) {
                LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                ((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.eq(BpmActReProcdef::getId, (Object)processId)).set(BpmActReProcdef::getMainProcess, (Object)4)).set(BpmActReProcdef::getRealVersion, (Object)realVersion);
                this.bpmActReProcdefService.update((Wrapper)updateWrapper);
            }
        }
        if (needModify && HussarUtils.isEmpty((Object)organId)) {
            processKey = ((SysActProcessFile)sysActProcessFiles.get(0)).getProcessKey();
            ArrayList<SysActProcessFile> wfds = new ArrayList<SysActProcessFile>();
            ArrayList<SysActProcessFile> arrayList = new ArrayList<SysActProcessFile>();
            oldSysActProcessFiles = this.sysActProcessFileMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActProcessFile::getVersion, (Object)0)).eq(SysActProcessFile::getProcessKey, (Object)modelKey));
            for (SysActProcessFile file : sysActProcessFiles) {
                if (HussarUtils.isNotEmpty((Object)oldSysActProcessFiles)) {
                    for (SysActProcessFile oldSysActProcessFile : oldSysActProcessFiles) {
                        if (!oldSysActProcessFile.getType().equals(file.getType())) continue;
                        file.setId(oldSysActProcessFile.getId());
                        file.setVersion(Integer.valueOf(0));
                        file.setProcessId(null);
                        if ("temp-wfd".equals(file.getType()) || "wfd".equals(file.getType())) {
                            wfds.add(file);
                            continue;
                        }
                        arrayList.add(file);
                    }
                    continue;
                }
                file.setId(null);
                file.setVersion(Integer.valueOf(0));
                file.setProcessId(null);
                if ("temp-wfd".equals(file.getType()) || "wfd".equals(file.getType())) {
                    wfds.add(file);
                    continue;
                }
                arrayList.add(file);
            }
            for (SysActProcessFile sysActProcessFile : arrayList) {
                WorkFlow workFlow = (WorkFlow)JSON.parseObject((String)new String(sysActProcessFile.getContent(), StandardCharsets.UTF_8), WorkFlow.class);
                if (HussarUtils.isNotEmpty((Object)identityId)) {
                    workFlow.setModelId(Long.valueOf(identityId));
                    workFlow.setProcDefId(processId);
                }
                sysActProcessFile.setContent(JSONObject.toJSONString((Object)workFlow).getBytes(StandardCharsets.UTF_8));
                if (!HussarUtils.isNotEmpty((Object)identityId)) continue;
                sysActProcessFile.setModelId(Long.valueOf(identityId));
            }
            for (SysActProcessFile sysActProcessFile : wfdList) {
                if (!HussarUtils.isNotEmpty((Object)identityId)) continue;
                sysActProcessFile.setModelId(Long.valueOf(identityId));
            }
            ArrayList<SysActProcessFile> addList = new ArrayList<SysActProcessFile>();
            addList.addAll(wfds);
            addList.addAll(arrayList);
            this.sysActProcessFileService.saveOrUpdateBatch(addList);
            BpmActGeBytearray bpmActGeBytearray = new BpmActGeBytearray();
            bpmActGeBytearray.setBytes(new BpmnXMLConverter().convertToXML(bpmnModel));
            Long id = HussarUtils.isNotEmpty((Object)this.bpm2XMLMapper.getUpdateModelId(Long.parseLong(identityId))) ? this.bpm2XMLMapper.getUpdateModelId(Long.parseLong(identityId)) : null;
            bpmActGeBytearray.setId(id);
            this.bpmActGeBytearrayMapper.updateById(bpmActGeBytearray);
            Model modelData = (Model)this.repositoryService.createModelQuery().modelId(identityId).singleResult();
            String metaInfo = modelData.getMetaInfo();
            JSONObject metaInfoJsonObject = JSONObject.parseObject((String)metaInfo);
            metaInfoJsonObject.put("name", (Object)workFlowName);
            this.processDefinitionsMapper.setNameAndDeploymentId(workFlowName, null, workflowStyle, processKey, metaInfoJsonObject.toString(), organId);
        }
        return ApiResponse.success((String)processId);
    }

    private WorkFlow getWorkflow(List<SysActProcessFile> sysActProcessFiles) {
        SysActProcessFile wfd = null;
        SysActProcessFile meta = null;
        for (SysActProcessFile sysActProcessFile : sysActProcessFiles) {
            if ("wfd".equals(sysActProcessFile.getType())) {
                wfd = sysActProcessFile;
                continue;
            }
            if (!"meta".equals(sysActProcessFile.getType())) continue;
            meta = sysActProcessFile;
        }
        if (HussarUtils.isEmpty(wfd) || HussarUtils.isEmpty(meta)) {
            return null;
        }
        WorkFlow workFlow = (WorkFlow)JSON.parseObject((String)new String(meta.getContent(), StandardCharsets.UTF_8), WorkFlow.class);
        workFlow.setProcDefId(meta.getProcessId());
        workFlow.setModelId(meta.getModelId());
        workFlow.setData(new String(wfd.getContent(), StandardCharsets.UTF_8));
        return workFlow;
    }

    public BpmResponseResult selectByName(WorkflowQueryDto workflowQueryDto) {
        List<WorkflowQueryVo> list = this.queryModelList((Page<WorkflowQueryVo>)workflowQueryDto.getPage(), workflowQueryDto.getName());
        if (!list.isEmpty()) {
            List<String> processKeys = list.stream().map(WorkflowQueryVo::getProcessKey).collect(Collectors.toList());
            List<ProcessDefinitionModel> processDefinitionModels = this.workflowMigrationMapper.queryProcessDefList(processKeys);
            Map<String, List<ProcessDefinitionModel>> processDefinitionModelListMap = WorkflowBpmUtil.getListMap(processDefinitionModels, ProcessDefinitionModel::getKey, null);
            for (WorkflowQueryVo workflowQueryVo : list) {
                List<ProcessDefinitionModel> processDefinitionModelList = processDefinitionModelListMap.get(workflowQueryVo.getProcessKey());
                Map<String, List<ProcessDefinitionModel>> organProcessMap = WorkflowBpmUtil.getListMap(processDefinitionModelList, ProcessDefinitionModel::getOrganId, null);
                workflowQueryVo.setVersionMap(this.getVersionMap(organProcessMap.get(workflowQueryVo.getOrganId())));
                if (!HussarUtils.isNotEmpty((Object)workflowQueryVo.getOrganModels())) continue;
                if (!this.lcdpBpmProperties.isUseOrganProcess()) {
                    workflowQueryVo.setOrganModels(new ArrayList());
                }
                for (WorkflowQueryVo organWorkflow : workflowQueryVo.getOrganModels()) {
                    organWorkflow.setVersionMap(this.getVersionMap(organProcessMap.get(organWorkflow.getOrganId())));
                }
            }
        }
        JSONArray jsonArray = new JSONArray();
        jsonArray.add((Object)workflowQueryDto.getPage().setRecords(list));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    private List<Map<String, String>> getVersionMap(List<ProcessDefinitionModel> processDefinitionModels) {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        for (ProcessDefinitionModel processDefinitionModel : processDefinitionModels) {
            HashMap<String, String> map = new HashMap<String, String>();
            String version = processDefinitionModel.getId().split(":")[1];
            map.put("key", version);
            map.put("value", processDefinitionModel.getId());
            map.put("realVersion", HussarUtils.isEmpty((Object)processDefinitionModel.getRealVersion()) ? null : processDefinitionModel.getRealVersion());
            result.add(map);
        }
        return result;
    }

    public List<WorkflowQueryVo> queryModelList(Page<WorkflowQueryVo> page, String processName) {
        List<WorkflowQueryVo> list = this.workflowMigrationMapper.queryModelList(page, processName, null);
        List<String> processKeyList = list.stream().map(WorkflowQueryVo::getProcessKey).collect(Collectors.toList());
        List<WorkflowQueryVo> organProcessList = this.workflowMigrationMapper.queryModelList(null, null, processKeyList);
        if (HussarUtils.isNotEmpty(organProcessList)) {
            ArrayList organIds = new ArrayList(organProcessList.stream().map(WorkflowQueryVo::getOrganId).collect(Collectors.toSet()));
            Map organNameMap = this.assigneeChooseService.getUserListByUserId(organIds);
            organProcessList.forEach(e -> e.setOrganName((String)organNameMap.get(e.getOrganId())));
            Map<String, List<WorkflowQueryVo>> organProcessListMap = WorkflowBpmUtil.getListMap(organProcessList, WorkflowQueryVo::getProcessKey, null);
            for (WorkflowQueryVo workflowQueryVo : list) {
                workflowQueryVo.setOrganModels(organProcessListMap.get(workflowQueryVo.getProcessKey()));
            }
        }
        return list;
    }

    private void removeProcessFileAssignee(List<SysActProcessFile> sysActProcessFiles) {
        for (SysActProcessFile sysActProcessFile : sysActProcessFiles) {
            if (!"temp-wfd".equals(sysActProcessFile.getType()) && !"wfd".equals(sysActProcessFile.getType())) continue;
            String workflow = new String(sysActProcessFile.getContent(), StandardCharsets.UTF_8);
            JSONObject jsonObject = JSON.parseObject((String)workflow);
            JSONArray nodes = jsonObject.getJSONObject("slots").getJSONArray("default");
            for (int i = 0; i < nodes.size(); ++i) {
                JSONArray subProcessNodes;
                JSONObject node = nodes.getJSONObject(i);
                JSONObject props = node.getJSONObject("props");
                if (BpmNodeTypeUtil.isStart((String)node.getString("name"))) {
                    this.removeFormAuth(props);
                    continue;
                }
                if (BpmNodeTypeUtil.isUserTask((String)node.getString("name"))) {
                    props.put("flowAssignment", (Object)new JSONObject());
                    props.put("flowEndRecipients", (Object)new JSONObject());
                    props.put("flowRecipients", (Object)new JSONObject());
                    this.removeFormAuth(props);
                    continue;
                }
                if (BpmNodeTypeUtil.isCallActivity((String)node.getString("name"))) {
                    props.put("flowSelector", (Object)new JSONObject());
                    continue;
                }
                if (!BpmNodeTypeUtil.isSubProcess((String)node.getString("name"))) continue;
                props.put("flowAssignment", (Object)new JSONObject());
                if (node.getJSONObject("slots") == null || (subProcessNodes = node.getJSONObject("slots").getJSONArray("default")) == null) continue;
                for (int j = 0; j < subProcessNodes.size(); ++j) {
                    JSONObject subProcessNode = subProcessNodes.getJSONObject(j);
                    if (!BpmNodeTypeUtil.isUserTask((String)subProcessNode.getString("name"))) continue;
                    JSONObject subProcessProps = node.getJSONObject("props");
                    subProcessProps.put("flowAssignment", (Object)new JSONObject());
                    subProcessProps.put("flowEndRecipients", (Object)new JSONObject());
                    subProcessProps.put("flowRecipients", (Object)new JSONObject());
                    this.removeFormAuth(subProcessProps);
                }
            }
            workflow = jsonObject.toJSONString();
            sysActProcessFile.setContent(workflow.getBytes(StandardCharsets.UTF_8));
        }
    }

    private void removeFormAuth(JSONObject props) {
        JSONObject assistFormDetailAddress;
        JSONObject assistFormAddress;
        JSONObject ccFormDetailAddress;
        JSONObject ccFormAddress;
        JSONObject formDetailAddress;
        JSONObject formAddress = props.getJSONObject("formAddress");
        if (formAddress != null) {
            for (Object key : formAddress.keySet()) {
                formAddress.getJSONObject((String)key).remove((Object)"formAuth");
            }
        }
        if ((formDetailAddress = props.getJSONObject("formDetailAddress")) != null) {
            for (Object key : formDetailAddress.keySet()) {
                formDetailAddress.getJSONObject((String)key).remove((Object)"formAuth");
            }
        }
        if ((ccFormAddress = props.getJSONObject("ccFormAddress")) != null) {
            for (Object key : ccFormAddress.keySet()) {
                ccFormAddress.getJSONObject((String)key).remove((Object)"formAuth");
            }
        }
        if ((ccFormDetailAddress = props.getJSONObject("ccFormDetailAddress")) != null) {
            for (Object key : ccFormDetailAddress.keySet()) {
                ccFormDetailAddress.getJSONObject((String)key).remove((Object)"formAuth");
            }
        }
        if ((assistFormAddress = props.getJSONObject("assistFormAddress")) != null) {
            for (String key : assistFormAddress.keySet()) {
                assistFormAddress.getJSONObject(key).remove((Object)"formAuth");
            }
        }
        if ((assistFormDetailAddress = props.getJSONObject("assistFormDetailAddress")) != null) {
            for (String key : assistFormDetailAddress.keySet()) {
                assistFormDetailAddress.getJSONObject(key).remove((Object)"formAuth");
            }
        }
    }
}

