/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.AddAssigneeSaveTaskCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.MultiInstancePercentUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.model.TimeOutModel;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.workflow.manage.util.BpmSpringContextHolder;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.impl.cfg.IdGenerator;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.runtime.Execution;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskInfo;
import org.activiti.engine.task.TaskQuery;

public class MultiInstanceAddAssigneeCmd
implements Command<Map<String, String>> {
    protected String executionId;
    protected List<String> assigneeList;
    private long dueTime;
    private String outTimeType;
    private Map<String, Object> variableMap;
    private ActivityRedisTimerService activityRedisTimerService = (ActivityRedisTimerService)BpmSpringContextHolder.getBean(ActivityRedisTimerService.class);
    private ProcessEngine processEngine = (ProcessEngine)BpmSpringContextHolder.getSpringContext().getBean(ProcessEngine.class);

    public MultiInstanceAddAssigneeCmd(String executionId, List<String> assigneeList, long dueTime, String outTimeType, Map<String, Object> variableMap) {
        this.executionId = executionId;
        this.assigneeList = assigneeList;
        this.dueTime = dueTime;
        this.outTimeType = outTimeType;
        this.variableMap = variableMap;
    }

    public Map<String, String> execute(CommandContext commandContext) {
        if (this.assigneeList == null || this.assigneeList.isEmpty()) {
            return null;
        }
        ProcessEngineConfigurationImpl pec = commandContext.getProcessEngineConfiguration();
        RuntimeService runtimeService = pec.getRuntimeService();
        TaskService taskService = pec.getTaskService();
        IdGenerator idGenerator = pec.getIdGenerator();
        Execution execution = (Execution)runtimeService.createExecutionQuery().executionId(this.executionId).singleResult();
        ExecutionEntity ee = (ExecutionEntity)execution;
        ExecutionEntity parent = ee.getParent();
        Task newTask = (Task)((TaskQuery)taskService.createTaskQuery().executionId(this.executionId)).singleResult();
        HashMap<String, String> newTaskIdMap = new HashMap<String, String>();
        for (String user : this.assigneeList) {
            TaskEntity t = (TaskEntity)newTask;
            ExecutionEntity newExecution = parent.createExecution();
            newExecution.setActive(true);
            newExecution.setConcurrent(true);
            newExecution.setScope(false);
            TaskEntity taskEntity = new TaskEntity();
            taskEntity.setNewTask(true);
            taskEntity.setVariableInstances();
            taskEntity.copyTaskProperty((TaskInfo)t);
            taskEntity.setCreateTime(new Date());
            taskEntity.setTaskDefinition(t.getTaskDefinition());
            taskEntity.setProcessDefinitionId(t.getProcessDefinitionId());
            taskEntity.setTaskDefinitionKey(t.getTaskDefinitionKey());
            taskEntity.setFormKey(t.getFormKey());
            taskEntity.setProcessInstanceId(t.getProcessInstanceId());
            taskEntity.setExecutionId(newExecution.getId());
            String taskId = idGenerator.getNextId();
            taskEntity.setId(taskId);
            taskEntity.setExecution(newExecution);
            taskEntity.addCandidateUser(user);
            taskEntity.setSendUser(t.getSendUser());
            taskEntity.setCompleteType(t.getCompleteType());
            taskEntity.setJumpInfo(t.getJumpInfo());
            taskEntity.setSubProcessKey(t.getSubProcessKey());
            taskEntity.setCycleCount(t.getCycleCount());
            taskEntity.setProcessCycleCount(t.getProcessCycleCount());
            taskEntity.setSubmitToRejectNode(t.getSubmitToRejectNode());
            newTaskIdMap.put(user, taskId);
            if (this.dueTime != 0L && this.outTimeType != null) {
                taskEntity.setDueDate(new Date(taskEntity.getCreateTime().getTime() + this.dueTime));
                TimeOutModel timeOutModel = new TimeOutModel();
                timeOutModel.setTaskId(Long.valueOf(Long.parseLong(taskId)));
                timeOutModel.setCreateTime(taskEntity.getCreateTime());
                timeOutModel.setDueTime(taskEntity.getDueDate());
                timeOutModel.setAssignee(user);
                timeOutModel.setTimeOutType(this.outTimeType);
                if (timeOutModel.getTimeOutType().startsWith("http") || "urging".equals(timeOutModel.getTimeOutType())) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("name", taskEntity.getName());
                    map.put("processInsId", taskEntity.getProcessInstanceId());
                    map.put("processDefinitionId", taskEntity.getProcessDefinitionId());
                    map.put("taskDefinitionKey", taskEntity.getTaskDefinitionKey());
                    map.put("formKey", taskEntity.getFormKey());
                    ExecutionEntity entity = parent;
                    while (entity.getParent() != null) {
                        entity = entity.getParent();
                    }
                    map.put("businessId", entity.getProcessBusinessKey());
                    map.put("processName", entity.getProcessDefinition().getName());
                    map.put("todoConfiguration", taskEntity.getTodoConfiguration());
                    map.put("sendUser", taskEntity.getSendUser());
                    timeOutModel.setMap(JSON.toJSONString(map));
                }
                this.activityRedisTimerService.addTimeOutModel(timeOutModel);
            }
            this.processEngine.getManagementService().executeCommand((Command)new AddAssigneeSaveTaskCmd((Task)taskEntity, (Execution)taskEntity.getExecution()));
            taskService.setVariablesLocal(taskEntity.getId(), this.variableMap);
            int nrOfInstances = MultiInstancePercentUtils.getLoopVariable(newExecution, "nrOfInstances");
            int nrOfActiveInstances = MultiInstancePercentUtils.getLoopVariable(newExecution, "nrOfActiveInstances");
            MultiInstancePercentUtils.setLoopVariable(newExecution, "nrOfInstances", nrOfInstances + 1);
            MultiInstancePercentUtils.setLoopVariable(newExecution, "nrOfActiveInstances", nrOfActiveInstances + 1);
        }
        return newTaskIdMap;
    }
}

