/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.activiti.model.BpmActRuMultUser;
import com.jxdinfo.hussar.workflow.activiti.service.IBpmActRuMultUserService;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.model.SysActCcTask;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.service.ISysActCcTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.AnalyticalModelUtil;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import com.jxdinfo.hussar.workflow.engine.constant.BpmAttribute;
import com.jxdinfo.hussar.workflow.engine.constant.TaskSourceFlag;
import com.jxdinfo.hussar.workflow.manage.util.BpmSpringContextHolder;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.ExecutionListener;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JumpNodeLeaveAddCcTaskCmd
implements Command<Void> {
    private final Logger logger = LoggerFactory.getLogger(JumpNodeLeaveAddCcTaskCmd.class);
    private ExecutionEntity execution;
    private ISysActCcTaskService iSysActCcTaskService = (ISysActCcTaskService)BpmSpringContextHolder.getBean(ISysActCcTaskService.class);
    private DataPushService dataPushService = (DataPushService)BpmSpringContextHolder.getBean(DataPushService.class);
    private IBpmActRuMultUserService bpmActRuMultUserService = (IBpmActRuMultUserService)BpmSpringContextHolder.getBean(IBpmActRuMultUserService.class);

    public JumpNodeLeaveAddCcTaskCmd(ExecutionEntity execution) {
        this.execution = execution;
    }

    public Void execute(CommandContext commandContext) {
        this.delMultiUser(commandContext);
        this.addCcTask(commandContext);
        this.fireExecutionListener();
        return null;
    }

    private void delMultiUser(CommandContext commandContext) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        HashSet<Long> multiIdSet = new HashSet<Long>();
        List taskEntityList = this.execution.getTasks();
        for (TaskEntity task : taskEntityList) {
            if (!HussarUtils.isNotEmpty((Object)task.getSeqMultiCount())) continue;
            multiIdSet.add(task.getMultiId());
        }
        ArrayList multiIdList = new ArrayList(multiIdSet);
        if (HussarUtils.isNotEmpty(multiIdList)) {
            queryWrapper.in(BpmActRuMultUser::getMultiId, multiIdList);
            this.bpmActRuMultUserService.remove((Wrapper)queryWrapper);
        }
    }

    private void addCcTask(CommandContext commandContext) {
        if (TaskSourceFlag.isRevoke((String)BpmAttribute.getTaskSourceFlag((ActivityExecution)this.execution))) {
            return;
        }
        BpmnModel bm = commandContext.getProcessEngineConfiguration().getRepositoryService().getBpmnModel(this.execution.getProcessDefinitionId());
        if (!(bm.getFlowElement(this.execution.getActivityId()) instanceof UserTask)) {
            return;
        }
        Map<String, Object> ccUserMap = AnalyticalModelUtil.getCcEndUser(bm, (ActivityExecution)this.execution);
        List ccUserIds = (List)ccUserMap.get("ccUser");
        String ccSendUser = (String)ccUserMap.get("ccSendUser");
        if (!ccUserIds.isEmpty()) {
            List ccFormKeyList;
            Map ccFormKeyMap;
            String processInsId = this.execution.getProcessInstanceId();
            String taskDefKey = this.execution.getCurrentActivityId();
            String subProcessKey = this.execution.getSubProcessKey();
            if (ccUserIds.isEmpty()) {
                return;
            }
            List hisTaskList = commandContext.getTaskEntityManager().findAllHistoricTask(processInsId, taskDefKey, subProcessKey);
            if (hisTaskList.isEmpty()) {
                return;
            }
            hisTaskList.sort((o1, o2) -> o2.getEndTime().compareTo(o1.getEndTime()));
            HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)hisTaskList.get(0);
            List<String> userIds = AnalyticalModelUtil.getMultiInstanceUser(hisTaskList);
            ArrayList<SysActCcTask> list = new ArrayList<SysActCcTask>();
            ExecutionEntity processInstance = this.execution.getProcessInstance();
            Timestamp ts = new Timestamp(System.currentTimeMillis());
            List ccElement = (List)bm.getFlowElement(historicTaskInstance.getTaskDefinitionKey()).getExtensionElements().get("ccFormKey");
            String formKey = null;
            if (ccElement != null && !ccElement.isEmpty() && (ccFormKeyMap = ((ExtensionElement)ccElement.get(0)).getAttributes()) != null && (ccFormKeyList = (List)ccFormKeyMap.get("ccFormKey")) != null && !ccFormKeyList.isEmpty()) {
                formKey = ((ExtensionAttribute)ccFormKeyList.get(0)).getValue();
            }
            ArrayList<DataPush> dataPushList = new ArrayList<DataPush>();
            for (String user : ccUserIds) {
                DataPush dataPush = new DataPush();
                dataPush.setTaskId(historicTaskInstance.getId());
                dataPush.setUserId(user);
                dataPush.setCcMoment("1");
                dataPush.setStartDate((Date)ts);
                dataPush.setProcessInsId(historicTaskInstance.getProcessInstanceId());
                dataPushList.add(dataPush);
                SysActCcTask sysActCcTask = new SysActCcTask();
                sysActCcTask.setProcessInsId(Long.valueOf(Long.parseLong(historicTaskInstance.getProcessInstanceId())));
                sysActCcTask.setProcName(processInstance.getProcessDefinition().getName());
                sysActCcTask.setTaskId(Long.valueOf(Long.parseLong(historicTaskInstance.getId())));
                sysActCcTask.setTaskName(historicTaskInstance.getName());
                sysActCcTask.setReceiveUser(user);
                sysActCcTask.setSendUser(ccSendUser);
                sysActCcTask.setSendTime(ts);
                sysActCcTask.setFormKey(formKey);
                sysActCcTask.setTaskDefKey(historicTaskInstance.getTaskDefinitionKey());
                sysActCcTask.setProcDefKey(processInstance.getProcessDefinitionKey());
                sysActCcTask.setProcDefId(processInstance.getProcessDefinitionId());
                sysActCcTask.setBusinessId(this.execution.getProcessBusinessKey());
                sysActCcTask.setTaskState("0");
                sysActCcTask.setCcMoment("1");
                sysActCcTask.setToDoConfig(historicTaskInstance.getTodoConfiguration());
                if (userIds.contains(sysActCcTask.getReceiveUser())) {
                    sysActCcTask.setTaskState("1");
                    sysActCcTask.setEndTime(new Timestamp(historicTaskInstance.getEndTime().getTime()));
                    dataPush.setEndDate((Date)sysActCcTask.getEndTime());
                }
                list.add(sysActCcTask);
            }
            this.dataPushService.addCcTask(dataPushList);
            if (!list.isEmpty()) {
                this.iSysActCcTaskService.saveBatch(list);
            }
        }
    }

    public void fireExecutionListener() {
        this.execution.setEventName("end");
        List executionListeners = this.execution.getActivity().getExecutionListeners("end");
        for (ExecutionListener executionListener : executionListeners) {
            try {
                executionListener.notify((DelegateExecution)this.execution);
            }
            catch (Exception e) {
                this.logger.error(BpmExceptionCodeEnum.LISTENER_EXECUTION_ERROR.getMessage(), (Throwable)e);
                throw new PublicClientException(BpmExceptionCodeEnum.LISTENER_EXECUTION_ERROR.getMessage());
            }
        }
    }
}

