/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.common.utils;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.callback.business.visitor.service.IWorkflowCallbackVisitorService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.WorkFlow;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.workflow.engine.bpm.processtest.VariableHandler;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import com.jxdinfo.hussar.workflow.engine.constant.BpmAttribute;
import com.jxdinfo.hussar.workflow.engine.constant.TaskSourceFlag;
import com.jxdinfo.hussar.workflow.engine.constant.TaskType;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowModel;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowProps;
import com.jxdinfo.hussar.workflow.engine.flowmodel.ProcessBinding;
import com.jxdinfo.hussar.workflow.manage.util.BpmSpringContextHolder;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.Gateway;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.activiti.engine.impl.persistence.entity.HistoricProcessInstanceEntityManager;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.task.TaskInfo;

public class CommonCodeUtil {
    private static ModelService modelService = (ModelService)BpmSpringContextHolder.getBean(ModelService.class);
    private static RepositoryService repositoryService = (RepositoryService)BpmSpringContextHolder.getBean(RepositoryService.class);
    private static ActivityRedisTimerService activityRedisTimerService = (ActivityRedisTimerService)BpmSpringContextHolder.getBean(ActivityRedisTimerService.class);
    private static SysActProcessFileService sysActProcessFileService = (SysActProcessFileService)BpmSpringContextHolder.getBean(SysActProcessFileService.class);
    private static VariableHandler variableHandler = (VariableHandler)BpmSpringContextHolder.getBean(VariableHandler.class);
    private static IWorkflowCallbackVisitorService workflowCallbackVisitorService = (IWorkflowCallbackVisitorService)BpmSpringContextHolder.getBean(IWorkflowCallbackVisitorService.class);

    public static Map<String, Object> getTestProcessGodAxeResult(String nodeId, String businessId, String procDefId, List<Map<String, String>> superProcessInstanceMessageList) {
        String procDefKey = procDefId.split(":")[0];
        try {
            Map<String, Object> variable = variableHandler.visit(businessId, nodeId, procDefKey, superProcessInstanceMessageList);
            CommonCodeUtil.handleVariables(variable);
            return variable;
        }
        catch (Exception e) {
            return new HashMap<String, Object>();
        }
    }

    public static Map<String, Object> getGodAxeResult(String nodeId, String businessId, String procDefId) {
        String procDefKey = procDefId.split(":")[0];
        String realVersion = String.valueOf(modelService.getRealVersion(procDefId));
        if (Integer.valueOf(procDefId.split(":")[1]) <= 0) {
            realVersion = String.valueOf(modelService.getRealVersion(procDefKey, realVersion));
        }
        BpmnModel bm = repositoryService.getBpmnModel(procDefId);
        String beanId = procDefKey + ":" + realVersion + CommonCodeUtil.getVisitorNodeId(nodeId, bm);
        Map variable = workflowCallbackVisitorService.getVisitorResult(beanId, businessId, procDefId);
        CommonCodeUtil.handleVariables(variable);
        return variable;
    }

    public static void handleVariables(Map<String, Object> variable) {
        for (Map.Entry<String, Object> k : variable.entrySet()) {
            Object date;
            if (k.getValue() == null) continue;
            String className = k.getValue().getClass().getName();
            if ("java.lang.String".equals(className) && HussarUtils.isNotEmpty((Object)(date = CommonCodeUtil.isValidDate(k.getValue().toString())))) {
                variable.put(k.getKey(), date);
            }
            if (!"java.math.BigDecimal".equals(className)) continue;
            BigDecimal bigDecimal = (BigDecimal)k.getValue();
            if (new BigDecimal(bigDecimal.longValue()).compareTo(bigDecimal) == 0) {
                variable.put(k.getKey(), bigDecimal.longValue());
                continue;
            }
            variable.put(k.getKey(), bigDecimal.doubleValue());
        }
    }

    private static Object isValidDate(String str) {
        SimpleDateFormat format;
        String yMdhmsRegex = "^(?:(?!0000)[0-9]{4}([-/]?)(?:(?:0[1-9]|1[0-2])([-/]?)(?:0[1-9]|1[0-9]|2[0-8])|(?:0[13-9]|1[0-2])-(?:29|30)|(?:0[13578]|1[02])-31)|(?:[0-9]{2}(?:0[48]|[2468][048]|[13579][26])|(?:0[48]|[2468][048]|[13579][26])00)-02-29)\\s+([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9]$";
        String yMdRegex = "^(?:(?!0000)[0-9]{4}([-/]?)(?:(?:0?[1-9]|1[0-2])\\1(?:0?[1-9]|1[0-9]|2[0-8])|(?:0?[13-9]|1[0-2])\\1(?:29|30)|(?:0?[13578]|1[02])\\1(?:31))|(?:[0-9]{2}(?:0[48]|[2468][048]|[13579][26])|(?:0[48]|[2468][048]|[13579][26])00)([-/]?)0?2\\2(?:29))$";
        String yMRegex = "^\\d{4}([-/]?)(0[1-9]|1[0-2])$";
        String hmsRegex = "([0-1]?[0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])$";
        if (str.length() == 7) {
            if (!str.matches(yMRegex)) {
                return null;
            }
            format = new SimpleDateFormat("yyyy-MM");
        } else if (str.length() == 10) {
            if (!str.matches(yMdRegex)) {
                return null;
            }
            format = new SimpleDateFormat("yyyy-MM-dd");
        } else if (str.length() == 8) {
            if (!str.matches(hmsRegex)) {
                return null;
            }
            format = new SimpleDateFormat("HH:mm:ss");
        } else {
            if (!str.matches(yMdhmsRegex)) {
                return null;
            }
            format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
        try {
            format.setLenient(false);
            return format.parse(str);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static String getVisitorNodeId(String id, BpmnModel bm) {
        Process process = (Process)bm.getProcesses().get(0);
        int num = process.getFlowElements().size();
        while (id.startsWith("jxd_bpm_custom_node")) {
            id = id.contains("parallel_node") ? id.split("parallel_node")[1] : ((SequenceFlow)((FlowNode)bm.getFlowElement(id)).getIncomingFlows().get(0)).getSourceRef();
            if (--num >= 0) continue;
            throw new BpmException(BpmExceptionCodeEnum.ERROR_FLOW_CHAR.getMessage());
        }
        return id;
    }

    public static void triggerEventHandleClass(Map<String, Object> map) {
        BpmnModel bm = repositoryService.getBpmnModel((String)map.get("processDefinitionId"));
        String type = "";
        Object tType = map.get("type");
        if (HussarUtils.isNotEmpty((Object)tType)) {
            type = tType.toString();
        }
        if ("processCreateEnd".equals(type)) {
            activityRedisTimerService.addGlobalTimeOutModel(bm, map);
        } else if ("processCompleteEnd".equals(type)) {
            activityRedisTimerService.delGlobalTimeOutModel(map);
        }
    }

    public static boolean isBindTable(Set<String> processDefinitionIdList) {
        if (HussarUtils.isEmpty(processDefinitionIdList)) {
            return false;
        }
        for (String procDefId : processDefinitionIdList) {
            WorkFlow workFlow = sysActProcessFileService.getFileByProcessDefId(procDefId);
            String wfdFile = workFlow.getData();
            FlowModel parse = (FlowModel)JSONObject.parseObject((String)wfdFile, FlowModel.class);
            FlowProps props = parse.getProps();
            ProcessBinding processBinding = props.getProcessBinding();
            if (processBinding == null) {
                return false;
            }
            String mainTableName = processBinding.getMainTableName();
            String taskTableName = processBinding.getTaskTableName();
            String mainTableBusinessKey = processBinding.getMainTableBusinessKey();
            if (HussarUtils.isNotEmpty((Object)mainTableName) && HussarUtils.isNotEmpty((Object)taskTableName) && HussarUtils.isNotEmpty((Object)mainTableBusinessKey)) continue;
            return false;
        }
        return true;
    }

    private CommonCodeUtil() {
    }

    public static boolean isBackfill(Set<String> processDefinitionIdList) {
        if (HussarUtils.isEmpty(processDefinitionIdList)) {
            return false;
        }
        boolean isBackFill = false;
        for (String prodefId : processDefinitionIdList) {
            String isBackFillText;
            BpmnModel bm = repositoryService.getBpmnModel(prodefId);
            Map extensionElementList = ((Process)bm.getProcesses().get(0)).getExtensionElements();
            List isBackFillElement = (List)extensionElementList.get("isBackfill");
            if (!HussarUtils.isNotEmpty((Object)isBackFillElement) || !HussarUtils.isNotEmpty(((ExtensionElement)isBackFillElement.get(0)).getAttributes().get("isBackfill")) || !(isBackFill = Boolean.valueOf(isBackFillText = ((ExtensionAttribute)((List)((ExtensionElement)isBackFillElement.get(0)).getAttributes().get("isBackfill")).get(0)).getValue()).booleanValue())) continue;
            return isBackFill;
        }
        return isBackFill;
    }

    public static <T extends Collection<String>> T getLastCompleted(List<? extends HistoricTaskInstance> currentNodeTasks, T collection) {
        return CommonCodeUtil.getLastCompleted(currentNodeTasks, collection, task -> !TaskSourceFlag.NORMAL_COMPLETE.contains(task.getTaskSourceFlag()) || TaskType.isRevoked((String)task.getTaskType()) || task.getParentTaskId() != null, HistoricTaskInstance::getOriginalAssignee);
    }

    public static <T extends Collection<HistoricTaskInstance>> T getLastTaskCompleted(List<? extends HistoricTaskInstance> currentNodeTasks, T collection) {
        return CommonCodeUtil.getLastCompleted(currentNodeTasks, collection, task -> !TaskSourceFlag.NORMAL_COMPLETE.contains(task.getTaskSourceFlag()) || TaskType.isRevoked((String)task.getTaskType()) || task.getParentTaskId() != null, e -> e);
    }

    public static <T extends Collection<E>, E> T getLastCompleted(List<? extends HistoricTaskInstance> currentNodeTasks, T collection, Predicate<HistoricTaskInstance> filter, Function<HistoricTaskInstance, E> function) {
        ArrayList<HistoricTaskInstance> lastCompleted = new ArrayList<HistoricTaskInstance>();
        Long multiId = null;
        for (HistoricTaskInstance historicTaskInstance : currentNodeTasks) {
            if (filter.test(historicTaskInstance)) continue;
            if (multiId == null) {
                if (!lastCompleted.isEmpty()) continue;
                lastCompleted.add(historicTaskInstance);
                if (historicTaskInstance.getMultiId() == null) break;
                multiId = historicTaskInstance.getMultiId();
                continue;
            }
            if (!multiId.equals(historicTaskInstance.getMultiId())) continue;
            lastCompleted.add(historicTaskInstance);
        }
        if (HussarUtils.isNotEmpty(lastCompleted) && HussarUtils.isNotEmpty((Object)((HistoricTaskInstance)lastCompleted.get(0)).getSeqMultiCount())) {
            lastCompleted.sort(Comparator.comparing(TaskInfo::getSeqMultiCount));
        }
        lastCompleted.forEach(o -> collection.add(function.apply((HistoricTaskInstance)o)));
        return collection;
    }

    public static void updateTodoConfiguration(DelegateExecution delegateExecution) throws Exception {
        List extensionElements;
        String id = ((ExecutionEntity)delegateExecution).getActivityId();
        BpmnModel bm = repositoryService.getBpmnModel(delegateExecution.getProcessDefinitionId());
        FlowElement flowElement = bm.getFlowElement(id);
        if (flowElement instanceof Gateway && HussarUtils.isNotEmpty((Object)(extensionElements = (List)flowElement.getExtensionElements().get("previousId")))) {
            id = ((ExtensionAttribute)((List)((ExtensionElement)((List)flowElement.getExtensionElements().get("previousId")).get(0)).getAttributes().get("previousId")).get(0)).getValue();
        }
        HistoricProcessInstanceEntityManager historicProcessInstanceEntityManager = Context.getCommandContext().getHistoricProcessInstanceEntityManager();
        HistoricProcessInstanceEntity processInstanceEntity = historicProcessInstanceEntityManager.findHistoricProcessInstance(delegateExecution.getProcessInstanceId());
        boolean isEmulation = "1".equals(processInstanceEntity.getIsEmulation());
        Map<Object, Object> result = new HashMap();
        if (isEmulation) {
            ArrayList<Map<String, String>> superProcessInstanceMessageList = new ArrayList<Map<String, String>>();
            String superProcessInstanceId = processInstanceEntity.getSuperProcessInstanceId();
            if (superProcessInstanceId != null) {
                String callProcessKey = processInstanceEntity.getProcessDefinitionKey();
                String mainActId = processInstanceEntity.getMainActId();
                processInstanceEntity = historicProcessInstanceEntityManager.findHistoricProcessInstance(superProcessInstanceId);
                superProcessInstanceId = processInstanceEntity.getSuperProcessInstanceId();
                HashMap<String, String> superProcessInstanceMessage = new HashMap<String, String>();
                superProcessInstanceMessage.put("mainActId", mainActId);
                superProcessInstanceMessage.put("businessKey", processInstanceEntity.getBusinessKey());
                superProcessInstanceMessage.put("callProcessKey", callProcessKey);
                superProcessInstanceMessageList.add(superProcessInstanceMessage);
            }
            result = CommonCodeUtil.getTestProcessGodAxeResult(id, delegateExecution.getProcessBusinessKey(), delegateExecution.getProcessDefinitionId(), superProcessInstanceMessageList);
        } else {
            result = CommonCodeUtil.getGodAxeResult(id, delegateExecution.getProcessBusinessKey(), delegateExecution.getProcessDefinitionId());
        }
        result.remove("bpm_next_node");
        if (HussarUtils.isNotEmpty(result)) {
            BpmAttribute.addCallActivityInfo((ActivityExecution)((ExecutionEntity)delegateExecution), result.remove("call_activity_info"));
            delegateExecution.setVariables(result);
        }
    }
}

