/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.listener;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.httpclient.HttpClient;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import com.jxdinfo.hussar.workflow.manage.bpm.constant.CallActivityInfo;
import com.jxdinfo.hussar.workflow.manage.bpm.constant.SubProcessInfo;
import com.jxdinfo.hussar.workflow.manage.bpm.listener.visitor.HussarWorkflowCallActivityListener;
import com.jxdinfo.hussar.workflow.manage.bpm.listener.visitor.HussarWorkflowListener;
import com.jxdinfo.hussar.workflow.manage.bpm.listener.visitor.HussarWorkflowSubProcessListener;
import com.jxdinfo.hussar.workflow.manage.util.BpmSpringContextHolder;
import com.jxdinfo.hussar.workflow.outside.listener.service.WorkflowListenerService;
import java.util.List;
import java.util.Map;

public class WorkflowListenerUtils {
    private static final LcdpBpmProperties lcdpBpmProperties = (LcdpBpmProperties)BpmSpringContextHolder.getBean(LcdpBpmProperties.class);

    public static void executionListener(String listenerModel, String requestMethod, String beanId, Map<String, Object> map, String serviceName) {
        String deploymentModel = lcdpBpmProperties.getDeploymentModel();
        if (HussarUtils.isEmpty((Object)listenerModel) || "local".equals(listenerModel)) {
            switch (deploymentModel) {
                case "single": {
                    HussarWorkflowListener workflowListenerVisitor = (HussarWorkflowListener)BpmSpringContextHolder.getBean((String)beanId, HussarWorkflowListener.class);
                    workflowListenerVisitor.notify(map);
                    return;
                }
                case "micro": {
                    map.put("beanId", beanId);
                    WorkflowListenerService workflowListenerService = (WorkflowListenerService)BpmSpringContextHolder.getBean(WorkflowListenerService.class);
                    workflowListenerService.executeListener(map, serviceName);
                    break;
                }
                default: {
                    throw new BpmException(BpmExceptionCodeEnum.LISTENER_MODEL_ERROR);
                }
            }
        } else if ("remote".equals(listenerModel)) {
            String result;
            if (!beanId.startsWith("/")) {
                beanId = "/" + beanId;
            }
            String url = lcdpBpmProperties.getTenantCallAddress() + beanId;
            if (HussarUtils.isEmpty((Object)requestMethod)) {
                requestMethod = "POST";
            }
            switch (requestMethod) {
                case "GET": {
                    result = HttpClient.doGet((String)url, (Map)((Map)JSON.parseObject((String)JSON.toJSONString(map), Map.class)));
                    break;
                }
                case "POST": {
                    result = HttpClient.doPost((String)url, (String)JSON.toJSONString(map));
                    break;
                }
                default: {
                    throw new BpmException(BpmExceptionCodeEnum.LISTENER_REQUEST_METHOD_ERROR);
                }
            }
            if (HussarUtils.isNotEmpty((Object)result)) {
                Object success = null;
                try {
                    JSONObject object = JSONObject.parseObject((String)result);
                    success = object.get((Object)"success");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (Boolean.FALSE.equals(success)) {
                    throw new BpmException(BpmExceptionCodeEnum.LISTENER_EXECUTION_ERROR);
                }
            }
        } else {
            throw new BpmException(BpmExceptionCodeEnum.LISTENER_MODEL_ERROR);
        }
    }

    public static List<CallActivityInfo> executionCallActivityListener(String listenerModel, String requestMethod, String beanId, Map<String, Object> map, String serviceName) {
        String deploymentModel = lcdpBpmProperties.getDeploymentModel();
        if (HussarUtils.isEmpty((Object)listenerModel) || "local".equals(listenerModel)) {
            switch (deploymentModel) {
                case "single": {
                    HussarWorkflowCallActivityListener workflowListenerVisitor = (HussarWorkflowCallActivityListener)BpmSpringContextHolder.getBean((String)beanId, HussarWorkflowCallActivityListener.class);
                    return workflowListenerVisitor.notify(map);
                }
                case "micro": {
                    map.put("beanId", beanId);
                    WorkflowListenerService workflowListenerService = (WorkflowListenerService)BpmSpringContextHolder.getBean(WorkflowListenerService.class);
                    return workflowListenerService.executeCallActivityListener(map, serviceName);
                }
            }
            throw new BpmException(BpmExceptionCodeEnum.LISTENER_MODEL_ERROR);
        }
        if ("remote".equals(listenerModel)) {
            if (!beanId.startsWith("/")) {
                beanId = "/" + beanId;
            }
            String url = lcdpBpmProperties.getTenantCallAddress() + beanId;
            switch (requestMethod) {
                case "GET": {
                    String result = HttpClient.doGet((String)url, (Map)((Map)JSON.parseObject((String)JSON.toJSONString(map), Map.class)));
                    return JSONArray.parseArray((String)result, CallActivityInfo.class);
                }
                case "POST": {
                    String postResult = HttpClient.doPost((String)url, (String)JSON.toJSONString(map));
                    return JSONArray.parseArray((String)postResult, CallActivityInfo.class);
                }
            }
            throw new BpmException(BpmExceptionCodeEnum.LISTENER_REQUEST_METHOD_ERROR);
        }
        throw new BpmException(BpmExceptionCodeEnum.LISTENER_MODEL_ERROR);
    }

    public static List<SubProcessInfo> executeSubProcessListener(String listenerModel, String requestMethod, String beanId, Map<String, Object> map, String serviceName) {
        String deploymentModel = lcdpBpmProperties.getDeploymentModel();
        if (HussarUtils.isEmpty((Object)listenerModel) || "local".equals(listenerModel)) {
            switch (deploymentModel) {
                case "single": {
                    HussarWorkflowSubProcessListener workflowListenerVisitor = (HussarWorkflowSubProcessListener)BpmSpringContextHolder.getBean((String)beanId, HussarWorkflowSubProcessListener.class);
                    return workflowListenerVisitor.notify(map);
                }
                case "micro": {
                    map.put("beanId", beanId);
                    WorkflowListenerService workflowListenerService = (WorkflowListenerService)BpmSpringContextHolder.getBean(WorkflowListenerService.class);
                    return workflowListenerService.executeSubProcessListener(map, serviceName);
                }
            }
            throw new BpmException(BpmExceptionCodeEnum.LISTENER_MODEL_ERROR);
        }
        if ("remote".equals(listenerModel)) {
            if (!beanId.startsWith("/")) {
                beanId = "/" + beanId;
            }
            String url = lcdpBpmProperties.getTenantCallAddress() + beanId;
            switch (requestMethod) {
                case "GET": {
                    String result = HttpClient.doGet((String)url, (Map)((Map)JSON.parseObject((String)JSON.toJSONString(map), Map.class)));
                    return JSONArray.parseArray((String)result, SubProcessInfo.class);
                }
                case "POST": {
                    String postResult = HttpClient.doPost((String)url, (String)JSON.toJSONString(map));
                    return JSONArray.parseArray((String)postResult, SubProcessInfo.class);
                }
            }
            throw new BpmException(BpmExceptionCodeEnum.LISTENER_REQUEST_METHOD_ERROR);
        }
        throw new BpmException(BpmExceptionCodeEnum.LISTENER_MODEL_ERROR);
    }
}

