/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.AddAssistHistoryTaskCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.processentrust.service.ISysActEntrustService;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import com.jxdinfo.hussar.workflow.engine.constant.TaskType;
import com.jxdinfo.hussar.workflow.manage.util.BpmSpringContextHolder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.bpmn.behavior.MultiInstanceActivityBehavior;
import org.activiti.engine.impl.cmd.NeedsActiveTaskCmd;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskInfo;

public class ChildTaskCreateCmd
extends NeedsActiveTaskCmd<Task> {
    private static IAssigneeChooseService iAssigneeChooseService = (IAssigneeChooseService)BpmSpringContextHolder.getBean(IAssigneeChooseService.class);
    protected String assistInitiator;
    protected String taskType;
    protected Set<String> userIds;
    protected Map<String, Object> map;
    protected String comment;
    protected ISysActEntrustService sysActEntrustService = (ISysActEntrustService)BpmSpringContextHolder.getBean(ISysActEntrustService.class);

    public Task execute(CommandContext commandContext, TaskEntity parentTask) {
        Context.getCommandContext().addAttribute("taskSourceFlag", (Object)"assist");
        this.authentication(parentTask);
        final Date now = Context.getProcessEngineConfiguration().getClock().getCurrentTime();
        parentTask.getExecution().addTempVariable("taskSourceFlag", (Object)"assist");
        String createHistoryTaskId = new AddAssistHistoryTaskCmd(parentTask, this.comment, this.assistInitiator, "assist"){

            @Override
            protected TaskEntity initTask(CommandContext commandContext, TaskEntity task, ExecutionEntity execution) {
                TaskEntity taskEntity = super.initTask(commandContext, task, execution);
                taskEntity.setTaskType("4");
                taskEntity.setCreateTime(now);
                taskEntity.setParentTaskId(task.getId());
                return taskEntity;
            }
        }.execute(commandContext).getId();
        TaskEntity task = new TaskEntity();
        task.setNewTask(true);
        task.copyTaskPropertyAsHistory((TaskInfo)parentTask);
        task.setExecutionId(parentTask.getExecutionId());
        task.setParentTaskId(parentTask.getId());
        task.setTaskType(this.taskType);
        task.setProcessDefinitionId(parentTask.getProcessDefinitionId());
        task.setTaskDefinitionKey(parentTask.getTaskDefinitionKey());
        task.setProcessInstanceId(parentTask.getProcessInstanceId());
        task.setSubProcessKey(parentTask.getSubProcessKey());
        task.setCycleCount(parentTask.getCycleCount());
        task.setProcessCycleCount(parentTask.getProcessCycleCount());
        task.setSendUser(this.assistInitiator);
        BpmnModel bpmnModel = commandContext.getProcessEngineConfiguration().getRepositoryService().getBpmnModel(parentTask.getProcessDefinitionId());
        FlowElement flowElement = bpmnModel.getFlowElement(parentTask.getTaskDefinitionKey());
        List assistElement = (List)flowElement.getExtensionElements().get("assistFormKey");
        if (assistElement != null && !assistElement.isEmpty()) {
            List assistFormKeyList;
            String formKey = "";
            Map assistFormKeyMap = ((ExtensionElement)assistElement.get(0)).getAttributes();
            if (assistFormKeyMap != null && (assistFormKeyList = (List)assistFormKeyMap.get("assistFormKey")) != null && !assistFormKeyList.isEmpty()) {
                formKey = ((ExtensionAttribute)assistFormKeyList.get(0)).getValue();
            }
            task.setFormKey(formKey);
        }
        task.setTenantId(parentTask.getTenantId());
        task.setName(parentTask.getName());
        task.setCreateTime(now);
        task.setCreateHistoryTaskId(createHistoryTaskId);
        task.setTodoConfiguration(parentTask.getTodoConfiguration());
        task.insert(parentTask.getExecution());
        if (this.map != null) {
            task.setVariablesLocal(this.map);
        }
        Map userMap = this.sysActEntrustService.queryByUsers(this.userIds, task.getProcessDefinitionId().split(":")[0], task.getTaskDefinitionKey(), 1);
        for (String userId : this.userIds) {
            if (userMap.containsKey(userId)) {
                task.addCandidateUser((String)userMap.get(userId), userId, "1", this.assistInitiator);
                continue;
            }
            task.addCandidateUser(userId, null, null, this.assistInitiator);
        }
        if (Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityEvent((ActivitiEventType)ActivitiEventType.TASK_CREATED, (Object)task));
        }
        task.fireEvent("create");
        task.fireEvent("start");
        task.fireEvent("assignment");
        return task;
    }

    private void authentication(TaskEntity task) {
        if (TaskType.isAssist((String)this.taskType)) {
            List childTask;
            if (this.userIds.contains(this.assistInitiator)) {
                throw new ActivitiException(BpmExceptionCodeEnum.CAN_NOT_ADD_ASSIST_USER_WITH_CURRENT_USER.getMessage());
            }
            HashSet<String> existUserIds = new HashSet<String>();
            if (task.getExecution().getActivity().getActivityBehavior() instanceof MultiInstanceActivityBehavior) {
                List executions = task.getExecution().getParent().getExecutions();
                for (ExecutionEntity execution : executions) {
                    execution.getTasks().forEach(taskEntity -> {
                        List identityLinkEntityList;
                        if (taskEntity.getTaskType() != null) {
                            return;
                        }
                        if (taskEntity.getAssignee() != null && this.userIds.contains(taskEntity.getAssignee())) {
                            existUserIds.add(taskEntity.getAssignee());
                        }
                        if ((identityLinkEntityList = taskEntity.getIdentityLinks()) != null) {
                            for (IdentityLinkEntity identityLink : identityLinkEntityList) {
                                if ("preempted".equals(identityLink.getType()) || !this.userIds.contains(identityLink.getUserId())) continue;
                                existUserIds.add(identityLink.getUserId());
                            }
                        }
                    });
                }
            } else {
                List identityLinkEntityList = task.getIdentityLinks();
                for (IdentityLinkEntity identityLink : identityLinkEntityList) {
                    if ("preempted".equals(identityLink.getType()) || !this.userIds.contains(identityLink.getUserId())) continue;
                    existUserIds.add(identityLink.getUserId());
                }
            }
            if ((childTask = Context.getCommandContext().getTaskEntityManager().findTasksByParentTaskId(this.taskId)) != null && !childTask.isEmpty()) {
                for (Task taskEntity2 : childTask) {
                    if (!TaskType.isAssist((String)taskEntity2.getTaskType())) continue;
                    List identityLinkEntityList = ((TaskEntity)taskEntity2).getIdentityLinks();
                    for (IdentityLinkEntity identityLink : identityLinkEntityList) {
                        if (!this.assistInitiator.equals(identityLink.getAssistInitiator()) || !this.userIds.contains(identityLink.getOriginalUserId())) continue;
                        existUserIds.add(identityLink.getOriginalUserId());
                    }
                }
            }
            if (!existUserIds.isEmpty()) {
                String userNames = iAssigneeChooseService.getUserNames(new ArrayList(existUserIds));
                throw new BpmException(BpmExceptionCodeEnum.CAN_NOT_ADD_ASSIST_USER.format(new Object[]{userNames}).getMessage());
            }
        }
    }

    public ChildTaskCreateCmd(String taskId, String assistInitiator, Set<String> userIds, String comment, String taskType) {
        super(taskId);
        this.assistInitiator = assistInitiator;
        this.taskType = taskType;
        this.userIds = userIds;
        this.comment = comment;
    }

    public ChildTaskCreateCmd(String taskId, String assistInitiator, Map<String, Object> map, String comment, Set<String> userIds, String taskType) {
        super(taskId);
        this.assistInitiator = assistInitiator;
        this.taskType = taskType;
        this.userIds = userIds;
        this.map = map;
        this.comment = comment;
    }
}

