/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.upgrade;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.CheckNextNodeAssigneeDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.CustomNodeAddDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.EntrustTaskDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.FlowTaskDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.NextAssigneeQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.NextUserTaskQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.NodeQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.PreemptCommonDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.ProcessRestartDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.RejectNodeQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.SecurityUpdateDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.StarterUpdateDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskAddAssigneeDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskAssigneeDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskCommentEditDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskDefQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskEntrustDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskFreeJumpDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskReceiveDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskRejectDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskRevokeDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.ITaskEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.AddCustomNodeService;
import com.jxdinfo.hussar.workflow.engine.bpm.taskmanage.dto.AssigneeConditionDto;
import com.jxdinfo.hussar.workflow.engine.bpm.taskmanage.dto.CompleteTaskDto;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.manage.engine.TaskEngineService;
import com.jxdinfo.hussar.workflow.manage.util.TypeConvertUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u6d41\u7a0b\u4efb\u52a1\u7ba1\u7406"})
@RequestMapping(value={"/bpm/upgrade/task"})
public class StandardTaskEngineController {
    private final ITaskEngineService taskEngineService;
    @Autowired
    private AddCustomNodeService addCustomNodeService;

    @Autowired
    public StandardTaskEngineController(ITaskEngineService iTaskEngineService) {
        this.taskEngineService = iTaskEngineService;
    }

    @PostMapping(value={"/rejectToFirstTask"})
    @ApiOperation(value="\u4efb\u52a1\u9a73\u56de", notes="\u4efb\u52a1\u9a73\u56de")
    public BpmResponseResult rejectToFirstTask(@RequestBody TaskRejectDto taskRejectDto) {
        return this.taskEngineService.rejectToFirstTask(taskRejectDto);
    }

    @PostMapping(value={"/rejectToLastTask"})
    @ApiOperation(value="\u4efb\u52a1\u9a73\u56de", notes="\u4efb\u52a1\u9a73\u56de")
    public BpmResponseResult rejectToLastTask(@RequestBody TaskRejectDto taskRejectDto) {
        return this.taskEngineService.rejectToLastTask(taskRejectDto);
    }

    @PostMapping(value={"/entrustTask"})
    @ApiOperation(value="\u4efb\u52a1\u59d4\u6258", notes="\u4efb\u52a1\u59d4\u6258")
    public BpmResponseResult entrustTask(@RequestBody EntrustTaskDto entrustTaskDto) {
        TaskEntrustDto taskEntrustDto = new TaskEntrustDto();
        taskEntrustDto.setTaskId(entrustTaskDto.getTaskId());
        taskEntrustDto.setComment(entrustTaskDto.getComment());
        taskEntrustDto.setUserId(entrustTaskDto.getUserId());
        taskEntrustDto.setMandatary(entrustTaskDto.getMandatary());
        return this.taskEngineService.entrustTask(taskEntrustDto);
    }

    @PostMapping(value={"/rejectToAnyTask"})
    @ApiOperation(value="\u4efb\u52a1\u9a73\u56de", notes="\u4efb\u52a1\u9a73\u56de")
    public BpmResponseResult rejectToAnyTask(@RequestBody TaskRejectDto taskRejectDto) {
        return this.taskEngineService.rejectToAnyTask(taskRejectDto);
    }

    @PostMapping(value={"/revokeTask"})
    @ApiOperation(value="\u4efb\u52a1\u64a4\u56de", notes="\u4efb\u52a1\u64a4\u56de")
    public BpmResponseResult revokeTask(@RequestBody TaskRevokeDto taskRevokeDto) {
        Map variable = (Map)JSON.parseObject((String)taskRevokeDto.getVariablesJson(), HashMap.class);
        return this.taskEngineService.revokeTask(taskRevokeDto.getHistoricTaskId(), taskRevokeDto.getUserId(), taskRevokeDto.getComment(), taskRevokeDto.getIsSubmit(), variable);
    }

    @GetMapping(value={"/queryTask"})
    @ApiOperation(value="\u67e5\u8be2\u6d41\u7a0b\u4efb\u52a1", notes="\u67e5\u8be2\u6d41\u7a0b\u4efb\u52a1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", value="\u4efb\u52a1id", required=true, paramType="query")})
    public BpmResponseResult queryProcessTask(@RequestParam(value="taskId") String taskId) {
        return TaskEngineService.changeReturnType((ApiResponse)this.taskEngineService.queryTask(taskId));
    }

    @PostMapping(value={"/queryToDoList"})
    @ApiOperation(value="\u5f85\u529e\u67e5\u8be2", notes="\u5f85\u529e\u67e5\u8be2")
    @ApiImplicitParams(value={@ApiImplicitParam(name="flowTaskDto", value="\u67e5\u8be2\u6761\u4ef6", required=false, paramType="query")})
    public BpmResponseResult queryToDoList(@RequestBody FlowTaskDto flowTaskDto) {
        return this.taskEngineService.queryToDoList(flowTaskDto);
    }

    @PostMapping(value={"/queryDoneList"})
    @ApiOperation(value="\u5df2\u529e\u67e5\u8be2", notes="\u5df2\u529e\u67e5\u8be2")
    @ApiImplicitParams(value={@ApiImplicitParam(name="flowTaskDto", value="\u67e5\u8be2\u6761\u4ef6", required=false, paramType="query")})
    public BpmResponseResult queryDoneList(@RequestBody FlowTaskDto flowTaskDto) {
        return this.taskEngineService.queryDoneList(flowTaskDto);
    }

    @GetMapping(value={"/queryUserTaskCount"})
    @ApiOperation(value="\u67e5\u8be2\u5404\u4e2a\u6d41\u7a0b\u5f85\u529e\u6570\u91cf", notes="\u67e5\u8be2\u5404\u4e2a\u6d41\u7a0b\u5f85\u529e\u6570\u91cf")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237id", required=false, paramType="query")})
    public BpmResponseResult queryUserProcessTaskCount(@RequestParam(value="userId", required=false) String userId) {
        return TaskEngineService.changeReturnType((ApiResponse)this.taskEngineService.queryUserTaskCount(userId));
    }

    @GetMapping(value={"/queryUserTaskCountByNode"})
    @ApiOperation(value="\u67e5\u8be2\u5404\u4e2a\u8282\u70b9\u5f85\u529e\u6570\u91cf", notes="\u67e5\u8be2\u5404\u4e2a\u8282\u70b9\u5f85\u529e\u6570\u91cf")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237id", required=false, paramType="query")})
    public BpmResponseResult queryUserProcessTaskCountByNode(@RequestParam(value="userId", required=false) String userId) {
        return TaskEngineService.changeReturnType((ApiResponse)this.taskEngineService.queryUserTaskCountByNode(userId));
    }

    @PostMapping(value={"/completeTask"})
    public BpmResponseResult completeTask(@RequestBody CompleteTaskDto completeTaskDto) {
        return this.taskEngineService.completeTask(completeTaskDto);
    }

    @GetMapping(value={"/queryRejectComment"})
    @ApiOperation(value="\u83b7\u53d6\u88ab\u9a73\u56de\u610f\u89c1", notes="\u83b7\u53d6\u88ab\u9a73\u56de\u610f\u89c1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", value="\u4efb\u52a1ID", required=true, paramType="query")})
    public BpmResponseResult queryRejectComment(@RequestParam(value="taskId") String taskId) {
        return this.taskEngineService.queryRejectComment(taskId);
    }

    @GetMapping(value={"/setTimeout"})
    @ApiOperation(value="\u6839\u636e\u4efb\u52a1id\u8bbe\u7f6e\u8d85\u65f6\u65f6\u95f4", notes="\u6839\u636e\u4efb\u52a1id\u8bbe\u7f6e\u8d85\u65f6\u65f6\u95f4")
    public BpmResponseResult setTimeout(@RequestParam(value="taskId") String taskId, @RequestParam(value="timeout") String timeout) {
        return this.taskEngineService.setTimeoutPeriod(taskId, timeout);
    }

    @GetMapping(value={"/queryRejectNode"})
    @ApiOperation(value="\u67e5\u8be2\u53ef\u4ee5\u9a73\u56de\u7684\u8282\u70b9", notes="\u67e5\u8be2\u53ef\u4ee5\u9a73\u56de\u7684\u8282\u70b9")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", value="\u4efb\u52a1ID", required=true, paramType="query")})
    public BpmResponseResult queryRejectNode(@RequestParam(value="taskId") String taskId, @RequestParam(value="isGetMainProcess") boolean isGetMainProcess) {
        return this.taskEngineService.queryRejectNode(taskId, isGetMainProcess);
    }

    @PostMapping(value={"/getRejectNode"})
    @ApiOperation(value="\u83b7\u53d6\u4e0a\u4e00\u8282\u70b9\u7684\u8282\u70b9id\uff0c\u8282\u70b9\u540d\u5b57\uff0c\u53c2\u4e0e\u8005", notes="\u83b7\u53d6\u4e0a\u4e00\u8282\u70b9\u7684\u8282\u70b9id\uff0c\u8282\u70b9\u540d\u5b57\uff0c\u53c2\u4e0e\u8005")
    public BpmResponseResult getRejectNode(@RequestBody RejectNodeQueryDto rejectNodeQueryDto) {
        return this.taskEngineService.getRejectNode(rejectNodeQueryDto.getTaskId(), rejectNodeQueryDto.getIsSubmit(), rejectNodeQueryDto.getMap());
    }

    @PostMapping(value={"/freeJump"})
    @ApiOperation(value="\u81ea\u7531\u8df3\u8f6c\u4e00\u4e2a\u6216\u591a\u4e2a\u8282\u70b9", notes="\u81ea\u7531\u8df3\u8f6c\u4e00\u4e2a\u6216\u591a\u4e2a\u8282\u70b9")
    public BpmResponseResult freeJump(@RequestBody TaskFreeJumpDto taskFreeJumpDto) {
        return this.taskEngineService.freeJump(taskFreeJumpDto);
    }

    @GetMapping(value={"/queryJumpNode"})
    @ApiOperation(value="\u67e5\u8be2\u53ef\u4ee5\u9a73\u56de\u7684\u8282\u70b9", notes="\u67e5\u8be2\u53ef\u4ee5\u9a73\u56de\u7684\u8282\u70b9")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", value="\u4efb\u52a1ID", required=true, paramType="query")})
    public BpmResponseResult queryJumpNode(@RequestParam(value="taskId") String taskId, @RequestParam(value="isGetMainProcess") boolean isGetMainProcess) {
        return this.taskEngineService.queryJumpNode(taskId, isGetMainProcess);
    }

    @PostMapping(value={"/multiInstanceAddAssignee"})
    @ApiOperation(value="\u4f1a\u7b7e\u8282\u70b9\u589e\u52a0\u529e\u7406\u4eba", notes="\u4f1a\u7b7e\u8282\u70b9\u589e\u52a0\u529e\u7406\u4eba")
    public BpmResponseResult multiInstanceAddAssignee(@RequestBody TaskAssigneeDto taskAssigneeDto) {
        return this.taskEngineService.multiInstanceAddAssignee(taskAssigneeDto.getTaskId(), taskAssigneeDto.getAssignees());
    }

    @GetMapping(value={"/queryAssigneeByTaskId"})
    @ApiOperation(value="\u67e5\u8be2\u5f53\u524d\u8282\u70b9\u53c2\u4e0e\u8005", notes="\u67e5\u8be2\u5f53\u524d\u8282\u70b9\u53c2\u4e0e\u8005")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", value="\u4efb\u52a1ID", required=true, paramType="query")})
    public BpmResponseResult queryAssigneeByTaskId(@RequestParam(value="taskId") String taskId) {
        return this.taskEngineService.queryAssigneeByTaskId(taskId);
    }

    @PostMapping(value={"/taskAddAssignee"})
    @ApiOperation(value="\u6839\u636e\u4e1a\u52a1\u4e3b\u952e\u6216\u8005\u662f\u4efb\u52a1id\u7ed9\u4efb\u52a1\u6dfb\u52a0\u53c2\u4e0e\u8005", notes="\u6839\u636e\u4e1a\u52a1\u4e3b\u952e\u6216\u8005\u662f\u4efb\u52a1id\u7ed9\u4efb\u52a1\u6dfb\u52a0\u53c2\u4e0e\u8005")
    public BpmResponseResult taskAddAssignee(@RequestBody TaskAddAssigneeDto taskAddAssigneeDto) {
        return this.taskEngineService.taskAddAssignee(taskAddAssigneeDto.getTaskId(), String.join((CharSequence)",", taskAddAssigneeDto.getAssigneeList()));
    }

    @GetMapping(value={"/queryProcessNodeByTaskId"})
    @ApiOperation(value="\u67e5\u8be2\u6d41\u7a0b\u8282\u70b9", notes="\u67e5\u8be2\u6d41\u7a0b\u8282\u70b9")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", value="\u4efb\u52a1ID", required=true, paramType="query")})
    public BpmResponseResult queryProcessNodeByTaskId(@RequestParam(value="taskId") String taskId) {
        return this.taskEngineService.queryProcessNodeByTaskId(taskId);
    }

    @PostMapping(value={"/queryNextAssignee"})
    @ApiOperation(value="\u67e5\u8be2\u4e0b\u4e00\u8282\u70b9\u53c2\u4e0e\u8005", notes="\u67e5\u8be2\u4e0b\u4e00\u8282\u70b9\u53c2\u4e0e\u8005")
    public BpmResponseResult queryNextAssignee(@RequestBody NextAssigneeQueryDto nextAssigneeQueryDto) {
        Map variable = nextAssigneeQueryDto.getMap();
        String userId = nextAssigneeQueryDto.getUserId();
        if (HussarUtils.isNotEmpty((Object)userId)) {
            variable.put("userId", userId);
        }
        return this.taskEngineService.queryNextAssigneeByTaskIdAndNodeId(nextAssigneeQueryDto.getProcessKey(), nextAssigneeQueryDto.getTaskId(), nextAssigneeQueryDto.getNodeId(), variable);
    }

    @PostMapping(value={"/queryAssignee"})
    @ApiOperation(value="\u67e5\u8be2\u8282\u70b9\u53c2\u4e0e\u8005", notes="\u67e5\u8be2\u8282\u70b9\u53c2\u4e0e\u8005")
    public BpmResponseResult queryAssignee(@RequestBody AssigneeConditionDto assigneeConditionDto) {
        return this.taskEngineService.queryAllAssignee(assigneeConditionDto.getProcessKey(), assigneeConditionDto.getTaskDefinitionKey());
    }

    @GetMapping(value={"/queryHistoryNodeInfo"})
    @ApiOperation(value="\u67e5\u8be2\u5386\u53f2\u8282\u70b9\u4fe1\u606f", notes="\u67e5\u8be2\u5386\u53f2\u8282\u70b9\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", value="\u4efb\u52a1ID", required=true, paramType="query")})
    public BpmResponseResult queryHistoryNodeInfo(@RequestParam(value="taskId") String taskId) {
        return TypeConvertUtils.changeReturnToBpmResult((ApiResponse)this.taskEngineService.queryHistoryActByTaskId(taskId, null));
    }

    @PostMapping(value={"/queryProcessDefIdAndTaskDefKey"})
    @ApiOperation(value="\u6839\u636e\u6d41\u7a0b\u6807\u8bc6\u6216\u8005taskId\u83b7\u53d6\u6d41\u7a0b\u7248\u672cID\u548c\u8282\u70b9id", notes="\u6839\u636e\u6d41\u7a0b\u6807\u8bc6\u6216\u8005taskId\u83b7\u53d6\u6d41\u7a0b\u7248\u672cID\u548c\u8282\u70b9id")
    public BpmResponseResult queryProcessDefIdAndTaskDefKey(@RequestBody TaskDefQueryDto taskDefQueryDto) {
        return TypeConvertUtils.changeReturnToBpmResult((ApiResponse)this.taskEngineService.getProcessDefinitionIdAndNodeId(taskDefQueryDto.getProcessKey(), taskDefQueryDto.getTaskId()));
    }

    @PostMapping(value={"/queryCurrentNodeInfo"})
    @ApiOperation(value="\u6839\u636e\u4e1a\u52a1\u4e3b\u952e\u67e5\u8be2\u4efb\u52a1ID", notes="\u6839\u636e\u4e1a\u52a1\u4e3b\u952e\u67e5\u8be2\u4efb\u52a1ID")
    public BpmResponseResult queryCurrentNodeInfo(@RequestBody NodeQueryDto nodeQueryDto) {
        return this.taskEngineService.queryTaskByBusinessIdAndProcessInsId(nodeQueryDto.getBusinessId(), nodeQueryDto.getProcessInstId());
    }

    @PostMapping(value={"/queryNextUserTask"})
    @ApiOperation(value="\u67e5\u8be2\u4e0b\u4e00\u8282\u70b9", notes="\u67e5\u8be2\u4e0b\u4e00\u8282\u70b9")
    public BpmResponseResult queryNextUserTask(@RequestBody NextUserTaskQueryDto nextUserTaskQueryDto) {
        return this.taskEngineService.queryNextNode(nextUserTaskQueryDto.getProcessKey(), nextUserTaskQueryDto.getTaskId(), nextUserTaskQueryDto.getIsGetRevokeNode(), nextUserTaskQueryDto.getIsGetWithGroup(), nextUserTaskQueryDto.getLineCondition());
    }

    @GetMapping(value={"/withdrawState"})
    @ApiOperation(value="\u67e5\u8be2\u80fd\u5426\u64a4\u56de", notes="\u67e5\u8be2\u80fd\u5426\u64a4\u56de")
    @ApiImplicitParams(value={@ApiImplicitParam(name="historicTaskId", value="\u5386\u53f2\u4efb\u52a1ID", required=true, paramType="query")})
    public BpmResponseResult withdrawState(@RequestParam(value="historicTaskId") String historicTaskId) {
        return this.taskEngineService.withdrawState(historicTaskId);
    }

    @PostMapping(value={"/editTaskComment"})
    @ApiOperation(value="\u4fee\u6539\u529e\u7406\u610f\u89c1", notes="\u4fee\u6539\u529e\u7406\u610f\u89c1")
    public BpmResponseResult editTaskComment(@RequestBody TaskCommentEditDto taskCommentEditDto) {
        return this.taskEngineService.editTaskComment(taskCommentEditDto.getTaskId(), taskCommentEditDto.getComment());
    }

    @PostMapping(value={"/multiInstanceDelAssignee"})
    @ApiOperation(value="\u4f1a\u7b7e\u8282\u70b9\u51cf\u5c11\u53c2\u4e0e\u8005", notes="\u4f1a\u7b7e\u8282\u70b9\u51cf\u5c11\u53c2\u4e0e\u8005")
    public BpmResponseResult multiInstanceDelAssignee(@RequestBody TaskAssigneeDto taskAssigneeDto) {
        return this.taskEngineService.multiInstanceDelAssignee(taskAssigneeDto.getTaskId(), String.join((CharSequence)",", taskAssigneeDto.getAssignees()));
    }

    @PostMapping(value={"/reStartProcess"})
    @ApiOperation(value="\u91cd\u542f\u6d41\u7a0b\u5230\u76ee\u6807\u8282\u70b9", notes="\u91cd\u542f\u6d41\u7a0b\u5230\u76ee\u6807\u8282\u70b9")
    public BpmResponseResult reStartProcess(@RequestBody ProcessRestartDto processRestartDto) {
        return this.taskEngineService.reStartProcess(processRestartDto.getProcessInsId(), processRestartDto.getBusinessId(), processRestartDto.getTaskDefinitionKey(), processRestartDto.getUserId(), processRestartDto.getAssignee(), processRestartDto.getIsSubmit().booleanValue(), processRestartDto.getMap());
    }

    @PostMapping(value={"/addCustomNode"})
    @ApiOperation(value="\u589e\u52a0\u4e34\u65f6\u8282\u70b9", notes="\u589e\u52a0\u4e34\u65f6\u8282\u70b9")
    public BpmResponseResult addCustomNode(@RequestBody CustomNodeAddDto customNodeAddDto) {
        return TaskEngineService.changeReturnType((ApiResponse)this.addCustomNodeService.addNode(customNodeAddDto.getTaskId(), JSONObject.toJSONString((Object)customNodeAddDto.getList()), customNodeAddDto.getParallel()));
    }

    @PostMapping(value={"/updateUserSecurityLevel"})
    @ApiOperation(value="\u66f4\u65b0\u53d7\u5bc6\u7ea7\u53d8\u52a8\u5f71\u54cd\u7684\u6d41\u7a0b", notes="\u66f4\u65b0\u53d7\u5bc6\u7ea7\u53d8\u52a8\u5f71\u54cd\u7684\u6d41\u7a0b")
    public BpmResponseResult updateUserSecurityLevel(@RequestBody SecurityUpdateDto securityUpdateDto) {
        return this.taskEngineService.updateUserSecurityLevel(securityUpdateDto.getUserId(), securityUpdateDto.getLevel());
    }

    @PostMapping(value={"/updateStarter"})
    @ApiOperation(value="\u4fee\u6539\u6d41\u7a0b\u542f\u52a8\u8005", notes="\u4fee\u6539\u6d41\u7a0b\u542f\u52a8\u8005")
    public BpmResponseResult updateStarter(@RequestBody StarterUpdateDto starterUpdateDto) {
        return this.taskEngineService.updateStarter(starterUpdateDto.getProcessInsId(), starterUpdateDto.getBusinessId(), starterUpdateDto.getUserId());
    }

    @GetMapping(value={"/activeTaskCandidates"})
    @ApiOperation(value="\u6fc0\u6d3b\u4efb\u52a1\u53c2\u4e0e\u8005\uff0c\u6d41\u7a0b\u753b\u5e03\u4e2d\u914d\u7f6e\u3010\u662f\u5426\u89e6\u53d1\u542f\u52a8\u65f6\u4f7f\u7528\u3011", notes="\u6fc0\u6d3b\u4efb\u52a1\u53c2\u4e0e\u8005\uff0c\u6d41\u7a0b\u753b\u5e03\u4e2d\u914d\u7f6e\u3010\u662f\u5426\u89e6\u53d1\u542f\u52a8\u65f6\u4f7f\u7528\u3011")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", value="\u4efb\u52a1id", required=true, paramType="query")})
    public BpmResponseResult activeTaskCandidates(@RequestParam(value="taskId") String taskId) {
        return this.taskEngineService.activeTaskCandidates(taskId);
    }

    @GetMapping(value={"/queryReceiveExecution"})
    @ApiOperation(value="\u6839\u636e\u4e1a\u52a1\u4e3b\u952e\u83b7\u5f97\u6267\u884cid", notes="\u6839\u636e\u4e1a\u52a1\u4e3b\u952e\u83b7\u5f97\u6267\u884cid")
    @ApiImplicitParams(value={@ApiImplicitParam(name="businessId", value="\u4e1a\u52a1\u4e3b\u952e", required=true, paramType="query")})
    public BpmResponseResult queryReceiveExecution(@RequestParam(value="businessId") String businessId) {
        return this.taskEngineService.getExecutionByBusinessId(businessId);
    }

    @PostMapping(value={"/receiveTaskSignal"})
    @ApiOperation(value="\u63a5\u6536\u4efb\u52a1\u6267\u884c\u5230\u4e0b\u4e00\u8282\u70b9", notes="\u63a5\u6536\u4efb\u52a1\u6267\u884c\u5230\u4e0b\u4e00\u8282\u70b9")
    public BpmResponseResult receiveTaskSignal(@RequestBody TaskReceiveDto taskReceiveDto) {
        if (HussarUtils.isNotEmpty((Object)taskReceiveDto.getExecutionId())) {
            return this.taskEngineService.receiveTaskSignal(taskReceiveDto.getExecutionId(), taskReceiveDto.getVariableMap());
        }
        return this.taskEngineService.receiveTaskSignalByProcessInfo(taskReceiveDto);
    }

    @GetMapping(value={"/canAddCustomNode"})
    @ApiOperation(value="\u5224\u65ad\u662f\u5426\u53ef\u4ee5\u8fdb\u884c\u666e\u901a\u7c7b\u578b\u7684\u8ffd\u52a0\u8282\u70b9", notes="\u5224\u65ad\u662f\u5426\u53ef\u4ee5\u8fdb\u884c\u666e\u901a\u7c7b\u578b\u7684\u8ffd\u52a0\u8282\u70b9")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", value="\u4efb\u52a1Id", required=true, paramType="query")})
    public BpmResponseResult canAddCustomNode(@RequestParam(value="taskId") String taskId) {
        return TaskEngineService.changeReturnType((ApiResponse)this.addCustomNodeService.isAddCustomNode(taskId));
    }

    @GetMapping(value={"/canParallelAddNode"})
    @ApiOperation(value="\u5224\u65ad\u662f\u5426\u53ef\u4ee5\u8fdb\u884c\u666e\u901a\u7c7b\u578b\u7684\u8ffd\u52a0\u8282\u70b9", notes="\u5224\u65ad\u662f\u5426\u53ef\u4ee5\u8fdb\u884c\u666e\u901a\u7c7b\u578b\u7684\u8ffd\u52a0\u8282\u70b9")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", value="\u4efb\u52a1Id", required=true, paramType="query")})
    public BpmResponseResult canParallelAddNode(@RequestParam(value="taskId") String taskId) {
        return TaskEngineService.changeReturnType((ApiResponse)this.addCustomNodeService.isAddParallel(taskId));
    }

    @PostMapping(value={"/preemptTask"})
    @ApiOperation(value="\u62a2\u5355", notes="\u62a2\u5355")
    public BpmResponseResult preemptTask(@RequestBody PreemptCommonDto preemptCommonDto) {
        return this.taskEngineService.preemptTask(preemptCommonDto);
    }

    @PostMapping(value={"/unPreemptTask"})
    @ApiOperation(value="\u53d6\u6d88\u62a2\u5355", notes="\u53d6\u6d88\u62a2\u5355")
    public BpmResponseResult unPreemptTask(@RequestBody PreemptCommonDto preemptCommonDto) {
        return this.taskEngineService.unPreemptTask(preemptCommonDto);
    }

    @PostMapping(value={"/checkNextNodeAssignee"})
    @ApiOperation(value="\u9a8c\u8bc1\u4e0b\u4e00\u8282\u70b9\u662f\u5426\u6709\u53c2\u4e0e\u8005\u63a5\u53e3", notes="\u9a8c\u8bc1\u4e0b\u4e00\u8282\u70b9\u662f\u5426\u6709\u53c2\u4e0e\u8005\u63a5\u53e3")
    public BpmResponseResult checkNextNodeAssignee(@RequestBody CheckNextNodeAssigneeDto checkNextNodeAssigneeDto) {
        return this.taskEngineService.checkNextNodeAssignee(checkNextNodeAssigneeDto);
    }
}

