/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.cache;

import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.support.service.DynamicDatasourceService;
import java.io.Serializable;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.engine.impl.persistence.deploy.DeploymentCache;
import org.apache.commons.lang3.SerializationUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HussarWorkflowBpmnModelCache
implements DeploymentCache<BpmnModel> {
    private static final String WORKFLOW_BPMN_MODEL_CACHE = "workflow_bpmn_model_cache";
    private static final String DEFINITION_CACHE_CHARSET_NAME = "ISO-8859-1";
    @Autowired
    private DynamicDatasourceService dynamicDatasourceService;

    public BpmnModel get(String id) {
        String dataSourceName = this.dynamicDatasourceService.getCurrentDatasourceName();
        String string = (String)HussarCacheUtil.get((String)("workflow_bpmn_model_cache." + dataSourceName), (Object)id, String.class);
        BpmnModel bpmnModel = null;
        if (string != null) {
            try {
                bpmnModel = (BpmnModel)SerializationUtils.deserialize((byte[])string.getBytes(DEFINITION_CACHE_CHARSET_NAME));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return bpmnModel;
    }

    public void add(String id, BpmnModel object) {
        String dataSourceName = this.dynamicDatasourceService.getCurrentDatasourceName();
        String bpmnModel = null;
        try {
            byte[] bytes = SerializationUtils.serialize((Serializable)object);
            bpmnModel = new String(bytes, DEFINITION_CACHE_CHARSET_NAME);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        HussarCacheUtil.put((String)("workflow_bpmn_model_cache." + dataSourceName), (Object)id, (Object)bpmnModel);
    }

    public void remove(String id) {
        String dataSourceName = this.dynamicDatasourceService.getCurrentDatasourceName();
        HussarCacheUtil.evict((String)("workflow_bpmn_model_cache." + dataSourceName), (Object)id);
    }

    public void clear() {
        String dataSourceName = this.dynamicDatasourceService.getCurrentDatasourceName();
        HussarCacheUtil.evictKeysLike((String)("workflow_bpmn_model_cache." + dataSourceName), (String)"*");
    }
}

