/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.listener;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.model.SysActCcTask;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.service.ISysActCcTaskService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.constant.BpmAttribute;
import com.jxdinfo.hussar.workflow.engine.constant.TaskSourceFlag;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventListener;
import org.activiti.engine.delegate.event.impl.ActivitiEntityEventImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.repository.Model;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.TaskStateType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class TaskCreateListener
implements ActivitiEventListener {
    private static Logger logger = LogManager.getLogger(TaskCreateListener.class);
    @Resource
    private DataPushService dataPushService;
    @Autowired
    private ISysActCcTaskService sysActCcTaskService;
    @Lazy
    @Resource
    private HistoryService historyService;
    @Lazy
    @Resource
    private RepositoryService repositoryService;

    public void onEvent(ActivitiEvent activitiEvent) {
        HistoricProcessInstanceEntity historicProcessInstance;
        String taskSourceFlag;
        TaskEntity taskEntity = (TaskEntity)((ActivitiEntityEventImpl)activitiEvent).getEntity();
        String userId = (String)taskEntity.getVariable("startUser");
        if (HussarUtils.isNotEmpty((Object)userId)) {
            taskEntity.removeVariable("startUser");
        }
        if (HussarUtils.isEmpty((Object)taskEntity.getSendUser())) {
            taskEntity.setSendUser((String)BpmAttribute.getContextAttribute("sendUser"));
        }
        if (TaskSourceFlag.PROCESS_START.contains(taskSourceFlag = BpmAttribute.getTaskSourceFlag(taskEntity)) && (historicProcessInstance = Context.getCommandContext().getHistoricProcessInstanceEntityManager().findHistoricProcessInstance(taskEntity.getProcessInstanceId())).getFirstUserTaskActivityId() == null) {
            historicProcessInstance.setFirstUserTaskActivityId(taskEntity.getTaskDefinitionKey());
        }
        HashSet<String> processDefinitionIdList = new HashSet<String>();
        processDefinitionIdList.add(taskEntity.getProcessDefinitionId());
        if (this.dataPushService.isDataPush(processDefinitionIdList)) {
            String taskAssignee = this.getAssigneeByTaskId(taskEntity);
            String string = userId = HussarUtils.isEmpty((Object)taskAssignee) ? userId : taskAssignee;
            if (HussarUtils.isNotEmpty((Object)userId)) {
                taskEntity.removeVariable("startUser");
            }
            DataPush dataPush = this.dataPush(taskEntity);
            dataPush.setUserId(HussarUtils.isEmpty((Object)taskAssignee) ? userId : taskAssignee);
            List<Map<String, String>> taskAssigneeMap = this.getAssigneeMapByTaskId(taskEntity);
            if (taskAssigneeMap.isEmpty()) {
                HashMap<String, String> assigneeMap = new HashMap<String, String>();
                assigneeMap.put("userId", userId);
                taskAssigneeMap.add(assigneeMap);
            }
            dataPush.setUserMaps(taskAssigneeMap);
            dataPush.setTaskType(taskEntity.getTaskType());
            List ccTasks = this.sysActCcTaskService.list((Wrapper)new LambdaQueryWrapper().eq(SysActCcTask::getTaskId, (Object)Long.parseLong(taskEntity.getId())));
            if (HussarUtils.isNotEmpty((Object)ccTasks)) {
                dataPush.setCcUrl(((SysActCcTask)ccTasks.get(0)).getFormKey());
            } else {
                List ccFormKeyList;
                Map ccFormKeyMap;
                BpmnModel bpmnModel = this.repositoryService.getBpmnModel(taskEntity.getProcessDefinitionId());
                List ccElement = (List)bpmnModel.getFlowElement(taskEntity.getTaskDefinitionKey()).getExtensionElements().get("ccFormKey");
                String formKey = null;
                if (ccElement != null && !ccElement.isEmpty() && (ccFormKeyMap = ((ExtensionElement)ccElement.get(0)).getAttributes()) != null && (ccFormKeyList = (List)ccFormKeyMap.get("ccFormKey")) != null && !ccFormKeyList.isEmpty()) {
                    formKey = ((ExtensionAttribute)ccFormKeyList.get(0)).getValue();
                }
                dataPush.setCcUrl(formKey);
            }
            this.dataPushService.addDataPush(dataPush);
            if (HussarUtils.isNotEmpty((Object)ccTasks)) {
                ArrayList<String> ccUsers = new ArrayList<String>();
                for (SysActCcTask sysActCcTask : ccTasks) {
                    ccUsers.add(sysActCcTask.getReceiveUser());
                }
                dataPush.setUserId(String.join((CharSequence)",", ccUsers));
                dataPush.setCcMoment("0");
                dataPush.setStartDate((Date)((SysActCcTask)ccTasks.get(0)).getSendTime());
                dataPush.setProcessInsId(taskEntity.getProcessInstanceId());
                this.dataPushService.addCcTask(dataPush);
            }
        }
    }

    private String getAssigneeByTaskId(TaskEntity taskEntity) {
        HashSet<String> users = new HashSet<String>();
        List identityLinks = taskEntity.getCandidates();
        if (identityLinks != null && !identityLinks.isEmpty()) {
            for (IdentityLink identityLink : identityLinks) {
                users.add(identityLink.getUserId());
            }
        }
        if (taskEntity.getAssignee() != null) {
            users.add(taskEntity.getAssignee());
        }
        return String.join((CharSequence)",", users);
    }

    private List<Map<String, String>> getAssigneeMapByTaskId(TaskEntity taskEntity) {
        ArrayList<Map<String, String>> userMaps = new ArrayList<Map<String, String>>();
        List identityLinks = taskEntity.getCandidates();
        if (identityLinks != null && !identityLinks.isEmpty()) {
            for (IdentityLink identityLink : identityLinks) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("userId", identityLink.getUserId());
                if (TaskStateType.isEntrust((IdentityLink)identityLink)) {
                    map.put("mandator", identityLink.getMandator());
                    map.put("taskState", identityLink.getTaskState());
                }
                userMaps.add(map);
            }
        }
        return userMaps;
    }

    public boolean isFailOnException() {
        logger.error("\u4efb\u52a1\u521b\u5efa\u540e\u89e6\u53d1\u4e8b\u4ef6\u6267\u884c\u5931\u8d25");
        return false;
    }

    private DataPush dataPush(TaskEntity task) {
        String processInstanceId = task.getProcessInstanceId();
        HistoricProcessInstanceEntity historicProcessInstance = Context.getCommandContext().getHistoricProcessInstanceEntityManager().findHistoricProcessInstance(processInstanceId);
        DataPush dataPush = new DataPush();
        dataPush.setTaskId(task.getId());
        if (historicProcessInstance != null) {
            dataPush.setBusinessKey(historicProcessInstance.getBusinessKey());
            dataPush.setStartUserId(historicProcessInstance.getStartUserId());
            dataPush.setProcessStartTime(historicProcessInstance.getStartTime());
        } else {
            dataPush.setBusinessKey(task.getProcessInstance().getBusinessKey());
            dataPush.setStartUserId(task.getSendUser());
        }
        String processDefinitionId = task.getProcessDefinitionId();
        String processKey = processDefinitionId.split(":")[0];
        String processVersion = processDefinitionId.split(":")[1];
        dataPush.setTaskDefinitionKey(task.getTaskDefinitionKey());
        dataPush.setProcessDefinitionId(processDefinitionId);
        dataPush.setProcessKey(processKey);
        dataPush.setTaskDefinitionName(task.getName());
        dataPush.setSendUser(task.getSendUser());
        dataPush.setStartDate(task.getCreateTime());
        dataPush.setEndDate(null);
        dataPush.setTaskDueTime(task.getDueDate());
        dataPush.setUrl(task.getFormKey());
        dataPush.setDescription(task.getTodoConfiguration());
        String processTitle = null;
        processTitle = HussarUtils.isEmpty((Object)historicProcessInstance) ? task.getProcessInstance().getProcessTitle() : historicProcessInstance.getProcessTitle();
        String dataDetail = null;
        dataDetail = HussarUtils.isEmpty((Object)historicProcessInstance) ? task.getProcessInstance().getDataDetail() : historicProcessInstance.getDataDetail();
        dataPush.setProcessTitle(processTitle);
        dataPush.setDataDetail(dataDetail);
        dataPush.setComment(null);
        dataPush.setProcessName(task.getProcessInstance().getProcessDefinition().getName());
        dataPush.setProcessInsId(processInstanceId);
        dataPush.setTaskType(task.getTaskType());
        dataPush.setProcessVersion(processVersion);
        String processDefKey = null;
        processDefKey = HussarUtils.isEmpty((Object)historicProcessInstance) ? task.getProcessInstance().getProcessDefinitionKey() : historicProcessInstance.getProcessDefinitionKey();
        Model model = (Model)this.repositoryService.createModelQuery().modelKey(processDefKey).singleResult();
        dataPush.setAppId(String.valueOf(model.getAppId()));
        dataPush.setFormId(task.getFormId());
        return dataPush;
    }
}

