/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.upgrade;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.mp.base.controller.HussarBaseController;
import com.jxdinfo.hussar.workflow.common.InstallResult;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.UrgeSaveDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.UrgeTaskQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.model.SysActUrgeTask;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.service.ISysActUrgeTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.vo.SysActUrgeTaskVo;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u50ac\u529e\u7ba1\u7406"})
@RequestMapping(value={"/bpm/upgrade/sysActUrgeTask"})
public class StandardSysActUrgeTaskController
extends HussarBaseController<SysActUrgeTask, ISysActUrgeTaskService> {
    @Resource
    private ISysActUrgeTaskService sysActUrgeTaskService;

    @GetMapping(value={"/getList"})
    @ApiOperation(value="\u67e5\u8be2\u50ac\u529e", notes="\u67e5\u8be2\u50ac\u529e")
    @AuditLog(moduleName="\u50ac\u529e\u7ba1\u7406", eventDesc="\u83b7\u53d6\u50ac\u529e\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<SysActUrgeTaskVo>> getList(UrgeTaskQueryDto urgeTaskQueryDto) {
        Page pages = new Page((long)urgeTaskQueryDto.getPage().intValue(), (long)urgeTaskQueryDto.getSize().intValue());
        return this.sysActUrgeTaskService.query(pages, urgeTaskQueryDto.getUserId(), urgeTaskQueryDto.getProcessKey(), urgeTaskQueryDto.getSendUserId(), urgeTaskQueryDto.getStartTime(), urgeTaskQueryDto.getEndTime(), null);
    }

    @GetMapping(value={"/save"})
    @ApiOperation(value="\u6dfb\u52a0\u50ac\u529e", notes="\u6dfb\u52a0\u50ac\u529e")
    @AuditLog(moduleName="\u50ac\u529e\u7ba1\u7406", eventDesc="\u6dfb\u52a0\u50ac\u529e", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public BpmResponseResult save(UrgeSaveDto urgeSaveDto) {
        String msg = this.sysActUrgeTaskService.urgeTask(urgeSaveDto.getProcessInsId(), urgeSaveDto.getBusinessId(), urgeSaveDto.getTaskId(), urgeSaveDto.getUserId());
        return InstallResult.getResult((String)"1", (String)msg, null);
    }

    @PostMapping(value={"/delete"})
    @ApiOperation(value="\u5220\u9664\u50ac\u529e", notes="\u5220\u9664\u50ac\u529e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="\u50ac\u529eid  \u591a\u4e2aid\u9017\u53f7\u62fc\u63a5", required=false, paramType="query")})
    @AuditLog(moduleName="\u50ac\u529e\u7ba1\u7406", eventDesc="\u5220\u9664\u50ac\u529e", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public BpmResponseResult delete(@RequestBody List<Long> idList) {
        if (this.sysActUrgeTaskService.removeByIds(idList)) {
            return InstallResult.getResult((String)"1", (String)BpmExceptionCodeEnum.DELETE_SUCCESS.getMessage(), null);
        }
        return InstallResult.getResult((String)"0", (String)BpmExceptionCodeEnum.ERROR_DELETE.getMessage(), null);
    }
}

