/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.AddAttributeCmd;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import java.util.Map;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.deploy.DeploymentManager;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.runtime.ProcessInstanceBuilderImpl;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.ProcessInstance;

public class StartProcessInstanceCmd
extends AddAttributeCmd<ProcessInstance> {
    private static final long serialVersionUID = 1L;
    protected String processDefinitionKey;
    protected String processDefinitionId;
    protected Map<String, Object> variables;
    protected String businessKey;
    protected String tenantId;
    protected String processInstanceName;
    protected String processTitle;
    protected String dataDetail;
    protected String isEmulation;

    public StartProcessInstanceCmd(String processDefinitionKey, String processDefinitionId, String businessKey, Map<String, Object> variables, String processTitle, String dataDetail) {
        this.processDefinitionKey = processDefinitionKey;
        this.processDefinitionId = processDefinitionId;
        this.businessKey = businessKey;
        this.variables = variables;
        this.processTitle = processTitle;
        this.dataDetail = dataDetail;
    }

    public StartProcessInstanceCmd(String processDefinitionKey, String processDefinitionId, String businessKey, String isEmulation, Map<String, Object> variables, String processTitle, String dataDetail) {
        this.processDefinitionKey = processDefinitionKey;
        this.processDefinitionId = processDefinitionId;
        this.businessKey = businessKey;
        this.variables = variables;
        this.processTitle = processTitle;
        this.dataDetail = dataDetail;
        this.isEmulation = isEmulation;
    }

    public StartProcessInstanceCmd(String processDefinitionKey, String processDefinitionId, String businessKey, Map<String, Object> variables, String tenantId, String processTitle, String dataDetail) {
        this(processDefinitionKey, processDefinitionId, businessKey, variables, processTitle, dataDetail);
        this.tenantId = tenantId;
    }

    public StartProcessInstanceCmd(ProcessInstanceBuilderImpl processInstanceBuilder) {
        this(processInstanceBuilder.getProcessDefinitionKey(), processInstanceBuilder.getProcessDefinitionId(), processInstanceBuilder.getBusinessKey(), processInstanceBuilder.getVariables(), processInstanceBuilder.getTenantId(), processInstanceBuilder.getProcessTitle(), processInstanceBuilder.getDataDetail());
        this.processInstanceName = processInstanceBuilder.getProcessInstanceName();
    }

    public ProcessInstance execute(CommandContext commandContext) {
        this.addAttribute(commandContext);
        commandContext.addAttribute("handleType", (Object)"start");
        DeploymentManager deploymentManager = commandContext.getProcessEngineConfiguration().getDeploymentManager();
        ProcessDefinitionEntity processDefinition = null;
        if (this.processDefinitionId != null) {
            processDefinition = deploymentManager.findDeployedProcessDefinitionById(this.processDefinitionId);
            if (processDefinition == null) {
                throw new ActivitiObjectNotFoundException("No process definition found for id = '" + this.processDefinitionId + "'", ProcessDefinition.class);
            }
        } else if (this.processDefinitionKey != null && (this.tenantId == null || "".equals(this.tenantId))) {
            processDefinition = deploymentManager.findDeployedLatestProcessDefinitionByKey(this.processDefinitionKey);
            if (processDefinition == null) {
                throw new ActivitiObjectNotFoundException("No process definition found for key '" + this.processDefinitionKey + "'", ProcessDefinition.class);
            }
        } else if (this.processDefinitionKey != null && this.tenantId != null && !"".equals(this.tenantId)) {
            processDefinition = deploymentManager.findDeployedLatestProcessDefinitionByKeyAndTenantId(this.processDefinitionKey, this.tenantId);
            if (processDefinition == null) {
                throw new ActivitiObjectNotFoundException("No process definition found for key '" + this.processDefinitionKey + "' for tenant identifier " + this.tenantId, ProcessDefinition.class);
            }
        } else {
            throw new ActivitiIllegalArgumentException("processDefinitionKey and processDefinitionId are null");
        }
        if (deploymentManager.isProcessDefinitionSuspended(processDefinition.getId())) {
            throw new ActivitiException(processDefinition.getName() + "\u5df2\u6302\u8d77");
        }
        processDefinition.setProcessTitle(this.processTitle);
        processDefinition.setDataDetail(this.dataDetail);
        ExecutionEntity processInstance = processDefinition.createEmulationProcessInstance(this.businessKey, this.isEmulation);
        this.addExecutionAttribute(processInstance);
        Object securityLevel = this.variables.remove("security_level");
        if (securityLevel != null) {
            if (securityLevel instanceof Integer) {
                commandContext.getHistoricProcessInstanceEntityManager().findHistoricProcessInstance(processInstance.getId()).setSecurityLevel((Integer)securityLevel);
            } else {
                throw new BpmException("\u5bc6\u7ea7\u7c7b\u578b\u9519\u8bef\uff01");
            }
        }
        this.initializeVariables(processInstance);
        if (this.processInstanceName != null) {
            processInstance.setName(this.processInstanceName);
            commandContext.getHistoryManager().recordProcessInstanceNameChange(processInstance.getId(), this.processInstanceName);
        }
        processInstance.fireEventExecution("beforeStart");
        processInstance.start();
        return processInstance;
    }

    protected void initializeVariables(ExecutionEntity processInstance) {
        if (this.variables != null) {
            processInstance.setVariables(this.variables);
        }
    }
}

