/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.CompleteLeapCheckInfo;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.ExecutionInfo;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.JumpInfo;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.JumpModel;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.AddAttributeCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.CommonJumpTaskCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.CompleteLeapCheckTaskCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.MultiInstanceJumpTaskCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.ParallelJumpTaskCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.TaskCompleteCmd;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import com.jxdinfo.hussar.workflow.engine.constant.BpmAttribute;
import com.jxdinfo.hussar.workflow.engine.constant.BpmConstant;
import com.jxdinfo.hussar.workflow.engine.constant.BpmHistoryTask;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.Activity;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SubProcess;
import org.activiti.engine.HistoryService;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.impl.bpmn.behavior.MultiInstanceActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.ParallelMultiInstanceBehavior;
import org.activiti.engine.impl.bpmn.behavior.SequentialMultiInstanceBehavior;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.db.PersistentObject;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.javax.el.ELContext;
import org.activiti.engine.impl.javax.el.ValueExpression;
import org.activiti.engine.impl.juel.ExpressionFactoryImpl;
import org.activiti.engine.impl.juel.SimpleContext;
import org.activiti.engine.impl.persistence.entity.CommentEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.delegate.ActivityBehavior;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.runtime.Execution;

public class CompleteLeapTaskCmd
extends AddAttributeCmd<TaskEntity> {
    private String taskId;
    private String comment;
    private String userId;
    private String mandator;
    private Map<String, Object> variables;
    private boolean isSubmit;
    private Boolean isNotAdd;
    private Boolean notNeedCheckAssignee;
    private CommandContext commandContext;

    public CompleteLeapTaskCmd(String taskId, String mandator, String userId, String comment, Map<String, Object> variables, boolean isSubmit) {
        this.taskId = taskId;
        this.comment = comment;
        this.userId = userId;
        this.mandator = mandator;
        this.variables = variables;
        this.isSubmit = isSubmit;
    }

    public CompleteLeapTaskCmd(String taskId, String mandator, String userId, String comment, Map<String, Object> variables, boolean isSubmit, boolean aFlg, Boolean notNeedCheckAssignee) {
        this.taskId = taskId;
        this.comment = comment;
        this.userId = userId;
        this.mandator = mandator;
        this.variables = variables;
        this.isSubmit = isSubmit;
        this.isNotAdd = aFlg;
        this.notNeedCheckAssignee = notNeedCheckAssignee;
    }

    public TaskEntity execute(CommandContext commandContext) {
        CompleteLeapCheckInfo completeLeapCheckInfo;
        this.addAttribute(commandContext);
        commandContext.addAttribute("notNeedCheckAssignee", (Object)this.notNeedCheckAssignee);
        if (this.isSubmit) {
            commandContext.addAttribute("isNotAdd", (Object)true);
        } else {
            commandContext.addAttribute("isNotAdd", (Object)this.isNotAdd);
        }
        this.commandContext = commandContext;
        TaskEntity task = commandContext.getTaskEntityManager().findTaskById(this.taskId);
        ExecutionEntity processInstance = task.getProcessInstance();
        this.addExecutionAttribute(processInstance);
        String subProcessKey = task.getSubProcessKey();
        if (HussarUtils.isNotEmpty((Object)this.comment)) {
            CommentEntity commentEntity = new CommentEntity();
            commentEntity.setUserId(this.userId);
            commentEntity.setType("complete");
            commentEntity.setTime(commandContext.getProcessEngineConfiguration().getClock().getCurrentTime());
            commentEntity.setTaskId(this.taskId);
            commentEntity.setProcessInstanceId(null);
            commentEntity.setAction("AddComment");
            String eventMessage = this.comment.replaceAll("\\s+", " ");
            if (eventMessage.length() > BpmConstant.MAX_COMMENT_LENGTG) {
                eventMessage = eventMessage.substring(0, BpmConstant.COMMENT_LENGTH) + "...";
            }
            commentEntity.setMessage(eventMessage);
            commentEntity.setFullMessage(this.comment);
            commandContext.getCommentEntityManager().insert((PersistentObject)commentEntity);
        }
        if (!(completeLeapCheckInfo = new CompleteLeapCheckTaskCmd(task).execute(commandContext)).isCompleteLeap()) {
            return this.complete(task);
        }
        ActivityBehavior activityBehavior = task.getExecution().getActivity().getActivityBehavior();
        boolean isScope = activityBehavior instanceof ParallelMultiInstanceBehavior || activityBehavior instanceof SequentialMultiInstanceBehavior;
        JumpInfo jumpInfo = completeLeapCheckInfo.getJumpInfo();
        List rejectTo = jumpInfo.getJumpTo();
        List rejectFrom = jumpInfo.getJumpFrom();
        List rejectExecution = completeLeapCheckInfo.getRejectExecution();
        String executionId = task.getExecutionId();
        ActivityImpl currentActivity = task.getExecution().getActivity();
        if (rejectTo.size() == 1) {
            if (!isScope) {
                this.taskAssigneeHandle(rejectFrom, task);
                task.setAssignee(this.userId, true, true);
                JumpModel jumpModel = new JumpModel(1).setJumpFrom(task.getTaskDefinitionKey()).setJumpTo(rejectFrom).setJumpToExecution(rejectExecution);
                this.addAllPrevNode(jumpModel, jumpModel.getJumpTo(), task.getTaskDefinitionKey());
                new CommonJumpTaskCmd(this.userId, this.mandator, executionId, jumpModel, this.comment, BpmAttribute.getTaskSourceFlag((ActivityExecution)processInstance), this.variables, currentActivity).execute(commandContext);
                return task;
            }
            if (this.multiCondition(task)) {
                this.taskAssigneeHandle(rejectFrom, task);
                task.setAssignee(this.userId, true, true);
                JumpModel jumpModel = new JumpModel(2).setJumpFrom(task.getTaskDefinitionKey()).setJumpTo(rejectFrom).setJumpToExecution(rejectExecution);
                this.addAllPrevNode(jumpModel, jumpModel.getJumpTo(), task.getTaskDefinitionKey());
                new MultiInstanceJumpTaskCmd(this.userId, this.mandator, executionId, jumpModel, this.taskId, this.comment, this.variables, currentActivity).execute(commandContext);
                return task;
            }
            return this.complete(task);
        }
        HashSet rejectToNodes = new HashSet(rejectTo);
        String targetGateway = completeLeapCheckInfo.getTargetGateway();
        List executionList = commandContext.getExecutionEntityManager().findChildExecutionsByProcessInstanceId(task.getProcessInstanceId());
        if (!isScope || this.multiCondition(task)) {
            int targetGatewayExecutionNum = 0;
            for (Execution execution : executionList) {
                if (subProcessKey != null && !subProcessKey.equals(execution.getSubProcessKey()) || !targetGateway.equals(execution.getActivityId())) continue;
                ++targetGatewayExecutionNum;
            }
            if (targetGatewayExecutionNum >= rejectToNodes.size() - 1) {
                this.taskAssigneeHandle(rejectFrom, task);
                ArrayList<String> affectedTasks = new ArrayList<String>();
                affectedTasks.add(targetGateway);
                affectedTasks.add(currentActivity.getId());
                task.setAssignee(this.userId, true, true);
                JumpModel jumpModel = new JumpModel(3).setJumpFrom(task.getTaskDefinitionKey()).setJumpTo(rejectFrom).setAffectedTasks(affectedTasks).setJumpToExecution(rejectExecution);
                this.addAllPrevNode(jumpModel, jumpModel.getJumpTo(), String.join((CharSequence)",", rejectTo));
                new ParallelJumpTaskCmd(this.taskId, this.userId, this.mandator, executionId, jumpModel, this.comment, task.getSubProcessKey(), this.variables, currentActivity).execute(commandContext);
                return task;
            }
            task.setAssignee(this.userId, true, true);
            JumpModel jumpModel = new JumpModel(1).setJumpFrom(task.getTaskDefinitionKey()).setJumpToExecution(Collections.singletonList(new ExecutionInfo(targetGateway, task.getTaskDefinitionKey(), null)));
            new CommonJumpTaskCmd(this.userId, this.mandator, executionId, jumpModel, this.comment, BpmAttribute.getTaskSourceFlag((ActivityExecution)processInstance), this.variables, currentActivity).execute(commandContext);
            return task;
        }
        return this.complete(task);
    }

    private void addAllPrevNode(JumpModel jumpModel, List<String> taskDefKey, String allPrevNode) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String s : taskDefKey) {
            map.put(s, allPrevNode);
        }
        jumpModel.setAllPrevNode(map);
    }

    private void taskAssigneeHandle(List<String> rejectNodes, TaskEntity task) {
        List<String> lastAppoint;
        HashMap<String, List<String>> appointAssigneeVar;
        String rejectNode = rejectNodes.get(0);
        String processInstanceId = task.getProcessInstanceId();
        String subProcessKey = task.getSubProcessKey();
        String processDefinitionId = task.getProcessDefinitionId();
        Map<String, Object> map = this.variables;
        HistoryService historyService = Context.getCommandContext().getProcessEngineConfiguration().getHistoryService();
        if (map == null) {
            map = new HashMap<String, Object>();
        }
        if ((appointAssigneeVar = (HashMap<String, List<String>>)BpmAttribute.getExecutionAttribute((ActivityExecution)task.getProcessInstance(), "appoint_assignee")) == null) {
            appointAssigneeVar = new HashMap<String, List<String>>();
        }
        if (!this.isSubmit && HussarUtils.isEmpty(appointAssigneeVar.get(rejectNode)) && HussarUtils.isEmpty(appointAssigneeVar.get("static_appoint_assignee")) && (lastAppoint = BpmHistoryTask.getLastAppoint(processInstanceId, subProcessKey, rejectNode)) != null) {
            appointAssigneeVar.put(rejectNode, lastAppoint);
            task.getExecution().addTempVariable("appoint_assignee", appointAssigneeVar);
        }
        BpmnModel bm = this.commandContext.getProcessEngineConfiguration().getDeploymentManager().getBpmnModelById(processDefinitionId);
        if (this.isSubmit) {
            HistoricTaskInstance lastComplete;
            ProcessDefinitionEntity definition;
            String subProcessKeyCondition = subProcessKey;
            Process process = bm.getMainProcess();
            if (process.getFlowElement(rejectNode) != null) {
                subProcessKeyCondition = null;
            }
            if ((definition = this.commandContext.getProcessEngineConfiguration().getDeploymentManager().findDeployedProcessDefinitionById(processDefinitionId)) == null) {
                throw new BpmException(BpmExceptionCodeEnum.PROCESS_NOT_FOUND);
            }
            ActivityImpl rejectActivity = definition.findActivity(rejectNode);
            if (rejectActivity == null) {
                throw new BpmException(BpmExceptionCodeEnum.RUNNING_NODE_NOT_FOUND);
            }
            ActivityBehavior activityBehavior = rejectActivity.getActivityBehavior();
            String assignee = null;
            if (!(activityBehavior instanceof MultiInstanceActivityBehavior) && (lastComplete = BpmHistoryTask.getLastComplete(task.getProcessInstanceId(), subProcessKeyCondition, rejectNode)) != null) {
                assignee = lastComplete.getOriginalAssignee();
            }
            List<String> assigneeList = null;
            if (assignee == null) {
                assigneeList = BpmHistoryTask.getLastAppoint(processInstanceId, subProcessKey, rejectNode);
            }
            if (HussarUtils.isNotEmpty(assignee)) {
                appointAssigneeVar.put(rejectNode, Arrays.asList(assignee.split(",")));
                task.getExecution().addTempVariable("appoint_assignee", appointAssigneeVar);
            }
            if (HussarUtils.isNotEmpty(assigneeList)) {
                appointAssigneeVar.put(rejectNode, assigneeList);
                task.getExecution().addTempVariable("appoint_assignee", appointAssigneeVar);
            }
        }
        if (this.isSubmit) {
            HashMap<String, String> subProcessRejectAppointMsg = new HashMap<String, String>();
            List list = historyService.createHistoricActivityInstanceQuery().activityType("startEvent").processInstanceId(task.getProcessInstanceId()).list();
            HashMap<String, Integer> subProcessKeyMap = new HashMap<String, Integer>();
            for (HistoricActivityInstance historicActivityInstance : list) {
                if (historicActivityInstance.getSubProcessKey() == null) continue;
                subProcessKeyMap.put(historicActivityInstance.getSubProcessKey(), historicActivityInstance.getCycleCount());
            }
            for (String targetId : rejectNodes) {
                if (!(bm.getFlowElement(targetId) instanceof SubProcess)) continue;
                int cycleCount = 0;
                ArrayList<String> subProcessVariableList = new ArrayList<String>();
                for (String subProcess : subProcessKeyMap.keySet()) {
                    if (!subProcess.startsWith(targetId + ":")) continue;
                    if (cycleCount < (Integer)subProcessKeyMap.get(subProcess)) {
                        subProcessVariableList = new ArrayList();
                        cycleCount = (Integer)subProcessKeyMap.get(subProcess);
                    }
                    subProcessVariableList.add(subProcess.split(":")[1]);
                }
                subProcessRejectAppointMsg.put(targetId, String.join((CharSequence)",", subProcessVariableList));
            }
            this.commandContext.addAttribute("subProcessRejectAppointMsg", subProcessRejectAppointMsg);
        }
    }

    private boolean multiCondition(TaskEntity task) {
        Map multiVariables = task.getExecution().getVariables();
        int nrOfCompletedInstances = (Integer)multiVariables.get("nrOfCompletedInstances") + 1;
        int nrOfInstances = (Integer)multiVariables.get("nrOfInstances");
        if (nrOfInstances != 0 && nrOfInstances > nrOfCompletedInstances) {
            String multiFinishCondition;
            String multiType = (String)multiVariables.get("multi_type");
            String string = multiFinishCondition = multiVariables.get("multi_finish_condition") == null ? null : multiVariables.get("multi_finish_condition").toString();
            if (HussarUtils.isNotEmpty((Object)multiType) && HussarUtils.isNotEmpty((Object)multiFinishCondition)) {
                if ("0".equals(multiType) ? (double)nrOfCompletedInstances / (double)nrOfInstances >= Double.parseDouble(multiFinishCondition) / 100.0 : "1".equals(multiType) && nrOfCompletedInstances == Integer.parseInt(multiFinishCondition)) {
                    return true;
                }
            } else {
                HashMap<String, Object> contextMap = new HashMap<String, Object>();
                contextMap.put("nrOfCompletedInstances", nrOfCompletedInstances);
                contextMap.put("nrOfInstances", nrOfInstances);
                boolean condition = false;
                BpmnModel bm = this.commandContext.getProcessEngineConfiguration().getDeploymentManager().getBpmnModelById(task.getProcessDefinitionId());
                String k = ((Activity)bm.getFlowElement(task.getTaskDefinitionKey())).getLoopCharacteristics().getCompletionCondition();
                ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
                SimpleContext context = CompleteLeapTaskCmd.getVariables(contextMap);
                ValueExpression e = factory.createValueExpression((ELContext)context, k, Boolean.TYPE);
                if (((Boolean)e.getValue((ELContext)context)).booleanValue()) {
                    condition = true;
                }
                if (condition) {
                    return true;
                }
            }
        } else {
            return true;
        }
        return false;
    }

    private static SimpleContext getVariables(Map<String, Object> map) {
        ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
        SimpleContext context = new SimpleContext();
        if (map != null && !map.isEmpty()) {
            for (String k : map.keySet()) {
                if (map.get(k.toString()) != null) {
                    context.setVariable(k.toString(), factory.createValueExpression(map.get(k.toString()), map.get(k.toString()).getClass()));
                    continue;
                }
                context.setVariable(k.toString(), factory.createValueExpression(map.get(k.toString()), Object.class));
            }
        }
        return context;
    }

    private TaskEntity complete(TaskEntity task) {
        task.setAssignee(this.userId, true, true);
        task.getProcessInstance().addTempVariable("taskSourceFlag", (Object)"complete");
        return new TaskCompleteCmd(this.taskId, this.userId, this.mandator, this.variables, this.notNeedCheckAssignee, this.isNotAdd).execute(this.commandContext);
    }
}

