/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.manage.engine.upgrade;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.CheckNextNodeAssigneeDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.CustomNodeAddDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.EntrustTaskDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.FlowTaskDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.NextAssigneeQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.NextUserTaskQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.NodeQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.PreemptCommonDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.ProcessRestartDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.QueryProcessTaskCountDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.RejectNodeQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.SecurityUpdateDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.StarterUpdateDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskAddAssigneeDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskAssigneeDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskCommentEditDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskDefQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskFreeJumpDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskReceiveDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskRejectDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskRevokeDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.ITaskEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.AddCustomNodeService;
import com.jxdinfo.hussar.workflow.engine.bpm.processtransfer.dto.TransferDto;
import com.jxdinfo.hussar.workflow.engine.bpm.taskmanage.dto.AssigneeConditionDto;
import com.jxdinfo.hussar.workflow.engine.bpm.taskmanage.dto.CompleteTaskDto;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.manage.util.TypeConvertUtils;
import com.jxdinfo.hussar.workflow.upgrade.StandardTaskEngineApiService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class StandardTaskEngineWorkflowApiService
implements StandardTaskEngineApiService {
    @Lazy
    @Autowired
    private ITaskEngineService taskEngineService;
    @Lazy
    @Autowired
    private AddCustomNodeService addCustomNodeService;

    public BpmResponseResult queryProcessTask(String taskId) {
        return TypeConvertUtils.changeReturnToBpmResult((ApiResponse)this.taskEngineService.queryTask(taskId));
    }

    public BpmResponseResult queryUserProcessTaskCount(String userId) {
        return TypeConvertUtils.changeReturnToBpmResult((ApiResponse)this.taskEngineService.queryUserTaskCount(userId));
    }

    public BpmResponseResult queryUserProcessTaskCountByNode(String userId) {
        return TypeConvertUtils.changeReturnToBpmResult((ApiResponse)this.taskEngineService.queryUserTaskCountByNode(userId));
    }

    public BpmResponseResult queryToDoList(FlowTaskDto flowTaskDto) {
        return this.taskEngineService.queryToDoList(flowTaskDto);
    }

    public BpmResponseResult queryDoneList(FlowTaskDto flowTaskDto) {
        return this.taskEngineService.queryDoneList(flowTaskDto);
    }

    public BpmResponseResult completeTask(CompleteTaskDto completeTaskDto) {
        return this.taskEngineService.completeTask(completeTaskDto);
    }

    public BpmResponseResult queryRejectComment(String taskId) {
        return this.taskEngineService.queryRejectComment(taskId);
    }

    public BpmResponseResult rejectToLastTask(TaskRejectDto taskRejectDto) {
        return this.taskEngineService.rejectToLastTask(taskRejectDto);
    }

    public BpmResponseResult getRejectNode(RejectNodeQueryDto nodeQueryDto) {
        return this.taskEngineService.getRejectNode(nodeQueryDto.getTaskId(), nodeQueryDto.getIsSubmit(), nodeQueryDto.getMap());
    }

    public BpmResponseResult rejectToFirstTask(TaskRejectDto taskRejectDto) {
        return this.taskEngineService.rejectToFirstTask(taskRejectDto);
    }

    public BpmResponseResult rejectToAnyTask(TaskRejectDto taskRejectDto) {
        return this.taskEngineService.rejectToAnyTask(taskRejectDto);
    }

    public BpmResponseResult queryRejectNode(String taskId, boolean isGetMainProcess) {
        return this.taskEngineService.queryRejectNode(taskId, isGetMainProcess);
    }

    public BpmResponseResult queryJumpNode(String taskId, boolean isGetMainProcess) {
        return this.taskEngineService.queryJumpNode(taskId, isGetMainProcess);
    }

    public BpmResponseResult entrustTask(EntrustTaskDto entrustTaskDto) {
        return this.taskEngineService.entrustTask(entrustTaskDto.getTaskId(), entrustTaskDto.getUserId(), entrustTaskDto.getMandatary(), entrustTaskDto.getComment());
    }

    public BpmResponseResult freeJump(TaskFreeJumpDto taskFreeJumpDto) {
        return this.taskEngineService.freeJump(taskFreeJumpDto);
    }

    public BpmResponseResult multiInstanceAddAssignee(TaskAssigneeDto taskAssigneeDto) {
        return this.taskEngineService.multiInstanceAddAssignee(taskAssigneeDto.getTaskId(), taskAssigneeDto.getAssignees());
    }

    public BpmResponseResult multiInstanceDelAssignee(TaskAssigneeDto taskAssigneeDto) {
        return this.taskEngineService.multiInstanceDelAssignee(taskAssigneeDto.getTaskId(), StringUtils.join((Iterable)taskAssigneeDto.getAssignees(), (String)","));
    }

    public BpmResponseResult queryAssigneeByTaskId(String taskId) {
        return this.taskEngineService.queryAssigneeByTaskId(taskId);
    }

    public BpmResponseResult taskAddAssignee(TaskAddAssigneeDto taskAddAssigneeDto) {
        return this.taskEngineService.taskAddAssignee(taskAddAssigneeDto.getTaskId(), taskAddAssigneeDto.getAssigneeList());
    }

    public BpmResponseResult queryProcessNodeByTaskId(String taskId) {
        return this.taskEngineService.queryProcessNodeByTaskId(taskId);
    }

    public BpmResponseResult queryNextAssignee(NextAssigneeQueryDto nextAssigneeQueryDto) {
        if (HussarUtils.isNotEmpty((Object)nextAssigneeQueryDto.getProcessKey())) {
            return this.taskEngineService.queryNextAssigneeByTaskIdAndNodeId(nextAssigneeQueryDto.getTaskId(), nextAssigneeQueryDto.getNodeId(), nextAssigneeQueryDto.getMap());
        }
        return this.taskEngineService.queryNextAssigneeByTaskIdAndNodeId(nextAssigneeQueryDto.getProcessKey(), nextAssigneeQueryDto.getTaskId(), nextAssigneeQueryDto.getNodeId(), nextAssigneeQueryDto.getMap());
    }

    public BpmResponseResult queryAssignee(AssigneeConditionDto assigneeQueryDto) {
        return this.taskEngineService.queryAllAssignee(assigneeQueryDto.getProcessKey(), assigneeQueryDto.getTaskDefinitionKey());
    }

    public BpmResponseResult queryHistoryNodeInfo(String taskId) {
        return TypeConvertUtils.changeReturnToBpmResult((ApiResponse)this.taskEngineService.queryHistoryActByTaskId(taskId, null));
    }

    public BpmResponseResult queryProcessDefIdAndTaskDefKey(TaskDefQueryDto taskDefQueryDto) {
        return TypeConvertUtils.changeReturnToBpmResult((ApiResponse)this.taskEngineService.getProcessDefinitionIdAndNodeId(taskDefQueryDto.getProcessKey(), taskDefQueryDto.getTaskId()));
    }

    public BpmResponseResult queryCurrentNodeInfo(NodeQueryDto nodeQueryDto) {
        return this.taskEngineService.queryTaskByBusinessIdAndProcessInsId(nodeQueryDto.getBusinessId(), nodeQueryDto.getBusinessId());
    }

    public BpmResponseResult queryNextUserTask(NextUserTaskQueryDto nextUserTaskQueryDto) {
        return this.taskEngineService.queryNextNode(nextUserTaskQueryDto.getProcessKey(), nextUserTaskQueryDto.getTaskId(), nextUserTaskQueryDto.getIsGetRevokeNode(), nextUserTaskQueryDto.getIsGetWithGroup(), nextUserTaskQueryDto.getLineCondition());
    }

    public BpmResponseResult withdrawState(String historicTaskId) {
        return this.taskEngineService.withdrawState(historicTaskId);
    }

    public BpmResponseResult revokeTask(TaskRevokeDto taskRevokeDto) {
        return this.taskEngineService.revokeTask(taskRevokeDto.getHistoricTaskId(), taskRevokeDto.getUserId(), taskRevokeDto.getComment(), taskRevokeDto.getIsSubmit(), taskRevokeDto.getMap());
    }

    public BpmResponseResult editTaskComment(TaskCommentEditDto taskCommentEditDto) {
        return this.taskEngineService.editTaskComment(taskCommentEditDto.getTaskId(), taskCommentEditDto.getComment());
    }

    public BpmResponseResult reStartProcess(ProcessRestartDto processRestartDto) {
        return this.taskEngineService.reStartProcess(processRestartDto.getProcessInsId(), processRestartDto.getBusinessId(), processRestartDto.getTaskDefinitionKey(), processRestartDto.getUserId(), processRestartDto.getAssignee(), processRestartDto.getIsSubmit().booleanValue(), processRestartDto.getMap());
    }

    public BpmResponseResult addCustomNode(CustomNodeAddDto customNodeAddDto) {
        return TypeConvertUtils.changeReturnToBpmResult((ApiResponse)this.addCustomNodeService.addNode(customNodeAddDto.getTaskId(), JSON.toJSONString((Object)customNodeAddDto.getList()), customNodeAddDto.getParallel()));
    }

    public BpmResponseResult canParallelAddNode(String taskId) {
        return TypeConvertUtils.changeReturnToBpmResult((ApiResponse)this.addCustomNodeService.isAddParallel(taskId));
    }

    public BpmResponseResult canAddCustomNode(String taskId) {
        return TypeConvertUtils.changeReturnToBpmResult((ApiResponse)this.addCustomNodeService.isAddCustomNode(taskId));
    }

    public BpmResponseResult updateUserSecurityLevel(SecurityUpdateDto securityUpdateDto) {
        return this.taskEngineService.updateUserSecurityLevel(securityUpdateDto.getUserId(), securityUpdateDto.getLevel());
    }

    public BpmResponseResult activeTaskCandidates(String taskId) {
        return this.taskEngineService.activeTaskCandidates(taskId);
    }

    public BpmResponseResult updateStarter(StarterUpdateDto starterUpdateDto) {
        return this.taskEngineService.updateStarter(starterUpdateDto.getProcessInsId(), starterUpdateDto.getBusinessId(), starterUpdateDto.getUserId());
    }

    public BpmResponseResult queryReceiveExecution(String businessId) {
        return this.taskEngineService.getExecutionByBusinessId(businessId);
    }

    public BpmResponseResult receiveTaskSignal(TaskReceiveDto taskReceiveDto) {
        return this.taskEngineService.receiveTaskSignal(taskReceiveDto.getExecutionId(), taskReceiveDto.getVariableMap());
    }

    public BpmResponseResult preemptTask(PreemptCommonDto preemptCommonDto) {
        return this.taskEngineService.preemptTask(preemptCommonDto);
    }

    public BpmResponseResult unPreemptTask(PreemptCommonDto preemptCommonDto) {
        return this.taskEngineService.unPreemptTask(preemptCommonDto);
    }

    public BpmResponseResult checkNextNodeAssignee(CheckNextNodeAssigneeDto checkNextNodeAssigneeDto) {
        return this.taskEngineService.checkNextNodeAssignee(checkNextNodeAssigneeDto);
    }

    public BpmResponseResult setTimeout(String taskId, String timeout) {
        return this.taskEngineService.setTimeoutPeriod(taskId, timeout);
    }

    public BpmResponseResult transferTask(TransferDto transferDto) {
        return this.taskEngineService.transferTask(transferDto);
    }

    public BpmResponseResult getTransferProgressInfo(Long transferId) {
        return this.taskEngineService.getTransferProgressInfo(transferId);
    }

    public BpmResponseResult queryProcessTaskCount(QueryProcessTaskCountDto queryProcessTaskCountDto) {
        return this.taskEngineService.queryProcessTaskCount(queryProcessTaskCountDto);
    }
}

