/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.model.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.workflow.common.InstallResult;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.CommonCodeUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.model.DefinitionModel;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.service.ProcessDefinitionsService;
import com.jxdinfo.hussar.workflow.engine.bpm.form.WorkflowAuthConfigQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.model.dao.SysActHandleAuthMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.SysActHandleAuth;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysActHandleAuthService;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="sysFormHandleAuthService")
@HussarTokenDs
public class SysActHandleAuthServiceImpl
extends ServiceImpl<SysActHandleAuthMapper, SysActHandleAuth>
implements SysActHandleAuthService {
    @Autowired
    private LcdpBpmProperties lcdpBpmProperties;
    @Resource
    private SysActHandleAuthMapper sysActHandleAuthMapper;
    @Autowired
    private ProcessDefinitionsService processDefinitionsService;
    @Resource
    private HistoryService historyService;
    @Resource
    private RepositoryService repositoryService;
    @Autowired
    private ModelService modelService;

    private List<SysActHandleAuth> getListByTaskId(String taskId, String formType) {
        HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId)).queryChildTask()).singleResult();
        if (historicTaskInstance == null) {
            return new ArrayList<SysActHandleAuth>();
        }
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(historicTaskInstance.getProcessInstanceId()).singleResult();
        if (HussarUtils.isNotEmpty((Object)historicProcessInstance.getEndTime())) {
            return new ArrayList<SysActHandleAuth>();
        }
        Integer conditionVersion = Integer.valueOf(this.modelService.getRealVersion(historicTaskInstance.getProcessDefinitionId()));
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(historicTaskInstance.getProcessDefinitionId());
        String nodeId = CommonCodeUtil.getVisitorNodeId(historicTaskInstance.getTaskDefinitionKey(), bpmnModel);
        String processKey = historicTaskInstance.getProcessDefinitionId().split(":")[0];
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(SysActHandleAuth::getProcessKey, (Object)processKey);
        lambdaQueryWrapper.eq(SysActHandleAuth::getTaskDefinitionKey, (Object)nodeId);
        lambdaQueryWrapper.eq(SysActHandleAuth::getProcessVersion, (Object)conditionVersion);
        List list = this.sysActHandleAuthMapper.selectList((Wrapper)lambdaQueryWrapper);
        for (SysActHandleAuth sysActHandleAuth : list) {
            sysActHandleAuth.setTaskDefinitionKey(historicTaskInstance.getTaskDefinitionKey());
        }
        return list;
    }

    public BpmResponseResult queryHandleAuthConfigs(String processKey, String taskDefintionKey, String processVersion, String taskId, String formType) {
        if (!this.lcdpBpmProperties.isModifyConfigurationOnline()) {
            return InstallResult.fail((String)"");
        }
        JSONArray jsonArray = new JSONArray();
        List<Object> list = new ArrayList();
        if (HussarUtils.isEmpty((Object)taskId)) {
            DefinitionModel definitionModel = this.processDefinitionsService.getMainOrNew(processKey);
            if (HussarUtils.isNotEmpty((Object)definitionModel)) {
                processVersion = definitionModel.getVersion();
            }
            list = this.sysActHandleAuthMapper.getHandleAuthWithoutRunning(processKey, processVersion, formType);
        } else {
            list = this.getListByTaskId(taskId, formType);
        }
        for (SysActHandleAuth sysActHandleAuth : list) {
            if (HussarUtils.isEmpty((Object)taskId) && ("EndProcess".equals(sysActHandleAuth.getHandleType()) || "EntrustTask".equals(sysActHandleAuth.getHandleType())) || ("2".equals(formType) ? "Revoke".equals(sysActHandleAuth.getHandleType()) : "1".equals(formType) && !"Revoke".equals(sysActHandleAuth.getHandleType()))) continue;
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("handleAuthId", (Object)sysActHandleAuth.getId());
            jsonObject.put("processDefinitionKey", (Object)sysActHandleAuth.getProcessKey());
            jsonObject.put("taskDefinitionKey", (Object)sysActHandleAuth.getTaskDefinitionKey());
            jsonObject.put("processVersion", (Object)String.valueOf(sysActHandleAuth.getProcessVersion()));
            jsonObject.put("handleName", (Object)sysActHandleAuth.getHandleName());
            jsonObject.put("handleType", (Object)sysActHandleAuth.getHandleType());
            jsonObject.put("extendConfiguration", (Object)sysActHandleAuth.getExtendConfiguration());
            jsonObject.put("handleIcon", (Object)sysActHandleAuth.getHandleIcon());
            jsonArray.add((Object)jsonObject);
        }
        return InstallResult.success((JSONArray)jsonArray);
    }

    public JSONArray getAllAuthConfigs(WorkflowAuthConfigQueryDto workflowAuthConfigQueryDto) {
        JSONArray jsonArray = new JSONArray();
        List<Object> list = new ArrayList();
        if (HussarUtils.isEmpty((Object)workflowAuthConfigQueryDto.getTaskId())) {
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.eq(HussarUtils.isNotEmpty((Object)workflowAuthConfigQueryDto.getProcessKey()), SysActHandleAuth::getProcessKey, (Object)workflowAuthConfigQueryDto.getProcessKey());
            Integer n = workflowAuthConfigQueryDto.getVersion();
            if (n == null) {
                Integer conditionVersion;
                try {
                    String processDefinitionId;
                    if (workflowAuthConfigQueryDto.isGetLastVersion()) {
                        processDefinitionId = this.processDefinitionsService.getLastProcessDefinitionId(workflowAuthConfigQueryDto.getProcessKey());
                        conditionVersion = Integer.valueOf(processDefinitionId.split(":")[1]);
                    } else {
                        processDefinitionId = this.processDefinitionsService.getStartProcessDefinitionId(workflowAuthConfigQueryDto.getProcessKey(), null);
                        conditionVersion = Integer.valueOf(processDefinitionId.split(":")[1]);
                    }
                }
                catch (BpmException e) {
                    return new JSONArray();
                }
                lambdaQueryWrapper.eq(SysActHandleAuth::getProcessVersion, (Object)conditionVersion);
            } else {
                lambdaQueryWrapper.eq(SysActHandleAuth::getProcessVersion, (Object)n);
            }
            list = this.sysActHandleAuthMapper.selectList((Wrapper)lambdaQueryWrapper);
        } else {
            list = this.getListByTaskId(workflowAuthConfigQueryDto.getTaskId(), workflowAuthConfigQueryDto.getFormType());
        }
        for (SysActHandleAuth sysActHandleAuth : list) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("handleAuthId", (Object)sysActHandleAuth.getId());
            jsonObject.put("processDefinitionKey", (Object)sysActHandleAuth.getProcessKey());
            jsonObject.put("taskDefinitionKey", (Object)sysActHandleAuth.getTaskDefinitionKey());
            jsonObject.put("processVersion", (Object)String.valueOf(sysActHandleAuth.getProcessVersion()));
            jsonObject.put("handleName", (Object)sysActHandleAuth.getHandleName());
            jsonObject.put("extendConfiguration", (Object)sysActHandleAuth.getExtendConfiguration());
            jsonObject.put("handleIcon", (Object)sysActHandleAuth.getHandleIcon());
            jsonObject.put("handleType", (Object)sysActHandleAuth.getHandleType());
            jsonArray.add((Object)jsonObject);
        }
        return jsonArray;
    }

    public BpmResponseResult queryHandleAuthConfigsByDto(WorkflowAuthConfigQueryDto workflowAuthConfigQueryDto) {
        return InstallResult.success((JSONArray)this.getAllAuthConfigs(workflowAuthConfigQueryDto));
    }
}

