/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.message.service.impl;

import com.jxdinfo.hussar.msg.qingtui.model.MsgQingTuiTemplate;
import com.jxdinfo.hussar.msg.qingtui.service.QtTemplate4WorkFlowService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import com.jxdinfo.hussar.workflow.engine.bpm.message.model.BpmActMsgDetail;
import com.jxdinfo.hussar.workflow.engine.bpm.message.push.unifiedinterface.PushMsgHandlerService;
import com.jxdinfo.hussar.workflow.engine.bpm.message.service.BpmMsgPushMessageService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
@HussarTokenDs
public class BpmMsgPushMessageServiceImpl
implements BpmMsgPushMessageService {
    @Autowired
    private List<PushMsgHandlerService> pushMsgHandlerServices;
    @Autowired(required=false)
    private QtTemplate4WorkFlowService qtTemplate4WorkFlowService;
    private static final Logger logger = LoggerFactory.getLogger(BpmMsgPushMessageServiceImpl.class);

    public void pushMessageAsync(BpmActMsgDetail bpmActMsgDetail, ServletRequestAttributes servletRequestAttributes, String tenantCode, String connName) {
        String[] channelTypes;
        RequestContextHolder.setRequestAttributes((RequestAttributes)servletRequestAttributes);
        HussarContextHolder.setTenant((String)connName, (String)tenantCode);
        for (String channelType : channelTypes = bpmActMsgDetail.getChannelType().split(",")) {
            bpmActMsgDetail.setChannelType(channelType);
            this.addMessageOtherContent(bpmActMsgDetail);
        }
    }

    private void addMessageOtherContent(BpmActMsgDetail bpmActMsgDetail) {
        List receive = bpmActMsgDetail.getReceive();
        for (int i = 0; i < bpmActMsgDetail.getReceive().size(); i += 10) {
            BpmActMsgDetail subBpmActMsgDetail = bpmActMsgDetail.clone();
            if (subBpmActMsgDetail == null) continue;
            ArrayList receiveChild = new ArrayList();
            for (int j = i; j < i + 10 && j < bpmActMsgDetail.getReceive().size(); ++j) {
                receiveChild.add(receive.get(j));
            }
            subBpmActMsgDetail.setReceive(receiveChild);
            if ("qingTui".equals(subBpmActMsgDetail.getChannelType())) {
                this.setQtMessage(subBpmActMsgDetail);
            }
            this.distributeMessage(subBpmActMsgDetail);
        }
    }

    private void setQtMessage(BpmActMsgDetail bpmActMsgDetail) {
        String channelType;
        String sceneCode = bpmActMsgDetail.getSceneCode();
        MsgQingTuiTemplate msgQingTuiTemplate = this.qtTemplate4WorkFlowService.find4WorkFlow(sceneCode, channelType = bpmActMsgDetail.getChannelType());
        if (HussarUtils.isEmpty((Object)msgQingTuiTemplate)) {
            logger.error("\u672a\u627e\u5230\u6a21\u677f\uff0c\u8bf7\u786e\u8ba4\u6a21\u677f\u662f\u5426\u7981\u7528");
        }
        bpmActMsgDetail.setMessage(msgQingTuiTemplate.getContent());
        bpmActMsgDetail.setQtMsgType(msgQingTuiTemplate.getMsgType());
    }

    public void distributeMessage(BpmActMsgDetail bpmActMsgDetail) {
        switch (bpmActMsgDetail.getChannelType()) {
            case "mail": {
                this.publishEmailMessage(bpmActMsgDetail);
                break;
            }
            case "sms": {
                this.publishSmsMessage(bpmActMsgDetail);
                break;
            }
            case "wx_account": {
                this.publishMpMessage(bpmActMsgDetail);
                break;
            }
            case "app_im": {
                this.publishAppImMessage(bpmActMsgDetail);
                break;
            }
            case "app_push": {
                this.publishAppMessage(bpmActMsgDetail);
                break;
            }
            case "cp": {
                this.publishCpMessage(bpmActMsgDetail);
                break;
            }
            case "dingTalk": {
                this.publishDingTalkMessage(bpmActMsgDetail);
                break;
            }
            case "qingTui": {
                this.publishQingTuiMessage(bpmActMsgDetail);
                break;
            }
        }
    }

    private void publishDingTalkMessage(BpmActMsgDetail bpmActMsgDetail) {
        if (this.verifyMessage(bpmActMsgDetail, "dingTalkUserId")) {
            for (PushMsgHandlerService pushMsgHandlerService : this.pushMsgHandlerServices) {
                pushMsgHandlerService.pushDingTalkMsg(bpmActMsgDetail);
            }
        }
    }

    private void publishQingTuiMessage(BpmActMsgDetail bpmActMsgDetail) {
        if (this.verifyMessage(bpmActMsgDetail, "qingTuiUserId")) {
            for (PushMsgHandlerService pushMsgHandlerService : this.pushMsgHandlerServices) {
                pushMsgHandlerService.pushQingTuiMsg(bpmActMsgDetail);
            }
        }
    }

    private void publishEmailMessage(BpmActMsgDetail bpmActMsgDetail) {
        if (this.verifyMessage(bpmActMsgDetail, "email")) {
            for (PushMsgHandlerService pushMsgHandlerService : this.pushMsgHandlerServices) {
                pushMsgHandlerService.pushMsgEmail(bpmActMsgDetail);
            }
        }
    }

    private void publishSmsMessage(BpmActMsgDetail bpmActMsgDetail) {
        if (this.verifyMessage(bpmActMsgDetail, "mobile")) {
            for (PushMsgHandlerService pushMsgHandlerService : this.pushMsgHandlerServices) {
                pushMsgHandlerService.pushMsgSms(bpmActMsgDetail);
            }
        }
    }

    private void publishMpMessage(BpmActMsgDetail bpmActMsgDetail) {
        if (this.verifyMessage(bpmActMsgDetail, "openId")) {
            for (PushMsgHandlerService pushMsgHandlerService : this.pushMsgHandlerServices) {
                pushMsgHandlerService.pushMsgMp(bpmActMsgDetail);
            }
        }
    }

    private void publishCpMessage(BpmActMsgDetail bpmActMsgDetail) {
        if (this.verifyMessage(bpmActMsgDetail, "cpUserId")) {
            for (PushMsgHandlerService pushMsgHandlerService : this.pushMsgHandlerServices) {
                pushMsgHandlerService.pushMsgCp(bpmActMsgDetail);
            }
        }
    }

    private void publishAppImMessage(BpmActMsgDetail bpmActMsgDetail) {
        if (this.verifyMessage(bpmActMsgDetail, "appImUserId")) {
            for (PushMsgHandlerService pushMsgHandlerService : this.pushMsgHandlerServices) {
                pushMsgHandlerService.pushMsgAppIm(bpmActMsgDetail);
            }
        }
    }

    private void publishAppMessage(BpmActMsgDetail bpmActMsgDetail) {
        if (this.verifyMessage(bpmActMsgDetail, "appToken")) {
            for (PushMsgHandlerService pushMsgHandlerService : this.pushMsgHandlerServices) {
                pushMsgHandlerService.pushMsgApp(bpmActMsgDetail);
            }
        }
    }

    private boolean verifyMessage(BpmActMsgDetail bpmActMsgDetail, String elem) {
        HashMap userMsg = new HashMap(bpmActMsgDetail.getUserMsg());
        ArrayList receiveList = new ArrayList(bpmActMsgDetail.getReceive());
        for (String receive : bpmActMsgDetail.getReceive()) {
            if (!HussarUtils.isEmpty(userMsg.get(receive))) continue;
            logger.error("\u6d41\u7a0b[{}]\uff0c\u7528\u6237id[{}]\uff0c\u7f3a\u5c11[{}]\u4fe1\u606f\uff01", new Object[]{bpmActMsgDetail.getProcessKey(), receive, elem});
            userMsg.remove(receive);
            receiveList.remove(receive);
        }
        bpmActMsgDetail.setReceive(receiveList);
        bpmActMsgDetail.setUserMsg(userMsg);
        return HussarUtils.isNotEmpty((Object)bpmActMsgDetail.getReceive());
    }
}

