/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.extend;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.CallActivity;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.IOParameter;
import org.activiti.editor.language.json.converter.BaseBpmnJsonConverter;
import org.activiti.editor.language.json.converter.BpmnJsonConverterUtil;
import org.activiti.editor.language.json.converter.CallActivityJsonConverter;
import org.apache.commons.lang3.StringUtils;

public class ExtendCallActivityJsonConverter
extends CallActivityJsonConverter {
    private static final String CALLACTIVITYCALLEDELEMENT = "callactivitycalledelement";
    private static final String SOURCE = "source";
    private static final String TARGET = "target";
    private static final String SOURCE_EXPRESSION = "sourceExpression";

    public static void fillTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        ExtendCallActivityJsonConverter.fillJsonTypes(convertersToBpmnMap);
        ExtendCallActivityJsonConverter.fillBpmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap) {
        convertersToBpmnMap.put("CallActivity", CallActivityJsonConverter.class);
    }

    public static void fillBpmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        convertersToJsonMap.put(CallActivity.class, CallActivityJsonConverter.class);
    }

    protected String getStencilId(BaseElement baseElement) {
        return "CallActivity";
    }

    protected void convertElementToJson(ObjectNode propertiesNode, BaseElement baseElement) {
        List conditionCallProcessKeyElement;
        List conditionCallAssigneeElement;
        List defaultCallProcessKeyElement;
        List defaultCallAssigneeElement;
        List assigneeNodeElement;
        List extendExecutionListenerElement;
        CallActivity callActivity = (CallActivity)baseElement;
        if (StringUtils.isNotEmpty((CharSequence)callActivity.getCalledElement())) {
            propertiesNode.put(CALLACTIVITYCALLEDELEMENT, callActivity.getCalledElement());
        }
        this.addJsonParameters("callactivityinparameters", "inParameters", callActivity.getInParameters(), propertiesNode);
        this.addJsonParameters("callactivityoutparameters", "outParameters", callActivity.getOutParameters(), propertiesNode);
        Map elementsListMap = callActivity.getExtensionElements();
        if (elementsListMap != null && (extendExecutionListenerElement = (List)elementsListMap.get("extendExecutionListener")) != null && !extendExecutionListenerElement.isEmpty()) {
            ArrayNode itemsNode = this.objectMapper.createArrayNode();
            for (ExtensionElement extensionElement : extendExecutionListenerElement) {
                ObjectNode propertyItemNode = this.objectMapper.createObjectNode();
                Map maps = extensionElement.getAttributes();
                if (HussarUtils.isNotEmpty((Object)maps)) {
                    for (Map.Entry map : maps.entrySet()) {
                        propertyItemNode.put((String)map.getKey(), ((ExtensionAttribute)((List)map.getValue()).get(0)).getValue());
                    }
                }
                itemsNode.add((JsonNode)propertyItemNode);
            }
            propertiesNode.put("extendExecutionListener", (JsonNode)itemsNode);
        }
        if ((assigneeNodeElement = (List)elementsListMap.get("assignmentnode")) != null && !assigneeNodeElement.isEmpty()) {
            List assigneeNodeList;
            String assigneeNodeNode = "";
            Map assigneeNodeMap = ((ExtensionElement)assigneeNodeElement.get(0)).getAttributes();
            if (assigneeNodeMap != null && (assigneeNodeList = (List)assigneeNodeMap.get("assignmentnode")) != null && !assigneeNodeList.isEmpty()) {
                assigneeNodeNode = ((ExtensionAttribute)assigneeNodeList.get(0)).getValue();
            }
            propertiesNode.put("assignmentnode", assigneeNodeNode);
        }
        if ((defaultCallAssigneeElement = (List)elementsListMap.get("defaultCallAssignee")) != null && !defaultCallAssigneeElement.isEmpty()) {
            List defaultCallAssigneeList;
            String defaultCallAssigneeNode = "";
            Map defaultCallAssigneeMap = ((ExtensionElement)defaultCallAssigneeElement.get(0)).getAttributes();
            if (defaultCallAssigneeMap != null && (defaultCallAssigneeList = (List)defaultCallAssigneeMap.get("defaultCallAssignee")) != null && !defaultCallAssigneeList.isEmpty()) {
                defaultCallAssigneeNode = ((ExtensionAttribute)defaultCallAssigneeList.get(0)).getValue();
            }
            propertiesNode.put("defaultCallAssignee", defaultCallAssigneeNode);
        }
        if ((defaultCallProcessKeyElement = (List)elementsListMap.get("defaultCallProcessKey")) != null && !defaultCallProcessKeyElement.isEmpty()) {
            List defaultCallProcessKeyList;
            String defaultCallProcessKeyNode = "";
            Map defaultCallProcessKeyMap = ((ExtensionElement)defaultCallProcessKeyElement.get(0)).getAttributes();
            if (defaultCallProcessKeyMap != null && (defaultCallProcessKeyList = (List)defaultCallProcessKeyMap.get("defaultCallProcessKey")) != null && !defaultCallProcessKeyList.isEmpty()) {
                defaultCallProcessKeyNode = ((ExtensionAttribute)defaultCallProcessKeyList.get(0)).getValue();
            }
            propertiesNode.put("defaultCallProcessKey", defaultCallProcessKeyNode);
        }
        if ((conditionCallAssigneeElement = (List)elementsListMap.get("conditionCallAssign")) != null && !conditionCallAssigneeElement.isEmpty()) {
            List conditionCallAssigneeList;
            String conditionCallAssigneeNode = "";
            Map conditionCallAssigneeMap = ((ExtensionElement)conditionCallAssigneeElement.get(0)).getAttributes();
            if (conditionCallAssigneeMap != null && (conditionCallAssigneeList = (List)conditionCallAssigneeMap.get("conditionCallAssign")) != null && !conditionCallAssigneeList.isEmpty()) {
                conditionCallAssigneeNode = ((ExtensionAttribute)conditionCallAssigneeList.get(0)).getValue();
            }
            propertiesNode.put("conditionCallAssign", conditionCallAssigneeNode);
        }
        if ((conditionCallProcessKeyElement = (List)elementsListMap.get("conditionCallProcessKey")) != null && !conditionCallProcessKeyElement.isEmpty()) {
            List conditionCallProcessKeyList;
            String conditionCallProcessKeyNode = "";
            Map conditionCallProcessKeyMap = ((ExtensionElement)conditionCallProcessKeyElement.get(0)).getAttributes();
            if (conditionCallProcessKeyMap != null && (conditionCallProcessKeyList = (List)conditionCallProcessKeyMap.get("conditionCallProcessKey")) != null && !conditionCallProcessKeyList.isEmpty()) {
                conditionCallProcessKeyNode = ((ExtensionAttribute)conditionCallProcessKeyList.get(0)).getValue();
            }
            propertiesNode.put("conditionCallProcessKey", conditionCallProcessKeyNode);
        }
    }

    private void addJsonParameters(String propertyName, String valueName, List<IOParameter> parameterList, ObjectNode propertiesNode) {
        ObjectNode parametersNode = this.objectMapper.createObjectNode();
        ArrayNode itemsNode = this.objectMapper.createArrayNode();
        for (IOParameter parameter : parameterList) {
            ObjectNode parameterItemNode = this.objectMapper.createObjectNode();
            if (StringUtils.isNotEmpty((CharSequence)parameter.getSource())) {
                parameterItemNode.put(SOURCE, parameter.getSource());
            } else {
                parameterItemNode.putNull(SOURCE);
            }
            if (StringUtils.isNotEmpty((CharSequence)parameter.getTarget())) {
                parameterItemNode.put(TARGET, parameter.getTarget());
            } else {
                parameterItemNode.putNull(TARGET);
            }
            if (StringUtils.isNotEmpty((CharSequence)parameter.getSourceExpression())) {
                parameterItemNode.put(SOURCE_EXPRESSION, parameter.getSourceExpression());
            } else {
                parameterItemNode.putNull(SOURCE_EXPRESSION);
            }
            itemsNode.add((JsonNode)parameterItemNode);
        }
        parametersNode.put(valueName, (JsonNode)itemsNode);
        propertiesNode.put(propertyName, (JsonNode)parametersNode);
    }

    protected FlowElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, Map<String, JsonNode> shapeMap) {
        CallActivity callActivity = new CallActivity();
        if (StringUtils.isNotEmpty((CharSequence)this.getPropertyValueAsString(CALLACTIVITYCALLEDELEMENT, elementNode))) {
            callActivity.setCalledElement(this.getPropertyValueAsString(CALLACTIVITYCALLEDELEMENT, elementNode));
        }
        callActivity.getInParameters().addAll(this.convertToIOParameters("callactivityinparameters", "inParameters", elementNode));
        callActivity.getOutParameters().addAll(this.convertToIOParameters("callactivityoutparameters", "outParameters", elementNode));
        ArrayNode executionListener = (ArrayNode)this.getProperty("extendExecutionListener", elementNode);
        if (HussarUtils.isNotEmpty((Object)executionListener)) {
            for (JsonNode jsonNode : executionListener) {
                ExtensionElement extensionElement = new ExtensionElement();
                extensionElement.setName("extendExecutionListener");
                extensionElement.setNamespacePrefix("extend");
                extensionElement.setNamespace("http://activiti.org/bpmn");
                ExtensionAttribute eventAttribute = new ExtensionAttribute();
                eventAttribute.setName("event");
                eventAttribute.setValue(jsonNode.get("event").toString().replace("\"", ""));
                extensionElement.addAttribute(eventAttribute);
                ExtensionAttribute typeAttribute = new ExtensionAttribute();
                typeAttribute.setName("type");
                typeAttribute.setValue(jsonNode.get("type").toString().replace("\"", ""));
                extensionElement.addAttribute(typeAttribute);
                ExtensionAttribute urlAttribute = new ExtensionAttribute();
                urlAttribute.setName("url");
                urlAttribute.setValue(jsonNode.get("url").toString().replace("\"", ""));
                extensionElement.addAttribute(urlAttribute);
                callActivity.addExtensionElement(extensionElement);
            }
        }
        ExtensionElement extensionElementNode = new ExtensionElement();
        ExtensionAttribute extensionAttributeNode = new ExtensionAttribute();
        String assignmentnode = this.getPropertyValueAsString("assignmentnode", elementNode);
        extensionElementNode.setName("assignmentnode");
        extensionElementNode.setNamespacePrefix("extend");
        extensionElementNode.setNamespace("http://activiti.org/bpmn");
        extensionAttributeNode.setName("assignmentnode");
        extensionAttributeNode.setValue(assignmentnode);
        extensionElementNode.addAttribute(extensionAttributeNode);
        callActivity.addExtensionElement(extensionElementNode);
        String defaultCallAssigneeNode = this.getPropertyValueAsString("defaultCallAssignee", elementNode);
        ExtensionElement defaultCallAssigneeElement = new ExtensionElement();
        ExtensionAttribute defaultCallAssigneeAttribute = new ExtensionAttribute();
        defaultCallAssigneeElement.setName("defaultCallAssignee");
        defaultCallAssigneeElement.setNamespacePrefix("extend");
        defaultCallAssigneeElement.setNamespace("http://activiti.org/bpmn");
        defaultCallAssigneeAttribute.setName("defaultCallAssignee");
        defaultCallAssigneeAttribute.setValue(defaultCallAssigneeNode);
        defaultCallAssigneeElement.addAttribute(defaultCallAssigneeAttribute);
        callActivity.addExtensionElement(defaultCallAssigneeElement);
        String defaultCallProcessKeyNode = this.getPropertyValueAsString("defaultCallProcessKey", elementNode);
        ExtensionElement defaultCallProcessKeyElement = new ExtensionElement();
        ExtensionAttribute defaultCallProcessKeyAttribute = new ExtensionAttribute();
        defaultCallProcessKeyElement.setName("defaultCallProcessKey");
        defaultCallProcessKeyElement.setNamespacePrefix("extend");
        defaultCallProcessKeyElement.setNamespace("http://activiti.org/bpmn");
        defaultCallProcessKeyAttribute.setName("defaultCallProcessKey");
        defaultCallProcessKeyAttribute.setValue(defaultCallProcessKeyNode);
        defaultCallProcessKeyElement.addAttribute(defaultCallProcessKeyAttribute);
        callActivity.addExtensionElement(defaultCallProcessKeyElement);
        String conditionCallAssigneeNode = this.getPropertyValueAsString("conditionCallAssign", elementNode);
        ExtensionElement conditionCallAssigneeElement = new ExtensionElement();
        ExtensionAttribute conditionCallAssigneeAttribute = new ExtensionAttribute();
        conditionCallAssigneeElement.setName("conditionCallAssign");
        conditionCallAssigneeElement.setNamespacePrefix("extend");
        conditionCallAssigneeElement.setNamespace("http://activiti.org/bpmn");
        conditionCallAssigneeAttribute.setName("conditionCallAssign");
        conditionCallAssigneeAttribute.setValue(conditionCallAssigneeNode);
        conditionCallAssigneeElement.addAttribute(conditionCallAssigneeAttribute);
        callActivity.addExtensionElement(conditionCallAssigneeElement);
        String conditionCallProcessKeyNode = this.getPropertyValueAsString("conditionCallProcessKey", elementNode);
        ExtensionElement conditionCallProcessKeyElement = new ExtensionElement();
        ExtensionAttribute conditionCallProcessKeyAttribute = new ExtensionAttribute();
        conditionCallProcessKeyElement.setName("conditionCallProcessKey");
        conditionCallProcessKeyElement.setNamespacePrefix("extend");
        conditionCallProcessKeyElement.setNamespace("http://activiti.org/bpmn");
        conditionCallProcessKeyAttribute.setName("conditionCallProcessKey");
        conditionCallProcessKeyAttribute.setValue(conditionCallProcessKeyNode);
        conditionCallProcessKeyElement.addAttribute(conditionCallProcessKeyAttribute);
        callActivity.addExtensionElement(conditionCallProcessKeyElement);
        return callActivity;
    }

    private List<IOParameter> convertToIOParameters(String propertyName, String valueName, JsonNode elementNode) {
        JsonNode itemsArrayNode;
        ArrayList<IOParameter> ioParameters = new ArrayList<IOParameter>();
        JsonNode parametersNode = this.getProperty(propertyName, elementNode);
        if (parametersNode != null && (itemsArrayNode = (parametersNode = BpmnJsonConverterUtil.validateIfNodeIsTextual((JsonNode)parametersNode)).get(valueName)) != null) {
            Iterator var7 = itemsArrayNode.iterator();
            while (true) {
                if (!var7.hasNext()) {
                    return ioParameters;
                }
                JsonNode itemNode = (JsonNode)var7.next();
                JsonNode sourceNode = itemNode.get(SOURCE);
                JsonNode sourceExpressionNode = itemNode.get(SOURCE_EXPRESSION);
                if ((sourceNode == null || !StringUtils.isNotEmpty((CharSequence)sourceNode.asText())) && (sourceExpressionNode == null || !StringUtils.isNotEmpty((CharSequence)sourceExpressionNode.asText()))) continue;
                IOParameter parameter = new IOParameter();
                if (StringUtils.isNotEmpty((CharSequence)this.getValueAsString(SOURCE, itemNode))) {
                    parameter.setSource(this.getValueAsString(SOURCE, itemNode));
                } else if (StringUtils.isNotEmpty((CharSequence)this.getValueAsString(SOURCE_EXPRESSION, itemNode))) {
                    parameter.setSourceExpression(this.getValueAsString(SOURCE_EXPRESSION, itemNode));
                }
                if (StringUtils.isNotEmpty((CharSequence)this.getValueAsString(TARGET, itemNode))) {
                    parameter.setTarget(this.getValueAsString(TARGET, itemNode));
                }
                ioParameters.add(parameter);
            }
        }
        return ioParameters;
    }
}

