/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.common.properties;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.bpmconfig.service.IBpmConfigService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmYmlConfigurationProperties;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class LcdpBpmProperties {
    private final IBpmConfigService bpmConfigService;
    private final BpmYmlConfigurationProperties bpmYmlConfigurationProperties;

    public LcdpBpmProperties(IBpmConfigService bpmConfigService, BpmYmlConfigurationProperties bpmYmlConfigurationProperties) {
        this.bpmConfigService = bpmConfigService;
        this.bpmYmlConfigurationProperties = bpmYmlConfigurationProperties;
    }

    public boolean isModifyConfigurationOnline() {
        return true;
    }

    public boolean isEditableOnline() {
        return false;
    }

    public String getDeploymentModel() {
        return this.bpmYmlConfigurationProperties.getDeploymentModel();
    }

    public int getReadTimeOut() {
        return (int)this.bpmConfigService.getLongByKeyUseCache("read_timeout");
    }

    public int getConnectionTimeOut() {
        return (int)this.bpmConfigService.getLongByKeyUseCache("connection_timeout");
    }

    public String getCompleteHistoryOrderingRule() {
        return this.bpmConfigService.getStringByKeyUseCache("complete_history_ordering_rule");
    }

    public boolean isUseSecurityLevel() {
        return this.bpmConfigService.getBooleanByKeyUseCache("use_security_level");
    }

    public boolean isUseDatapush() {
        return this.bpmConfigService.getBooleanByKeyUseCache("use_data_push");
    }

    public String getUnifiedTodoServerName() {
        return this.bpmConfigService.getStringByKeyUseCache("unified_todo_server_name");
    }

    public String getTenantCallAddress() {
        String address = this.bpmConfigService.getStringByKeyUseCache("tenant_call_address");
        if (HussarUtils.isNotEmpty((Object)address) && address.endsWith("/")) {
            return address.substring(0, address.length() - 1);
        }
        return address;
    }

    public String getAssigneeMode() {
        return this.bpmConfigService.getStringByKeyUseCache("assignee_mode");
    }

    public String getRemoteDBName() {
        return this.bpmConfigService.getStringByKeyUseCache("remote_db_name");
    }

    public String getTenantType() {
        if (this.isWorkflowPlatformStandalone()) {
            return this.bpmConfigService.getStringByKeyUseCache("tenant_type");
        }
        return "base";
    }

    public boolean isWorkflowPlatformStandalone() {
        return this.bpmYmlConfigurationProperties.isWorkflowPlatformStandalone();
    }

    public boolean isTenantIsBase() {
        return !this.isWorkflowPlatformStandalone() || !"external".equals(this.getTenantType());
    }

    public String getTenantDBPrimaryKeyType() {
        return this.bpmConfigService.getStringByKeyUseCache("tenant_db_primary_key_type");
    }

    public boolean getTenantDBPrimaryKeyIsLong() {
        return "long".equals(this.getTenantDBPrimaryKeyType());
    }

    public Map<String, String> getNodeColourMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("finish", this.bpmConfigService.getStringByKeyUseCache("finish_node_colour"));
        map.put("complete", this.bpmConfigService.getStringByKeyUseCache("complete_node_colour"));
        map.put("reject", this.bpmConfigService.getStringByKeyUseCache("reject_node_colour"));
        map.put("suspend", this.bpmConfigService.getStringByKeyUseCache("suspend_node_colour"));
        map.put("overtime", this.bpmConfigService.getStringByKeyUseCache("overtime_node_colour"));
        map.put("next", this.bpmConfigService.getStringByKeyUseCache("next_node_colour"));
        return map;
    }
}

