/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.ProcessNode;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.IInstanceEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.WorkFlow;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowModel;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowProps;
import com.jxdinfo.hussar.workflow.engine.flowmodel.ProcessBinding;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.manage.util.BpmSpringContextHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.EndEvent;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.activiti.engine.impl.persistence.entity.HistoricProcessInstanceEntityManager;
import org.activiti.engine.impl.persistence.entity.TaskEntity;

public class ProcessNodeCmd
implements Command<Void> {
    private static LcdpBpmProperties lcdpBpmProperties = (LcdpBpmProperties)BpmSpringContextHolder.getBean(LcdpBpmProperties.class);
    private static IInstanceEngineService instanceEngineService = (IInstanceEngineService)BpmSpringContextHolder.getBean(IInstanceEngineService.class);
    private static DataPushService dataPushService = (DataPushService)BpmSpringContextHolder.getBean(DataPushService.class);
    private static RepositoryService repositoryService = (RepositoryService)BpmSpringContextHolder.getBean(RepositoryService.class);
    private static SysActProcessFileService sysActProcessFileService = (SysActProcessFileService)BpmSpringContextHolder.getBean(SysActProcessFileService.class);
    private String processInstanceId;
    private String processDefinitionId;
    private int type;

    public ProcessNodeCmd(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public ProcessNodeCmd(String processInstanceId, int type) {
        this.processInstanceId = processInstanceId;
        this.type = type;
    }

    public ProcessNodeCmd(String processInstanceId, String processDefinitionId, int type) {
        this.processInstanceId = processInstanceId;
        this.processDefinitionId = processDefinitionId;
        this.type = type;
    }

    public Void execute(CommandContext commandContext) {
        HistoricProcessInstanceEntityManager historicProcessInstanceEntityManager = commandContext.getHistoricProcessInstanceEntityManager();
        HistoricProcessInstanceEntity historicProcessInstance = historicProcessInstanceEntityManager.findHistoricProcessInstance(this.processInstanceId);
        String tableName = this.getTableName(historicProcessInstance.getProcessDefinitionId());
        if (HussarUtils.isEmpty((Object)tableName) && !this.isBackFill(historicProcessInstance.getProcessDefinitionId())) {
            return null;
        }
        ArrayList<Object> processNodeList = new ArrayList<Object>();
        if (this.type == 2) {
            List tasks = commandContext.getTaskEntityManager().findTasksByProcessInstanceIdFromCache(this.processInstanceId);
            for (TaskEntity taskEntity : tasks) {
                ProcessNode processNode = new ProcessNode();
                processNode.setTaskDefinitionKey(taskEntity.getTaskDefinitionKey());
                processNode.setTaskDefinitionName(taskEntity.getName());
                processNodeList.add(processNode);
            }
        } else if (this.type == 1) {
            BpmnModel bm = repositoryService.getBpmnModel(this.processDefinitionId);
            Process process = (Process)bm.getProcesses().get(0);
            Collection flowElements = process.getFlowElements();
            for (FlowElement flowElement : flowElements) {
                if (!(flowElement instanceof EndEvent)) continue;
                ProcessNode processNode = new ProcessNode();
                processNode.setTaskDefinitionKey(flowElement.getId());
                processNode.setTaskDefinitionName(flowElement.getName());
                processNodeList.add(processNode);
                break;
            }
        } else {
            JSONObject jsonObject;
            Object currentNodes;
            while (historicProcessInstance.getEndTime() != null && historicProcessInstance.getSuperProcessInstanceId() != null) {
                this.processInstanceId = historicProcessInstance.getSuperProcessInstanceId();
                historicProcessInstance = historicProcessInstanceEntityManager.findHistoricProcessInstance(this.processInstanceId);
            }
            if (historicProcessInstance.getEndTime() != null) {
                return null;
            }
            BpmResponseResult result = instanceEngineService.queryCurrentNodes(this.processInstanceId, null);
            JSONArray jsonArray = result.getResult();
            if (HussarUtils.isNotEmpty((Object)jsonArray) && (currentNodes = (jsonObject = jsonArray.getJSONObject(0)).get((Object)"currentNodes")) instanceof List) {
                for (Object o : (List)currentNodes) {
                    processNodeList.add(ProcessNode.class.cast(o));
                }
            }
        }
        if (HussarUtils.isNotEmpty(processNodeList)) {
            DataPush dataPush = new DataPush();
            dataPush.setProcessDefinitionId(historicProcessInstance.getProcessDefinitionId());
            dataPush.setBusinessKey(historicProcessInstance.getBusinessKey());
            dataPush.setProcessNodeList(processNodeList);
            String processKey = historicProcessInstance.getProcessDefinitionId().split(":")[0];
            dataPush.setProcessKey(processKey);
            dataPush.setProcessInsId(historicProcessInstance.getId());
            dataPush.setProcessStartTime(historicProcessInstance.getStartTime());
            dataPush.setDueDate(historicProcessInstance.getDueDate());
            dataPush.setStartUserId(historicProcessInstance.getStartUserId());
            dataPushService.changeProcessNode(dataPush);
        }
        return null;
    }

    public String getTableName(String processDefinitionId) {
        WorkFlow workFlow = sysActProcessFileService.getFileByProcessDefId(processDefinitionId);
        String wfdFile = workFlow.getData();
        FlowModel parse = (FlowModel)JSONObject.parseObject((String)wfdFile, FlowModel.class);
        FlowProps props = parse.getProps();
        ProcessBinding processBinding = props.getProcessBinding();
        if (processBinding == null) {
            return null;
        }
        String mainTableName = processBinding.getMainTableName();
        String taskTableName = processBinding.getTaskTableName();
        String mainTableBusinessKey = processBinding.getMainTableBusinessKey();
        if (HussarUtils.isEmpty((Object)mainTableName) || HussarUtils.isEmpty((Object)taskTableName) || HussarUtils.isEmpty((Object)mainTableBusinessKey)) {
            return null;
        }
        return mainTableName + "," + taskTableName + "," + mainTableBusinessKey;
    }

    private boolean isBackFill(String processDefinitionId) {
        boolean isBackFill = false;
        BpmnModel bm = repositoryService.getBpmnModel(processDefinitionId);
        Map extensionElementList = ((Process)bm.getProcesses().get(0)).getExtensionElements();
        List isBackFillElement = (List)extensionElementList.get("isBackfill");
        if (HussarUtils.isNotEmpty((Object)isBackFillElement) && HussarUtils.isNotEmpty(((ExtensionElement)isBackFillElement.get(0)).getAttributes().get("isBackfill"))) {
            String isBackFillText = ((ExtensionAttribute)((List)((ExtensionElement)isBackFillElement.get(0)).getAttributes().get("isBackfill")).get(0)).getValue();
            isBackFill = Boolean.valueOf(isBackFillText);
        }
        return isBackFill;
    }
}

