/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.migration.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jxdinfo.hussar.common.utils.IdempotentJsonUtils;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.workflow.activiti.dao.BpmActGeBytearrayMapper;
import com.jxdinfo.hussar.workflow.activiti.model.BpmActGeBytearray;
import com.jxdinfo.hussar.workflow.common.InstallResult;
import com.jxdinfo.hussar.workflow.engine.bpm.check.service.impl.ProcessCheckServiceImpl;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.dao.ProcessDefinitionsMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.model.DefinitionModel;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.model.ImportDefinitionModel;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.model.ProcessDefinitionModel;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.DeleteProcessDefinitionCacheCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.extend.ExtendBpmnJsonConverter;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.model.SysActExtendProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.service.impl.SysActExtendPropertiesServiceImpl;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.dto.WorkflowDumpDto;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.dto.WorkflowLoadDto;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.dto.WorkflowPreloadDto;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.dto.WorkflowQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.service.IWorkflowMigrationService;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.vo.WorkflowDumpVo;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.vo.WorkflowLoadVo;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.vo.WorkflowMigrationPreloadVo;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.vo.WorkflowQueryVo;
import com.jxdinfo.hussar.workflow.engine.bpm.model.dao.ModelMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.model.dao.WorkflowMigrationMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.ExportModel;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.SysActAssignee;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.SysActFormAuth;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.SysActHandleAuth;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.WorkFlow;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysActAssigneeService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysActFormAuthService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysActHandleAuthService;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.dao.SysActProcessFileMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.model.SysActProcessFile;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.workflow.engine.flowmodel.BpmNodeTypeUtil;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.dao.Bpm2XMLMapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.activiti.bpmn.converter.BpmnXMLConverter;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.Process;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.repository.Model;
import org.activiti.explorer.util.XmlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class WorkflowMigrationServiceImpl
implements IWorkflowMigrationService {
    private static final Logger logger = LoggerFactory.getLogger(WorkflowMigrationServiceImpl.class);
    @Autowired
    private SysActAssigneeService sysActAssigneeService;
    @Autowired
    private SysActFormAuthService sysActFormAuthService;
    @Autowired
    private SysActExtendPropertiesServiceImpl sysActExtendPropertiesService;
    @Autowired
    private SysActProcessFileService sysActProcessFileService;
    @Autowired
    private ModelService modelService;
    @Autowired
    private SysActHandleAuthService handleAuthService;
    @Resource
    private ProcessDefinitionsMapper processDefinitionsMapper;
    @Resource
    private ProcessEngine processEngine;
    @Resource
    private ModelMapper modelMapper;
    @Resource
    private SysActProcessFileMapper sysActProcessFileMapper;
    @Resource
    private WorkflowMigrationMapper workflowMigrationMapper;
    @Resource
    private BpmActGeBytearrayMapper bpmActGeBytearrayMapper;
    @Resource
    private Bpm2XMLMapper bpm2XMLMapper;
    @Resource
    private RepositoryService repositoryService;
    @Autowired
    private ProcessCheckServiceImpl processCheckService;

    public List<WorkflowDumpVo> dump(List<WorkflowDumpDto> workflowDumpDtos) {
        ArrayList<String> processKeys = new ArrayList<String>();
        for (WorkflowDumpDto workflowDumpDto : workflowDumpDtos) {
            processKeys.add(workflowDumpDto.getProcessKey());
        }
        List<ExportModel> list = this.modelMapper.selectModelNames(processKeys);
        HashMap<String, String> serviceNameMap = new HashMap<String, String>();
        for (ExportModel exportModel : list) {
            serviceNameMap.put(exportModel.getBusinessId(), exportModel.getCategory());
        }
        ArrayList<WorkflowDumpVo> workflowDumpVoList = new ArrayList<WorkflowDumpVo>();
        for (WorkflowDumpDto workflowDumpDto : workflowDumpDtos) {
            WorkflowDumpVo workflowDumpVo;
            String processKey = workflowDumpDto.getProcessKey();
            int version = workflowDumpDto.getVersion();
            if (workflowDumpDto.getExportData().getAssigneeData().booleanValue()) {
                List sysActAssignees = this.sysActAssigneeService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActAssignee::getProcDefKey, (Object)processKey)).eq(SysActAssignee::getProcessVersion, (Object)version));
                workflowDumpVo = new WorkflowDumpVo(workflowDumpDto, IdempotentJsonUtils.toString((Object)sysActAssignees), "\u53c2\u4e0e\u8005.json", (String)serviceNameMap.get(processKey));
                workflowDumpVoList.add(workflowDumpVo);
            }
            if (workflowDumpDto.getExportData().getFormAuthData().booleanValue()) {
                List sysActFormAuths = this.sysActFormAuthService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActFormAuth::getProcessKey, (Object)processKey)).and(wrapper -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(SysActFormAuth::getProcessVersion, (Object)version)).or()).isNull(SysActFormAuth::getProcessVersion);
                }));
                ArrayList<SysActFormAuth> result = new ArrayList<SysActFormAuth>();
                for (SysActFormAuth sysActFormAuth : sysActFormAuths) {
                    if (sysActFormAuth.getProcessVersion() == null) continue;
                    result.add(sysActFormAuth);
                }
                if (result.isEmpty()) {
                    result.addAll(sysActFormAuths);
                }
                WorkflowDumpVo workflowDumpVo2 = new WorkflowDumpVo(workflowDumpDto, IdempotentJsonUtils.toString(result), "\u8868\u5355\u6743\u9650.json", (String)serviceNameMap.get(processKey));
                workflowDumpVoList.add(workflowDumpVo2);
            }
            if (workflowDumpDto.getExportData().getWorkflowData().booleanValue()) {
                List sysActExtendProperties = this.sysActExtendPropertiesService.list((Wrapper)new LambdaQueryWrapper().eq(SysActExtendProperties::getProcDefId, (Object)workflowDumpDto.getProcessDefId()));
                WorkflowDumpVo extendPropertiesDumpVo = new WorkflowDumpVo(workflowDumpDto, IdempotentJsonUtils.toString((Object)sysActExtendProperties), "\u62d3\u5c55.json", (String)serviceNameMap.get(processKey));
                workflowDumpVoList.add(extendPropertiesDumpVo);
                List sysActProcessFiles = this.sysActProcessFileService.list((Wrapper)new LambdaQueryWrapper().eq(SysActProcessFile::getProcessId, (Object)workflowDumpDto.getProcessDefId()));
                this.removeProcessFileAssignee(sysActProcessFiles);
                WorkflowDumpVo sysActProcessFilesDumpVo = new WorkflowDumpVo(workflowDumpDto, IdempotentJsonUtils.toString((Object)sysActProcessFiles), "\u6d41\u7a0b\u6587\u4ef6.lcdpbpm", (String)serviceNameMap.get(processKey));
                workflowDumpVoList.add(sysActProcessFilesDumpVo);
                InputStream resourceAsStream = this.processEngine.getProcessEngineConfiguration().getRepositoryService().getProcessModel(workflowDumpDto.getProcessDefId());
                String xmlByteString = null;
                try {
                    int temp;
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    byte[] bytes = new byte[2048];
                    while ((temp = resourceAsStream.read(bytes)) != -1) {
                        outputStream.write(bytes, 0, temp);
                    }
                    byte[] finalBytes = outputStream.toByteArray();
                    xmlByteString = new String(finalBytes);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                WorkflowDumpVo xmlDumpVo = new WorkflowDumpVo(workflowDumpDto, xmlByteString, "bpmn20.xml", (String)serviceNameMap.get(processKey));
                workflowDumpVoList.add(xmlDumpVo);
            }
            if (!workflowDumpDto.getExportData().getHandleAuthData().booleanValue()) continue;
            List handleAuthList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.handleAuthService.lambdaQuery().eq(SysActHandleAuth::getProcessKey, (Object)processKey)).eq(SysActHandleAuth::getProcessVersion, (Object)version)).list();
            workflowDumpVo = new WorkflowDumpVo(workflowDumpDto, IdempotentJsonUtils.toString((Object)handleAuthList), "\u8868\u5355\u6743\u9650.json", (String)serviceNameMap.get(processKey));
            workflowDumpVoList.add(workflowDumpVo);
        }
        return workflowDumpVoList;
    }

    public List<WorkflowMigrationPreloadVo> preload(List<WorkflowPreloadDto> workflowPreloadDtos) {
        ArrayList<WorkflowMigrationPreloadVo> result = new ArrayList<WorkflowMigrationPreloadVo>();
        ArrayList<String> processKeys = new ArrayList<String>();
        for (WorkflowPreloadDto workflowPreloadDto : workflowPreloadDtos) {
            processKeys.add(workflowPreloadDto.getProcessKey());
        }
        List<DefinitionModel> list = this.processDefinitionsMapper.getProcessMsgByProcessKeys(processKeys);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (DefinitionModel definitionModel : list) {
            map.put(definitionModel.getMykey(), Integer.parseInt(definitionModel.getVersion()));
        }
        for (WorkflowPreloadDto workflowPreloadDto : workflowPreloadDtos) {
            WorkflowMigrationPreloadVo workflowMigrationPreloadVo = new WorkflowMigrationPreloadVo(workflowPreloadDto, (Integer)map.get(workflowPreloadDto.getProcessKey()));
            result.add(workflowMigrationPreloadVo);
        }
        return result;
    }

    public List<WorkflowLoadVo> load(WorkflowLoadDto workflowLoadDto) {
        HashMap<String, String> overrideProcessDefIdMap = new HashMap<String, String>();
        Map importMap = workflowLoadDto.getImportMsgMap();
        Map serviceNameMap = workflowLoadDto.getServiceNameMap();
        HashMap<String, String> importResult = new HashMap<String, String>();
        if (importMap != null) {
            for (String processKey : importMap.keySet()) {
                Map workflowFile = (Map)workflowLoadDto.getWorkflowFiles().get(processKey);
                if (workflowFile == null) continue;
                String lcpbBpmFile = (String)workflowFile.get("\u6d41\u7a0b\u6587\u4ef6.lcdpbpm");
                String xml = (String)workflowFile.get("bpmn20.xml");
                String type = ((WorkflowMigrationPreloadVo)importMap.get(processKey)).getImportType();
                if ("unable".equals(type)) continue;
                ApiResponse<String> apiResponse = this.importModel(xml, lcpbBpmFile, (String)serviceNameMap.get(processKey), "override".equals(type));
                if (!apiResponse.isSuccess()) {
                    importResult.put(processKey, apiResponse.getMsg());
                    continue;
                }
                overrideProcessDefIdMap.put(processKey, apiResponse.getMsg());
            }
        }
        HashSet<String> errorImportKeySet = new HashSet<String>(importResult.keySet());
        ArrayList<Map<String, Object>> process = new ArrayList<Map<String, Object>>();
        HashMap<String, Integer> overrideProcessVersionMap = new HashMap<String, Integer>();
        for (WorkflowMigrationPreloadVo workflowMigrationPreloadVo : workflowLoadDto.getImportMsgMap().values()) {
            String importType = workflowMigrationPreloadVo.getImportType();
            if ("override".equals(importType)) {
                HashMap<String, Object> processMap = new HashMap<String, Object>();
                processMap.put("processKey", workflowMigrationPreloadVo.getProcessKey());
                processMap.put("version", workflowMigrationPreloadVo.getTenantVersion());
                overrideProcessVersionMap.put(workflowMigrationPreloadVo.getProcessKey(), workflowMigrationPreloadVo.getTenantVersion());
                process.add(processMap);
                continue;
            }
            if (!"unable".equals(importType)) continue;
            errorImportKeySet.add(workflowMigrationPreloadVo.getProcessKey());
        }
        if (!process.isEmpty()) {
            List<ImportDefinitionModel> newProcessMap = this.processDefinitionsMapper.getProcessDefinitions(process);
            for (ImportDefinitionModel importDefinitionModelMap : newProcessMap) {
                overrideProcessDefIdMap.put(importDefinitionModelMap.getProcessKey(), importDefinitionModelMap.getProcessDefinition());
            }
        }
        this.importAssignee(workflowLoadDto, errorImportKeySet, overrideProcessVersionMap);
        this.importFormAuth(workflowLoadDto, errorImportKeySet, overrideProcessVersionMap);
        this.importHandleAuth(workflowLoadDto, errorImportKeySet, overrideProcessVersionMap);
        this.importExtendProperties(workflowLoadDto, errorImportKeySet, overrideProcessDefIdMap);
        ArrayList<WorkflowLoadVo> workflowLoadVos = new ArrayList<WorkflowLoadVo>();
        for (WorkflowMigrationPreloadVo workflowMigrationPreloadVo : workflowLoadDto.getImportMsgs()) {
            WorkflowLoadVo workflowLoadVo = new WorkflowLoadVo(workflowMigrationPreloadVo);
            if (importResult.containsKey(workflowLoadVo.getProcessKey())) {
                workflowLoadVo.setImportResult("fail");
                workflowLoadVo.setFailReason((String)importResult.get(workflowLoadVo.getProcessKey()));
            }
            workflowLoadVos.add(workflowLoadVo);
        }
        return workflowLoadVos;
    }

    private void importAssignee(WorkflowLoadDto workflowLoadDto, Set<String> errorImportKeyList, Map<String, Integer> overrideProcessVersionMap) {
        HashMap<String, Integer> importAssignee = new HashMap<String, Integer>();
        for (Object workflow : workflowLoadDto.getImportMsgs()) {
            if (!workflow.getExportData().getAssigneeData().booleanValue() || errorImportKeyList.contains(workflow.getProcessKey())) continue;
            importAssignee.put(workflow.getProcessKey(), workflow.getImportVersion());
        }
        if (!importAssignee.isEmpty()) {
            LambdaQueryWrapper removeWrapper = new LambdaQueryWrapper();
            for (Map.Entry entry : importAssignee.entrySet()) {
                removeWrapper.or(wp -> {
                    wp.eq(SysActAssignee::getProcDefKey, formAuthImport.getKey());
                    if (overrideProcessVersionMap.containsKey(formAuthImport.getKey())) {
                        wp.eq(SysActAssignee::getProcessVersion, overrideProcessVersionMap.get(formAuthImport.getKey()));
                    } else {
                        wp.eq(SysActAssignee::getProcessVersion, formAuthImport.getValue());
                    }
                });
            }
            this.sysActAssigneeService.remove((Wrapper)removeWrapper);
            if (!workflowLoadDto.getAssigneeMsgs().isEmpty()) {
                ArrayList actAssignees = new ArrayList();
                for (String assignee : workflowLoadDto.getAssigneeMsgs()) {
                    String processKey;
                    List list = JSON.parseArray((String)assignee, SysActAssignee.class);
                    if (list.isEmpty() || errorImportKeyList.contains(processKey = ((SysActAssignee)list.get(0)).getProcDefKey())) continue;
                    if (overrideProcessVersionMap.containsKey(processKey)) {
                        list.forEach(sysActAssignee -> {
                            if (overrideProcessVersionMap.containsKey(sysActAssignee.getProcDefKey())) {
                                sysActAssignee.setProcessVersion((Integer)overrideProcessVersionMap.get(processKey));
                            }
                        });
                    }
                    actAssignees.addAll(list);
                }
                if (!actAssignees.isEmpty()) {
                    for (SysActAssignee sysActAssignee2 : actAssignees) {
                        sysActAssignee2.setId(null);
                    }
                    this.sysActAssigneeService.saveBatch(actAssignees);
                }
            }
        }
    }

    private void importFormAuth(WorkflowLoadDto workflowLoadDto, Set<String> errorImportKeyList, Map<String, Integer> overrideProcessVersionMap) {
        HashMap<String, Integer> importFormAuth = new HashMap<String, Integer>();
        for (Object workflow : workflowLoadDto.getImportMsgs()) {
            if (!workflow.getExportData().getFormAuthData().booleanValue() || errorImportKeyList.contains(workflow.getProcessKey())) continue;
            importFormAuth.put(workflow.getProcessKey(), workflow.getImportVersion());
        }
        if (!importFormAuth.isEmpty()) {
            LambdaQueryWrapper removeWrapper = new LambdaQueryWrapper();
            for (Map.Entry entry : importFormAuth.entrySet()) {
                removeWrapper.or(wp -> {
                    wp.eq(SysActFormAuth::getProcessKey, entry.getKey());
                    if (overrideProcessVersionMap.containsKey(entry.getKey())) {
                        wp.eq(SysActFormAuth::getProcessVersion, overrideProcessVersionMap.get(entry.getKey()));
                    } else {
                        wp.eq(SysActFormAuth::getProcessVersion, entry.getValue());
                    }
                });
            }
            if (!workflowLoadDto.getFormAuthMsgs().isEmpty()) {
                ArrayList formAuths = new ArrayList();
                for (String formAuth : workflowLoadDto.getFormAuthMsgs()) {
                    String processKey;
                    List list = JSON.parseArray((String)formAuth, SysActFormAuth.class);
                    if (list.isEmpty() || errorImportKeyList.contains(processKey = ((SysActFormAuth)list.get(0)).getProcessKey())) continue;
                    if (overrideProcessVersionMap.containsKey(processKey)) {
                        list.forEach(sysActFormAuth -> {
                            if (overrideProcessVersionMap.containsKey(sysActFormAuth.getProcessKey())) {
                                sysActFormAuth.setProcessVersion((Integer)overrideProcessVersionMap.get(processKey));
                            }
                        });
                    }
                    formAuths.addAll(list);
                }
                if (!formAuths.isEmpty()) {
                    for (String formAuth : formAuths) {
                        formAuth.setId(null);
                    }
                    List list = this.sysActFormAuthService.list((Wrapper)removeWrapper);
                    ArrayList<Long> removeIds = new ArrayList<Long>();
                    block4: for (SysActFormAuth sysActFormAuth2 : formAuths) {
                        for (SysActFormAuth oldFormAuth : list) {
                            if (!this.isSameFormAuthMsg(oldFormAuth, sysActFormAuth2)) continue;
                            removeIds.add(oldFormAuth.getId());
                            continue block4;
                        }
                    }
                    List<List<Long>> removeIdList = this.getInList(removeIds);
                    for (List<Long> removeId : removeIdList) {
                        this.sysActFormAuthService.removeByIds(removeId);
                    }
                    this.sysActFormAuthService.saveBatch(formAuths);
                }
            }
        }
    }

    private boolean isSameFormAuthMsg(SysActFormAuth oldFormAuth, SysActFormAuth sysActFormAuth) {
        if (oldFormAuth.getProcessKey() == null ? sysActFormAuth.getProcessKey() != null : !oldFormAuth.getProcessKey().equals(sysActFormAuth.getProcessKey())) {
            return false;
        }
        if (oldFormAuth.getProcessVersion() == null ? sysActFormAuth.getProcessVersion() != null : !oldFormAuth.getProcessVersion().equals(sysActFormAuth.getProcessVersion())) {
            return false;
        }
        if (oldFormAuth.getTaskDefinitionKey() == null ? sysActFormAuth.getTaskDefinitionKey() != null : !oldFormAuth.getTaskDefinitionKey().equals(sysActFormAuth.getTaskDefinitionKey())) {
            return false;
        }
        if (oldFormAuth.getFormName() == null ? sysActFormAuth.getFormName() != null : !oldFormAuth.getFormName().equals(sysActFormAuth.getFormName())) {
            return false;
        }
        if (oldFormAuth.getFormType() == null ? sysActFormAuth.getFormType() != null : !oldFormAuth.getFormType().equals(sysActFormAuth.getFormType())) {
            return false;
        }
        return !(oldFormAuth.getFormState() == null ? sysActFormAuth.getFormState() != null : !oldFormAuth.getFormState().equals(sysActFormAuth.getFormState()));
    }

    private void importHandleAuth(WorkflowLoadDto workflowLoadDto, Set<String> errorImportKeyList, Map<String, Integer> overrideProcessVersionMap) {
        HashMap<String, Integer> importHandleAuth = new HashMap<String, Integer>();
        for (Object workflow : workflowLoadDto.getImportMsgs()) {
            if (!workflow.getExportData().getHandleAuthData().booleanValue() || errorImportKeyList.contains(workflow.getProcessKey())) continue;
            importHandleAuth.put(workflow.getProcessKey(), workflow.getImportVersion());
        }
        if (!importHandleAuth.isEmpty()) {
            LambdaQueryWrapper removeWrapper = new LambdaQueryWrapper();
            for (Map.Entry entry : importHandleAuth.entrySet()) {
                removeWrapper.or(wp -> {
                    wp.eq(SysActHandleAuth::getProcessKey, entry.getKey());
                    if (overrideProcessVersionMap.containsKey(entry.getKey())) {
                        wp.eq(SysActHandleAuth::getProcessVersion, overrideProcessVersionMap.get(entry.getKey()));
                    } else {
                        wp.eq(SysActHandleAuth::getProcessVersion, entry.getValue());
                    }
                });
            }
            if (!workflowLoadDto.getHandleAuthMsgs().isEmpty()) {
                ArrayList handleAuths = new ArrayList();
                for (String handleAuth : workflowLoadDto.getHandleAuthMsgs()) {
                    String processKey;
                    List list = JSON.parseArray((String)handleAuth, SysActHandleAuth.class);
                    if (list.isEmpty() || errorImportKeyList.contains(processKey = ((SysActHandleAuth)list.get(0)).getProcessKey())) continue;
                    if (overrideProcessVersionMap.containsKey(processKey)) {
                        list.forEach(sysActHandleAuth -> {
                            if (overrideProcessVersionMap.containsKey(sysActHandleAuth.getProcessKey())) {
                                sysActHandleAuth.setProcessVersion((Integer)overrideProcessVersionMap.get(sysActHandleAuth.getProcessKey()));
                            }
                        });
                    }
                    handleAuths.addAll(list);
                }
                if (!handleAuths.isEmpty()) {
                    List list = this.handleAuthService.list((Wrapper)removeWrapper);
                    ArrayList<Long> removeIds = new ArrayList<Long>();
                    block3: for (SysActHandleAuth sysActFormAuth : handleAuths) {
                        for (SysActHandleAuth oldFormAuth : list) {
                            if (!this.isSameHandleAuth(oldFormAuth, sysActFormAuth)) continue;
                            removeIds.add(oldFormAuth.getId());
                            continue block3;
                        }
                    }
                    List<List<Long>> removeIdList = this.getInList(removeIds);
                    for (List<Long> removeId : removeIdList) {
                        this.handleAuthService.removeByIds(removeId);
                    }
                    this.handleAuthService.saveBatch(handleAuths);
                }
            }
        }
    }

    private boolean isSameHandleAuth(SysActHandleAuth oldFormAuth, SysActHandleAuth sysActFormAuth) {
        if (oldFormAuth.getProcessKey() == null ? sysActFormAuth.getProcessKey() != null : !oldFormAuth.getProcessKey().equals(sysActFormAuth.getProcessKey())) {
            return false;
        }
        if (oldFormAuth.getProcessVersion() == null ? sysActFormAuth.getProcessVersion() != null : !oldFormAuth.getProcessVersion().equals(sysActFormAuth.getProcessVersion())) {
            return false;
        }
        if (oldFormAuth.getTaskDefinitionKey() == null ? sysActFormAuth.getTaskDefinitionKey() != null : !oldFormAuth.getTaskDefinitionKey().equals(sysActFormAuth.getTaskDefinitionKey())) {
            return false;
        }
        return !(oldFormAuth.getHandleType() == null ? sysActFormAuth.getHandleType() != null : !oldFormAuth.getHandleType().equals(sysActFormAuth.getHandleType()));
    }

    private void importExtendProperties(WorkflowLoadDto workflowLoadDto, Set<String> errorImportKeyList, Map<String, String> overrideProcessDefIdMap) {
        ArrayList newSysActExtendProperties = new ArrayList();
        ArrayList<String> importProcessIds = new ArrayList<String>();
        for (String extendPropertie : workflowLoadDto.getExpandMsgs()) {
            String procDefId;
            String processId;
            String proDefKey;
            List extendProperties = JSON.parseArray((String)extendPropertie, SysActExtendProperties.class);
            if (HussarUtils.isEmpty((Object)extendProperties) || errorImportKeyList.contains(proDefKey = (processId = ((SysActExtendProperties)extendProperties.get(0)).getProcDefId()).split(":")[0])) continue;
            if (overrideProcessDefIdMap.containsKey(proDefKey)) {
                procDefId = overrideProcessDefIdMap.get(proDefKey);
                importProcessIds.add(procDefId);
                for (SysActExtendProperties sysActExtendProperties : extendProperties) {
                    sysActExtendProperties.setProcDefId(overrideProcessDefIdMap.get(proDefKey));
                    sysActExtendProperties.setId(null);
                }
            } else {
                procDefId = ((SysActExtendProperties)extendProperties.get(0)).getProcDefId();
                importProcessIds.add(procDefId);
                for (SysActExtendProperties sysActExtendProperties : extendProperties) {
                    sysActExtendProperties.setId(null);
                }
            }
            newSysActExtendProperties.addAll(extendProperties);
        }
        if (newSysActExtendProperties.isEmpty()) {
            return;
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.in(SysActExtendProperties::getProcDefId, importProcessIds);
        this.sysActExtendPropertiesService.remove((Wrapper)lambdaQueryWrapper);
        this.sysActExtendPropertiesService.saveBatch(newSysActExtendProperties);
    }

    private ApiResponse<String> importModel(String xml, String lcdpbpm, String serviceName, boolean isOverride) {
        List oldSysActProcessFiles;
        String processKey;
        BpmnModel bpmnModel = null;
        try (ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes());){
            XMLInputFactory xif = XmlUtil.createSafeXmlInputFactory();
            XMLStreamReader xtr = xif.createXMLStreamReader(in);
            bpmnModel = new BpmnXMLConverter().convertToBpmnModel(xtr);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return ApiResponse.fail((String)e.getMessage());
        }
        String impModelName = ((Process)bpmnModel.getProcesses().get(0)).getName();
        String modelKey = ((Process)bpmnModel.getProcesses().get(0)).getId();
        String identityId = this.modelMapper.getIdByIdentity(modelKey);
        List sysActProcessFiles = JSON.parseArray((String)lcdpbpm, SysActProcessFile.class);
        ArrayList<SysActProcessFile> wfdList = new ArrayList<SysActProcessFile>();
        ArrayList<SysActProcessFile> metaList = new ArrayList<SysActProcessFile>();
        boolean needModify = false;
        String workFlowName = null;
        String workflowStyle = null;
        String processId = null;
        if (!isOverride) {
            List oldSysActProcessFiles2 = this.sysActProcessFileMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActProcessFile::getVersion, (Object)0)).eq(SysActProcessFile::getProcessKey, (Object)modelKey));
            for (SysActProcessFile sysActProcessFile : sysActProcessFiles) {
                if (HussarUtils.isNotEmpty((Object)oldSysActProcessFiles2)) {
                    for (SysActProcessFile oldSysActProcessFile : oldSysActProcessFiles2) {
                        if (!oldSysActProcessFile.getType().equals(sysActProcessFile.getType())) continue;
                        sysActProcessFile.setId(oldSysActProcessFile.getId());
                        sysActProcessFile.setVersion(Integer.valueOf(0));
                        if ("temp-wfd".equals(sysActProcessFile.getType()) || "wfd".equals(sysActProcessFile.getType())) {
                            wfdList.add(sysActProcessFile);
                            continue;
                        }
                        metaList.add(sysActProcessFile);
                    }
                    continue;
                }
                sysActProcessFile.setId(null);
                sysActProcessFile.setVersion(Integer.valueOf(0));
                if ("temp-wfd".equals(sysActProcessFile.getType()) || "wfd".equals(sysActProcessFile.getType())) {
                    wfdList.add(sysActProcessFile);
                    continue;
                }
                metaList.add(sysActProcessFile);
            }
            for (SysActProcessFile sysActProcessFile : metaList) {
                WorkFlow workFlow = (WorkFlow)JSON.parseObject((String)new String(sysActProcessFile.getContent(), StandardCharsets.UTF_8), WorkFlow.class);
                if (HussarUtils.isNotEmpty((Object)identityId)) {
                    workFlow.setModelId(Long.valueOf(identityId));
                }
                sysActProcessFile.setContent(JSONObject.toJSONString((Object)workFlow).getBytes(StandardCharsets.UTF_8));
                if (!HussarUtils.isNotEmpty((Object)identityId)) continue;
                sysActProcessFile.setModelId(Long.valueOf(identityId));
            }
            for (SysActProcessFile sysActProcessFile : wfdList) {
                if (!HussarUtils.isNotEmpty((Object)identityId)) continue;
                sysActProcessFile.setModelId(Long.valueOf(identityId));
            }
            ArrayList<SysActProcessFile> addList = new ArrayList<SysActProcessFile>();
            addList.addAll(wfdList);
            addList.addAll(metaList);
            for (SysActProcessFile sysActProcessFile : addList) {
                sysActProcessFile.setProcessId(null);
            }
            this.sysActProcessFileService.saveOrUpdateBatch(addList);
            if (HussarUtils.isEmpty((Object)identityId)) {
                Model model = this.repositoryService.newModel();
                ObjectNode modelObjectNode = new ObjectMapper().createObjectNode();
                modelObjectNode.put("name", impModelName);
                modelObjectNode.put("description", ((Process)bpmnModel.getProcesses().get(0)).getDocumentation());
                modelObjectNode.put("revision", 1);
                model.setMetaInfo(modelObjectNode.toString());
                model.setName(impModelName);
                model.setKey(modelKey);
                model.setCategory(serviceName);
                this.repositoryService.saveModel(model);
                identityId = model.getId();
            }
            ExtendBpmnJsonConverter extendBpmnJsonConverter = new ExtendBpmnJsonConverter();
            extendBpmnJsonConverter.updateConvertersToBpmnMap();
            extendBpmnJsonConverter.updateConvertersToJsonMap();
            ObjectNode editorNode = extendBpmnJsonConverter.convertToJson(bpmnModel);
            this.repositoryService.addModelEditorSource(identityId, editorNode.toString().getBytes(StandardCharsets.UTF_8));
            WorkFlow workFlow = this.sysActProcessFileService.getFileByProcessKeyAndProcessId(modelKey, null, false, Integer.valueOf(0), false);
            if (workFlow == null) {
                logger.error("{} \u6570\u636e\u7f3a\u5931", (Object)modelKey);
                throw new NullPointerException(modelKey + "\u6570\u636e\u7f3a\u5931");
            }
            workFlow.setModelId(Long.valueOf(Long.parseLong(identityId)));
            this.sysActProcessFileService.updateFile(workFlow, Integer.valueOf(0));
            processId = this.modelService.deployModel(Long.valueOf(Long.parseLong(identityId)), workFlow.getWorkflowStyle());
        } else {
            ApiResponse<String> apiResponse;
            processKey = ((SysActProcessFile)sysActProcessFiles.get(0)).getProcessKey();
            ArrayList<String> processKeys = new ArrayList<String>();
            processKeys.add(processKey);
            int n = Integer.parseInt(this.processDefinitionsMapper.getProcessMsgByProcessKeys(processKeys).get(0).getVersion());
            oldSysActProcessFiles = this.sysActProcessFileMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActProcessFile::getVersion, (Object)n)).eq(SysActProcessFile::getProcessKey, (Object)modelKey));
            WorkFlow oldWorkflow = this.getWorkflow(oldSysActProcessFiles);
            WorkFlow newWorkflow = this.getWorkflow(sysActProcessFiles);
            if (oldWorkflow != null && newWorkflow != null && !(apiResponse = this.processCheckService.checkWorkflow(newWorkflow, oldWorkflow, "3")).isSuccess()) {
                return apiResponse;
            }
            int overVersion = Integer.parseInt(this.processDefinitionsMapper.getMainOrNew(processKey).get(0).getVersion());
            needModify = overVersion == n;
            LambdaQueryWrapper removeWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActProcessFile::getProcessKey, (Object)modelKey)).eq(SysActProcessFile::getType, (Object)"temp-wfd");
            if (needModify) {
                Iterator removeTempVersions = new ArrayList<Integer>();
                removeTempVersions.add(n);
                removeTempVersions.add(0);
                removeWrapper.in(SysActProcessFile::getVersion, (Collection)((Object)removeTempVersions));
            } else {
                removeWrapper.eq(SysActProcessFile::getVersion, (Object)n);
            }
            this.sysActProcessFileMapper.delete((Wrapper)removeWrapper);
            for (SysActProcessFile file : sysActProcessFiles) {
                if (HussarUtils.isNotEmpty((Object)oldSysActProcessFiles)) {
                    for (SysActProcessFile oldSysActProcessFile : oldSysActProcessFiles) {
                        if (!oldSysActProcessFile.getType().equals(file.getType())) continue;
                        file.setId(oldSysActProcessFile.getId());
                        processId = String.valueOf(oldSysActProcessFile.getProcessId());
                        file.setProcessId(processId);
                        file.setVersion(Integer.valueOf(n));
                        if ("temp-wfd".equals(file.getType()) || "wfd".equals(file.getType())) {
                            wfdList.add(file);
                            continue;
                        }
                        metaList.add(file);
                    }
                    continue;
                }
                file.setId(null);
                file.setVersion(Integer.valueOf(n));
                if ("temp-wfd".equals(file.getType()) || "wfd".equals(file.getType())) {
                    wfdList.add(file);
                    continue;
                }
                metaList.add(file);
            }
            for (SysActProcessFile sysActProcessFile : metaList) {
                WorkFlow workFlow = (WorkFlow)JSON.parseObject((String)new String(sysActProcessFile.getContent(), StandardCharsets.UTF_8), WorkFlow.class);
                if (HussarUtils.isNotEmpty((Object)identityId)) {
                    workFlow.setModelId(Long.valueOf(identityId));
                    workFlow.setProcDefId(processId);
                }
                workFlowName = workFlow.getName();
                workflowStyle = workFlow.getWorkflowStyle();
                sysActProcessFile.setContent(JSONObject.toJSONString((Object)workFlow).getBytes(StandardCharsets.UTF_8));
                if (!HussarUtils.isNotEmpty((Object)identityId)) continue;
                sysActProcessFile.setModelId(Long.valueOf(identityId));
            }
            for (SysActProcessFile sysActProcessFile : wfdList) {
                if (!HussarUtils.isNotEmpty((Object)identityId)) continue;
                sysActProcessFile.setModelId(Long.valueOf(identityId));
            }
            ArrayList<SysActProcessFile> addList = new ArrayList<SysActProcessFile>();
            addList.addAll(wfdList);
            addList.addAll(metaList);
            this.sysActProcessFileService.saveOrUpdateBatch(addList);
            BpmActGeBytearray bpmActGeBytearray = new BpmActGeBytearray();
            bpmActGeBytearray.setBytes(new BpmnXMLConverter().convertToXML(bpmnModel));
            Long id = HussarUtils.isNotEmpty((Object)this.bpm2XMLMapper.getModelId(n, processKey)) ? Long.valueOf(this.bpm2XMLMapper.getModelId(n, processKey)) : null;
            bpmActGeBytearray.setId(id);
            this.bpmActGeBytearrayMapper.updateById(bpmActGeBytearray);
            ExtendBpmnJsonConverter jsonConverter = new ExtendBpmnJsonConverter();
            jsonConverter.updateConvertersToBpmnMap();
            jsonConverter.updateConvertersToJsonMap();
            ObjectNode editorNode = jsonConverter.convertToJson(bpmnModel);
            this.repositoryService.addModelEditorSource(identityId, editorNode.toString().getBytes(StandardCharsets.UTF_8));
            this.processDefinitionsMapper.updateProcessName(processId, workFlowName, workflowStyle);
            this.processEngine.getManagementService().executeCommand((Command)new DeleteProcessDefinitionCacheCmd(processId));
        }
        if (needModify) {
            processKey = ((SysActProcessFile)sysActProcessFiles.get(0)).getProcessKey();
            ArrayList<SysActProcessFile> wfds = new ArrayList<SysActProcessFile>();
            ArrayList<SysActProcessFile> arrayList = new ArrayList<SysActProcessFile>();
            oldSysActProcessFiles = this.sysActProcessFileMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActProcessFile::getVersion, (Object)0)).eq(SysActProcessFile::getProcessKey, (Object)modelKey));
            for (SysActProcessFile file : sysActProcessFiles) {
                if (HussarUtils.isNotEmpty((Object)oldSysActProcessFiles)) {
                    for (SysActProcessFile oldSysActProcessFile : oldSysActProcessFiles) {
                        if (!oldSysActProcessFile.getType().equals(file.getType())) continue;
                        file.setId(oldSysActProcessFile.getId());
                        file.setVersion(Integer.valueOf(0));
                        file.setProcessId(null);
                        if ("temp-wfd".equals(file.getType()) || "wfd".equals(file.getType())) {
                            wfds.add(file);
                            continue;
                        }
                        arrayList.add(file);
                    }
                    continue;
                }
                file.setId(null);
                file.setVersion(Integer.valueOf(0));
                file.setProcessId(null);
                if ("temp-wfd".equals(file.getType()) || "wfd".equals(file.getType())) {
                    wfds.add(file);
                    continue;
                }
                arrayList.add(file);
            }
            for (SysActProcessFile sysActProcessFile : arrayList) {
                WorkFlow workFlow = (WorkFlow)JSON.parseObject((String)new String(sysActProcessFile.getContent(), StandardCharsets.UTF_8), WorkFlow.class);
                if (HussarUtils.isNotEmpty((Object)identityId)) {
                    workFlow.setModelId(Long.valueOf(identityId));
                    workFlow.setProcDefId(processId);
                }
                sysActProcessFile.setContent(JSONObject.toJSONString((Object)workFlow).getBytes(StandardCharsets.UTF_8));
                if (!HussarUtils.isNotEmpty((Object)identityId)) continue;
                sysActProcessFile.setModelId(Long.valueOf(identityId));
            }
            for (SysActProcessFile sysActProcessFile : wfdList) {
                if (!HussarUtils.isNotEmpty((Object)identityId)) continue;
                sysActProcessFile.setModelId(Long.valueOf(identityId));
            }
            ArrayList<SysActProcessFile> addList = new ArrayList<SysActProcessFile>();
            addList.addAll(wfds);
            addList.addAll(arrayList);
            this.sysActProcessFileService.saveOrUpdateBatch(addList);
            BpmActGeBytearray bpmActGeBytearray = new BpmActGeBytearray();
            bpmActGeBytearray.setBytes(new BpmnXMLConverter().convertToXML(bpmnModel));
            Long id = HussarUtils.isNotEmpty((Object)this.bpm2XMLMapper.getUpdateModelId(Long.parseLong(identityId))) ? this.bpm2XMLMapper.getUpdateModelId(Long.parseLong(identityId)) : null;
            bpmActGeBytearray.setId(id);
            this.bpmActGeBytearrayMapper.updateById(bpmActGeBytearray);
            Model modelData = (Model)this.repositoryService.createModelQuery().modelId(identityId).singleResult();
            String metaInfo = modelData.getMetaInfo();
            JSONObject metaInfoJsonObject = JSONObject.parseObject((String)metaInfo);
            metaInfoJsonObject.put("name", (Object)workFlowName);
            this.processDefinitionsMapper.setNameAndDeploymentId(workFlowName, null, workflowStyle, processKey, metaInfoJsonObject.toString());
        }
        return ApiResponse.success((String)processId);
    }

    private WorkFlow getWorkflow(List<SysActProcessFile> sysActProcessFiles) {
        SysActProcessFile wfd = null;
        SysActProcessFile meta = null;
        for (SysActProcessFile sysActProcessFile : sysActProcessFiles) {
            if ("wfd".equals(sysActProcessFile.getType())) {
                wfd = sysActProcessFile;
                continue;
            }
            if (!"meta".equals(sysActProcessFile.getType())) continue;
            meta = sysActProcessFile;
        }
        if (HussarUtils.isEmpty(wfd) || HussarUtils.isEmpty(meta)) {
            return null;
        }
        WorkFlow workFlow = (WorkFlow)JSON.parseObject((String)new String(meta.getContent(), StandardCharsets.UTF_8), WorkFlow.class);
        workFlow.setProcDefId(meta.getProcessId());
        workFlow.setModelId(meta.getModelId());
        workFlow.setData(new String(wfd.getContent(), StandardCharsets.UTF_8));
        return workFlow;
    }

    public BpmResponseResult selectByName(WorkflowQueryDto workflowQueryDto) {
        List<WorkflowQueryVo> list = this.queryModelList((Page<WorkflowQueryVo>)workflowQueryDto.getPage(), workflowQueryDto.getName());
        if (!list.isEmpty()) {
            int i;
            ArrayList<String> processKeys = new ArrayList<String>();
            for (int i2 = 0; i2 < list.size(); ++i2) {
                String a = list.get(i2).getProcessKey();
                processKeys.add(a);
            }
            List<ProcessDefinitionModel> processDefinitionModels = this.workflowMigrationMapper.queryProcessDefList(processKeys);
            ArrayList<String> processDefinitonKeys = new ArrayList<String>();
            HashMap versionMap = new HashMap();
            for (int i3 = 0; i3 < processKeys.size(); ++i3) {
                ArrayList list1 = new ArrayList();
                for (int j = 0; j < processDefinitionModels.size(); ++j) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    String pd = processDefinitionModels.get(j).getId();
                    String version = processDefinitionModels.get(j).getVersion();
                    String[] arr = pd.split(":");
                    if (!((String)processKeys.get(i3)).equals(arr[0])) continue;
                    map.put("key", version);
                    map.put("value", pd);
                    int index = 0;
                    for (Map map2 : list1) {
                        if (Integer.parseInt((String)map2.get("key")) <= Integer.parseInt(version)) continue;
                        ++index;
                    }
                    list1.add(index, map);
                }
                versionMap.put(processKeys.get(i3), list1);
            }
            for (int j = 0; j < processDefinitionModels.size(); ++j) {
                String pd = processDefinitionModels.get(j).getId();
                processDefinitonKeys.add(pd);
            }
            HashMap map = new HashMap();
            for (i = 0; i < processKeys.size(); ++i) {
                ArrayList list2 = new ArrayList();
                for (int j = 0; j < processDefinitonKeys.size(); ++j) {
                    String[] arr = ((String)processDefinitonKeys.get(j)).split(":");
                    if (!((String)processKeys.get(i)).equals(arr[0])) continue;
                    list2.add(processDefinitonKeys.get(j));
                }
                map.put(processKeys.get(i), list2);
            }
            for (i = 0; i < list.size(); ++i) {
                list.get(i).setVersionMap((List)versionMap.get(list.get(i).getProcessKey()));
            }
        }
        JSONArray jsonArray = new JSONArray();
        jsonArray.add((Object)workflowQueryDto.getPage().setRecords(list));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    public List<WorkflowQueryVo> queryModelList(Page<WorkflowQueryVo> page, String processName) {
        return this.workflowMigrationMapper.queryModelList(page, processName);
    }

    private void removeProcessFileAssignee(List<SysActProcessFile> sysActProcessFiles) {
        for (SysActProcessFile sysActProcessFile : sysActProcessFiles) {
            if (!"temp-wfd".equals(sysActProcessFile.getType()) && !"wfd".equals(sysActProcessFile.getType())) continue;
            String workflow = new String(sysActProcessFile.getContent(), StandardCharsets.UTF_8);
            JSONObject jsonObject = JSON.parseObject((String)workflow);
            JSONArray nodes = jsonObject.getJSONObject("slots").getJSONArray("default");
            for (int i = 0; i < nodes.size(); ++i) {
                JSONArray subProcessNodes;
                JSONObject node = nodes.getJSONObject(i);
                JSONObject props = node.getJSONObject("props");
                if (BpmNodeTypeUtil.isStart((String)node.getString("name"))) {
                    this.removeFormAuth(props);
                    continue;
                }
                if (BpmNodeTypeUtil.isUserTask((String)node.getString("name"))) {
                    props.put("flowAssignment", (Object)new JSONObject());
                    props.put("flowEndRecipients", (Object)new JSONObject());
                    props.put("flowRecipients", (Object)new JSONObject());
                    this.removeFormAuth(props);
                    continue;
                }
                if (BpmNodeTypeUtil.isCallActivity((String)node.getString("name"))) {
                    props.put("flowSelector", (Object)new JSONObject());
                    continue;
                }
                if (!BpmNodeTypeUtil.isSubProcess((String)node.getString("name"))) continue;
                props.put("flowAssignment", (Object)new JSONObject());
                if (node.getJSONObject("slots") == null || (subProcessNodes = node.getJSONObject("slots").getJSONArray("default")) == null) continue;
                for (int j = 0; j < subProcessNodes.size(); ++j) {
                    JSONObject subProcessNode = subProcessNodes.getJSONObject(j);
                    if (!BpmNodeTypeUtil.isUserTask((String)subProcessNode.getString("name"))) continue;
                    JSONObject subProcessProps = node.getJSONObject("props");
                    subProcessProps.put("flowAssignment", (Object)new JSONObject());
                    subProcessProps.put("flowEndRecipients", (Object)new JSONObject());
                    subProcessProps.put("flowRecipients", (Object)new JSONObject());
                    this.removeFormAuth(subProcessProps);
                }
            }
            workflow = jsonObject.toJSONString();
            sysActProcessFile.setContent(workflow.getBytes(StandardCharsets.UTF_8));
        }
    }

    private void removeFormAuth(JSONObject props) {
        JSONObject assistFormDetailAddress;
        JSONObject assistFormAddress;
        JSONObject ccFormDetailAddress;
        JSONObject ccFormAddress;
        JSONObject formDetailAddress;
        JSONObject formAddress = props.getJSONObject("formAddress");
        if (formAddress != null) {
            for (Object key : formAddress.keySet()) {
                formAddress.getJSONObject((String)key).remove((Object)"formAuth");
            }
        }
        if ((formDetailAddress = props.getJSONObject("formDetailAddress")) != null) {
            for (Object key : formDetailAddress.keySet()) {
                formDetailAddress.getJSONObject((String)key).remove((Object)"formAuth");
            }
        }
        if ((ccFormAddress = props.getJSONObject("ccFormAddress")) != null) {
            for (Object key : ccFormAddress.keySet()) {
                ccFormAddress.getJSONObject((String)key).remove((Object)"formAuth");
            }
        }
        if ((ccFormDetailAddress = props.getJSONObject("ccFormDetailAddress")) != null) {
            for (Object key : ccFormDetailAddress.keySet()) {
                ccFormDetailAddress.getJSONObject((String)key).remove((Object)"formAuth");
            }
        }
        if ((assistFormAddress = props.getJSONObject("assistFormAddress")) != null) {
            for (String key : assistFormAddress.keySet()) {
                assistFormAddress.getJSONObject(key).remove((Object)"formAuth");
            }
        }
        if ((assistFormDetailAddress = props.getJSONObject("assistFormDetailAddress")) != null) {
            for (String key : assistFormDetailAddress.keySet()) {
                assistFormDetailAddress.getJSONObject(key).remove((Object)"formAuth");
            }
        }
    }

    private List<List<Long>> getInList(List<Long> longList) {
        ArrayList<List<Long>> result = new ArrayList<List<Long>>();
        int size = longList.size();
        for (int i = 0; i < size; i += 1000) {
            List<Long> list = longList.subList(i, Math.min(i + 1000, size));
            result.add(list);
        }
        return result;
    }
}

