/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.migration.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jxdinfo.hussar.common.utils.IdempotentJsonUtils;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.workflow.engine.bpm.extend.ExtendBpmnJsonConverter;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.model.SysActExtendProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.service.impl.SysActExtendPropertiesServiceImpl;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.dao.GodAxeWorkflowMigrationMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.dto.ImportMappingDto;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.service.WorkflowMigrationServiceImpl;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.vo.WorkflowDumpVo;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.vo.WorkflowQueryVo;
import com.jxdinfo.hussar.workflow.engine.bpm.model.dao.SysActAssigneeMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.SysActAssignee;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.SysActFormAuth;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.SysActHandleAuth;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.WorkFlow;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysActAssigneeService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysActFormAuthService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysActHandleAuthService;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.model.SysActProcessFile;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.service.Bpm2XMLService;
import com.jxdinfo.hussar.workflow.godaxe.migration.GodAxeMigrationService;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.activiti.bpmn.converter.BpmnXMLConverter;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.Process;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.Model;
import org.activiti.explorer.util.XmlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class GodAxeWorkflowMigrationServiceImpl
implements GodAxeMigrationService {
    private static final Logger logger = LoggerFactory.getLogger(WorkflowMigrationServiceImpl.class);
    @Autowired
    private SysActAssigneeService sysActAssigneeService;
    @Autowired
    private SysActFormAuthService sysActFormAuthService;
    @Autowired
    private SysActHandleAuthService sysActHandleAuthService;
    @Autowired
    private SysActExtendPropertiesServiceImpl sysActExtendPropertiesService;
    @Autowired
    private SysActProcessFileService sysActProcessFileService;
    @Resource
    private RepositoryService repositoryService;
    @Autowired
    private ModelService modelService;
    @Autowired
    private Bpm2XMLService bpm2XMLService;
    @Resource
    private ProcessEngine processEngine;
    @Resource
    private SysActAssigneeMapper sysActAssigneeMapper;
    @Resource
    private GodAxeWorkflowMigrationMapper godAxeWorkflowMigrationMapper;
    private static final Pattern RoleRegex = Pattern.compile("R.GRANTED_ROLE (NOT )?IN \\(([^)])*\\)");

    public List<Long> queryRoleIdList(Long appId) {
        Map<String, WorkflowQueryVo> processKeyVersionMap = this.queryProcessKeyVersionMap(appId);
        ArrayList<String> contentTypeList = new ArrayList<String>();
        contentTypeList.add("defaultAssign");
        contentTypeList.add("defaultCcAssign");
        ArrayList contentList = new ArrayList();
        for (String processKey : processKeyVersionMap.keySet()) {
            List list = this.sysActAssigneeMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActAssignee::getProcDefKey, (Object)processKey)).in(SysActAssignee::getContentType, contentTypeList)).eq(SysActAssignee::getProcessVersion, (Object)processKeyVersionMap.get(processKey).getVersion()));
            list.forEach(sysActAssignee -> contentList.add(sysActAssignee.getContent() == null ? "" : new String(sysActAssignee.getContent(), StandardCharsets.UTF_8)));
        }
        ArrayList<Long> roleIdList = new ArrayList<Long>();
        for (String content : contentList) {
            if (!content.contains("R.GRANTED_ROLE")) continue;
            Matcher matcher = RoleRegex.matcher(content);
            while (matcher.find()) {
                String roleId = matcher.group().substring(matcher.group().indexOf("(") + 2, matcher.group().length() - 2);
                if (roleIdList.contains(Long.valueOf(roleId))) continue;
                roleIdList.add(Long.valueOf(roleId));
            }
        }
        return roleIdList;
    }

    public Map<String, List<WorkflowDumpVo>> exportWorkflow(Long appId) {
        Map<String, WorkflowQueryVo> processKeyVersionMap = this.queryProcessKeyVersionMap(appId);
        HashMap<String, List<WorkflowDumpVo>> workflowDumpVoListMap = new HashMap<String, List<WorkflowDumpVo>>();
        for (String processKey : processKeyVersionMap.keySet()) {
            ArrayList<WorkflowDumpVo> workflowDumpVoList = new ArrayList<WorkflowDumpVo>();
            WorkflowQueryVo workflowQueryVo = processKeyVersionMap.get(processKey);
            String processName = workflowQueryVo.getName();
            String processDefinitionId = workflowQueryVo.getProcessDefinitionId();
            Integer version = Integer.valueOf(processKeyVersionMap.get(processKey).getVersion());
            List sysActAssignees = this.sysActAssigneeService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActAssignee::getProcDefKey, (Object)processKey)).eq(SysActAssignee::getProcessVersion, (Object)version));
            WorkflowDumpVo workflowDumpVoAssignee = new WorkflowDumpVo(processName, processKey, processDefinitionId, version.intValue(), "\u53c2\u4e0e\u8005.json", IdempotentJsonUtils.toString((Object)sysActAssignees), processKey + "/" + "\u53c2\u4e0e\u8005.json");
            workflowDumpVoList.add(workflowDumpVoAssignee);
            List sysActFormAuths = this.sysActFormAuthService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActFormAuth::getProcessKey, (Object)processKey)).and(wrapper -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(SysActFormAuth::getProcessVersion, (Object)version)).or()).isNull(SysActFormAuth::getProcessVersion);
            }));
            ArrayList<SysActFormAuth> result = new ArrayList<SysActFormAuth>();
            for (SysActFormAuth sysActFormAuth : sysActFormAuths) {
                if (sysActFormAuth.getProcessVersion() == null) continue;
                result.add(sysActFormAuth);
            }
            if (result.isEmpty()) {
                result.addAll(sysActFormAuths);
            }
            WorkflowDumpVo workflowDumpVoFormAuth = new WorkflowDumpVo(processName, processKey, processDefinitionId, version.intValue(), "\u8868\u5355\u6743\u9650.json", IdempotentJsonUtils.toString(result), processKey + "/" + "\u8868\u5355\u6743\u9650.json");
            workflowDumpVoList.add(workflowDumpVoFormAuth);
            List sysActHandleAuths = this.sysActHandleAuthService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActHandleAuth::getProcessKey, (Object)processKey)).eq(SysActHandleAuth::getProcessVersion, (Object)version));
            WorkflowDumpVo workflowDumpVoHandleAuth = new WorkflowDumpVo(processName, processKey, processDefinitionId, version.intValue(), "\u64cd\u4f5c\u6743\u9650.json", IdempotentJsonUtils.toString((Object)sysActHandleAuths), processKey + "/" + "\u64cd\u4f5c\u6743\u9650.json");
            workflowDumpVoList.add(workflowDumpVoHandleAuth);
            List sysActExtendProperties = this.sysActExtendPropertiesService.list((Wrapper)new LambdaQueryWrapper().eq(SysActExtendProperties::getProcDefId, (Object)processDefinitionId));
            WorkflowDumpVo extendPropertiesDumpVo = new WorkflowDumpVo(processName, processKey, processDefinitionId, version.intValue(), "\u62d3\u5c55.json", IdempotentJsonUtils.toString((Object)sysActExtendProperties), processKey + "/" + "\u62d3\u5c55.json");
            workflowDumpVoList.add(extendPropertiesDumpVo);
            List sysActProcessFiles = this.sysActProcessFileService.list((Wrapper)new LambdaQueryWrapper().eq(SysActProcessFile::getProcessId, (Object)processDefinitionId));
            WorkflowDumpVo sysActProcessFilesDumpVo = new WorkflowDumpVo(processName, processKey, processDefinitionId, version.intValue(), "\u6d41\u7a0b\u6587\u4ef6.lcdpbpm", IdempotentJsonUtils.toString((Object)sysActProcessFiles), processKey + "/" + "\u6d41\u7a0b\u6587\u4ef6.lcdpbpm");
            workflowDumpVoList.add(sysActProcessFilesDumpVo);
            InputStream resourceAsStream = this.processEngine.getProcessEngineConfiguration().getRepositoryService().getProcessModel(processDefinitionId);
            String xmlByteString = null;
            try {
                int temp;
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                byte[] bytes = new byte[2048];
                while ((temp = resourceAsStream.read(bytes)) != -1) {
                    outputStream.write(bytes, 0, temp);
                }
                byte[] finalBytes = outputStream.toByteArray();
                xmlByteString = new String(finalBytes);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            WorkflowDumpVo xmlDumpVo = new WorkflowDumpVo(processName, processKey, processDefinitionId, version.intValue(), "bpmn20.xml", xmlByteString, processKey + "/" + "bpmn20.xml");
            workflowDumpVoList.add(xmlDumpVo);
            workflowDumpVoListMap.put(processKey, workflowDumpVoList);
        }
        return workflowDumpVoListMap;
    }

    public void importWorkflow(Map<String, List<WorkflowDumpVo>> workflowDumpVoListMap, ImportMappingDto importMappingDto) {
        for (String processKey : workflowDumpVoListMap.keySet()) {
            String newProcessKey = (String)importMappingDto.getProcessKeyMap().get(processKey);
            if (HussarUtils.isEmpty((Object)newProcessKey)) continue;
            List<WorkflowDumpVo> workflowDumpVos = workflowDumpVoListMap.get(processKey);
            String lcdpContent = null;
            String xmlContent = null;
            String assigneeContent = null;
            String formAuthContent = null;
            String handleAuthContent = null;
            String extendPropertiesContent = null;
            for (WorkflowDumpVo workflowDumpVo : workflowDumpVos) {
                switch (workflowDumpVo.getFileSuffix()) {
                    case "\u6d41\u7a0b\u6587\u4ef6.lcdpbpm": {
                        lcdpContent = workflowDumpVo.getContent();
                        break;
                    }
                    case "bpmn20.xml": {
                        xmlContent = workflowDumpVo.getContent();
                        break;
                    }
                    case "\u53c2\u4e0e\u8005.json": {
                        assigneeContent = workflowDumpVo.getContent();
                        break;
                    }
                    case "\u8868\u5355\u6743\u9650.json": {
                        formAuthContent = workflowDumpVo.getContent();
                        break;
                    }
                    case "\u64cd\u4f5c\u6743\u9650.json": {
                        handleAuthContent = workflowDumpVo.getContent();
                        break;
                    }
                    case "\u62d3\u5c55.json": {
                        extendPropertiesContent = workflowDumpVo.getContent();
                    }
                }
            }
            this.importModel(xmlContent, lcdpContent, importMappingDto);
            this.importAssignee(assigneeContent, importMappingDto);
            this.importFormAuth(formAuthContent, importMappingDto);
            this.importHandleAuth(handleAuthContent, importMappingDto);
        }
    }

    private void importModel(String xmlContent, String lcdpContent, ImportMappingDto importMappingDto) {
        BpmnModel bpmnModel = null;
        try (ByteArrayInputStream in = new ByteArrayInputStream(xmlContent.getBytes());){
            XMLInputFactory xif = XmlUtil.createSafeXmlInputFactory();
            XMLStreamReader xtr = xif.createXMLStreamReader(in);
            bpmnModel = new BpmnXMLConverter().convertToBpmnModel(xtr);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        String processName = ((Process)bpmnModel.getProcesses().get(0)).getName();
        String oldprocessKey = ((Process)bpmnModel.getProcesses().get(0)).getId();
        String newProcessKey = (String)importMappingDto.getProcessKeyMap().get(oldprocessKey);
        Model modelData = this.repositoryService.newModel();
        ObjectNode modelObjectNode = new ObjectMapper().createObjectNode();
        modelObjectNode.put("name", processName);
        modelObjectNode.put("description", ((Process)bpmnModel.getProcesses().get(0)).getDocumentation());
        modelObjectNode.put("revision", 1);
        modelData.setMetaInfo(modelObjectNode.toString());
        modelData.setName(processName);
        modelData.setKey(newProcessKey);
        modelData.setAppId(importMappingDto.getNewAppId());
        this.repositoryService.saveModel(modelData);
        String modelId = modelData.getId();
        List sysActProcessFiles = JSON.parseArray((String)lcdpContent, SysActProcessFile.class);
        ArrayList<Object> wfdList = new ArrayList<Object>();
        ArrayList<Object> metaList = new ArrayList<Object>();
        for (Object sysActProcessFile : sysActProcessFiles) {
            sysActProcessFile.setId(null);
            sysActProcessFile.setVersion(Integer.valueOf(0));
            sysActProcessFile.setProcessId(null);
            if ("temp-wfd".equals(sysActProcessFile.getType()) || "wfd".equals(sysActProcessFile.getType())) {
                wfdList.add(sysActProcessFile);
                continue;
            }
            metaList.add(sysActProcessFile);
        }
        WorkFlow workFlow = null;
        for (SysActProcessFile sysActProcessFile : metaList) {
            workFlow = (WorkFlow)JSON.parseObject((String)new String(sysActProcessFile.getContent(), StandardCharsets.UTF_8), WorkFlow.class);
            workFlow.setAppId(String.valueOf(importMappingDto.getNewAppId()));
            workFlow.setIdentity(newProcessKey);
            workFlow.setModelId(Long.valueOf(modelId));
            workFlow.setVersion("1");
            sysActProcessFile.setContent(JSONObject.toJSONString((Object)workFlow).getBytes(StandardCharsets.UTF_8));
            sysActProcessFile.setModelId(Long.valueOf(modelId));
            sysActProcessFile.setProcessKey(newProcessKey);
        }
        for (SysActProcessFile sysActProcessFile : wfdList) {
            String wfdFile = new String(sysActProcessFile.getContent(), StandardCharsets.UTF_8);
            wfdFile = this.updateWfdFile(wfdFile, importMappingDto);
            sysActProcessFile.setProcessKey(newProcessKey);
            sysActProcessFile.setModelId(Long.valueOf(modelId));
            sysActProcessFile.setContent(wfdFile.getBytes(StandardCharsets.UTF_8));
            workFlow.setData(wfdFile);
        }
        ArrayList<Object> addList = new ArrayList<Object>();
        addList.addAll(wfdList);
        addList.addAll(metaList);
        this.sysActProcessFileService.saveOrUpdateBatch(addList);
        if (HussarUtils.isNotEmpty((Object)workFlow)) {
            bpmnModel = this.bpm2XMLService.getBpmnModel(workFlow, newProcessKey);
        }
        ExtendBpmnJsonConverter extendBpmnJsonConverter = new ExtendBpmnJsonConverter();
        extendBpmnJsonConverter.updateConvertersToBpmnMap();
        extendBpmnJsonConverter.updateConvertersToJsonMap();
        ObjectNode editorNode = extendBpmnJsonConverter.convertToJson(bpmnModel);
        this.repositoryService.addModelEditorSource(modelId, editorNode.toString().getBytes(StandardCharsets.UTF_8));
        this.modelService.deployModel(Long.valueOf(Long.parseLong(modelId)), workFlow.getWorkflowStyle());
    }

    private String updateWfdFile(String wfdFile, ImportMappingDto importMappingDto) {
        JSONObject jsonObject = JSON.parseObject((String)wfdFile);
        JSONObject props = jsonObject.getJSONObject("props");
        Object identity = props.get((Object)"identity");
        if (HussarUtils.isNotEmpty((Object)identity)) {
            props.put("identity", importMappingDto.getProcessKeyMap().get(identity.toString()));
        }
        JSONObject processBinding = props.getJSONObject("processBinding");
        Object mainTableName = processBinding.get((Object)"mainTableName");
        Object taskTableName = processBinding.get((Object)"taskTableName");
        Object mainTableBusinessKey = processBinding.get((Object)"mainTableBusinessKey");
        if (HussarUtils.isNotEmpty((Object)mainTableName)) {
            processBinding.put("mainTableName", importMappingDto.getMainTableNameMap().get(mainTableName.toString()));
        }
        if (HussarUtils.isNotEmpty((Object)taskTableName)) {
            processBinding.put("taskTableName", importMappingDto.getTaskTableNameMap().get(taskTableName.toString()));
        }
        if (HussarUtils.isNotEmpty((Object)mainTableBusinessKey)) {
            processBinding.put("mainTableBusinessKey", importMappingDto.getMainTableBusinessKeyMap().get(mainTableBusinessKey.toString()));
        }
        JSONObject slots = jsonObject.getJSONObject("slots");
        JSONArray nodes = slots.getJSONArray("default");
        for (int i = 0; i < nodes.size(); ++i) {
            JSONObject node = nodes.getJSONObject(i);
            JSONObject nodeProps = node.getJSONObject("props");
            JSONObject formAddress = nodeProps.getJSONObject("formAddress");
            JSONObject formDetailAddress = nodeProps.getJSONObject("formDetailAddress");
            JSONObject ccFormAddress = nodeProps.getJSONObject("ccFormAddress");
            JSONObject ccFormDetailAddress = nodeProps.getJSONObject("ccFormDetailAddress");
            JSONArray addressList = new JSONArray();
            if (HussarUtils.isNotEmpty((Object)formAddress)) {
                addressList.add((Object)formAddress);
            }
            if (HussarUtils.isNotEmpty((Object)formDetailAddress)) {
                addressList.add((Object)formDetailAddress);
            }
            if (HussarUtils.isNotEmpty((Object)ccFormAddress)) {
                addressList.add((Object)ccFormAddress);
            }
            if (HussarUtils.isNotEmpty((Object)ccFormDetailAddress)) {
                addressList.add((Object)ccFormDetailAddress);
            }
            if (!HussarUtils.isNotEmpty((Object)addressList)) continue;
            for (int j = 0; j < addressList.size(); ++j) {
                JSONObject mobile;
                JSONObject address = addressList.getJSONObject(j);
                JSONObject web = address.getJSONObject("web");
                if (HussarUtils.isNotEmpty((Object)web)) {
                    Object oldFormId = web.get((Object)"id");
                    web.put("id", importMappingDto.getFormIdMap().get(Long.valueOf(oldFormId.toString())));
                }
                if (!HussarUtils.isNotEmpty((Object)(mobile = address.getJSONObject("mobile")))) continue;
                Object oldFormId = mobile.get((Object)"id");
                mobile.put("id", importMappingDto.getFormIdMap().get(Long.valueOf(oldFormId.toString())));
            }
        }
        wfdFile = jsonObject.toJSONString();
        return wfdFile;
    }

    private void importAssignee(String assigneeContent, ImportMappingDto importMappingDto) {
        List list = JSON.parseArray((String)assigneeContent, SysActAssignee.class);
        if (HussarUtils.isNotEmpty((Object)list)) {
            String oldProcessKey = ((SysActAssignee)list.get(0)).getProcDefKey();
            String newProcessKey = (String)importMappingDto.getProcessKeyMap().get(oldProcessKey);
            list.forEach(sysActAssignee -> {
                sysActAssignee.setProcDefKey(newProcessKey);
                sysActAssignee.setProcessVersion(Integer.valueOf(1));
                sysActAssignee.setId(null);
            });
            this.sysActAssigneeService.saveBatch((Collection)list);
        }
    }

    private void importFormAuth(String formAuthContent, ImportMappingDto importMappingDto) {
        List list = JSON.parseArray((String)formAuthContent, SysActFormAuth.class);
        if (HussarUtils.isNotEmpty((Object)list)) {
            String oldProcessKey = ((SysActFormAuth)list.get(0)).getProcessKey();
            Long oldFormId = ((SysActFormAuth)list.get(0)).getFormId();
            String newProcessKey = (String)importMappingDto.getProcessKeyMap().get(oldProcessKey);
            Long newFormId = (Long)importMappingDto.getFormIdMap().get((long)oldFormId);
            list.forEach(sysActFormAuth -> {
                sysActFormAuth.setFormId(newFormId.longValue());
                sysActFormAuth.setProcessKey(newProcessKey);
                sysActFormAuth.setProcessVersion(Integer.valueOf(1));
                sysActFormAuth.setId(null);
            });
            this.sysActFormAuthService.saveBatch((Collection)list);
        }
    }

    private void importHandleAuth(String handleAuthContent, ImportMappingDto importMappingDto) {
        List list = JSON.parseArray((String)handleAuthContent, SysActHandleAuth.class);
        if (HussarUtils.isNotEmpty((Object)list)) {
            String oldProcessKey = ((SysActHandleAuth)list.get(0)).getProcessKey();
            String newProcessKey = (String)importMappingDto.getProcessKeyMap().get(oldProcessKey);
            list.forEach(sysActHandleAuth -> {
                sysActHandleAuth.setProcessKey(newProcessKey);
                sysActHandleAuth.setProcessVersion(Integer.valueOf(1));
                sysActHandleAuth.setId(null);
            });
            this.sysActHandleAuthService.saveBatch((Collection)list);
        }
    }

    private Map<String, WorkflowQueryVo> queryProcessKeyVersionMap(Long appId) {
        List<WorkflowQueryVo> processKeyList = this.godAxeWorkflowMigrationMapper.queryProcessKeyList(appId);
        HashMap<String, WorkflowQueryVo> processKeyVersionMap = new HashMap<String, WorkflowQueryVo>();
        for (WorkflowQueryVo workflowQueryVo : processKeyList) {
            if (processKeyVersionMap.containsKey(workflowQueryVo.getProcessKey())) continue;
            processKeyVersionMap.put(workflowQueryVo.getProcessKey(), workflowQueryVo);
        }
        return processKeyVersionMap;
    }
}

