/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.definition.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.dao.ProcessDefinitionsMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.model.DefinitionModel;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.model.ProcessDefinitionModel;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.service.ProcessDefinitionsService;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.vo.ProcessDefinitionVo;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.ProcessDefinition;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class ProcessDefinitionsServiceImpl
implements ProcessDefinitionsService {
    @Resource
    ProcessDefinitionsMapper processDefinitionsMapper;
    @Autowired
    private SysActProcessFileService sysActProcessFileService;
    @Autowired
    RepositoryService repositoryService;

    public IPage<DefinitionModel> queryProcessDefinitionsList(String definitionName, Page<DefinitionModel> page) {
        List<DefinitionModel> instList = this.processDefinitionsMapper.getList(page, definitionName);
        page.setRecords(instList);
        return page;
    }

    public DefinitionModel getMainOrNew(String processKey) {
        List<DefinitionModel> list = this.processDefinitionsMapper.getMainOrNew(processKey);
        if (list != null && !list.isEmpty()) {
            return list.get(0);
        }
        throw new PublicClientException(BpmExceptionCodeEnum.PROCESS_NOT_EXIST.getMessage(), Boolean.valueOf(false));
    }

    @Cacheable(value={"workflow_process_def_id"}, key="'workflow_process_def_id:'+#processKey+':'+#version")
    public String getStartProcessDefinitionId(String processKey, String version) {
        List<String> list = this.processDefinitionsMapper.getProcessDefinitionIdList(processKey, version, true);
        if (list != null && !list.isEmpty()) {
            return list.get(0);
        }
        throw new BpmException(BpmExceptionCodeEnum.PROCESS_KEY_ERROR.getMessage());
    }

    public String getLastProcessDefinitionId(String processKey) {
        List<String> list = this.processDefinitionsMapper.getProcessDefinitionIdList(processKey, null, false);
        if (list != null && !list.isEmpty()) {
            return list.get(0);
        }
        throw new BpmException(BpmExceptionCodeEnum.PROCESS_KEY_ERROR.getMessage());
    }

    public List<String> getProcessDefinitionId(String processKey, Integer version) {
        return this.processDefinitionsMapper.getProcessDefinitionId(processKey, version);
    }

    @CacheEvict(value={"workflow_process_def_id"}, allEntries=true)
    public ApiResponse<String> setMain(String processKey, String id) {
        int num = this.processDefinitionsMapper.setNotMain(processKey, null, 0) + this.processDefinitionsMapper.setMain(id, 1);
        num += this.processDefinitionsMapper.setModelMain(id);
        DefinitionModel definitionModel = this.getMainOrNew(processKey);
        String name = definitionModel.getName();
        Long deploymentId = definitionModel.getDeploymentId();
        String workflowStyle = definitionModel.getWorkflowStyle();
        ObjectNode modelObjectNode = new ObjectMapper().createObjectNode();
        modelObjectNode.put("name", name);
        modelObjectNode.put("description", definitionModel.getDescription());
        modelObjectNode.put("revision", 1);
        this.processDefinitionsMapper.setNameAndDeploymentId(name, deploymentId, workflowStyle, processKey, modelObjectNode.toString());
        if (num != 0) {
            this.sysActProcessFileService.removeTempWorkflowFile(processKey, Integer.valueOf(0));
            if (this.sysActProcessFileService.copyFiles(processKey, id)) {
                return ApiResponse.success((String)BpmExceptionCodeEnum.SET_SUCCESS.getMessage());
            }
            throw new BpmException(BpmExceptionCodeEnum.FILES_NOT_FOUND);
        }
        throw new BpmException(BpmExceptionCodeEnum.ERROR_SET);
    }

    public void canModelDeleteWithVersion(String processKey) {
        List<DefinitionModel> list = this.processDefinitionsMapper.getMainOrNew(processKey);
        if (list.size() == 1) {
            throw new BpmException(BpmExceptionCodeEnum.NOT_DELETE_THE_ONLY_PROCESS_DEFINITION);
        }
    }

    @CacheEvict(value={"workflow_process_def_id"}, allEntries=true)
    public int setNotMain(String processKey) {
        int num = this.processDefinitionsMapper.setNotMain(processKey, null, 0);
        DefinitionModel definitionModel = this.getMainOrNew(processKey);
        String name = definitionModel.getName();
        Long deploymentId = definitionModel.getDeploymentId();
        String workflowStyle = definitionModel.getWorkflowStyle();
        ObjectNode modelObjectNode = new ObjectMapper().createObjectNode();
        modelObjectNode.put("name", name);
        modelObjectNode.put("description", definitionModel.getDescription());
        modelObjectNode.put("revision", 1);
        this.processDefinitionsMapper.setNameAndDeploymentId(name, deploymentId, workflowStyle, processKey, modelObjectNode.toString());
        return num;
    }

    @CacheEvict(value={"workflow_process_def_id"}, allEntries=true)
    public ApiResponse<String> cancelMain(String processKey, String id) {
        int num = this.processDefinitionsMapper.setNotMain(processKey, id, 0);
        DefinitionModel definitionModel = this.getMainOrNew(processKey);
        String name = definitionModel.getName();
        Long deploymentId = definitionModel.getDeploymentId();
        String workflowStyle = definitionModel.getWorkflowStyle();
        ObjectNode modelObjectNode = new ObjectMapper().createObjectNode();
        modelObjectNode.put("name", name);
        modelObjectNode.put("description", definitionModel.getDescription());
        modelObjectNode.put("revision", 1);
        this.processDefinitionsMapper.setNameAndDeploymentId(name, deploymentId, workflowStyle, processKey, modelObjectNode.toString());
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(processKey).latestVersion().singleResult();
        if (num != 0) {
            if (this.sysActProcessFileService.copyFiles(processKey, processDefinition.getId())) {
                return ApiResponse.success((String)BpmExceptionCodeEnum.SUCCESS_UPDATE.getMessage());
            }
            throw new BpmException(BpmExceptionCodeEnum.FILES_NOT_FOUND);
        }
        throw new BpmException(BpmExceptionCodeEnum.ERROR_UPDATE);
    }

    public int updateProcessName(String id, String processName, String workflowStyle) {
        return this.processDefinitionsMapper.updateProcessName(id, processName, workflowStyle);
    }

    public List<ProcessDefinitionModel> queryProcessDefListOfMainVersion(String processName) {
        List<ProcessDefinitionModel> list = this.processDefinitionsMapper.queryProcessDefListOfMainVersion(processName);
        ArrayList<ProcessDefinitionModel> newList = new ArrayList<ProcessDefinitionModel>();
        for (ProcessDefinitionModel oldPro : list) {
            boolean flag = false;
            for (ProcessDefinitionModel newPro : newList) {
                if (!HussarUtils.equals((Object)oldPro.getKey(), (Object)newPro.getKey())) continue;
                flag = true;
                break;
            }
            if (flag) continue;
            newList.add(oldPro);
        }
        return newList;
    }

    public List<ProcessDefinitionModel> getProcessMainOrNew(String processKey) {
        List<ProcessDefinitionModel> list = this.processDefinitionsMapper.getProcessMainOrNew(processKey);
        ArrayList newList = Lists.newArrayList();
        if (CollectionUtil.isNotEmpty(list)) {
            newList.add(list.get(0));
        }
        return newList;
    }

    public ProcessDefinitionModel getProcessDefitionById(String processId) {
        ProcessDefinitionModel processDefinitionModel = this.processDefinitionsMapper.getProcessDefitionById(processId);
        return processDefinitionModel;
    }

    public List<ProcessDefinitionVo> queryFlowVersion(String processKey) {
        return this.processDefinitionsMapper.queryFlowVersion(processKey);
    }

    public int setVersionTemporary(String id) {
        return this.processDefinitionsMapper.setVersionTemporary(id);
    }

    public void editTemporaryDefId(String defId, Long processInsId, String version) {
        this.processDefinitionsMapper.updateActInst(defId, processInsId);
        this.processDefinitionsMapper.updateExecution(defId, processInsId);
        this.processDefinitionsMapper.updateProcDef(defId, processInsId, Long.parseLong(version));
        this.processDefinitionsMapper.updateTask(defId, processInsId);
        this.processDefinitionsMapper.updateCcTask(defId, processInsId);
        this.processDefinitionsMapper.updateTaskInst(defId, processInsId);
        this.processDefinitionsMapper.updateProcInst(defId, processInsId);
    }

    public void editTemporaryDefIdByOldDefId(String defId, String oldDefId, String version) {
        this.processDefinitionsMapper.updateActInstByOldDefId(defId, oldDefId);
        this.processDefinitionsMapper.updateExecutionByOldDefId(defId, oldDefId);
        this.processDefinitionsMapper.updateProcDefByOldDefId(defId, oldDefId, Long.parseLong(version));
        this.processDefinitionsMapper.updateTaskByOldDefId(defId, oldDefId);
        this.processDefinitionsMapper.updateCcTaskByOldDefId(defId, oldDefId);
        this.processDefinitionsMapper.updateTaskInstByOldDefId(defId, oldDefId);
        this.processDefinitionsMapper.updateProcInstByOldDefId(defId, oldDefId);
    }

    public void editTemporaryDefId(String defId, String processInsId, String version) {
        this.editTemporaryDefId(defId, Long.parseLong(processInsId), version);
    }

    public int queryLatestVersion(String processKey) {
        List processDefinition = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(processKey).latestVersion().list();
        if (HussarUtils.isNotEmpty((Object)processDefinition)) {
            return ((ProcessDefinition)processDefinition.get(0)).getVersion();
        }
        return 0;
    }

    @CacheEvict(value={"workflow_process_def_id"}, allEntries=true)
    public ApiResponse<String> setMainVersion(String processKey, String processVersion) {
        DefinitionModel definitionModel = this.processDefinitionsMapper.getProcDefIdByKeyAndVersion(processKey, processVersion);
        if (HussarUtils.isEmpty((Object)definitionModel)) {
            throw new PublicClientException(BpmExceptionCodeEnum.PROCESS_VERSION_NOT_FOUND.getMessage());
        }
        String processDefinitionId = definitionModel.getId();
        ApiResponse<String> result = this.setMain(processKey, processDefinitionId);
        return result;
    }

    public Integer queryNewVersion(String processKey) {
        return this.processDefinitionsMapper.queryNewVersion(processKey);
    }

    public String getProcessDefIdByVersion(String identity, Integer processVersion) {
        return this.processDefinitionsMapper.getProcessDefIdByVersion(identity, processVersion);
    }

    public DefinitionModel getByVersion(String id, String processKey, Integer version) {
        if (id != null) {
            return this.processDefinitionsMapper.getById(id, null);
        }
        List<DefinitionModel> defByVersion = this.processDefinitionsMapper.getByVersion(processKey, version);
        if (HussarUtils.isNotEmpty(defByVersion)) {
            return defByVersion.get(0);
        }
        return null;
    }
}

