/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.util;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.HttpRequestUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.IInstanceEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.ITaskEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.dao.ActivityRedisTimerMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.model.TimeOutModel;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.util.TimeOutHandleUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.service.ISysActUrgeTaskService;
import com.jxdinfo.hussar.workflow.engine.core.util.BpmTenantInfoUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.activiti.engine.TaskService;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class TimeOutSetListUtil {
    @Autowired
    private LcdpBpmProperties lcdpBpmProperties;
    @Autowired
    private RedisTemplate redisTemplate;
    @Autowired
    private ISysActUrgeTaskService iSysActUrgeTaskService;
    @Autowired
    private ITaskEngineService taskEngineService;
    @Autowired
    private BpmTenantInfoUtils bpmTenantInfoUtils;
    @Resource
    private TaskService taskService;
    @Autowired
    private IInstanceEngineService instanceEngineService;
    private static final LcdpBpmProperties LCDP_BPM_PROPERTIES = (LcdpBpmProperties)SpringContextHolder.getBean(LcdpBpmProperties.class);
    private static Logger logger = LogManager.getLogger(TimeOutSetListUtil.class);
    @Resource
    private ActivityRedisTimerMapper activityRedisTimerMapper;

    private String tenantRequestAddress() {
        return LCDP_BPM_PROPERTIES.getTenantCallAddress();
    }

    @HussarDs(value="#connName")
    public void setList(String connName, String tcode) {
        try {
            if (TimeOutHandleUtil.useRedis) {
                try {
                    List timeOutModels = this.activityRedisTimerMapper.selectList(null);
                    for (TimeOutModel timeOutModel : timeOutModels) {
                        timeOutModel.setDataSourceName(connName);
                        timeOutModel.setTcode(tcode);
                        String id = String.valueOf(timeOutModel.getId());
                        if ("1".equals(timeOutModel.getMessageType())) {
                            id = "global-" + id;
                        }
                        this.redisTemplate.opsForValue().set((Object)("bpm_activity:timer:task_Message:" + id), (Object)JSON.toJSONString((Object)timeOutModel));
                        Set oldTask = this.redisTemplate.opsForZSet().rangeByScore((Object)"bpm_activity:timer:score_list", (double)timeOutModel.getDueTime().getTime(), (double)timeOutModel.getDueTime().getTime());
                        if (HussarUtils.isEmpty((Object)oldTask)) {
                            this.redisTemplate.opsForZSet().add((Object)"bpm_activity:timer:score_list", (Object)id, (double)timeOutModel.getDueTime().getTime());
                            continue;
                        }
                        this.redisTemplate.opsForZSet().add((Object)"bpm_activity:timer:score_list", (Object)((String)new ArrayList(oldTask).get(0) + "," + id), (double)timeOutModel.getDueTime().getTime());
                    }
                    this.activityRedisTimerMapper.delete(null);
                }
                catch (Exception e) {
                    logger.error("redis\u50a8\u5b58\u8d85\u65f6\u4efb\u52a1\u4fe1\u606f\u5931\u8d25{}", (Object)e.toString());
                }
                return;
            }
            List timeOutModels = this.activityRedisTimerMapper.selectList(null);
            for (TimeOutModel timeOutModel : timeOutModels) {
                timeOutModel.setDataSourceName(connName);
                timeOutModel.setTcode(tcode);
                String id = String.valueOf(timeOutModel.getId());
                if ("1".equals(timeOutModel.getMessageType())) {
                    id = "global-" + id;
                }
                HussarCacheUtil.put((String)"bpm_timer_activity", (Object)id, (Object)timeOutModel);
                Long time = timeOutModel.getDueTime().getTime();
                TimeOutHandleUtil.timeOutList.add(time);
                TimeOutHandleUtil.timeOutMap.put(time, TimeOutHandleUtil.timeOutMap.get(time) == null ? id : TimeOutHandleUtil.timeOutMap.get(time) + "," + id);
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u8d85\u65f6\u4fe1\u606f\u51fa\u9519\uff1a{}", new Object[]{e.getMessage()});
        }
    }

    @HussarDs(value="#connName")
    public void timeOutTaskHandler(TimeOutModel timeOutModel, boolean isDelTimeOutTableMessage, String connName) {
        if (!this.bpmTenantInfoUtils.isMultiTenant()) {
            if (isDelTimeOutTableMessage) {
                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                queryWrapper.eq(TimeOutModel::getId, (Object)timeOutModel.getId());
                queryWrapper.eq(TimeOutModel::getMessageType, (Object)timeOutModel.getMessageType());
                this.activityRedisTimerMapper.delete((Wrapper)queryWrapper);
            }
            this.handleTimeOutModel(timeOutModel);
        } else {
            try {
                if (isDelTimeOutTableMessage) {
                    LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                    queryWrapper.eq(TimeOutModel::getId, (Object)timeOutModel.getId());
                    queryWrapper.eq(TimeOutModel::getMessageType, (Object)timeOutModel.getMessageType());
                    this.activityRedisTimerMapper.delete((Wrapper)queryWrapper);
                }
                this.handleTimeOutModel(timeOutModel);
            }
            catch (Exception e) {
                logger.error("\u8fde\u63a5\u5207\u6362\u81f3\u8d85\u65f6\u4efb\u52a1\u6240\u5728\u79df\u6237\u5e93\u5931\u8d25{}", (Object)e.getMessage());
            }
        }
    }

    private void handleTimeOutModel(TimeOutModel timeOutModel) {
        if (this.lcdpBpmProperties.getDeploymentModel().equals("workflow-platform")) {
            HussarContextHolder.setTenant((String)timeOutModel.getDataSourceName(), (String)timeOutModel.getTcode());
        }
        if ("autoHandle".equals(timeOutModel.getTimeOutType())) {
            String assignee = "";
            if (HussarUtils.isNotEmpty((Object)timeOutModel.getAssignee())) {
                String[] assignees;
                for (String user : assignees = timeOutModel.getAssignee().split(",")) {
                    if ("".equals(user)) continue;
                    assignee = user;
                    break;
                }
            }
            try {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("bpm_next_node", "");
                this.taskEngineService.completeTask(String.valueOf(timeOutModel.getId()), assignee, map, true);
            }
            catch (Exception e) {
                logger.error("\u8d85\u65f6\u4efb\u52a1\u81ea\u52a8\u529e\u7406\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            }
        } else if ("urging".equals(timeOutModel.getTimeOutType())) {
            String userId = null;
            if (HussarUtils.isNotEmpty((Object)timeOutModel.getMap())) {
                Map map = (Map)JSON.toJavaObject((JSON)JSON.parseObject((String)timeOutModel.getMap()), Map.class);
                userId = (String)map.get("sendUser");
            }
            try {
                this.iSysActUrgeTaskService.urgeTaskByTaskId(String.valueOf(timeOutModel.getId()), userId);
            }
            catch (Exception e) {
                logger.error("\u8d85\u65f6\u4efb\u52a1\u50ac\u529e\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            }
        } else if ("global-urging".equals(timeOutModel.getTimeOutType())) {
            try {
                String processInsId = String.valueOf(timeOutModel.getId());
                String assignee = timeOutModel.getAssignee();
                this.iSysActUrgeTaskService.urgeTask(processInsId, null, assignee);
            }
            catch (Exception e) {
                logger.error("\u8d85\u65f6\u6d41\u7a0b\u50ac\u529e\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            }
        } else if ("global-terminate".equals(timeOutModel.getTimeOutType())) {
            try {
                String assignee;
                Task runningTask;
                String taskId;
                Set<String> userSet;
                String processInsId = String.valueOf(timeOutModel.getId());
                List tasks = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().includeTaskLocalVariables()).processInstanceId(processInsId)).list();
                if (!tasks.isEmpty() && !(userSet = this.getAssigneeByTaskId(taskId = (runningTask = (Task)tasks.get(0)).getId())).isEmpty() && HussarUtils.isNotEmpty((Object)(assignee = userSet.iterator().next()))) {
                    this.instanceEngineService.endProcess(taskId, assignee, "");
                }
            }
            catch (Exception e) {
                logger.error("\u8d85\u65f6\u6d41\u7a0b\u7ec8\u7ed3\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            }
        } else if ("receiveTask-autoHandle".equals(timeOutModel.getTimeOutType())) {
            try {
                String executionId = String.valueOf(timeOutModel.getId());
                this.taskEngineService.receiveTaskSignal(executionId, null);
            }
            catch (Exception e) {
                logger.error("\u8d85\u65f6\u4efb\u52a1\u81ea\u52a8\u529e\u7406\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            }
        } else {
            String outInterface = timeOutModel.getTimeOutType();
            if (HussarUtils.isEmpty((Object)outInterface)) {
                throw new BaseException("\u8d85\u65f6\u5904\u7406\u672a\u914d\u7f6e\u5916\u90e8\u63a5\u53e3\u5185\u5bb9");
            }
            boolean isProcessTimeOut = false;
            if (outInterface.startsWith("global-")) {
                isProcessTimeOut = true;
                outInterface = outInterface.replace("global-", "");
            }
            if (outInterface.startsWith("receiveTask-")) {
                isProcessTimeOut = true;
                outInterface = outInterface.replace("receiveTask-", "");
            }
            outInterface = outInterface.startsWith("/") ? this.tenantRequestAddress() + outInterface : this.tenantRequestAddress() + "/" + outInterface;
            HashMap<String, Object> map = new HashMap<String, Object>();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            if (!isProcessTimeOut) {
                map.put("taskId", timeOutModel.getId());
                map.put("assignee", timeOutModel.getAssignee());
                map.put("startTime", sdf.format(timeOutModel.getCreateTime()));
            }
            map.put("dueTime", sdf.format(timeOutModel.getDueTime()));
            if (HussarUtils.isNotEmpty((Object)timeOutModel.getMap())) {
                map.putAll((Map)JSON.toJavaObject((JSON)JSON.parseObject((String)timeOutModel.getMap()), Map.class));
            }
            try {
                HttpRequestUtil.getRequestResult(outInterface, map);
            }
            catch (Exception e) {
                logger.error("\u8d85\u65f6\u4efb\u52a1\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            }
        }
    }

    private Set<String> getAssigneeByTaskId(String taskId) {
        HashSet<String> users = new HashSet<String>();
        List identityLinkList = this.taskService.getIdentityLinksType(taskId);
        if (identityLinkList != null && !identityLinkList.isEmpty()) {
            for (IdentityLink identityLink : identityLinkList) {
                users.add(identityLink.getUserId());
            }
        }
        return users;
    }
}

