/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.flowevents.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.FlowTaskQueryModel;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.ITaskEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.flowevents.service.FlowEventsService;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.model.FlowTask;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.service.IFlowTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.taskmanage.vo.TaskManagerQueryVo;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.service.ISysActUrgeTaskService;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.repository.ProcessDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class FlowEventsServiceImpl
implements FlowEventsService {
    private final TaskService taskService;
    private final ITaskEngineService taskEngineService;
    private final RepositoryService repositoryService;
    private final IFlowTaskService flowTaskService;
    private static final Logger logger = LoggerFactory.getLogger(FlowEventsServiceImpl.class);
    @Autowired
    private ISysActUrgeTaskService urgeTaskService;

    public FlowEventsServiceImpl(TaskService taskService, ITaskEngineService iTaskEngineService, RuntimeService runtimeService, RepositoryService repositoryService, IFlowTaskService flowTaskService) {
        this.taskService = taskService;
        this.taskEngineService = iTaskEngineService;
        this.repositoryService = repositoryService;
        this.flowTaskService = flowTaskService;
    }

    public ApiResponse<Page<TaskManagerQueryVo>> todoList(Page<FlowTask> pages, String userId, String processKey, String definitionKey, List<String> processKeys, String message, String sendUserId, String startTime, String endTime) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = null;
        Date end = null;
        try {
            start = HussarUtils.isNotEmpty((Object)startTime) ? formatter.parse(startTime) : null;
            end = HussarUtils.isNotEmpty((Object)endTime) ? formatter.parse(endTime) : null;
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        FlowTaskQueryModel flowTaskQueryModel = new FlowTaskQueryModel(userId, processKey, definitionKey);
        flowTaskQueryModel.setProcessKeys(processKeys);
        flowTaskQueryModel.setTodoConfiguration(message);
        flowTaskQueryModel.setSendUserId(sendUserId);
        flowTaskQueryModel.setStartTime(start);
        flowTaskQueryModel.setEndTime(end);
        return this.flowTaskService.todoList(pages, flowTaskQueryModel);
    }

    public ApiResponse<Page<TaskManagerQueryVo>> doneList(Page<FlowTask> pages, String userId, String processKey, String definitionKey, List<String> processKeys, String message, String sendUserId, String startTime, String endTime) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = null;
        Date end = null;
        try {
            start = HussarUtils.isNotEmpty((Object)startTime) ? formatter.parse(startTime) : null;
            end = HussarUtils.isNotEmpty((Object)endTime) ? formatter.parse(endTime) : null;
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        FlowTaskQueryModel flowTaskQueryModel = new FlowTaskQueryModel(userId, processKey, definitionKey);
        flowTaskQueryModel.setProcessKeys(processKeys);
        flowTaskQueryModel.setTodoConfiguration(message);
        flowTaskQueryModel.setSendUserId(sendUserId);
        flowTaskQueryModel.setStartTime(start);
        flowTaskQueryModel.setEndTime(end);
        return this.flowTaskService.doneList(pages, flowTaskQueryModel);
    }

    public JSONArray flowType() {
        List definitions = this.repositoryService.createProcessDefinitionQuery().latestVersion().active().list();
        JSONArray jsonArray = new JSONArray();
        if (definitions != null) {
            for (ProcessDefinition tmp : definitions) {
                HashMap<String, String> tmpMap = new HashMap<String, String>();
                tmpMap.put("id", tmp.getKey());
                tmpMap.put("name", tmp.getName());
                jsonArray.add(tmpMap);
            }
        }
        return jsonArray;
    }

    public ApiResponse<String> revokeTask(String historicTaskId, String userId) {
        BpmResponseResult check = this.taskEngineService.withdrawState(historicTaskId);
        if (check.getCode().equals("0")) {
            throw new BpmException(check.getMsg());
        }
        if (!((Boolean)check.getResult().get(0)).booleanValue()) {
            throw new BpmException((String)check.getResult().get(1));
        }
        BpmResponseResult bpmResponseResult = this.taskEngineService.revokeTask(historicTaskId, userId, "", true, null);
        return ApiResponse.success((String)bpmResponseResult.getMsg());
    }

    public ApiResponse<String> urgeTask(String processInsId, String userId) {
        return ApiResponse.success((String)this.urgeTaskService.urgeTask(processInsId, null, userId));
    }
}

