/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.workflow.activiti.dao.BpmActRuIdentitylinkMapper;
import com.jxdinfo.hussar.workflow.activiti.model.BpmActRuIdentitylink;
import com.jxdinfo.hussar.workflow.common.InstallResult;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.model.SysActCcTask;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.service.ISysActCcTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.comment.vo.TaskCommentVO;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.AnalyticalModelUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.CommonCodeUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.RealTaskId;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.model.ProcessDefinitionModel;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.service.ProcessDefinitionsService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dao.InstanceEngineMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dao.TaskEngineMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.ProcessQueryByStarterDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.ProcessRevokeDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.ProcessNode;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.IInstanceEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.ITaskEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.CommonPrepareCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.ProcessActionCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.ProcessEndCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.ProcessNodeCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.StartProcessReturnValueCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.vo.ActInstVo;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.vo.ProcessInstVo;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.dao.FlowTaskMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.model.FlowTask;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.model.Variables;
import com.jxdinfo.hussar.workflow.engine.bpm.hisline.model.SysActHiLine;
import com.jxdinfo.hussar.workflow.engine.bpm.hisline.service.ISysActHiLineService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.WorkFlow;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.BusinessInfoDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.ProcessDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.ProcessStatusCheckDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.StartProcessDto;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.model.SysActUrgeTask;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.service.ISysActUrgeTaskService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowModel;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowObject;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.manage.bpm.flowchart.FlowChartCommonDto;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.activiti.bpmn.model.BoundaryEvent;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.CallActivity;
import org.activiti.bpmn.model.EndEvent;
import org.activiti.bpmn.model.ErrorEventDefinition;
import org.activiti.bpmn.model.EventDefinition;
import org.activiti.bpmn.model.ExclusiveGateway;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.GraphicInfo;
import org.activiti.bpmn.model.InclusiveGateway;
import org.activiti.bpmn.model.MessageEventDefinition;
import org.activiti.bpmn.model.ParallelGateway;
import org.activiti.bpmn.model.ReceiveTask;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.ServiceTask;
import org.activiti.bpmn.model.SignalEventDefinition;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.SubProcess;
import org.activiti.bpmn.model.TimerEventDefinition;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.HistoryService;
import org.activiti.engine.IdentityService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.history.HistoricActivityInstanceQuery;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricProcessInstanceQuery;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Comment;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskInfo;
import org.activiti.engine.task.TaskQuery;
import org.activiti.engine.task.TaskStateType;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@HussarTransactional
@HussarTokenDs
public class InstanceEngineServiceImpl
implements IInstanceEngineService,
InitializingBean {
    @Autowired
    private ProcessDefinitionsService processDefinitionsService;
    @Autowired
    private ISysActHiLineService iSysActHiLineService;
    @Resource
    private ProcessEngine processEngine;
    @Resource
    private RuntimeService runtimeService;
    @Resource
    private TaskService taskService;
    @Resource
    private HistoryService historyService;
    @Resource
    private RepositoryService repositoryService;
    @Resource
    private TaskEngineMapper taskEngineMapper;
    @Resource
    private BpmActRuIdentitylinkMapper bpmActRuIdentitylinkMapper;
    @Resource
    private ITaskEngineService taskEngineService;
    @Resource
    private FlowTaskMapper flowTaskMapper;
    @Resource
    private IdentityService identityService;
    @Autowired
    private IAssigneeChooseService iAssigneeChooseService;
    @Autowired
    private BpmConstantProperties bpmConstantProperties;
    @Autowired
    private ActivityRedisTimerService activityRedisTimerService;
    @Autowired
    private ISysActUrgeTaskService iSysActUrgeTaskService;
    @Autowired
    private ISysActCcTaskService iSysActCcTaskService;
    @Autowired
    private LcdpBpmProperties lcdpBpmProperties;
    @Autowired
    private DataPushService dataPushService;
    @Autowired
    private ModelService modelService;
    @Autowired
    private SysActProcessFileService sysActProcessFileService;
    @Resource
    private InstanceEngineMapper instanceEngineMapper;
    private static final Map<String, String> TASK_SOURCE_FLAG = new HashMap<String, String>();
    public static final String SUB_PROCINST_NAME = "\u5b9e\u4f8b";
    private static final String FINISH_STATE = "finish";
    private static final String NOW_STATE = "complete";

    public void afterPropertiesSet() {
        TASK_SOURCE_FLAG.put(NOW_STATE, "\u529e\u7406");
        TASK_SOURCE_FLAG.put("revoke", "\u64a4\u56de");
        TASK_SOURCE_FLAG.put("reject_revoke", "\u64a4\u56de");
        TASK_SOURCE_FLAG.put("skip", "\u8df3\u8fc7");
        TASK_SOURCE_FLAG.put("reject", "\u9a73\u56de");
        TASK_SOURCE_FLAG.put("freejump", "\u81ea\u7531\u8df3\u8f6c");
        TASK_SOURCE_FLAG.put("endProcess", "\u7ec8\u6b62");
        TASK_SOURCE_FLAG.put("complete_leap", "\u529e\u7406");
        TASK_SOURCE_FLAG.put("revokeProcess", "\u6d41\u7a0b\u64a4\u529e");
        TASK_SOURCE_FLAG.put("transfer", "\u8f6c\u529e");
        TASK_SOURCE_FLAG.put("multiTransfer", "\u79fb\u4ea4");
        TASK_SOURCE_FLAG.put("assist_complete", "\u529e\u7406\u534f\u529e");
        TASK_SOURCE_FLAG.put("assist_add", "\u53d1\u8d77\u534f\u529e");
        TASK_SOURCE_FLAG.put("assist", "\u53d1\u8d77\u534f\u529e");
        TASK_SOURCE_FLAG.put("ccTask", "\u4f20\u9605");
        if (this.bpmConstantProperties != null && HussarUtils.isNotEmpty((Object)this.bpmConstantProperties.getTaskSourceFlag())) {
            TASK_SOURCE_FLAG.putAll(this.bpmConstantProperties.getTaskSourceFlag());
        }
    }

    public BpmResponseResult startProcessInstanceById(String processDefinitionId, String userId, String businessId, Map<String, Object> variables) {
        boolean flag;
        if (this.instanceEngineMapper.getProcessInstCountByBusinessId(businessId) > 0L) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getBusinessAlreadyStartProcess(), null);
        }
        if (variables == null) {
            variables = new HashMap<String, Object>();
        }
        if (!(flag = this.validateAuthority(userId, processDefinitionId, businessId, variables))) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNoAuthorityStartProcess(), null);
        }
        this.identityService.setAuthenticatedUserId(userId);
        HashMap<String, Object> newVariables = new HashMap<String, Object>(this.installVariables(processDefinitionId, variables));
        newVariables.put("sendUser", userId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", "processCreateStart");
        map.put("processDefinitionId", processDefinitionId);
        map.put("userId", userId);
        map.put("businessId", businessId);
        CommonCodeUtil.triggerEventHandleClass(map);
        newVariables.put("startUser", userId);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinitionId, businessId, newVariables);
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new StartProcessReturnValueCmd(processInstance.getProcessInstanceId(), userId, newVariables));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult startProcessInstanceByKey(String processKey, String userId, String businessId, String version, Map<String, Object> variables) {
        String processDefinitionId;
        boolean flag;
        if (this.instanceEngineMapper.getProcessInstCountByBusinessId(businessId) > 0L) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getBusinessAlreadyStartProcess(), null);
        }
        if (variables == null) {
            variables = new HashMap<String, Object>();
        }
        if (!(flag = this.validateAuthority(userId, processDefinitionId = this.processDefinitionsService.getStartProcessDefinitionId(processKey, version), businessId, variables))) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNoAuthorityStartProcess(), null);
        }
        this.identityService.setAuthenticatedUserId(userId);
        HashMap<String, Object> newVariables = new HashMap<String, Object>(this.installVariables(processDefinitionId, variables));
        newVariables.put("sendUser", userId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", "processCreateStart");
        map.put("processDefinitionId", processDefinitionId);
        map.put("userId", userId);
        map.put("businessId", businessId);
        CommonCodeUtil.triggerEventHandleClass(map);
        newVariables.put("startUser", userId);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinitionId, businessId, newVariables);
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new StartProcessReturnValueCmd(processInstance.getProcessInstanceId(), userId, newVariables));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult startProcessInstanceByKey(StartProcessDto startProcessDto) {
        String processKey = startProcessDto.getProcessKey();
        String userId = startProcessDto.getUserId();
        String businessId = startProcessDto.getBusinessId();
        Map variables = startProcessDto.getVariables();
        String dataDetail = startProcessDto.getDataDetail();
        String processTitle = startProcessDto.getProcessTitle();
        List instance = this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).listPage(0, 1);
        if (instance != null && !instance.isEmpty()) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getBusinessAlreadyStartProcess(), null);
        }
        String processDefinitionId = this.processDefinitionsService.getMainOrNew(processKey).getId();
        boolean flag = this.validateAuthority(userId, processDefinitionId, businessId, variables);
        if (!flag) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNoAuthorityStartProcess(), null);
        }
        this.identityService.setAuthenticatedUserId(userId);
        HashMap<String, Object> newVariables = new HashMap<String, Object>(this.installVariables(processDefinitionId, variables));
        newVariables.put("sendUser", userId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", "processCreateStart");
        map.put("processDefinitionId", processDefinitionId);
        map.put("userId", userId);
        map.put("businessId", businessId);
        CommonCodeUtil.triggerEventHandleClass(map);
        newVariables.put("startUser", userId);
        newVariables.put("dataDetail", dataDetail);
        newVariables.put("processTitle", processTitle);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinitionId, businessId, newVariables, processTitle, dataDetail);
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new StartProcessReturnValueCmd(processInstance.getProcessInstanceId(), userId, newVariables));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult updateBusinessInfo(BusinessInfoDto businessInfoDto) {
        String processTitle = businessInfoDto.getProcessTitle();
        String dataDetail = businessInfoDto.getDataDetail();
        String procInstId = businessInfoDto.getProcessInstId();
        String businessId = businessInfoDto.getBusinessId();
        boolean updateFlag = false;
        if (HussarUtils.isNotEmpty((Object)procInstId)) {
            updateFlag = this.instanceEngineMapper.updateBusinessInfoByInstId(procInstId, processTitle, dataDetail);
        } else if (HussarUtils.isNotEmpty((Object)businessId)) {
            updateFlag = this.instanceEngineMapper.updateBusinessInfoByBusinessKey(businessId, processTitle, dataDetail);
        } else {
            return InstallResult.fail((String)"\u6d41\u7a0b\u5b9e\u4f8bID\u548c\u4e1a\u52a1\u4e3b\u952e\u4e0d\u53ef\u540c\u65f6\u4e3a\u7a7a");
        }
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(procInstId).singleResult();
        HashSet<String> processDefinitionIdList = new HashSet<String>();
        processDefinitionIdList.add(historicProcessInstance.getProcessDefinitionId());
        if (this.dataPushService.isDataPush(processDefinitionIdList)) {
            DataPush dataPush = new DataPush();
            dataPush.setBusinessKey(businessId);
            dataPush.setProcessInsId(procInstId);
            dataPush.setProcessTitle(processTitle);
            dataPush.setDataDetail(dataDetail);
            this.dataPushService.updateStartProcess(dataPush);
            this.dataPushService.updateBusinessInfo(dataPush);
        }
        if (updateFlag) {
            return InstallResult.success((String)this.bpmConstantProperties.getSuccessUpdate());
        }
        return InstallResult.fail((String)this.bpmConstantProperties.getErrorUpdate());
    }

    public BpmResponseResult validationStartProcess(String processKey, String userId, String businessId, Map<String, Object> variables) {
        if (this.instanceEngineMapper.getProcessInstCountByBusinessId(businessId) > 0L) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getBusinessAlreadyStartProcess(), null);
        }
        String processDefinitionId = this.processDefinitionsService.getStartProcessDefinitionId(processKey, null);
        this.identityService.setAuthenticatedUserId(userId);
        HashMap<String, Object> newVariables = new HashMap<String, Object>(this.installVariables(processDefinitionId, variables));
        newVariables.put("sendUser", userId);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinitionId, businessId, newVariables);
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new StartProcessReturnValueCmd(processInstance.getProcessInstanceId(), userId, newVariables));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult checkProcessInstByBusinessId(String businessId) {
        if (this.instanceEngineMapper.getProcessInstCountByBusinessId(businessId) > 0L) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getBusinessAlreadyStartProcess(), null);
        }
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult checkProcessStatus(ProcessStatusCheckDto processStatusCheckDto) {
        List tasks = Lists.newArrayList();
        if (HussarUtils.isNotEmpty((Object)processStatusCheckDto.getProcessInsId())) {
            tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processStatusCheckDto.getProcessInsId())).list();
        } else if (HussarUtils.isNotEmpty((Object)processStatusCheckDto.getBusinessId())) {
            tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceBusinessKey(processStatusCheckDto.getBusinessId())).list();
        }
        JSONArray jsonArray = new JSONArray();
        if (HussarUtils.isNotEmpty((Object)tasks)) {
            List historicActivityInstances = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(((Task)tasks.get(0)).getProcessInstanceId()).orderByHistoricActivityInstanceStartTime().activityType("userTask").asc()).listPage(0, 1);
            HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)historicActivityInstances.get(0);
            for (Task task : tasks) {
                if (!task.getTaskDefinitionKey().equals(historicActivityInstance.getActivityId())) continue;
                jsonArray.add((Object)"1");
                return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
            }
            jsonArray.add((Object)"2");
            return InstallResult.getResult((String)"1", (String)this.bpmConstantProperties.getBusinessAlreadyStartProcess(), (JSONArray)jsonArray);
        }
        if (HussarUtils.isNotEmpty((Object)processStatusCheckDto.getProcessInsId())) {
            List instanceList = this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processStatusCheckDto.getProcessInsId()).list();
            if (HussarUtils.isNotEmpty((Object)instanceList)) {
                jsonArray.add((Object)"3");
                return InstallResult.getResult((String)"1", (String)this.bpmConstantProperties.getBusinessAlreadyStartProcess(), (JSONArray)jsonArray);
            }
        } else if (HussarUtils.isNotEmpty((Object)processStatusCheckDto.getBusinessId()) && this.instanceEngineMapper.getProcessInstCountByBusinessId(processStatusCheckDto.getBusinessId()) > 0L) {
            jsonArray.add((Object)"3");
            return InstallResult.getResult((String)"1", (String)this.bpmConstantProperties.getBusinessAlreadyStartProcess(), (JSONArray)jsonArray);
        }
        jsonArray.add((Object)"0");
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    public ApiResponse<JSONObject> validateEditAuthority(String businessId) {
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceBusinessKey(businessId)).list();
        JSONObject object = new JSONObject();
        if (tasks != null && !tasks.isEmpty()) {
            List historicActivityInstances = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(((Task)tasks.get(0)).getProcessInstanceId()).orderByHistoricActivityInstanceStartTime().activityType("userTask").asc()).listPage(0, 1);
            HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)historicActivityInstances.get(0);
            for (Task task : tasks) {
                if (!task.getTaskDefinitionKey().equals(historicActivityInstance.getActivityId())) continue;
                object.put("processKey", (Object)task.getProcessDefinitionId().split(":")[0]);
                object.put("taskDefinitionKey", (Object)task.getTaskDefinitionKey());
                object.put("businessId", (Object)businessId);
                object.put("taskId", (Object)task.getId());
                return ApiResponse.success((Object)object);
            }
            return ApiResponse.fail((String)this.bpmConstantProperties.getBusinessAlreadyStartProcess());
        }
        if (this.instanceEngineMapper.getProcessInstCountByBusinessId(businessId) > 0L) {
            return ApiResponse.fail((String)this.bpmConstantProperties.getBusinessAlreadyStartProcess());
        }
        return ApiResponse.success((Object)object);
    }

    public BpmResponseResult validateDeleteByBusinessId(String businessId) {
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceBusinessKey(businessId)).list();
        JSONArray jsonArray = new JSONArray();
        if (tasks != null && !tasks.isEmpty()) {
            List historicActivityInstances = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(((Task)tasks.get(0)).getProcessInstanceId()).orderByHistoricActivityInstanceStartTime().activityType("userTask").asc()).listPage(0, 1);
            HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)historicActivityInstances.get(0);
            for (Task task : tasks) {
                if (!task.getTaskDefinitionKey().equals(historicActivityInstance.getActivityId())) continue;
                jsonArray.add((Object)"1");
                return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
            }
            jsonArray.add((Object)"2");
            return InstallResult.getResult((String)"1", (String)this.bpmConstantProperties.getBusinessAlreadyStartProcess(), (JSONArray)jsonArray);
        }
        if (this.instanceEngineMapper.getProcessInstCountByBusinessId(businessId) > 0L) {
            jsonArray.add((Object)"2");
            return InstallResult.getResult((String)"1", (String)this.bpmConstantProperties.getBusinessAlreadyStartProcess(), (JSONArray)jsonArray);
        }
        jsonArray.add((Object)"0");
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    public BpmResponseResult queryAllCommentByBusinessId(String businessId) {
        if (businessId == null) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        HistoricProcessInstance instance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult();
        if (instance == null) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getProcessNotStart(), null);
        }
        String processInsId = instance.getId();
        List hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInsId)).orderByHistoricTaskInstanceEndTime().finished().asc()).list();
        return this.getResult(hisTaskList, true, true);
    }

    private boolean validateAuthority(String userId, String processDefinitionId, String businessId, Map<String, Object> variables) {
        boolean flag;
        String sql = AnalyticalModelUtil.queryFirstNodeAssigneeConfig(userId, processDefinitionId, businessId, variables);
        if (variables == null) {
            variables = new HashMap<String, Object>();
        }
        if (HussarUtils.isEmpty((Object)sql)) {
            ArrayList<String> users = new ArrayList<String>();
            users.add(userId);
            HashMap<String, ArrayList<String>> appointAssignee = new HashMap<String, ArrayList<String>>();
            appointAssignee.put("static_appoint_assignee", users);
            variables.put("appoint_assignee", appointAssignee);
            return true;
        }
        String processDefinitionKey = processDefinitionId.split(":")[0];
        HashMap<String, String> processInfo = new HashMap<String, String>();
        processInfo.put("workflowStarterUserId", userId);
        processInfo.put("workflowProcessDefinitionId", processDefinitionId);
        processInfo.put("workflowProcessKey", processDefinitionId.split(":")[0]);
        processInfo.put("workflowBusinessId", businessId);
        List users = this.iAssigneeChooseService.getCandidateUser(sql, processDefinitionKey, (Integer)variables.get("security_level"), processInfo);
        if (users != null && !users.isEmpty()) {
            flag = users.contains(userId);
        } else {
            users.add(userId);
            flag = true;
        }
        HashMap<String, List> appointAssignee = new HashMap<String, List>();
        appointAssignee.put("static_appoint_assignee", users);
        variables.put("appoint_assignee", appointAssignee);
        return flag;
    }

    public Map<String, Object> installVariables(String processDefinitionId, Map<String, Object> variables) {
        if (HussarUtils.isEmpty((Object)processDefinitionId)) {
            return variables;
        }
        Map<String, String> map = AnalyticalModelUtil.getToDoConfiguration(processDefinitionId, null);
        if (map.isEmpty()) {
            return variables;
        }
        if (variables == null) {
            variables = new HashMap<String, Object>();
        }
        variables.put("todoConfiguration", map.get("todoConfiguration"));
        return variables;
    }

    public BpmResponseResult suspendProcessInstanceById(String processInsId) {
        this.runtimeService.suspendProcessInstanceById(processInsId);
        HistoricProcessInstance processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInsId).singleResult();
        HashSet<String> processDefinitionIdList = new HashSet<String>();
        processDefinitionIdList.add(processInstance.getProcessDefinitionId());
        if (this.dataPushService.isDataPush(processDefinitionIdList)) {
            DataPush dataPush = new DataPush();
            dataPush.setBusinessKey(processInstance.getBusinessKey());
            dataPush.setProcessKey(processInstance.getProcessDefinitionKey());
            dataPush.setProcessDefinitionId(processInstance.getProcessDefinitionId());
            dataPush.setProcessState("suspendProcess");
            dataPush.setProcessInsId(processInsId);
            dataPush.setProcessStartTime(processInstance.getStartTime());
            dataPush.setStartUserId(processInstance.getStartUserId());
            dataPush.setDueDate(processInstance.getDueDate());
            this.dataPushService.changeProcessStateDataPush(dataPush);
        }
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult suspendProcessInstanceByBusinessId(String businessId) {
        HistoricProcessInstance processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult();
        if (HussarUtils.isEmpty((Object)processInstance)) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getProcessNotStart(), null);
        }
        this.runtimeService.suspendProcessInstanceById(processInstance.getId());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", "suspendEnd");
        map.put("processInsId", processInstance.getId());
        map.put("processDefinitionId", processInstance.getProcessDefinitionId());
        map.put("processDefinitionName", processInstance.getProcessDefinitionName());
        map.put("businessId", processInstance.getBusinessKey());
        map.put("starter", processInstance.getStartUserId());
        map.put("startTime", processInstance.getStartTime());
        CommonCodeUtil.triggerEventHandleClass(map);
        HashSet<String> processDefinitionIdList = new HashSet<String>();
        processDefinitionIdList.add(processInstance.getProcessDefinitionId());
        if (this.dataPushService.isDataPush(processDefinitionIdList)) {
            DataPush dataPush = new DataPush();
            dataPush.setBusinessKey(processInstance.getBusinessKey());
            dataPush.setProcessKey(processInstance.getProcessDefinitionKey());
            dataPush.setProcessState("suspendProcess");
            dataPush.setProcessDefinitionId(processInstance.getProcessDefinitionId());
            dataPush.setProcessInsId(processInstance.getId());
            dataPush.setProcessStartTime(processInstance.getStartTime());
            dataPush.setStartUserId(processInstance.getStartUserId());
            dataPush.setDueDate(processInstance.getDueDate());
            this.dataPushService.changeProcessStateDataPush(dataPush);
        }
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult activateProcessInstanceById(String processInsId) {
        this.runtimeService.activateProcessInstanceById(processInsId);
        HistoricProcessInstance processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInsId).singleResult();
        HashSet<String> processDefinitionIdList = new HashSet<String>();
        processDefinitionIdList.add(processInstance.getProcessDefinitionId());
        if (this.dataPushService.isDataPush(processDefinitionIdList)) {
            DataPush dataPush = new DataPush();
            dataPush.setBusinessKey(processInstance.getBusinessKey());
            dataPush.setProcessKey(processInstance.getProcessDefinitionKey());
            dataPush.setProcessDefinitionId(processInstance.getProcessDefinitionId());
            dataPush.setProcessState("activateProcess");
            dataPush.setProcessInsId(processInsId);
            dataPush.setProcessStartTime(processInstance.getStartTime());
            dataPush.setStartUserId(processInstance.getStartUserId());
            dataPush.setDueDate(processInstance.getDueDate());
            this.dataPushService.changeProcessStateDataPush(dataPush);
        }
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult activateProcessInstanceByBusinessId(String businessId) {
        HistoricProcessInstance processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult();
        if (HussarUtils.isEmpty((Object)processInstance)) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getProcessNotStart(), null);
        }
        this.runtimeService.activateProcessInstanceById(processInstance.getId());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", "activateEnd");
        map.put("processInsId", processInstance.getId());
        map.put("processDefinitionId", processInstance.getProcessDefinitionId());
        map.put("processDefinitionName", processInstance.getProcessDefinitionName());
        map.put("businessId", processInstance.getBusinessKey());
        map.put("starter", processInstance.getStartUserId());
        map.put("startTime", processInstance.getStartTime());
        CommonCodeUtil.triggerEventHandleClass(map);
        HashSet<String> processDefinitionIdList = new HashSet<String>();
        processDefinitionIdList.add(processInstance.getProcessDefinitionId());
        if (this.dataPushService.isDataPush(processDefinitionIdList)) {
            DataPush dataPush = new DataPush();
            dataPush.setBusinessKey(processInstance.getBusinessKey());
            dataPush.setProcessKey(processInstance.getProcessDefinitionKey());
            dataPush.setProcessState("activateProcess");
            dataPush.setProcessDefinitionId(processInstance.getProcessDefinitionId());
            dataPush.setProcessInsId(processInstance.getId());
            dataPush.setProcessStartTime(processInstance.getStartTime());
            dataPush.setStartUserId(processInstance.getStartUserId());
            dataPush.setDueDate(processInstance.getDueDate());
            this.dataPushService.changeProcessStateDataPush(dataPush);
        }
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult deleteProcessInstance(String processInsId, String reason) {
        List<Long> procIdList = new ArrayList<Long>();
        procIdList.add(Long.valueOf(processInsId));
        ArrayList<Long> allProcId = new ArrayList<Long>();
        do {
            allProcId.addAll(procIdList);
        } while (HussarUtils.isNotEmpty(procIdList = this.taskEngineMapper.getAllCallActivityInstIds(procIdList)));
        List stringProcIds = allProcId.stream().map(s -> s.toString()).collect(Collectors.toList());
        List historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().processInstanceIds(new HashSet(stringProcIds)).list();
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceIdIn(stringProcIds)).list();
        StringBuilder taskIds = new StringBuilder();
        for (Task task : tasks) {
            if (!HussarUtils.isNotEmpty((Object)task.getDueDate())) continue;
            taskIds.append(",").append(task.getId());
        }
        if (HussarUtils.isNotEmpty((Object)taskIds.toString())) {
            this.activityRedisTimerService.delTimeOutModel(taskIds.toString().substring(1));
        }
        this.runtimeService.deleteProcessInstance(processInsId, reason);
        this.historyService.deleteHistoricProcessInstance(processInsId);
        HashMap<String, String> businessKeyMap = new HashMap<String, String>();
        HashSet<String> processDefinitionIdList = new HashSet<String>();
        for (HistoricProcessInstance historicProcessInstance : historicProcessInstances) {
            String businessIds = (String)businessKeyMap.get(historicProcessInstance.getProcessDefinitionId());
            businessIds = businessIds == null ? historicProcessInstance.getBusinessKey() : businessIds + "," + historicProcessInstance.getBusinessKey();
            businessKeyMap.put(historicProcessInstance.getProcessDefinitionId(), businessIds);
            processDefinitionIdList.add(historicProcessInstance.getProcessDefinitionId());
        }
        if (this.dataPushService.isDataPush(processDefinitionIdList)) {
            DataPush dataPush = new DataPush();
            dataPush.setBusinessMap(businessKeyMap);
            dataPush.setComment(reason);
            dataPush.setProcessState("deleteProcess");
            this.dataPushService.deleteDataPush(dataPush);
            this.dataPushService.changeProcessStateDataPush(dataPush);
            DataPush dataPushTemp = new DataPush();
            dataPushTemp.setProcessInsId(processInsId);
            this.dataPushService.deleteStartProcess(dataPushTemp);
        }
        LambdaQueryWrapper urgeQueryWrapper = new LambdaQueryWrapper();
        urgeQueryWrapper.in(SysActUrgeTask::getProcessInsId, allProcId);
        this.iSysActUrgeTaskService.remove((Wrapper)urgeQueryWrapper);
        LambdaQueryWrapper lineQueryWrapper = new LambdaQueryWrapper();
        lineQueryWrapper.in(SysActHiLine::getProcessInsId, allProcId);
        this.iSysActHiLineService.remove((Wrapper)lineQueryWrapper);
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult deleteFinishedProcessInstance(String processInsId) {
        List<Long> procIdList = new ArrayList<Long>();
        procIdList.add(Long.valueOf(processInsId));
        ArrayList<Long> allProcId = new ArrayList<Long>();
        do {
            allProcId.addAll(procIdList);
        } while (HussarUtils.isNotEmpty(procIdList = this.taskEngineMapper.getAllCallActivityInstIds(procIdList)));
        List stringProcIds = allProcId.stream().map(s -> s.toString()).collect(Collectors.toList());
        List historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().processInstanceIds(new HashSet(stringProcIds)).list();
        this.historyService.deleteHistoricProcessInstance(processInsId);
        LambdaQueryWrapper ccQueryWrapper = new LambdaQueryWrapper();
        ccQueryWrapper.in(SysActCcTask::getProcessInsId, allProcId);
        this.iSysActCcTaskService.remove((Wrapper)ccQueryWrapper);
        HashMap<String, String> businessKeyMap = new HashMap<String, String>();
        HashSet<String> processDefinitionIdList = new HashSet<String>();
        for (HistoricProcessInstance historicProcessInstance : historicProcessInstances) {
            String businessIds = (String)businessKeyMap.get(historicProcessInstance.getProcessDefinitionId());
            businessIds = businessIds == null ? historicProcessInstance.getBusinessKey() : businessIds + "," + historicProcessInstance.getBusinessKey();
            businessKeyMap.put(historicProcessInstance.getProcessDefinitionId(), businessIds);
            processDefinitionIdList.add(historicProcessInstance.getProcessDefinitionId());
        }
        if (this.dataPushService.isDataPush(processDefinitionIdList)) {
            DataPush dataPush = new DataPush();
            dataPush.setBusinessMap(businessKeyMap);
            dataPush.setProcessState("deleteProcess");
            this.dataPushService.deleteDataPush(dataPush);
            this.dataPushService.changeProcessStateDataPush(dataPush);
            DataPush dataPushTemp = new DataPush();
            dataPushTemp.setProcessInsId(processInsId);
            this.dataPushService.deleteStartProcess(dataPushTemp);
        }
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult deleteFinishProcessInstanceByBusinessId(String businessId) {
        ArrayList<String> businessKeys = new ArrayList<String>();
        businessKeys.add(businessId);
        List<Long> procIdList = this.instanceEngineMapper.selectProcIdByBusinessIdList(businessKeys);
        if (procIdList.size() == 0) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getProcessNotStart(), null);
        }
        Long processInstanceId = procIdList.get(0);
        ArrayList<Long> allProcId = new ArrayList<Long>();
        do {
            allProcId.addAll(procIdList);
        } while (HussarUtils.isNotEmpty(procIdList = this.taskEngineMapper.getAllCallActivityInstIds(procIdList)));
        List stringProcIds = allProcId.stream().map(s -> s.toString()).collect(Collectors.toList());
        List historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().processInstanceIds(new HashSet(stringProcIds)).list();
        for (int i = 0; i < historicProcessInstances.size(); ++i) {
            if (!HussarUtils.isEmpty((Object)((HistoricProcessInstance)historicProcessInstances.get(i)).getEndTime())) continue;
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getProcessInstanceIsNotEnd(), null);
        }
        this.historyService.deleteHistoricProcessInstance(String.valueOf(processInstanceId));
        LambdaQueryWrapper ccQueryWrapper = new LambdaQueryWrapper();
        ccQueryWrapper.in(SysActCcTask::getProcessInsId, allProcId);
        this.iSysActCcTaskService.remove((Wrapper)ccQueryWrapper);
        HashMap<String, String> businessKeyMap = new HashMap<String, String>();
        HashSet<String> processDefinitionIdList = new HashSet<String>();
        for (HistoricProcessInstance historicProcessInstance : historicProcessInstances) {
            String businessIds = (String)businessKeyMap.get(historicProcessInstance.getProcessDefinitionKey());
            businessIds = businessIds == null ? historicProcessInstance.getBusinessKey() : businessIds + "," + historicProcessInstance.getBusinessKey();
            businessKeyMap.put(historicProcessInstance.getProcessDefinitionKey(), businessIds);
            processDefinitionIdList.add(historicProcessInstance.getProcessDefinitionId());
        }
        if (this.dataPushService.isDataPush(processDefinitionIdList)) {
            DataPush dataPush = new DataPush();
            dataPush.setBusinessMap(businessKeyMap);
            dataPush.setDescription("deleteProcess");
            this.dataPushService.deleteDataPush(dataPush);
        }
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult deleteProcessInstanceByBusinessId(String businessId) {
        if (businessId == null) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult();
        if (historicProcessInstance != null) {
            List<Long> procIdList = new ArrayList<Long>();
            procIdList.add(Long.valueOf(historicProcessInstance.getId()));
            ArrayList<Long> allProcId = new ArrayList<Long>();
            do {
                allProcId.addAll(procIdList);
            } while (HussarUtils.isNotEmpty(procIdList = this.taskEngineMapper.getAllCallActivityInstIds(procIdList)));
            List stringProcIds = allProcId.stream().map(s -> s.toString()).collect(Collectors.toList());
            List historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().processInstanceIds(new HashSet(stringProcIds)).list();
            if (historicProcessInstance.getEndTime() != null) {
                this.historyService.deleteHistoricProcessInstance(historicProcessInstance.getId());
            } else {
                List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceIdIn(stringProcIds)).list();
                StringBuilder taskIds = new StringBuilder();
                for (Task task : tasks) {
                    if (!HussarUtils.isNotEmpty((Object)task.getDueDate())) continue;
                    taskIds.append(",").append(task.getId());
                }
                if (HussarUtils.isNotEmpty((Object)taskIds.toString())) {
                    this.activityRedisTimerService.delTimeOutModel(taskIds.toString().substring(1));
                }
                this.runtimeService.deleteProcessInstance(historicProcessInstance.getId(), "");
                this.historyService.deleteHistoricProcessInstance(historicProcessInstance.getId());
            }
            LambdaQueryWrapper ccQueryWrapper = new LambdaQueryWrapper();
            ccQueryWrapper.in(SysActCcTask::getProcessInsId, allProcId);
            this.iSysActCcTaskService.remove((Wrapper)ccQueryWrapper);
            LambdaQueryWrapper urgeQueryWrapper = new LambdaQueryWrapper();
            urgeQueryWrapper.in(SysActUrgeTask::getProcessInsId, allProcId);
            this.iSysActUrgeTaskService.remove((Wrapper)urgeQueryWrapper);
            LambdaQueryWrapper lineQueryWrapper = new LambdaQueryWrapper();
            lineQueryWrapper.in(SysActHiLine::getProcessInsId, allProcId);
            this.iSysActHiLineService.remove((Wrapper)lineQueryWrapper);
            HashMap<String, String> businessKeyMap = new HashMap<String, String>();
            HashSet<String> processDefinitionIdList = new HashSet<String>();
            for (HistoricProcessInstance processInstance : historicProcessInstances) {
                String businessIds = (String)businessKeyMap.get(processInstance.getProcessDefinitionId());
                businessIds = businessIds == null ? processInstance.getBusinessKey() : businessIds + "," + processInstance.getBusinessKey();
                businessKeyMap.put(processInstance.getProcessDefinitionId(), businessIds);
                processDefinitionIdList.add(historicProcessInstance.getProcessDefinitionId());
            }
            if (this.dataPushService.isDataPush(processDefinitionIdList)) {
                DataPush dataPush = new DataPush();
                dataPush.setBusinessMap(businessKeyMap);
                dataPush.setProcessState("deleteProcess");
                this.dataPushService.deleteDataPush(dataPush);
                this.dataPushService.changeProcessStateDataPush(dataPush);
                DataPush dataPushTemp = new DataPush();
                dataPushTemp.setBusinessKey(businessId);
                this.dataPushService.deleteStartProcess(dataPushTemp);
            }
        }
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult deleteProcessInstanceByBusinessIdList(String businessId, boolean isValidate) {
        try {
            List<String> businessIdList;
            if (HussarUtils.isNotEmpty((Object)businessId) && HussarUtils.isNotEmpty(businessIdList = Arrays.asList(businessId.split(",")))) {
                if (isValidate) {
                    for (String s : businessIdList) {
                        BpmResponseResult validateResult;
                        if (s.isEmpty() || (validateResult = this.validateDeleteByBusinessId(s)).getResult().get(0) != null && "1".equals(validateResult.getResult().get(0).toString())) continue;
                        return InstallResult.getResult((String)"0", (String)validateResult.getMsg(), null);
                    }
                }
                List<Long> procIdList = this.instanceEngineMapper.selectProcIdByBusinessIdList(businessIdList);
                List<ProcessInstVo> businessProcKeyList = this.instanceEngineMapper.selectProcKeyByBusinessIdList(businessIdList);
                HashMap<String, String> businessMap = new HashMap<String, String>();
                HashSet<String> processDefinitionIdList = new HashSet<String>();
                if (HussarUtils.isNotEmpty(businessProcKeyList)) {
                    for (ProcessInstVo processInstVo : businessProcKeyList) {
                        if (businessMap.containsKey(processInstVo.getProcessDefinitionId())) {
                            String businessIds = (String)businessMap.get(processInstVo.getProcessDefinitionId());
                            businessIds = businessIds + "," + processInstVo.getBusinessId();
                            businessMap.put(processInstVo.getProcessDefinitionId(), businessIds);
                        } else {
                            businessMap.put(processInstVo.getProcessDefinitionId(), processInstVo.getBusinessId());
                        }
                        processDefinitionIdList.add(processInstVo.getProcessDefinitionId());
                    }
                }
                if (!procIdList.isEmpty()) {
                    ArrayList<Long> allProcId = new ArrayList<Long>();
                    do {
                        allProcId.addAll(procIdList);
                    } while (HussarUtils.isNotEmpty(procIdList = this.taskEngineMapper.getAllCallActivityInstIds(procIdList)));
                    this.multiDeleteByProcIdList(allProcId, businessMap, processDefinitionIdList);
                }
            }
        }
        catch (Exception e) {
            return InstallResult.getResult((String)"0", (String)"error", null);
        }
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult queryFinishedProcessInstance(String processKey, String businessId, int page, int rows) {
        JSONObject object = new JSONObject();
        JSONArray json = new JSONArray();
        HistoricProcessInstanceQuery countQuery = this.historyService.createHistoricProcessInstanceQuery().finished();
        HistoricProcessInstanceQuery listQuery = (HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().finished().orderByProcessInstanceEndTime().desc();
        if (HussarUtils.isNotEmpty((Object)businessId)) {
            countQuery.processInstanceBusinessKey(businessId);
            listQuery.processInstanceBusinessKey(businessId);
        }
        if (HussarUtils.isNotEmpty((Object)processKey)) {
            countQuery.processDefinitionKey(processKey);
            listQuery.processDefinitionKey(processKey);
        }
        Long count = countQuery.count();
        List insts = listQuery.listPage((page - 1) * rows, rows);
        object.put("data", (Object)insts);
        object.put("count", (Object)count);
        json.add((Object)object);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult queryProcessInstanceCompleteState(String processInsId) {
        JSONArray json = new JSONArray();
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInsId).singleResult();
        Boolean isEnded = historicProcessInstance == null ? null : Boolean.valueOf(historicProcessInstance.getEndTime() != null);
        json.add(isEnded);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult queryProcessInstanceCompleteStateByBusinessId(String businessId) {
        JSONArray json = new JSONArray();
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult();
        Boolean isEnded = historicProcessInstance == null ? null : Boolean.valueOf(historicProcessInstance.getEndTime() != null);
        json.add(isEnded);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult getProcessTrace(String processInsId) {
        if (processInsId == null) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        JSONArray jsonArray = new JSONArray();
        HistoricProcessInstance processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInsId).singleResult();
        if (processInstance == null) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getProcessNotFound(), null);
        }
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(processInstance.getProcessDefinitionId());
        List activitiList = processDefinition.getActivities();
        List hisList = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInsId).activityType("userTask").orderByHistoricActivityInstanceStartTime().desc()).finished().list();
        List<Object> userList = new ArrayList();
        if (hisList != null && !hisList.isEmpty()) {
            userList = hisList.stream().map(HistoricActivityInstance::getAssignee).filter(Objects::nonNull).collect(Collectors.toList());
        }
        Map finalUsersMap = this.iAssigneeChooseService.getUserListByUserId(userList);
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInsId)).list();
        for (ActivityImpl activity : activitiList) {
            JSONObject object = new JSONObject();
            object.put("width", (Object)activity.getWidth());
            object.put("height", (Object)activity.getHeight());
            object.put("x", (Object)activity.getX());
            object.put("y", (Object)activity.getY());
            object.put("id", (Object)activity.getId());
            List taskList = null;
            if (tasks != null && !tasks.isEmpty()) {
                taskList = tasks.stream().filter(t -> t.getTaskDefinitionKey().equals(activity.getId())).collect(Collectors.toList());
            }
            if (taskList != null && !taskList.isEmpty()) {
                List<String> user = this.getAssigneeByTaskId(((Task)taskList.get(0)).getId());
                if (!user.isEmpty()) {
                    String assignee = this.iAssigneeChooseService.getUserNames(user);
                    object.put("assignee", (Object)assignee);
                } else {
                    object.put("assignee", (Object)this.bpmConstantProperties.getNullAssignee());
                }
                object.put("state", (Object)NOW_STATE);
            } else {
                object.put("state", (Object)FINISH_STATE);
                List hisActivitList = null;
                if (hisList != null && !hisList.isEmpty()) {
                    hisActivitList = hisList.stream().filter(hai -> hai.getActivityId().equals(activity.getId())).collect(Collectors.toList());
                }
                if (hisActivitList == null || hisActivitList.isEmpty()) continue;
                hisActivitList.sort(Comparator.comparing(HistoricActivityInstance::getStartTime));
                JSONArray json = new JSONArray();
                for (HistoricActivityInstance historicActivityInstance : hisActivitList) {
                    List comments;
                    JSONObject o = new JSONObject();
                    String user = "";
                    if (historicActivityInstance.getAssignee() != null) {
                        user = (String)finalUsersMap.get(historicActivityInstance.getAssignee());
                    }
                    if ((comments = this.taskService.getTaskComments(historicActivityInstance.getTaskId(), NOW_STATE)) != null && !comments.isEmpty()) {
                        o.put("comments", (Object)(((Comment)comments.get(0)).getFullMessage() == null ? this.bpmConstantProperties.getNullComment() : ((Comment)comments.get(0)).getFullMessage()));
                    } else {
                        o.put("comments", (Object)this.bpmConstantProperties.getNullComment());
                    }
                    o.put("assignee", (Object)user);
                    o.put("endTime", (Object)historicActivityInstance.getEndTime());
                    o.put("startTime", (Object)historicActivityInstance.getStartTime());
                    json.add((Object)o);
                }
                object.put("completeInfo", (Object)json);
            }
            jsonArray.add((Object)object);
        }
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    public BpmResponseResult getAllProcessTrace(String processInsId, String subProcessKey, Integer cycleCount) {
        if (processInsId == null) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        List hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().queryChildTask()).processInstanceId(processInsId)).subProcessKey(subProcessKey)).cycleCount(cycleCount)).list();
        return this.getResult(hisTaskList, true, true);
    }

    public JSONObject getProcessHistoryMsg(String processInsId, String businessId, Integer processCycleCount, boolean isFirstQuery, String initialProcessInsId, String initialBusinessId, boolean needGetCallActivity) {
        HistoricProcessInstanceQuery historicProcessInstanceQuery = this.historyService.createHistoricProcessInstanceQuery();
        if (HussarUtils.isEmpty((Object)processInsId)) {
            if (HussarUtils.isEmpty((Object)businessId)) {
                return new JSONObject();
            }
            historicProcessInstanceQuery.processInstanceBusinessKey(businessId);
        } else {
            historicProcessInstanceQuery.processInstanceId(processInsId);
        }
        HistoricProcessInstance processInstance = (HistoricProcessInstance)historicProcessInstanceQuery.singleResult();
        if (processInstance == null) {
            return new JSONObject();
        }
        processInsId = processInstance.getId();
        JSONObject result = new JSONObject();
        JSONObject json = this.getProcessHistory(processInsId, processInstance.getProcessDefinitionName(), processCycleCount, isFirstQuery, true, null, needGetCallActivity);
        if (isFirstQuery) {
            result.put("processHistory", json.get((Object)"processHistory"));
            result.put("processHistoryCount", (Object)json.getJSONArray("processHistory").size());
            if (processInstance.getSuperProcessInstanceId() != null) {
                HistoricProcessInstance superProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstance.getSuperProcessInstanceId()).singleResult();
                String processInsIdCondition = null;
                if (HussarUtils.isNotEmpty((Object)businessId) && businessId.equals(initialBusinessId) || HussarUtils.isNotEmpty((Object)processInsId) && processInsId.equals(initialProcessInsId)) {
                    processInsIdCondition = processInsId;
                }
                JSONObject mainProcess = this.getProcessHistory(superProcessInstance.getId(), superProcessInstance.getProcessDefinitionName(), processCycleCount, isFirstQuery, true, processInsIdCondition, needGetCallActivity);
                result.put("superProcessHistoryWithCallActivity", mainProcess.get((Object)"processHistoryWithCallActivity"));
                result.put("superProcessHistoryWithCallActivityCount", (Object)mainProcess.getJSONArray("processHistoryWithCallActivity").size());
                result.put("superProcessHistory", mainProcess.get((Object)"processHistoryWithCallActivity"));
                result.put("superProcessHistoryCount", (Object)mainProcess.getJSONArray("processHistoryWithCallActivity").size());
            }
            if (json.containsKey((Object)"processHistoryWithCallActivity")) {
                result.put("processHistoryWithCallActivity", json.get((Object)"processHistoryWithCallActivity"));
                result.put("processHistoryWithCallActivityCount", (Object)json.getJSONArray("processHistoryWithCallActivity").size());
            }
        } else {
            result.put("processHistory", json.get((Object)"processHistory"));
            result.put("processHistoryCount", (Object)json.getJSONArray("processHistory").size());
        }
        return result;
    }

    private JSONObject getProcessHistory(String processInsId, String modelName, Integer processCycleCount, boolean isFirstQuery, boolean getWithCallActivity, String callActivityProcessInsId, boolean needGetCallActivity) {
        JSONObject json = new JSONObject();
        JSONArray result = new JSONArray();
        JSONArray resultWithCallProcess = new JSONArray();
        boolean containsCallActivity = false;
        json.put("processHistory", (Object)result);
        List hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().queryChildTask()).processInstanceId(processInsId)).processCycleCount(processCycleCount)).list();
        if (!hisTaskList.isEmpty()) {
            HashSet<String> userList = new HashSet<String>();
            ArrayList<Long> hisTaskIds = new ArrayList<Long>();
            ArrayList runningTaskIds = new ArrayList();
            hisTaskList.forEach(o -> {
                if (isFirstQuery || processCycleCount != null || o.getProcessCycleCount() == null) {
                    if (o.getEndTime() != null) {
                        hisTaskIds.add(Long.parseLong(o.getId()));
                        if (TaskStateType.isEntrust((HistoricTaskInstance)o) && HussarUtils.isNotEmpty((Object)o.getOwner())) {
                            userList.add(o.getOwner());
                        }
                        if (HussarUtils.isNotEmpty((Object)o.getAssignee())) {
                            userList.add(o.getAssignee());
                        }
                    } else {
                        runningTaskIds.add(Long.parseLong(o.getId()));
                    }
                }
            });
            List users = new ArrayList();
            if (!runningTaskIds.isEmpty()) {
                LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
                lambdaQueryWrapper.in(BpmActRuIdentitylink::getTaskId, runningTaskIds);
                lambdaQueryWrapper.eq(BpmActRuIdentitylink::getType, (Object)"candidate");
                users = this.bpmActRuIdentitylinkMapper.selectList((Wrapper)lambdaQueryWrapper);
            }
            HashMap<String, List> todoUserMap = new HashMap<String, List>();
            for (BpmActRuIdentitylink identityLink : users) {
                if (HussarUtils.isNotEmpty((Object)identityLink.getMandator())) {
                    userList.add(identityLink.getMandator());
                }
                userList.add(identityLink.getUserId());
                todoUserMap.computeIfAbsent(String.valueOf(identityLink.getTaskId()), k -> new ArrayList()).add(identityLink);
            }
            Map finalUsersMap = this.iAssigneeChooseService.getUserListByUserId(new ArrayList(userList));
            List<Object> commentsMap = new ArrayList();
            if (!hisTaskIds.isEmpty()) {
                commentsMap = this.taskEngineMapper.getTaskComments(hisTaskIds);
            }
            HashMap<String, String> taskComment = new HashMap<String, String>();
            for (TaskCommentVO taskCommentVO : commentsMap) {
                taskComment.put(String.valueOf(taskCommentVO.getTaskId()), taskCommentVO.getFullMessage() == null ? taskCommentVO.getMessage() : taskCommentVO.getFullMessage());
            }
            List<Object> allVariables = new ArrayList();
            if (HussarUtils.isNotEmpty(hisTaskIds)) {
                allVariables = this.flowTaskMapper.getAllVariables(hisTaskIds, null);
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (Variables variables : allVariables) {
                if (!"taskSourceFlag".equals(variables.getName())) continue;
                hashMap.put(variables.getTaskId(), variables.getTextValue());
            }
            HashMap<String, JSONArray> map = new HashMap<String, JSONArray>();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            for (HistoricTaskInstance hsi : hisTaskList) {
                if (!isFirstQuery && processCycleCount == null && hsi.getProcessCycleCount() != null) continue;
                JSONObject object = new JSONObject();
                String user = hsi.getAssignee() != null ? (finalUsersMap.get(hsi.getAssignee()) == null ? this.bpmConstantProperties.getNullComplete() : (TaskStateType.isEntrust((HistoricTaskInstance)hsi) ? (String)finalUsersMap.get(hsi.getAssignee()) + "(" + (String)finalUsersMap.get(hsi.getOwner()) + ")" : (String)finalUsersMap.get(hsi.getAssignee()))) : this.bpmConstantProperties.getNullComplete();
                String nullCommont = this.bpmConstantProperties.getNullComment();
                String comment = (String)taskComment.get(hsi.getId());
                object.put("comments", (Object)(comment == null ? nullCommont : comment));
                object.put("startTime", (Object)sdf.format(hsi.getStartTime()));
                object.put("start", (Object)hsi.getStartTime());
                object.put("end", (Object)hsi.getEndTime());
                if (hsi.getEndTime() != null) {
                    object.put("assignee", (Object)user);
                    object.put("endTime", (Object)sdf.format(hsi.getEndTime()));
                } else {
                    object.put("endTime", (Object)"");
                    List todoUser = (List)todoUserMap.get(hsi.getId());
                    if (HussarUtils.isNotEmpty((Object)todoUser)) {
                        ArrayList<String> todoUserName = new ArrayList<String>();
                        for (BpmActRuIdentitylink identityLink : todoUser) {
                            if (finalUsersMap.get(identityLink.getUserId()) == null) continue;
                            if (TaskStateType.isEntrust((String)identityLink.getTaskState()) && finalUsersMap.get(identityLink.getMandator()) != null) {
                                todoUserName.add((String)finalUsersMap.get(identityLink.getUserId()) + "(" + (String)finalUsersMap.get(identityLink.getMandator()) + ")");
                                continue;
                            }
                            todoUserName.add((String)finalUsersMap.get(identityLink.getUserId()));
                        }
                        String assignee = String.join((CharSequence)",", todoUserName);
                        if (HussarUtils.isNotEmpty((Object)assignee)) {
                            object.put("assignee", (Object)assignee);
                        } else {
                            object.put("assignee", (Object)this.bpmConstantProperties.getNullComplete());
                        }
                    } else {
                        object.put("assignee", (Object)this.bpmConstantProperties.getNullComplete());
                    }
                    object.put("comments", (Object)"");
                }
                object.put("modelName", (Object)modelName);
                object.put("activityName", (Object)hsi.getName());
                object.put("activityId", (Object)hsi.getId());
                object.put("taskId", (Object)hsi.getId());
                object.put("taskDefinitionKey", (Object)hsi.getTaskDefinitionKey());
                object.put("processDefinitionId", (Object)hsi.getProcessDefinitionId());
                object.put("processKey", (Object)hsi.getProcessDefinitionId().split(":")[0]);
                object.put("processInsId", (Object)hsi.getProcessInstanceId());
                object.put("assigneeId", (Object)hsi.getAssignee());
                String taskSourceFlag = (String)hashMap.get(hsi.getId());
                object.put("sub_process_key", (Object)hsi.getSubProcessKey());
                object.put("taskSourceFlag", (Object)(taskSourceFlag == null ? "" : TASK_SOURCE_FLAG.get(taskSourceFlag)));
                object.put("taskType", (Object)hsi.getTaskType());
                if (hsi.getSubProcessKey() != null) {
                    String subProcessKey = hsi.getSubProcessKey();
                    Integer cycleCount = hsi.getCycleCount();
                    map.computeIfAbsent(subProcessKey + ":" + cycleCount, k -> new JSONArray()).add((Object)object);
                    continue;
                }
                result.add((Object)object);
                resultWithCallProcess.add((Object)object);
            }
            List activityInstances = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInsId).processCycleCount(processCycleCount).list();
            HashMap<String, List> subProcessMap = new HashMap<String, List>();
            HashMap<String, List> callActivityMap = new HashMap<String, List>();
            for (HistoricActivityInstance historicActivityInstance : activityInstances) {
                Integer cycleCount;
                String taskDefKey;
                if (!isFirstQuery && processCycleCount == null && historicActivityInstance.getProcessCycleCount() != null) continue;
                if ("subProcess".equals(historicActivityInstance.getActivityType())) {
                    taskDefKey = historicActivityInstance.getActivityId();
                    cycleCount = historicActivityInstance.getCycleCount();
                    subProcessMap.computeIfAbsent(taskDefKey + ":" + cycleCount, k -> new ArrayList()).add(historicActivityInstance);
                    continue;
                }
                if (!"callActivity".equals(historicActivityInstance.getActivityType()) || callActivityProcessInsId != null && !callActivityProcessInsId.equals(historicActivityInstance.getCalledProcessInstanceId())) continue;
                taskDefKey = historicActivityInstance.getActivityId();
                cycleCount = historicActivityInstance.getCycleCount();
                callActivityMap.computeIfAbsent(taskDefKey + ":" + cycleCount, k -> new ArrayList()).add(historicActivityInstance);
            }
            for (List list : subProcessMap.values()) {
                Date start = ((HistoricActivityInstance)list.get(0)).getStartTime();
                Date end = ((HistoricActivityInstance)list.get(0)).getEndTime();
                JSONArray jsonArray = new JSONArray();
                for (HistoricActivityInstance subProcess : list) {
                    JSONObject subProcessMsg = new JSONObject();
                    JSONArray subProcessTask = (JSONArray)map.get(subProcess.getSubProcessKey() + ":" + subProcess.getCycleCount());
                    if (HussarUtils.isEmpty((Object)subProcessTask)) continue;
                    this.processHistoryMsgSort(subProcessTask);
                    subProcessMsg.put("subProcessTask", (Object)subProcessTask);
                    subProcessMsg.put("taskDefinitionName", (Object)subProcess.getActivityName());
                    subProcessMsg.put("activityId", (Object)subProcess.getId());
                    subProcessMsg.put("taskDefinitionKey", (Object)subProcess.getActivityId());
                    subProcessMsg.put("startTime", (Object)sdf.format(subProcess.getStartTime()));
                    subProcessMsg.put("start", (Object)subProcess.getStartTime());
                    if (start.after(subProcess.getStartTime())) {
                        start = subProcess.getStartTime();
                    }
                    subProcessMsg.put("taskSourceFlag", (Object)"");
                    subProcessMsg.put("sub_process_key", (Object)subProcess.getSubProcessKey());
                    subProcessMsg.put("type", (Object)"subProcess");
                    if (subProcess.getEndTime() != null) {
                        subProcessMsg.put("endTime", (Object)sdf.format(subProcess.getEndTime()));
                        if (end != null && end.before(subProcess.getEndTime())) {
                            end = subProcess.getEndTime();
                        }
                        subProcessMsg.put("end", (Object)subProcess.getEndTime());
                    }
                    int loopCounter = Integer.parseInt(subProcess.getSubProcessKey().split(":")[2]);
                    subProcessMsg.put("activityName", (Object)(SUB_PROCINST_NAME + (loopCounter + 1)));
                    while (jsonArray.size() < loopCounter + 1) {
                        jsonArray.add((Object)"");
                    }
                    jsonArray.set(loopCounter, (Object)subProcessMsg);
                }
                ArrayList<String> removeList = new ArrayList<String>();
                removeList.add("");
                jsonArray.removeAll(removeList);
                if (jsonArray.isEmpty()) continue;
                for (int m = 0; m < jsonArray.size(); ++m) {
                    jsonArray.getJSONObject(m).put("activityName", (Object)(SUB_PROCINST_NAME + (m + 1)));
                }
                JSONObject object = jsonArray.getJSONObject(0);
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("activityName", object.get((Object)"taskDefinitionName"));
                jsonObject.put("activityId", object.get((Object)"activityId"));
                jsonObject.put("taskDefinitionKey", object.get((Object)"taskDefinitionKey"));
                jsonObject.put("start", (Object)start);
                jsonObject.put("end", (Object)end);
                jsonObject.put("taskSourceFlag", (Object)"");
                jsonObject.put("subProcess", (Object)jsonArray);
                jsonObject.put("type", (Object)"multiSubProcess");
                result.add((Object)jsonObject);
                resultWithCallProcess.add((Object)jsonObject);
            }
            if (getWithCallActivity) {
                for (List list : callActivityMap.values()) {
                    containsCallActivity = true;
                    int loopCounter = 0;
                    HashSet<String> processInstIds = new HashSet<String>();
                    boolean isNotSegmentation = ((HistoricActivityInstance)list.get(0)).getCycleCount() == null;
                    Date start = ((HistoricActivityInstance)list.get(0)).getStartTime();
                    Date end = ((HistoricActivityInstance)list.get(0)).getEndTime();
                    JSONArray jsonArray = new JSONArray();
                    for (HistoricActivityInstance subProcess : list) {
                        if (isNotSegmentation && !processInstIds.add(subProcess.getCalledProcessInstanceId())) continue;
                        JSONObject callActivityMsg = new JSONObject();
                        callActivityMsg.put("processInsId", (Object)subProcess.getCalledProcessInstanceId());
                        callActivityMsg.put("process_cycle_count", (Object)subProcess.getCycleCount());
                        if (subProcess.getCalledProcessInstanceId() == null || ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(subProcess.getCalledProcessInstanceId())).processCycleCount(subProcess.getCycleCount())).count() == 0L) continue;
                        callActivityMsg.put("taskDefinitionName", (Object)subProcess.getActivityName());
                        callActivityMsg.put("activityId", (Object)subProcess.getId());
                        callActivityMsg.put("taskDefinitionKey", (Object)subProcess.getActivityId());
                        callActivityMsg.put("startTime", (Object)sdf.format(subProcess.getStartTime()));
                        callActivityMsg.put("start", (Object)subProcess.getStartTime());
                        if (start.after(subProcess.getStartTime())) {
                            start = subProcess.getStartTime();
                        }
                        callActivityMsg.put("taskSourceFlag", (Object)"");
                        callActivityMsg.put("type", (Object)"callActivity");
                        if (subProcess.getEndTime() != null) {
                            callActivityMsg.put("endTime", (Object)sdf.format(subProcess.getEndTime()));
                            if (end != null && end.before(subProcess.getEndTime())) {
                                end = subProcess.getEndTime();
                            }
                            callActivityMsg.put("end", (Object)subProcess.getEndTime());
                        }
                        callActivityMsg.put("activityName", (Object)(SUB_PROCINST_NAME + (loopCounter + 1)));
                        jsonArray.set(loopCounter, (Object)callActivityMsg);
                        ++loopCounter;
                    }
                    if (jsonArray.isEmpty()) continue;
                    JSONObject object = jsonArray.getJSONObject(0);
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("activityName", object.get((Object)"taskDefinitionName"));
                    jsonObject.put("activityId", object.get((Object)"activityId"));
                    jsonObject.put("taskDefinitionKey", object.get((Object)"taskDefinitionKey"));
                    jsonObject.put("start", (Object)start);
                    jsonObject.put("end", (Object)end);
                    jsonObject.put("taskSourceFlag", (Object)"");
                    jsonObject.put("subProcess", (Object)jsonArray);
                    jsonObject.put("type", (Object)"multiCallActivity");
                    resultWithCallProcess.add((Object)jsonObject);
                }
            }
        }
        if (isFirstQuery) {
            this.processHistoryMsgSort(result);
            if (containsCallActivity) {
                this.processHistoryMsgSort(resultWithCallProcess);
                json.put("processHistoryWithCallActivity", (Object)resultWithCallProcess);
            }
        } else if (needGetCallActivity) {
            this.processHistoryMsgSort(resultWithCallProcess);
            json.put("processHistory", (Object)resultWithCallProcess);
        } else {
            this.processHistoryMsgSort(result);
        }
        return json;
    }

    private void processHistoryMsgSort(JSONArray json) {
        String completeHistoryOrderingRule;
        JSONArray list = json;
        switch (completeHistoryOrderingRule = this.lcdpBpmProperties.getCompleteHistoryOrderingRule()) {
            case "create-time-asc": {
                list.sort((o1, o2) -> {
                    if (!o1.getDate("start").equals(o2.getDate("start"))) {
                        return o1.getDate("start").compareTo(o2.getDate("start"));
                    }
                    if (HussarUtils.isAllEmpty((Object[])new Object[]{o1.getDate("end"), o2.getDate("end")})) {
                        return o1.getString("taskDefinitionKey").compareTo(o2.getString("taskDefinitionKey"));
                    }
                    if (o1.getDate("end") == null && o2.getDate("end") != null) {
                        return new Date(0L).compareTo(o2.getDate("end"));
                    }
                    if (o1.getDate("end") != null && o2.getDate("end") == null) {
                        return o1.getDate("end").compareTo(new Date());
                    }
                    if (Objects.equals(o1.getDate("end"), o2.getDate("end"))) {
                        return o1.getString("taskDefinitionKey").compareTo(o2.getString("taskDefinitionKey"));
                    }
                    return o1.getDate("end").compareTo(o2.getDate("end"));
                });
                break;
            }
            case "create-time-desc": {
                list.sort((o1, o2) -> {
                    if (!o1.getDate("start").equals(o2.getDate("start"))) {
                        return o2.getDate("start").compareTo(o1.getDate("start"));
                    }
                    if (HussarUtils.isAllEmpty((Object[])new Object[]{o1.getDate("end"), o2.getDate("end")})) {
                        return o2.getString("taskDefinitionKey").compareTo(o1.getString("taskDefinitionKey"));
                    }
                    if (o1.getDate("end") == null && o2.getDate("end") != null) {
                        return o2.getDate("end").compareTo(new Date());
                    }
                    if (o1.getDate("end") != null && o2.getDate("end") == null) {
                        return new Date(0L).compareTo(o1.getDate("end"));
                    }
                    if (Objects.equals(o1.getDate("end"), o2.getDate("end"))) {
                        return o2.getString("taskDefinitionKey").compareTo(o1.getString("taskDefinitionKey"));
                    }
                    return o2.getDate("end").compareTo(o1.getDate("end"));
                });
                break;
            }
            default: {
                list.sort((o1, o2) -> {
                    if (HussarUtils.isAllEmpty((Object[])new Object[]{o1.getDate("end"), o2.getDate("end")})) {
                        return o1.getString("taskDefinitionKey").compareTo(o2.getString("taskDefinitionKey"));
                    }
                    if (o1.getDate("end") == null && o2.getDate("end") != null) {
                        return new Date(0L).compareTo(o2.getDate("end"));
                    }
                    if (o1.getDate("end") != null && o2.getDate("end") == null) {
                        return o1.getDate("end").compareTo(new Date(0L));
                    }
                    if (Objects.equals(o1.getDate("end"), o2.getDate("end"))) {
                        return o1.getString("taskDefinitionKey").compareTo(o2.getString("taskDefinitionKey"));
                    }
                    return o1.getDate("end").compareTo(o2.getDate("end"));
                });
            }
        }
    }

    public JSONArray getAllProcessTraceForComment(String processInsId) {
        String completeHistoryOrderingRule;
        if (processInsId == null) {
            return new JSONArray();
        }
        List hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().queryChildTask()).processInstanceId(processInsId)).includeTaskLocalVariables()).finished().list();
        ArrayList userList = new ArrayList();
        if (hisTaskList != null && !hisTaskList.isEmpty()) {
            hisTaskList.forEach(o -> {
                if (TaskStateType.isEntrust((HistoricTaskInstance)o) && HussarUtils.isNotEmpty((Object)o.getOwner())) {
                    userList.add(o.getOwner());
                }
                if (HussarUtils.isNotEmpty((Object)o.getAssignee())) {
                    userList.add(o.getAssignee());
                }
            });
        }
        switch (completeHistoryOrderingRule = this.lcdpBpmProperties.getCompleteHistoryOrderingRule()) {
            case "create-time-asc": {
                hisTaskList.sort((o1, o2) -> {
                    if (!o1.getStartTime().equals(o2.getStartTime())) {
                        return o1.getStartTime().compareTo(o2.getStartTime());
                    }
                    if (HussarUtils.isAllEmpty((Object[])new Object[]{o1.getEndTime(), o2.getEndTime()})) {
                        return o1.getTaskDefinitionKey().compareTo(o2.getTaskDefinitionKey());
                    }
                    if (o1.getEndTime() == null && o2.getEndTime() != null) {
                        return new Date(0L).compareTo(o2.getEndTime());
                    }
                    if (o1.getEndTime() != null && o2.getEndTime() == null) {
                        return o1.getEndTime().compareTo(new Date());
                    }
                    if (Objects.equals(o1.getEndTime(), o2.getEndTime())) {
                        return o1.getTaskDefinitionKey().compareTo(o2.getTaskDefinitionKey());
                    }
                    return o1.getEndTime().compareTo(o2.getEndTime());
                });
                break;
            }
            case "create-time-desc": {
                hisTaskList.sort((o1, o2) -> {
                    if (!o1.getStartTime().equals(o2.getStartTime())) {
                        return o2.getStartTime().compareTo(o1.getStartTime());
                    }
                    if (HussarUtils.isAllEmpty((Object[])new Object[]{o1.getEndTime(), o2.getEndTime()})) {
                        return o2.getTaskDefinitionKey().compareTo(o1.getTaskDefinitionKey());
                    }
                    if (o1.getEndTime() == null && o2.getEndTime() != null) {
                        return o2.getEndTime().compareTo(new Date());
                    }
                    if (o1.getEndTime() != null && o2.getEndTime() == null) {
                        return new Date(0L).compareTo(o1.getEndTime());
                    }
                    if (Objects.equals(o1.getEndTime(), o2.getEndTime())) {
                        return o2.getTaskDefinitionKey().compareTo(o1.getTaskDefinitionKey());
                    }
                    return o2.getEndTime().compareTo(o1.getEndTime());
                });
                break;
            }
            default: {
                hisTaskList.sort((o1, o2) -> {
                    if (HussarUtils.isAllEmpty((Object[])new Object[]{o1.getEndTime(), o2.getEndTime()})) {
                        return o1.getTaskDefinitionKey().compareTo(o2.getTaskDefinitionKey());
                    }
                    if (o1.getEndTime() == null && o2.getEndTime() != null) {
                        return new Date(0L).compareTo(o2.getEndTime());
                    }
                    if (o1.getEndTime() != null && o2.getEndTime() == null) {
                        return o1.getEndTime().compareTo(new Date(0L));
                    }
                    if (Objects.equals(o1.getEndTime(), o2.getEndTime())) {
                        return o1.getTaskDefinitionKey().compareTo(o2.getTaskDefinitionKey());
                    }
                    return o1.getEndTime().compareTo(o2.getEndTime());
                });
            }
        }
        Map finalUsersMap = this.iAssigneeChooseService.getUserListByUserId(userList);
        JSONArray jsonArray = new JSONArray();
        for (HistoricTaskInstance hsi : hisTaskList) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("taskId", (Object)hsi.getId());
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            jsonObject.put("endTime", (Object)sdf.format(hsi.getEndTime()));
            jsonObject.put("activityName", (Object)hsi.getName());
            jsonObject.put("sub_process_key", (Object)hsi.getSubProcessKey());
            jsonObject.put("start", (Object)hsi.getStartTime());
            String user = null;
            user = hsi.getAssignee() != null ? (finalUsersMap.get(hsi.getAssignee()) == null ? this.bpmConstantProperties.getNullComplete() : (TaskStateType.isEntrust((HistoricTaskInstance)hsi) ? (String)finalUsersMap.get(hsi.getAssignee()) + "(" + (String)finalUsersMap.get(hsi.getOwner()) + ")" : (String)finalUsersMap.get(hsi.getAssignee()))) : this.bpmConstantProperties.getNullComplete();
            jsonObject.put("assignee", (Object)user);
            jsonObject.put("taskType", (Object)hsi.getTaskType());
            Map variables = hsi.getTaskLocalVariables();
            String taskSourceFlag = (String)variables.get("taskSourceFlag");
            jsonObject.put("taskSourceFlag", (Object)TASK_SOURCE_FLAG.get(taskSourceFlag));
            jsonArray.add((Object)jsonObject);
        }
        this.handleSubProcessMessage(jsonArray, new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"), processInsId);
        return jsonArray;
    }

    public BpmResponseResult queryCallActivityTask(String businessId, String processInsId, int type) {
        HistoricProcessInstance historicProcessInstance;
        if (HussarUtils.isAllEmpty((Object[])new Object[]{processInsId, businessId})) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        List<Object> processInsIds = new ArrayList();
        if (type == 0) {
            if (HussarUtils.isEmpty((Object)processInsId)) {
                historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult();
                if (historicProcessInstance == null) {
                    return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getProcessNotFound(), null);
                }
                processInsId = historicProcessInstance.getId();
            }
            if ((processInsIds = this.taskEngineMapper.getCallActivityInstId(Long.parseLong(processInsId))).isEmpty()) {
                return InstallResult.getResult((String)"1", (String)"success", null);
            }
        } else {
            historicProcessInstance = HussarUtils.isEmpty((Object)processInsId) ? (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult() : (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInsId).singleResult();
            if (historicProcessInstance == null) {
                return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getProcessNotFound(), null);
            }
            if (HussarUtils.isEmpty((Object)historicProcessInstance.getSuperProcessInstanceId())) {
                return InstallResult.getResult((String)"1", (String)"success", null);
            }
            processInsIds.add(historicProcessInstance.getSuperProcessInstanceId());
        }
        List historicTaskInstances = ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceIdIn(processInsIds)).list();
        return this.getResult(historicTaskInstances, true, true);
    }

    public BpmResponseResult getAllProcessTraceByBusinessId(String businessId, int page, int size) {
        if (businessId == null) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        Long count = ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceBusinessKey(businessId)).count();
        List hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceBusinessKey(businessId)).orderByHistoricTaskInstanceEndTime().asc()).listPage((page - 1) * size, size);
        BpmResponseResult bpmResponseResult = this.getResult(hisTaskList, true, true);
        bpmResponseResult.setMsg(String.valueOf(count));
        return bpmResponseResult;
    }

    private BpmResponseResult getResult(List<HistoricTaskInstance> hisTaskList, boolean flag, boolean handleSubProcessMessage) {
        String completeHistoryOrderingRule;
        JSONArray json = new JSONArray();
        ArrayList userList = new ArrayList();
        if (hisTaskList != null && !hisTaskList.isEmpty()) {
            hisTaskList.forEach(o -> {
                if (TaskStateType.isEntrust((HistoricTaskInstance)o) && HussarUtils.isNotEmpty((Object)o.getOwner())) {
                    userList.add(o.getOwner());
                }
                if (HussarUtils.isNotEmpty((Object)o.getAssignee())) {
                    userList.add(o.getAssignee());
                }
            });
        }
        switch (completeHistoryOrderingRule = this.lcdpBpmProperties.getCompleteHistoryOrderingRule()) {
            case "create-time-asc": {
                hisTaskList.sort((o1, o2) -> {
                    if (!o1.getStartTime().equals(o2.getStartTime())) {
                        return o1.getStartTime().compareTo(o2.getStartTime());
                    }
                    if (HussarUtils.isAllEmpty((Object[])new Object[]{o1.getEndTime(), o2.getEndTime()})) {
                        return o1.getTaskDefinitionKey().compareTo(o2.getTaskDefinitionKey());
                    }
                    if (o1.getEndTime() == null && o2.getEndTime() != null) {
                        return new Date(0L).compareTo(o2.getEndTime());
                    }
                    if (o1.getEndTime() != null && o2.getEndTime() == null) {
                        return o1.getEndTime().compareTo(new Date());
                    }
                    if (Objects.equals(o1.getEndTime(), o2.getEndTime())) {
                        return o1.getTaskDefinitionKey().compareTo(o2.getTaskDefinitionKey());
                    }
                    return o1.getEndTime().compareTo(o2.getEndTime());
                });
                break;
            }
            case "create-time-desc": {
                hisTaskList.sort((o1, o2) -> {
                    if (!o1.getStartTime().equals(o2.getStartTime())) {
                        return o2.getStartTime().compareTo(o1.getStartTime());
                    }
                    if (HussarUtils.isAllEmpty((Object[])new Object[]{o1.getEndTime(), o2.getEndTime()})) {
                        return o2.getTaskDefinitionKey().compareTo(o1.getTaskDefinitionKey());
                    }
                    if (o1.getEndTime() == null && o2.getEndTime() != null) {
                        return o2.getEndTime().compareTo(new Date());
                    }
                    if (o1.getEndTime() != null && o2.getEndTime() == null) {
                        return new Date(0L).compareTo(o1.getEndTime());
                    }
                    if (Objects.equals(o1.getEndTime(), o2.getEndTime())) {
                        return o2.getTaskDefinitionKey().compareTo(o1.getTaskDefinitionKey());
                    }
                    return o2.getEndTime().compareTo(o1.getEndTime());
                });
                break;
            }
            default: {
                hisTaskList.sort((o1, o2) -> {
                    if (HussarUtils.isAllEmpty((Object[])new Object[]{o1.getEndTime(), o2.getEndTime()})) {
                        return o1.getTaskDefinitionKey().compareTo(o2.getTaskDefinitionKey());
                    }
                    if (o1.getEndTime() == null && o2.getEndTime() != null) {
                        return new Date(0L).compareTo(o2.getEndTime());
                    }
                    if (o1.getEndTime() != null && o2.getEndTime() == null) {
                        return o1.getEndTime().compareTo(new Date(0L));
                    }
                    if (Objects.equals(o1.getEndTime(), o2.getEndTime())) {
                        return o1.getTaskDefinitionKey().compareTo(o2.getTaskDefinitionKey());
                    }
                    return o1.getEndTime().compareTo(o2.getEndTime());
                });
            }
        }
        Map finalUsersMap = this.iAssigneeChooseService.getUserListByUserId(userList);
        if (hisTaskList != null && !hisTaskList.isEmpty()) {
            ArrayList<Long> hisTaskIds = new ArrayList<Long>();
            for (HistoricTaskInstance hisTask : hisTaskList) {
                if (hisTask.getEndTime() == null) continue;
                hisTaskIds.add(Long.parseLong(hisTask.getId()));
            }
            List<Object> commentsMap = new ArrayList();
            if (HussarUtils.isNotEmpty(hisTaskIds)) {
                commentsMap = this.taskEngineMapper.getTaskComments(hisTaskIds);
            }
            HashMap<String, String> taskComment = new HashMap<String, String>();
            for (TaskCommentVO taskCommentVO : commentsMap) {
                taskComment.put(String.valueOf(taskCommentVO.getTaskId()), taskCommentVO.getFullMessage() == null ? taskCommentVO.getMessage() : taskCommentVO.getFullMessage());
            }
            List<Object> allVariables = new ArrayList();
            if (HussarUtils.isNotEmpty(hisTaskIds)) {
                allVariables = this.flowTaskMapper.getAllVariables(hisTaskIds, null);
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (Variables variables : allVariables) {
                if (!"taskSourceFlag".equals(variables.getName())) continue;
                hashMap.put(variables.getTaskId(), variables.getTextValue());
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String processKey = hisTaskList.get(0).getProcessDefinitionId().split(":")[0];
            ArrayList<String> processKeys = new ArrayList<String>();
            processKeys.add(processKey);
            Map modelNames = this.modelService.selectModelNames(processKeys);
            String value = (String)modelNames.get(processKey);
            for (HistoricTaskInstance hsi : hisTaskList) {
                String comment;
                JSONObject object = new JSONObject();
                String user = hsi.getAssignee() != null ? (finalUsersMap.get(hsi.getAssignee()) == null ? this.bpmConstantProperties.getNullComplete() : (TaskStateType.isEntrust((HistoricTaskInstance)hsi) ? (String)finalUsersMap.get(hsi.getAssignee()) + "(" + (String)finalUsersMap.get(hsi.getOwner()) + ")" : (String)finalUsersMap.get(hsi.getAssignee()))) : this.bpmConstantProperties.getNullComplete();
                String nullCommont = "";
                if (flag) {
                    nullCommont = this.bpmConstantProperties.getNullComment();
                }
                object.put("comments", (Object)((comment = (String)taskComment.get(hsi.getId())) == null ? nullCommont : comment));
                object.put("startTime", (Object)sdf.format(hsi.getStartTime()));
                object.put("start", (Object)hsi.getStartTime());
                if (hsi.getEndTime() != null) {
                    object.put("assignee", (Object)user);
                    object.put("endTime", (Object)sdf.format(hsi.getEndTime()));
                } else {
                    object.put("endTime", (Object)"");
                    List<IdentityLink> users = this.getIdentityLinkByTaskId(hsi.getId());
                    if (user != null && !users.isEmpty()) {
                        String assignee = String.join((CharSequence)",", this.iAssigneeChooseService.getEntrustUserNames(users));
                        if (HussarUtils.isNotEmpty((Object)assignee)) {
                            object.put("assignee", (Object)assignee);
                        } else {
                            object.put("assignee", (Object)this.bpmConstantProperties.getNullComplete());
                        }
                    }
                    object.put("comments", (Object)"");
                }
                object.put("modelName", (Object)value);
                object.put("activityName", (Object)hsi.getName());
                object.put("activityId", (Object)hsi.getId());
                object.put("taskId", (Object)hsi.getId());
                object.put("taskDefinitionKey", (Object)hsi.getTaskDefinitionKey());
                object.put("processDefinitionId", (Object)hsi.getProcessDefinitionId());
                object.put("processKey", (Object)hsi.getProcessDefinitionId().split(":")[0]);
                object.put("processInsId", (Object)hsi.getProcessInstanceId());
                object.put("assigneeId", (Object)hsi.getAssignee());
                String taskSourceFlag = (String)hashMap.get(hsi.getId());
                object.put("sub_process_key", (Object)hsi.getSubProcessKey());
                object.put("taskSourceFlag", (Object)(taskSourceFlag == null ? "" : TASK_SOURCE_FLAG.get(taskSourceFlag)));
                object.put("taskType", (Object)hsi.getTaskType());
                json.add((Object)object);
            }
            if (handleSubProcessMessage) {
                this.handleSubProcessMessage(json, sdf, hisTaskList.get(0).getProcessInstanceId());
            }
        }
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    private void handleSubProcessMessage(JSONArray json, SimpleDateFormat sdf, String procInstId) {
        List activityInstances = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(procInstId).activityType("subProcess").orderByHistoricActivityInstanceStartTime().desc()).list();
        for (int i = 0; i < json.size(); ++i) {
            JSONObject object = json.getJSONObject(i);
            if (!HussarUtils.isNotEmpty((Object)object.get((Object)"sub_process_key"))) continue;
            String taskSubProcessKey = (String)object.get((Object)"sub_process_key");
            HistoricActivityInstance activity = null;
            for (int j = 0; j < activityInstances.size(); ++j) {
                activity = (HistoricActivityInstance)activityInstances.get(j);
                if (!activity.getSubProcessKey().equals(taskSubProcessKey) || !object.getDate("start").after(activity.getStartTime()) || activity.getEndTime() != null && !object.getDate("start").before(activity.getEndTime())) continue;
                activityInstances.remove(j);
                break;
            }
            if (activity == null) continue;
            JSONObject subProcessMsg = new JSONObject();
            subProcessMsg.put("activityName", (Object)activity.getActivityName());
            subProcessMsg.put("activityId", (Object)activity.getId());
            subProcessMsg.put("taskDefinitionKey", (Object)activity.getActivityId());
            subProcessMsg.put("startTime", (Object)sdf.format(activity.getStartTime()));
            subProcessMsg.put("start", (Object)activity.getStartTime());
            subProcessMsg.put("taskSourceFlag", (Object)"");
            subProcessMsg.put("sub_process_key", (Object)taskSubProcessKey);
            if (taskSubProcessKey.equals(activity.getActivityId() + "::0")) {
                subProcessMsg.put("type", (Object)"subProcess");
            } else {
                subProcessMsg.put("type", (Object)"multiSubProcess");
            }
            if (activity.getEndTime() != null) {
                subProcessMsg.put("endTime", (Object)sdf.format(activity.getEndTime()));
                subProcessMsg.put("end", (Object)activity.getEndTime());
            }
            JSONArray jsonArray = new JSONArray();
            jsonArray.add((Object)object);
            subProcessMsg.put("subProcessTask", (Object)jsonArray);
            json.set(i, (Object)subProcessMsg);
            for (int j = i + 1; j < json.size(); ++j) {
                JSONObject subObject = json.getJSONObject(j);
                if (!taskSubProcessKey.equals(subObject.get((Object)"sub_process_key")) || !subObject.getDate("start").after(activity.getStartTime()) || activity.getEndTime() != null && !subObject.getDate("start").before(activity.getEndTime())) continue;
                jsonArray.add((Object)subObject);
                json.remove(j--);
            }
        }
        HashMap<String, JSONObject> message = new HashMap<String, JSONObject>();
        for (int i = 0; i < json.size(); ++i) {
            JSONObject object = json.getJSONObject(i);
            if (!HussarUtils.isNotEmpty((Object)object.get((Object)"sub_process_key")) || !"multiSubProcess".equals(object.get((Object)"type"))) continue;
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("activityName", object.get((Object)"activityName"));
            jsonObject.put("activityId", object.get((Object)"activityId"));
            jsonObject.put("taskDefinitionKey", object.get((Object)"taskDefinitionKey"));
            Date start = object.getDate("start");
            Date end = object.getDate("end");
            jsonObject.put("taskSourceFlag", (Object)"");
            String subProcessKey = object.getString("sub_process_key");
            if (message.get(subProcessKey) != null) {
                ((JSONObject)message.get(subProcessKey)).put("type", (Object)"reStart");
            }
            if (end == null) {
                object.put("type", (Object)"start");
                message.put(subProcessKey, object);
            }
            int loopCounter = Integer.parseInt(subProcessKey.split(":")[2]);
            object.put("activityName", (Object)(SUB_PROCINST_NAME + (loopCounter + 1)));
            JSONArray jsonArray = new JSONArray();
            while (jsonArray.size() < loopCounter + 1) {
                jsonArray.add((Object)"");
            }
            jsonArray.set(loopCounter, (Object)object);
            jsonObject.put("subProcess", (Object)jsonArray);
            jsonObject.put("type", (Object)"multiSubProcess");
            json.set(i, (Object)jsonObject);
            for (int j = i + 1; j < json.size(); ++j) {
                boolean isSameMulti;
                JSONObject subObject = json.getJSONObject(j);
                if (subObject.get((Object)"sub_process_key") == null || !"multiSubProcess".equals(subObject.get((Object)"type"))) continue;
                if (object.get((Object)"end") == null) {
                    isSameMulti = subObject.get((Object)"end") == null ? true : subObject.getDate("end").after(object.getDate("start"));
                } else if (subObject.get((Object)"end") == null) {
                    isSameMulti = object.getDate("end").after(subObject.getDate("start"));
                } else {
                    boolean bl = isSameMulti = subObject.getDate("end").after(object.getDate("start")) && subObject.getDate("start").before(object.getDate("end"));
                }
                if (!isSameMulti) continue;
                subProcessKey = subObject.getString("sub_process_key");
                loopCounter = Integer.parseInt(subProcessKey.split(":")[2]);
                subObject.put("activityName", (Object)(SUB_PROCINST_NAME + (loopCounter + 1)));
                Date date = start = start.after(subObject.getDate("start")) ? subObject.getDate("start") : start;
                if (end != null) {
                    Date newEnd = subObject.getDate("end");
                    if (newEnd == null) {
                        end = null;
                    } else {
                        Date date2 = end = end.before(newEnd) ? newEnd : end;
                    }
                }
                if (message.get(subProcessKey) != null) {
                    ((JSONObject)message.get(subProcessKey)).put("type", (Object)"reStart");
                }
                if (subObject.getDate("end") == null) {
                    subObject.put("type", (Object)"start");
                    message.put(subProcessKey, subObject);
                }
                while (jsonArray.size() < loopCounter + 1) {
                    jsonArray.add((Object)"");
                }
                jsonArray.set(loopCounter, (Object)subObject);
                json.remove(j--);
            }
            while (jsonArray.remove((Object)"")) {
            }
            for (int m = 0; m < jsonArray.size(); ++m) {
                jsonArray.getJSONObject(m).put("activityName", (Object)(SUB_PROCINST_NAME + (m + 1)));
            }
            jsonObject.put("startTime", (Object)sdf.format(start));
            if (end == null) continue;
            jsonObject.put("endTime", (Object)sdf.format(end));
        }
    }

    public BpmResponseResult getAllProcessTraceByMicroApp(String processInsId) {
        JSONArray json = new JSONArray();
        List<Object> userList = new ArrayList();
        List hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().queryChildTask()).processInstanceId(processInsId)).orderByHistoricTaskInstanceEndTime().includeProcessVariables()).includeTaskLocalVariables()).asc()).list();
        ArrayList<HistoricTaskInstance> nullList = new ArrayList<HistoricTaskInstance>();
        for (HistoricTaskInstance historicTaskInstance : hisTaskList) {
            if (historicTaskInstance.getEndTime() != null) continue;
            nullList.add(historicTaskInstance);
        }
        hisTaskList.removeAll(nullList);
        for (HistoricTaskInstance hsi : nullList) {
            hisTaskList.add(hsi);
        }
        if (hisTaskList != null && !hisTaskList.isEmpty()) {
            userList = hisTaskList.stream().map(TaskInfo::getAssignee).filter(Objects::nonNull).collect(Collectors.toList());
        }
        Map finalUsersMap = this.iAssigneeChooseService.getUserListByUserId(userList);
        if (hisTaskList != null && !hisTaskList.isEmpty()) {
            for (HistoricTaskInstance hsi : hisTaskList) {
                JSONObject object = new JSONObject();
                String user = hsi.getAssignee() != null ? (finalUsersMap.get(hsi.getAssignee()) == null ? this.bpmConstantProperties.getNullComplete() : (String)finalUsersMap.get(hsi.getAssignee())) : this.bpmConstantProperties.getNullComplete();
                List comments = this.taskService.getTaskComments(hsi.getId(), NOW_STATE);
                if (comments != null && !comments.isEmpty()) {
                    object.put("comments", (Object)(((Comment)comments.get(0)).getFullMessage() == null ? this.bpmConstantProperties.getNullComment() : ((Comment)comments.get(0)).getFullMessage()));
                } else {
                    object.put("comments", (Object)this.bpmConstantProperties.getNullComment());
                }
                Map variables = hsi.getTaskLocalVariables();
                if (HussarUtils.isEmpty(variables.get("taskSourceFlag"))) {
                    variables.put("taskSourceFlag", "");
                }
                hsi.getTaskLocalVariables();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                object.put("startTime", (Object)sdf.format(hsi.getStartTime()));
                if (hsi.getEndTime() != null) {
                    object.put("assignee", (Object)user);
                    object.put("endTime", (Object)sdf.format(hsi.getEndTime()));
                } else {
                    object.put("endTime", (Object)"");
                    List<String> users = this.getAssigneeByTaskId(hsi.getId());
                    if (user != null && !users.isEmpty()) {
                        String assignee = this.iAssigneeChooseService.getUserNames(users);
                        object.put("assignee", (Object)assignee);
                    }
                    object.put("comments", (Object)"");
                }
                object.put("activityName", (Object)hsi.getName());
                object.put("activityId", (Object)hsi.getId());
                object.put("taskId", (Object)hsi.getId());
                object.put("taskDefinitionKey", (Object)hsi.getTaskDefinitionKey());
                object.put("processDefinitionId", (Object)hsi.getProcessDefinitionId());
                object.put("processInsId", (Object)hsi.getProcessInstanceId());
                String taskSourceFlag = (String)variables.get("taskSourceFlag");
                object.put("taskSourceFlag", (Object)TASK_SOURCE_FLAG.get(taskSourceFlag));
                object.put("taskType", (Object)hsi.getTaskType());
                json.add((Object)object);
            }
        }
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult getDoneProcessTrace(String businessId) {
        JSONArray json = new JSONArray();
        List<Object> userList = new ArrayList();
        List hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceBusinessKey(businessId)).orderByHistoricTaskInstanceEndTime().includeProcessVariables()).includeTaskLocalVariables()).asc()).list();
        ArrayList<HistoricTaskInstance> nullList = new ArrayList<HistoricTaskInstance>();
        for (HistoricTaskInstance historicTaskInstance : hisTaskList) {
            if (historicTaskInstance.getEndTime() != null) continue;
            nullList.add(historicTaskInstance);
        }
        hisTaskList.removeAll(nullList);
        if (hisTaskList != null && !hisTaskList.isEmpty()) {
            userList = hisTaskList.stream().map(TaskInfo::getAssignee).filter(Objects::nonNull).collect(Collectors.toList());
        }
        Map finalUsersMap = this.iAssigneeChooseService.getUserListByUserId(userList);
        if (hisTaskList != null && !hisTaskList.isEmpty()) {
            for (HistoricTaskInstance hsi : hisTaskList) {
                JSONObject object = new JSONObject();
                String user = hsi.getAssignee() != null ? (finalUsersMap.get(hsi.getAssignee()) == null ? this.bpmConstantProperties.getNullComplete() : (String)finalUsersMap.get(hsi.getAssignee())) : this.bpmConstantProperties.getNullComplete();
                List comments = this.taskService.getTaskComments(hsi.getId(), NOW_STATE);
                if (comments != null && !comments.isEmpty()) {
                    object.put("comments", (Object)(((Comment)comments.get(0)).getFullMessage() == null ? this.bpmConstantProperties.getNullComment() : ((Comment)comments.get(0)).getFullMessage()));
                } else {
                    object.put("comments", (Object)this.bpmConstantProperties.getNullComment());
                }
                Map variables = hsi.getTaskLocalVariables();
                if (HussarUtils.isEmpty(variables.get("taskSourceFlag"))) {
                    variables.put("taskSourceFlag", "");
                }
                hsi.getTaskLocalVariables();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                object.put("startTime", (Object)sdf.format(hsi.getStartTime()));
                object.put("assignee", (Object)user);
                object.put("endTime", (Object)sdf.format(hsi.getEndTime()));
                object.put("time", (Object)(hsi.getEndTime().getTime() - hsi.getStartTime().getTime()));
                object.put("activityName", (Object)hsi.getName());
                object.put("activityId", (Object)hsi.getId());
                object.put("taskId", (Object)hsi.getId());
                object.put("taskDefinitionKey", (Object)hsi.getTaskDefinitionKey());
                object.put("processDefinitionId", (Object)hsi.getProcessDefinitionId());
                object.put("processInsId", (Object)hsi.getProcessInstanceId());
                String taskSourceFlag = (String)variables.get("taskSourceFlag");
                if ("reject_revoke".equals(taskSourceFlag)) {
                    variables.put("taskSourceFlag", "revoke");
                }
                object.put("variables", (Object)variables);
                object.put("taskSourceFlag", (Object)TASK_SOURCE_FLAG.get(variables.get("taskSourceFlag")));
                object.put("taskType", (Object)hsi.getTaskType());
                json.add((Object)object);
            }
        }
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult queryProcessDefinitionByInstanceId(String processInsId) {
        if (processInsId == null) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        JSONArray json = new JSONArray();
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInsId).singleResult();
        if (processInstance == null) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getProcessNotFound(), null);
        }
        ProcessDefinitionModel processDefinitionModel = new ProcessDefinitionModel();
        processDefinitionModel = this.processDefinitionsService.getProcessDefitionById(processInstance.getProcessDefinitionId());
        json.add((Object)processDefinitionModel);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult queryProcessDefinitionByBusinessId(String businessId) {
        if (businessId == null) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        JSONArray json = new JSONArray();
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult();
        if (processInstance == null) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getProcessNotFound(), null);
        }
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(processInstance.getProcessDefinitionId()).singleResult();
        ProcessDefinitionModel processDefinitionModel = new ProcessDefinitionModel();
        processDefinitionModel.setKey(processDefinition.getKey());
        processDefinitionModel.setDescription(processDefinition.getDescription());
        processDefinitionModel.setVersion(String.valueOf(processDefinition.getVersion()));
        processDefinitionModel.setResourceName(processDefinition.getResourceName());
        processDefinitionModel.setDeploymentId(processDefinition.getDeploymentId());
        processDefinitionModel.setDiagramResourceName(processDefinition.getDiagramResourceName());
        processDefinitionModel.setHasStartFormKey(String.valueOf(processDefinition.hasStartFormKey()));
        processDefinitionModel.setHasGraphicalNotation(String.valueOf(processDefinition.hasGraphicalNotation()));
        processDefinitionModel.setIsSuspended(String.valueOf(processDefinition.isSuspended()));
        processDefinitionModel.setProcessName(processDefinition.getName());
        processDefinitionModel.setId(processDefinition.getId());
        json.add((Object)processDefinitionModel);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult endProcess(String taskId, String userId, String reason) {
        HistoricProcessInstance processInstance;
        RealTaskId realTaskId = RealTaskId.getRealTaskIdAndMandatary(taskId, userId);
        if (HussarUtils.isEmpty((Object)(taskId = realTaskId.getTaskId()))) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getTaskIdNull(), null);
        }
        String mandator = realTaskId.getMandatary();
        CommonPrepareCmd.PrepareReturn prepareReturn = (CommonPrepareCmd.PrepareReturn)this.processEngine.getManagementService().executeCommand((Command)new CommonPrepareCmd(taskId, userId, mandator));
        mandator = prepareReturn.getMandator();
        if (HussarUtils.isEmpty((Object)taskId)) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getTaskIdNull(), null);
        }
        Task task = this.taskEngineService.getTask(taskId, "0");
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
        String businessId = historicProcessInstance.getBusinessKey();
        String processDefinitionId = task.getProcessDefinitionId();
        this.processEngine.getManagementService().executeCommand((Command)new ProcessEndCmd(taskId, userId, mandator, reason, task.getProcessInstanceId(), businessId, processDefinitionId, "endProcess", true));
        String superProcessInstanceId = task.getProcessInstanceId();
        while ((processInstance = (HistoricProcessInstance)this.processEngine.getHistoryService().createHistoricProcessInstanceQuery().processInstanceId(superProcessInstanceId).singleResult()).getSuperProcessInstanceId() != null) {
            superProcessInstanceId = processInstance.getSuperProcessInstanceId();
            if (((TaskQuery)this.taskService.createTaskQuery().processInstanceId(superProcessInstanceId)).list().isEmpty()) continue;
        }
        if (processInstance.getSuperProcessInstanceId() != null) {
            List tasks = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(superProcessInstanceId)).includeTaskLocalVariables()).list();
            for (TaskEntity taskEntity : tasks) {
                if (taskEntity.getTaskLocalVariables().containsKey("complete_type")) continue;
                this.processEngine.getManagementService().executeCommand(commandContext -> {
                    taskEntity.setVariableLocalWithOutQuery("complete_type", (Object)"end_process", true);
                    taskEntity.setVariableLocalWithOutQuery("sendUser", (Object)userId, true);
                    return null;
                });
            }
            this.processEngine.getManagementService().executeCommand((Command)new ProcessActionCmd(processInstance.getSuperProcessInstanceId()));
            this.processEngine.getManagementService().executeCommand((Command)new ProcessNodeCmd(processInstance.getSuperProcessInstanceId()));
        }
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult endProcessByBusinessIdOrProcessInsId(String businessId, String processInsId, String userId, String comment) {
        HistoricProcessInstance processInstance;
        String processInstanceId = null;
        if (HussarUtils.isNotEmpty((Object)processInsId)) {
            processInstanceId = processInsId;
        } else if (HussarUtils.isNotEmpty((Object)businessId)) {
            ArrayList<String> businessIds = new ArrayList<String>();
            businessIds.add(businessId);
            List<Long> processInstanceIds = this.instanceEngineMapper.selectProcIdByBusinessIdList(businessIds);
            if (processInstanceIds.size() == 0) {
                return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getProcessNotStart(), null);
            }
            processInstanceId = String.valueOf(processInstanceIds.get(0));
        } else {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        ProcessInstance process = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (process.isSuspended()) {
            throw new BpmException(BpmExceptionCodeEnum.TASK_IS_SUSPENDED);
        }
        String busienssId = process.getBusinessKey();
        String processDefinitionId = process.getProcessDefinitionId();
        this.processEngine.getManagementService().executeCommand((Command)new ProcessEndCmd(userId, null, comment, processInstanceId, businessId, processDefinitionId, "endProcess"));
        String superProcessInstanceId = processInstanceId;
        while ((processInstance = (HistoricProcessInstance)this.processEngine.getHistoryService().createHistoricProcessInstanceQuery().processInstanceId(superProcessInstanceId).singleResult()).getSuperProcessInstanceId() != null) {
            superProcessInstanceId = processInstance.getSuperProcessInstanceId();
            if (((TaskQuery)this.taskService.createTaskQuery().processInstanceId(superProcessInstanceId)).list().isEmpty()) continue;
        }
        if (processInstance.getSuperProcessInstanceId() != null) {
            List tasks = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(superProcessInstanceId)).includeTaskLocalVariables()).list();
            for (TaskEntity taskEntity : tasks) {
                if (taskEntity.getTaskLocalVariables().containsKey("complete_type")) continue;
                this.processEngine.getManagementService().executeCommand(commandContext -> {
                    taskEntity.setVariableLocalWithOutQuery("complete_type", (Object)"end_process", true);
                    taskEntity.setVariableLocalWithOutQuery("sendUser", (Object)userId, true);
                    return null;
                });
            }
            this.processEngine.getManagementService().executeCommand((Command)new ProcessActionCmd(processInstance.getSuperProcessInstanceId()));
            this.processEngine.getManagementService().executeCommand((Command)new ProcessNodeCmd(processInstance.getSuperProcessInstanceId()));
        }
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult endProcessByProcessInsId(String processInstanceId, String userId, String reason) {
        HistoricProcessInstance processInstance;
        if (HussarUtils.isEmpty((Object)processInstanceId)) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getProcessInsIdNull(), null);
        }
        ProcessInstance process = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (process == null) {
            throw new BpmException(this.bpmConstantProperties.getProcessNotFound());
        }
        if (process.isSuspended()) {
            throw new BpmException(this.bpmConstantProperties.getProcessInsIsSuspended());
        }
        String businessId = process.getBusinessKey();
        String processDefinitionId = process.getProcessDefinitionId();
        this.processEngine.getManagementService().executeCommand((Command)new ProcessEndCmd(userId, null, reason, processInstanceId, businessId, processDefinitionId, "endProcess"));
        String superProcessInstanceId = processInstanceId;
        while ((processInstance = (HistoricProcessInstance)this.processEngine.getHistoryService().createHistoricProcessInstanceQuery().processInstanceId(superProcessInstanceId).singleResult()).getSuperProcessInstanceId() != null) {
            superProcessInstanceId = processInstance.getSuperProcessInstanceId();
            if (((TaskQuery)this.taskService.createTaskQuery().processInstanceId(superProcessInstanceId)).list().isEmpty()) continue;
        }
        if (processInstance.getSuperProcessInstanceId() != null) {
            List tasks = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(superProcessInstanceId)).includeTaskLocalVariables()).list();
            for (TaskEntity taskEntity : tasks) {
                if (taskEntity.getTaskLocalVariables().containsKey("complete_type")) continue;
                this.processEngine.getManagementService().executeCommand(commandContext -> {
                    taskEntity.setVariableLocalWithOutQuery("complete_type", (Object)"end_process", true);
                    taskEntity.setVariableLocalWithOutQuery("sendUser", (Object)userId, true);
                    return null;
                });
            }
            this.processEngine.getManagementService().executeCommand((Command)new ProcessActionCmd(processInstance.getSuperProcessInstanceId()));
            this.processEngine.getManagementService().executeCommand((Command)new ProcessNodeCmd(processInstance.getSuperProcessInstanceId()));
        }
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    private List<String> getAssigneeByTaskId(String taskId) {
        ArrayList<String> users = new ArrayList<String>();
        List identityLinkList = this.taskService.getIdentityLinksType(taskId);
        if (identityLinkList != null && !identityLinkList.isEmpty()) {
            for (IdentityLink identityLink : identityLinkList) {
                users.add(identityLink.getUserId());
            }
        }
        return users;
    }

    private List<IdentityLink> getIdentityLinkByTaskId(String taskId) {
        return this.taskService.getIdentityLinksType(taskId);
    }

    public List<Map<String, String>> getCallNodeType(String processInsId) {
        List<FlowTask> callNodeType = this.taskEngineMapper.getCallNodeType(Long.parseLong(processInsId));
        ArrayList<Map<String, String>> callNodeTypeList = new ArrayList<Map<String, String>>();
        for (FlowTask flowTask : callNodeType) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("node", flowTask.getTaskDefinitionKey());
            map.put("type", flowTask.getCompleteType());
            callNodeTypeList.add(map);
        }
        return callNodeTypeList;
    }

    public BpmResponseResult queryProcessByStarter(Page page, ProcessQueryByStarterDto processQueryByStarterDto) {
        Page processPage = new Page();
        if (page == null) {
            processPage.setCurrent(1L).setSize(Integer.MAX_VALUE);
        } else {
            processPage.setCurrent(page.getCurrent()).setSize(page.getSize());
        }
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = new JSONObject();
        if (HussarUtils.isNotEmpty((Object)processQueryByStarterDto.getStarter())) {
            if (HussarUtils.isEmpty((Object)processQueryByStarterDto.getProcessKeyList()) && HussarUtils.isNotEmpty((Object)processQueryByStarterDto.getProcessKey()) && processQueryByStarterDto.getProcessKey().contains(",")) {
                processQueryByStarterDto.setProcessKeyList(Arrays.asList(processQueryByStarterDto.getProcessKey().split(",")));
                processQueryByStarterDto.setProcessKey(null);
            }
            if (HussarUtils.isEmpty((Object)processQueryByStarterDto.getBusinessIdList()) && HussarUtils.isNotEmpty((Object)processQueryByStarterDto.getBusinessId()) && processQueryByStarterDto.getBusinessId().contains(",")) {
                processQueryByStarterDto.setBusinessIdList(Arrays.asList(processQueryByStarterDto.getBusinessId().split(",")));
                processQueryByStarterDto.setBusinessId(null);
            }
            List<ProcessInstVo> list = this.instanceEngineMapper.queryProcessByStarter((Page<ProcessInstVo>)processPage, processQueryByStarterDto);
            for (int i = 0; i < list.size(); ++i) {
                list.get(i).setStarter(processQueryByStarterDto.getStarter());
            }
            jsonObject.put("data", list);
            jsonObject.put("count", (Object)processPage.getTotal());
            jsonArray.add((Object)jsonObject);
        }
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    public BpmResponseResult queryCompletecomment(String businessId, String processInsId) {
        BpmResponseResult bpmResponseResult = new BpmResponseResult();
        if (HussarUtils.isEmpty((Object)processInsId)) {
            HistoricProcessInstance instance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult();
            if (instance != null) {
                processInsId = instance.getId();
            } else {
                return bpmResponseResult;
            }
        }
        if (processInsId == null) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        List hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInsId)).orderByHistoricTaskInstanceEndTime().includeProcessVariables()).includeTaskLocalVariables()).finished().asc()).list();
        return this.getResult(hisTaskList, true, false);
    }

    public BpmResponseResult revokeProcess(ProcessRevokeDto processRevokeDto) {
        if (HussarUtils.isEmpty((Object)processRevokeDto.getStartUserId())) {
            throw new BpmException(BpmExceptionCodeEnum.NOT_NULL_PARM_IS_NULL);
        }
        HistoricProcessInstance processInstance = this.getProcessInst(processRevokeDto.getProcessInsId(), processRevokeDto.getBusinessId(), processRevokeDto.getTaskId(), true);
        if (HussarUtils.isNotEmpty((Object)processInstance.getSuperProcessInstanceId())) {
            throw new BpmException(BpmExceptionCodeEnum.ERROR_CALL_ACTIVITY_REVOKE);
        }
        if (!processInstance.getStartUserId().equals(processRevokeDto.getStartUserId())) {
            throw new BpmException(BpmExceptionCodeEnum.ERROR_START_USER);
        }
        if (!processRevokeDto.getIsForce()) {
            List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstance.getId())).list();
            List historicActivityInstances = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstance.getId()).orderByHistoricActivityInstanceStartTime().activityType("userTask").asc()).listPage(0, 1);
            HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)historicActivityInstances.get(0);
            for (Task task : tasks) {
                if (task.getTaskDefinitionKey().equals(historicActivityInstance.getActivityId())) continue;
                throw new BpmException(BpmExceptionCodeEnum.FORBID_PROCESS_REVOKE);
            }
        }
        String businessId = processInstance.getBusinessKey();
        String processDefinitionId = processInstance.getProcessDefinitionId();
        this.processEngine.getManagementService().executeCommand((Command)new ProcessEndCmd(processRevokeDto.getStartUserId(), null, processRevokeDto.getReason(), processInstance.getId(), businessId, processDefinitionId, "revokeProcess", true));
        String userId = processRevokeDto.getStartUserId();
        String superProcessInstanceId = processInstance.getId();
        while ((processInstance = (HistoricProcessInstance)this.processEngine.getHistoryService().createHistoricProcessInstanceQuery().processInstanceId(superProcessInstanceId).singleResult()).getSuperProcessInstanceId() != null) {
            superProcessInstanceId = processInstance.getSuperProcessInstanceId();
            if (((TaskQuery)this.taskService.createTaskQuery().processInstanceId(superProcessInstanceId)).list().isEmpty()) continue;
        }
        if (processInstance.getSuperProcessInstanceId() != null) {
            List tasks = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(superProcessInstanceId)).includeTaskLocalVariables()).list();
            for (TaskEntity taskEntity : tasks) {
                if (taskEntity.getTaskLocalVariables().containsKey("complete_type")) continue;
                this.processEngine.getManagementService().executeCommand(commandContext -> {
                    taskEntity.setVariableLocalWithOutQuery("complete_type", (Object)"end_process", true);
                    taskEntity.setVariableLocalWithOutQuery("sendUser", (Object)userId, true);
                    return null;
                });
            }
            this.processEngine.getManagementService().executeCommand((Command)new ProcessActionCmd(processInstance.getSuperProcessInstanceId()));
            this.processEngine.getManagementService().executeCommand((Command)new ProcessNodeCmd(processInstance.getSuperProcessInstanceId()));
        }
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    private void multiDeleteByProcIdList(List<Long> allProcId, Map<String, String> businessMap, Set<String> processDefinitionIdList) {
        List<Long> taskIdList = this.instanceEngineMapper.selectTaskIdByProcInstIdList(allProcId);
        this.instanceEngineMapper.deleteHiComment(allProcId, taskIdList);
        this.instanceEngineMapper.deleteHiDetail(allProcId);
        this.instanceEngineMapper.deleteHiActinst(allProcId);
        this.instanceEngineMapper.deleteHiIdentityLink(allProcId, taskIdList);
        this.instanceEngineMapper.deleteHiTaskinst(allProcId);
        this.instanceEngineMapper.deleteHiVarinst(allProcId);
        this.instanceEngineMapper.deleteRuIdentityLink(allProcId, taskIdList);
        this.instanceEngineMapper.deleteRuTask(allProcId);
        this.instanceEngineMapper.deleteRuVariable(allProcId);
        this.instanceEngineMapper.deleteRuExecution(allProcId);
        this.instanceEngineMapper.deleteCcTask(allProcId);
        this.instanceEngineMapper.deleteHiLine(allProcId);
        this.instanceEngineMapper.deleteUrgeTask(allProcId);
        this.instanceEngineMapper.deleteHiProcinst(allProcId);
        if (this.dataPushService.isDataPush(processDefinitionIdList)) {
            DataPush dataPush = new DataPush();
            dataPush.setBusinessMap(businessMap);
            dataPush.setProcessInsId(StringUtils.join((Object[])allProcId.toArray(), (String)","));
            dataPush.setProcessState("deleteProcess");
            this.dataPushService.deleteDataPush(dataPush);
            this.dataPushService.changeProcessStateDataPush(dataPush);
            DataPush dataPushTemp = new DataPush();
            dataPushTemp.setProcessInsId(StringUtils.join((Object[])allProcId.toArray(), (String)","));
            this.dataPushService.deleteStartProcess(dataPushTemp);
        }
    }

    public BpmResponseResult queryProcessInstance(ProcessDto processDto) {
        String processInstId = processDto.getProcessInsId();
        String businessId = processDto.getBusinessId();
        String taskId = processDto.getTaskId();
        HistoricProcessInstance historicProcessInstance = this.getProcessInst(processInstId, businessId, taskId, null);
        HashMap<String, Object> resMap = new HashMap<String, Object>();
        resMap.put("processInsId", historicProcessInstance.getId());
        resMap.put("businessId", historicProcessInstance.getBusinessKey());
        resMap.put("startTime", historicProcessInstance.getStartTime());
        resMap.put("endTime", historicProcessInstance.getEndTime());
        resMap.put("startUser", historicProcessInstance.getStartUserId());
        resMap.put("processDefinitionId", historicProcessInstance.getProcessDefinitionId());
        resMap.put("processDefinitionName", historicProcessInstance.getProcessDefinitionName());
        resMap.put("processKey", historicProcessInstance.getProcessDefinitionKey());
        List taskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(historicProcessInstance.getId())).includeTaskLocalVariables()).list();
        if (!taskList.isEmpty()) {
            ArrayList taskUser;
            ArrayList<Map<String, String>> todo = new ArrayList<Map<String, String>>();
            ArrayList<Map<String, String>> done = new ArrayList<Map<String, String>>();
            HashSet<String> userId = new HashSet<String>();
            for (HistoricTaskInstance task : taskList) {
                Map<String, String> taskMap = new HashMap<String, String>();
                taskMap.put("taskId", task.getId());
                taskMap.put("taskDefinitionKey", task.getTaskDefinitionKey());
                taskMap.put("startTime", (String)((Object)task.getCreateTime()));
                taskMap.put("sendUser", (String)task.getTaskLocalVariables().get("sendUser"));
                userId.add((String)task.getTaskLocalVariables().get("sendUser"));
                taskMap.put("todoConfiguration", (String)task.getTaskLocalVariables().get("todoConfiguration"));
                taskMap.put("taskType", task.getTaskType());
                if (task.getEndTime() != null) {
                    userId.add(task.getAssignee());
                    taskUser = new ArrayList();
                    HashMap<String, String> taskUserMap = new HashMap<String, String>();
                    taskUserMap.put("userId", task.getAssignee());
                    taskUser.add(taskUserMap);
                    taskMap.put("assignee", (String)((Object)taskUser));
                    taskMap.put("endTime", (String)((Object)task.getEndTime()));
                    done.add(taskMap);
                    continue;
                }
                Set userSet = this.taskService.getIdentityLinksType(task.getId()).stream().map(IdentityLink::getUserId).collect(Collectors.toSet());
                if (!userSet.isEmpty()) {
                    userId.addAll(userSet);
                    ArrayList taskUser2 = new ArrayList();
                    for (String taskUserId : userSet) {
                        HashMap<String, String> taskUserMap = new HashMap<String, String>();
                        taskUserMap.put("userId", taskUserId);
                        taskUser2.add(taskUserMap);
                    }
                    taskMap.put("assignee", (String)((Object)taskUser2));
                }
                todo.add(taskMap);
            }
            Map finalUsers = this.iAssigneeChooseService.getUserListByUserId(new ArrayList(userId));
            for (Map<String, String> taskMap : todo) {
                if (taskMap.get("assignee") != null) {
                    taskUser = (ArrayList)taskMap.get("assignee");
                    for (Map map : taskUser) {
                        map.put("userName", finalUsers.get(map.get("userId")));
                    }
                }
                if (taskMap.get("sendUser") == null) continue;
                taskMap.put("sendUserName", (String)finalUsers.get(taskMap.get("sendUser")));
            }
            for (Map<String, String> taskMap : done) {
                if (taskMap.get("assignee") == null) continue;
                taskUser = (List)taskMap.get("assignee");
                for (Map map : taskUser) {
                    map.put("userName", finalUsers.get(map.get("userId")));
                }
            }
            resMap.put("todo", todo);
            resMap.put("done", done);
        }
        if (historicProcessInstance.getStartUserId() != null) {
            resMap.put("startUserName", this.iAssigneeChooseService.getUserNames(Collections.singletonList(historicProcessInstance.getStartUserId())));
        }
        return InstallResult.success(resMap);
    }

    public BpmResponseResult queryAllCountersignNodes(String taskId, String processInsId, String businessId, String processKey, String version) {
        HistoricProcessInstance processInstance;
        String processDefinitionId = null;
        if (HussarUtils.isNotEmpty((Object)taskId)) {
            taskId = RealTaskId.getRealTaskId(taskId);
            Task task = this.taskEngineService.getTask(taskId, "0");
            processDefinitionId = task.getProcessDefinitionId();
        } else if (HussarUtils.isNotEmpty((Object)processInsId)) {
            processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInsId).singleResult();
            processDefinitionId = processInstance.getProcessDefinitionId();
        } else if (HussarUtils.isNotEmpty((Object)businessId)) {
            processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult();
            processDefinitionId = processInstance.getProcessDefinitionId();
        }
        WorkFlow workFlow = this.sysActProcessFileService.getFileByProcessDefId(processDefinitionId, processKey, version);
        if (workFlow == null) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getProcessVersionOrProcessKeyNotFound(), null);
        }
        FlowModel w = (FlowModel)JSON.parseObject((String)workFlow.getData(), FlowModel.class, (Feature[])new Feature[0]);
        List elements = w.getSlots().getElement();
        JSONArray json = new JSONArray();
        for (int i = 0; i < elements.size(); ++i) {
            JSONObject object = new JSONObject();
            if ("com.jxdinfo.workflow.SubProcess".equals(((FlowObject)elements.get(i)).getName())) {
                JSONObject o = new JSONObject();
                if (((FlowObject)elements.get(i)).getProps().getFlowCountersign() != null && ((FlowObject)elements.get(i)).getProps().getFlowCountersign().isCountersign()) {
                    o.put("multi_type", (Object)((FlowObject)elements.get(i)).getProps().getFlowCountersign().getCountersignType());
                    o.put("taskDefinitionKey", (Object)((FlowObject)elements.get(i)).getInstanceKey());
                    o.put("taskDefinitionName", (Object)((FlowObject)elements.get(i)).getProps().getFlowName());
                    o.put("taskDefinitionType", (Object)"SubProcess");
                    if ("radio".equals(o.get((Object)"multi_type"))) {
                        o.put("multi_finish_condition", (Object)((FlowObject)elements.get(i)).getProps().getFlowCountersign().getCountersignNumByRatio());
                    } else {
                        o.put("multi_finish_condition", (Object)((FlowObject)elements.get(i)).getProps().getFlowCountersign().getCountersignNumByCount());
                    }
                    json.add((Object)o);
                }
                List elements2 = ((FlowObject)elements.get(i)).getSlots().getElement();
                for (int j = 0; j < elements2.size(); ++j) {
                    if (((FlowObject)elements2.get(j)).getProps().getFlowCountersign() == null || !((FlowObject)elements2.get(j)).getProps().getFlowCountersign().isCountersign()) continue;
                    object.put("multi_type", (Object)((FlowObject)elements2.get(j)).getProps().getFlowCountersign().getCountersignType());
                    object.put("taskDefinitionKey", (Object)((FlowObject)elements2.get(j)).getInstanceKey());
                    object.put("taskDefinitionName", (Object)((FlowObject)elements2.get(j)).getProps().getFlowName());
                    object.put("subProcessDefId", (Object)((FlowObject)elements.get(i)).getInstanceKey());
                    object.put("subProcessDefName", (Object)((FlowObject)elements.get(i)).getProps().getFlowName());
                    object.put("taskDefinitionType", (Object)"UserTask");
                    if ("radio".equals(object.get((Object)"multi_type"))) {
                        object.put("multi_finish_condition", (Object)((FlowObject)elements2.get(j)).getProps().getFlowCountersign().getCountersignNumByRatio());
                    } else {
                        object.put("multi_finish_condition", (Object)((FlowObject)elements2.get(j)).getProps().getFlowCountersign().getCountersignNumByCount());
                    }
                    json.add((Object)object);
                }
                continue;
            }
            if ("com.jxdinfo.workflow.CallActivity".equals(((FlowObject)elements.get(i)).getName())) {
                if (((FlowObject)elements.get(i)).getProps().getFlowCountersign() == null || !((FlowObject)elements.get(i)).getProps().getFlowCountersign().isCountersign()) continue;
                object.put("multi_type", (Object)((FlowObject)elements.get(i)).getProps().getFlowCountersign().getCountersignType());
                object.put("taskDefinitionKey", (Object)((FlowObject)elements.get(i)).getInstanceKey());
                object.put("taskDefinitionName", (Object)((FlowObject)elements.get(i)).getProps().getFlowName());
                object.put("taskDefinitionType", (Object)"CallActivity");
                if ("radio".equals(object.get((Object)"multi_type"))) {
                    object.put("multi_finish_condition", (Object)((FlowObject)elements.get(i)).getProps().getFlowCountersign().getCountersignNumByRatio());
                } else {
                    object.put("multi_finish_condition", (Object)((FlowObject)elements.get(i)).getProps().getFlowCountersign().getCountersignNumByCount());
                }
                json.add((Object)object);
                continue;
            }
            if (((FlowObject)elements.get(i)).getProps().getFlowCountersign() == null || !((FlowObject)elements.get(i)).getProps().getFlowCountersign().isCountersign()) continue;
            object.put("multi_type", (Object)((FlowObject)elements.get(i)).getProps().getFlowCountersign().getCountersignType());
            object.put("taskDefinitionKey", (Object)((FlowObject)elements.get(i)).getInstanceKey());
            object.put("taskDefinitionName", (Object)((FlowObject)elements.get(i)).getProps().getFlowName());
            object.put("taskDefinitionType", (Object)"UserTask");
            if ("radio".equals(object.get((Object)"multi_type"))) {
                object.put("multi_finish_condition", (Object)((FlowObject)elements.get(i)).getProps().getFlowCountersign().getCountersignNumByRatio());
            } else {
                object.put("multi_finish_condition", (Object)((FlowObject)elements.get(i)).getProps().getFlowCountersign().getCountersignNumByCount());
            }
            json.add((Object)object);
        }
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BpmResponseResult queryCurrentNodes(String processInstanceId, String businessId) {
        HistoricProcessInstance historicProcessInstance;
        if (HussarUtils.isEmpty((Object)processInstanceId)) {
            historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult();
            if (historicProcessInstance == null) return InstallResult.success((JSONArray)new JSONArray());
            processInstanceId = historicProcessInstance.getId();
        } else {
            historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
            if (HussarUtils.isEmpty((Object)historicProcessInstance)) {
                return InstallResult.success((JSONArray)new JSONArray());
            }
        }
        List<ActInstVo> actInstVoList = this.instanceEngineMapper.queryCurrentNodes(processInstanceId);
        ArrayList<ProcessNode> processNodeList = new ArrayList<ProcessNode>();
        HashSet<String> actIdSet = new HashSet<String>();
        for (ActInstVo actInstVo : actInstVoList) {
            ProcessNode processNode = new ProcessNode();
            if ("subProcess".equals(actInstVo.getActType())) {
                processNode.setTaskDefinitionKey(actInstVo.getActId());
                processNode.setTaskDefinitionName(actInstVo.getActName());
                ArrayList<ProcessNode> childrenList = new ArrayList<ProcessNode>();
                List<ActInstVo> subProcessActInstVoList = this.instanceEngineMapper.querySubProcessCurrentNodes(processInstanceId, actInstVo.getSubProcessKey());
                for (ActInstVo subActInstVo : subProcessActInstVoList) {
                    ProcessNode subProcessNode = new ProcessNode();
                    subProcessNode.setTaskDefinitionKey(subActInstVo.getActId());
                    subProcessNode.setTaskDefinitionName(subActInstVo.getActName());
                    childrenList.add(subProcessNode);
                }
                processNode.setChildrenList(childrenList);
            } else {
                if (actIdSet.contains(actInstVo.getActId())) continue;
                processNode.setTaskDefinitionKey(actInstVo.getActId());
                processNode.setTaskDefinitionName(actInstVo.getActName());
                actIdSet.add(actInstVo.getActId());
            }
            processNodeList.add(processNode);
        }
        JSONObject object = new JSONObject();
        object.put("currentNodes", processNodeList);
        JSONArray json = new JSONArray();
        json.add((Object)object);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BpmResponseResult queryFlowHistoryInfo(String businessId, String processInstId) {
        void var13_16;
        HistoricProcessInstance historicProcessInstance;
        if (HussarUtils.isEmpty((Object)processInstId)) {
            historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult();
            if (historicProcessInstance == null) return InstallResult.success((JSONArray)new JSONArray());
            processInstId = historicProcessInstance.getId();
        } else {
            historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstId).singleResult();
            if (HussarUtils.isEmpty((Object)historicProcessInstance)) {
                return InstallResult.success((JSONArray)new JSONArray());
            }
        }
        List<HistoricTaskInstance> hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstId)).queryChildTask()).list();
        hisTaskList = hisTaskList.stream().filter(historicTaskInstance -> !"2".equals(historicTaskInstance.getTaskType())).collect(Collectors.toList());
        hisTaskList.sort((o1, o2) -> {
            if (HussarUtils.isAllEmpty((Object[])new Object[]{o1.getEndTime(), o2.getEndTime()})) {
                return o1.getTaskDefinitionKey().compareTo(o2.getTaskDefinitionKey());
            }
            if (o1.getEndTime() == null && o2.getEndTime() != null) {
                return o2.getEndTime().compareTo(new Date(0L));
            }
            if (o1.getEndTime() != null && o2.getEndTime() == null) {
                return new Date(0L).compareTo(o1.getEndTime());
            }
            if (Objects.equals(o1.getEndTime(), o2.getEndTime())) {
                return o1.getTaskDefinitionKey().compareTo(o2.getTaskDefinitionKey());
            }
            return o1.getEndTime().compareTo(o2.getEndTime());
        });
        Date startTime = historicProcessInstance.getStartTime();
        JSONArray json = new JSONArray();
        JSONObject jsonObject = new JSONObject();
        JSONArray completeList = new JSONArray();
        HashSet<String> userSet = new HashSet<String>();
        if (hisTaskList == null || hisTaskList.isEmpty()) return InstallResult.success((JSONArray)json);
        ArrayList<Long> hisTaskIds = new ArrayList<Long>();
        for (HistoricTaskInstance hisTask : hisTaskList) {
            if (hisTask.getEndTime() == null) continue;
            hisTaskIds.add(Long.parseLong(hisTask.getId()));
        }
        List<Object> commentsMap = new ArrayList();
        if (HussarUtils.isNotEmpty(hisTaskIds)) {
            commentsMap = this.taskEngineMapper.getTaskComments(hisTaskIds);
        }
        HashMap<String, String> taskComment = new HashMap<String, String>();
        for (TaskCommentVO taskCommentVO : commentsMap) {
            taskComment.put(String.valueOf(taskCommentVO.getTaskId()), taskCommentVO.getFullMessage() == null ? taskCommentVO.getMessage() : taskCommentVO.getFullMessage());
        }
        ArrayList arrayList = new ArrayList();
        if (HussarUtils.isNotEmpty(hisTaskIds)) {
            List<Variables> list = this.flowTaskMapper.getAllVariables(hisTaskIds, null);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Variables variables : var13_16) {
            if (!"taskSourceFlag".equals(variables.getName())) continue;
            hashMap.put(variables.getTaskId(), variables.getTextValue());
        }
        LambdaQueryWrapper ccQueryWrapper = new LambdaQueryWrapper();
        ccQueryWrapper.in(SysActCcTask::getProcessInsId, new Object[]{historicProcessInstance.getId()});
        List ccTaskList = this.iSysActCcTaskService.list((Wrapper)ccQueryWrapper);
        for (SysActCcTask sysActCcTask2 : ccTaskList) {
            userSet.add(sysActCcTask2.getReceiveUser());
        }
        HashMap identityLinkMap = new HashMap();
        hisTaskList.forEach(o -> {
            if (TaskStateType.isEntrust((HistoricTaskInstance)o) && HussarUtils.isNotEmpty((Object)o.getOwner())) {
                userSet.add(o.getOwner());
            }
            if (HussarUtils.isNotEmpty((Object)o.getAssignee())) {
                userSet.add(o.getAssignee());
            }
            if (HussarUtils.isEmpty((Object)o.getEndTime())) {
                List<IdentityLink> users = this.getIdentityLinkByTaskId(o.getId());
                identityLinkMap.put(o.getId(), users);
                for (IdentityLink identityLink : users) {
                    userSet.add(identityLink.getUserId());
                    if (!TaskStateType.isEntrust((IdentityLink)identityLink)) continue;
                    userSet.add(identityLink.getMandator());
                }
            }
            if (HussarUtils.isNotEmpty((Object)o.getReceiver())) {
                userSet.add(o.getReceiver());
            }
        });
        Map finalUsersMap = this.iAssigneeChooseService.getUserListByUserId(new ArrayList(userSet));
        boolean isEndProcess = false;
        Date latestTime = startTime;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (HistoricTaskInstance hsi : hisTaskList) {
            JSONObject object = new JSONObject();
            if (hsi.getEndTime() != null) {
                String owner;
                String user;
                String userId;
                if (hsi.getAssignee() != null) {
                    userId = hsi.getAssignee() == null ? "" : hsi.getAssignee();
                    user = finalUsersMap.get(hsi.getAssignee()) == null ? this.bpmConstantProperties.getNullComplete() : (String)finalUsersMap.get(hsi.getAssignee());
                } else {
                    userId = "";
                    user = this.bpmConstantProperties.getNullComplete();
                }
                object.put("userId", (Object)userId);
                object.put("userName", (Object)user);
                String taskSourceFlag = (String)hashMap.get(hsi.getId());
                if ("reject_revoke".equals(taskSourceFlag)) {
                    taskSourceFlag = "revoke";
                }
                object.put("completeType", (Object)(taskSourceFlag == null ? "" : taskSourceFlag));
                object.put("completeTypeName", (Object)(taskSourceFlag == null ? "" : TASK_SOURCE_FLAG.get(taskSourceFlag)));
                if (HussarUtils.isNotEmpty((Object)hsi.getReceiver())) {
                    String receiverId = hsi.getReceiver();
                    object.put("receiverId", (Object)receiverId);
                    object.put("receiverName", finalUsersMap.get(receiverId));
                }
                if (TaskStateType.isEntrust((HistoricTaskInstance)hsi) && HussarUtils.isNotEmpty((Object)(owner = hsi.getOwner()))) {
                    String ownerName = (String)finalUsersMap.get(owner);
                    object.put("owner", (Object)owner);
                    object.put("ownerName", (Object)ownerName);
                }
                object.put("completeTime", (Object)sdf.format(hsi.getEndTime()));
                object.put("duration", (Object)hsi.getDurationInMillis());
                String nullCommont = this.bpmConstantProperties.getNullComment();
                String comment = (String)taskComment.get(hsi.getId());
                object.put("comment", comment == null ? nullCommont : comment);
                object.put("nodeType", (Object)"userTask");
                object.put("taskType", (Object)"done");
                if (hsi.getEndTime().getTime() >= latestTime.getTime()) {
                    isEndProcess = "endProcess".equals(taskSourceFlag);
                    latestTime = hsi.getEndTime();
                }
            } else {
                String userIds;
                List identityLinks = (List)identityLinkMap.get(hsi.getId());
                ArrayList<String> userIdList = new ArrayList<String>();
                ArrayList<String> userNameList = new ArrayList<String>();
                JSONArray entrustInfo = new JSONArray();
                if (HussarUtils.isNotEmpty((Object)identityLinks)) {
                    for (IdentityLink identityLink : identityLinks) {
                        String userId = identityLink.getUserId();
                        String userName = (String)finalUsersMap.get(userId);
                        userIdList.add(userId);
                        userNameList.add(userName);
                        if (!TaskStateType.isEntrust((IdentityLink)identityLink)) continue;
                        JSONObject obj = new JSONObject();
                        String mandator = identityLink.getMandator();
                        String mandatorName = (String)finalUsersMap.get(mandator);
                        obj.put("mandator", (Object)mandator);
                        obj.put("mandatorName", (Object)mandatorName);
                        obj.put("mandatary", (Object)userId);
                        obj.put("mandataryName", (Object)userName);
                        entrustInfo.add((Object)obj);
                    }
                } else if (HussarUtils.isNotEmpty((Object)hsi.getAssignee())) {
                    userIdList.add(hsi.getAssignee());
                    userNameList.add((String)finalUsersMap.get(hsi.getAssignee()));
                }
                object.put("userId", (Object)(HussarUtils.isEmpty((Object)(userIds = String.join((CharSequence)",", userIdList))) ? "" : userIds));
                String userNames = String.join((CharSequence)",", userNameList);
                object.put("userName", (Object)(HussarUtils.isEmpty((Object)userNames) ? this.bpmConstantProperties.getNullComplete() : userNames));
                if (HussarUtils.isNotEmpty((Object)entrustInfo)) {
                    object.put("entrustInfo", (Object)entrustInfo);
                }
                object.put("nodeType", (Object)"userTask");
                object.put("taskType", (Object)"todo");
            }
            object.put("taskDefinitionKey", (Object)hsi.getTaskDefinitionKey());
            object.put("taskDefinitionName", (Object)hsi.getName());
            object.put("createTime", (Object)sdf.format(hsi.getStartTime()));
            List ccTasks = ccTaskList.stream().filter(sysActCcTask -> hsi.getId().equals(String.valueOf(sysActCcTask.getTaskId()))).collect(Collectors.toList());
            if (HussarUtils.isNotEmpty(ccTasks)) {
                JSONObject ccObject = new JSONObject();
                JSONArray userInfo = new JSONArray();
                for (SysActCcTask sysActCcTask3 : ccTasks) {
                    JSONObject obj = new JSONObject();
                    obj.put("userId", (Object)sysActCcTask3.getReceiveUser());
                    obj.put("userName", finalUsersMap.get(sysActCcTask3.getReceiveUser()));
                    obj.put("readState", (Object)sysActCcTask3.getTaskState());
                    obj.put("readTime", (Object)sysActCcTask3.getEndTime());
                    userInfo.add((Object)obj);
                }
                ccObject.put("userInfo", (Object)userInfo);
                ccObject.put("taskDefinitionKey", (Object)hsi.getTaskDefinitionKey());
                ccObject.put("taskDefinitionName", (Object)hsi.getName());
                ccObject.put("createTime", (Object)sdf.format(hsi.getStartTime()));
                ccObject.put("nodeType", (Object)"ccTask");
                completeList.add((Object)ccObject);
            }
            completeList.add((Object)object);
        }
        jsonObject.put("completeList", (Object)completeList);
        Date finishTime = historicProcessInstance.getEndTime();
        if (HussarUtils.isNotEmpty((Object)finishTime)) {
            jsonObject.put("finishTime", (Object)sdf.format(finishTime));
            if (isEndProcess) {
                jsonObject.put("processState", (Object)"\u5ba1\u6279\u7ec8\u6b62");
            } else {
                jsonObject.put("processState", (Object)"\u5ba1\u6279\u901a\u8fc7");
            }
        }
        jsonObject.put("startTime", (Object)sdf.format(startTime));
        json.add((Object)jsonObject);
        return InstallResult.success((JSONArray)json);
    }

    private HistoricProcessInstance getProcessInst(String processInstId, String businessKey, String taskId, Boolean isUnFinish) {
        HistoricProcessInstance processInstance;
        if (HussarUtils.isAllEmpty((Object[])new Object[]{processInstId, businessKey, taskId})) {
            throw new BpmException(BpmExceptionCodeEnum.NOT_NULL_PARM_IS_NULL);
        }
        if (HussarUtils.isEmpty((Object)processInstId)) {
            if (HussarUtils.isNotEmpty((Object)businessKey)) {
                processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessKey).singleResult();
                if (processInstance == null) {
                    throw new BpmException(BpmExceptionCodeEnum.PROCESS_NOT_START);
                }
                processInstId = processInstance.getId();
            } else {
                HistoricTaskInstance taskInstance = (HistoricTaskInstance)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId)).singleResult();
                if (taskInstance == null) {
                    throw new BpmException(BpmExceptionCodeEnum.TASK_NOT_FOUND);
                }
                processInstId = taskInstance.getProcessInstanceId();
            }
        } else {
            processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstId).singleResult();
            if (processInstance == null) {
                throw new BpmException(BpmExceptionCodeEnum.PROCESS_NOT_START);
            }
        }
        processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstId).singleResult();
        if (isUnFinish != null) {
            if (isUnFinish.booleanValue()) {
                if (processInstance.getEndTime() != null) {
                    throw new BpmException(BpmExceptionCodeEnum.PROCESS_END);
                }
            } else if (processInstance.getEndTime() == null) {
                throw new BpmException(BpmExceptionCodeEnum.PROCESS_NOT_END);
            }
        }
        return processInstance;
    }

    public JSONObject getProcessShowMsg(String processInsId, String businessId, boolean isFirstQuery) {
        ProcessInstance instance;
        HistoricProcessInstanceQuery historicProcessInstanceQuery = this.historyService.createHistoricProcessInstanceQuery();
        if (HussarUtils.isEmpty((Object)processInsId)) {
            if (HussarUtils.isEmpty((Object)businessId)) {
                return new JSONObject();
            }
            historicProcessInstanceQuery.processInstanceBusinessKey(businessId);
        } else {
            historicProcessInstanceQuery.processInstanceId(processInsId);
        }
        HistoricProcessInstance processInstance = (HistoricProcessInstance)historicProcessInstanceQuery.singleResult();
        if (processInstance == null) {
            return new JSONObject();
        }
        processInsId = processInstance.getId();
        JSONObject result = new JSONObject();
        boolean suspended = false;
        if (processInstance.getEndTime() == null && (instance = (ProcessInstance)this.processEngine.getRuntimeService().createProcessInstanceQuery().processInstanceId(processInsId).singleResult()) != null) {
            suspended = instance.isSuspended();
        }
        JSONArray allProcessMsg = new JSONArray();
        result.put("allProcessMsg", (Object)allProcessMsg);
        JSONObject processMsg = new JSONObject();
        processMsg.put("processDefinitionName", (Object)processInstance.getProcessDefinitionName());
        processMsg.put("processInsId", (Object)processInstance.getId());
        processMsg.put("businessId", (Object)processInstance.getBusinessKey());
        if (processInstance.getEndTime() == null) {
            if (processInstance.getDueDate() != null && processInstance.getDueDate().getTime() < System.currentTimeMillis()) {
                processMsg.put("state", (Object)"overtime");
            } else if (suspended) {
                processMsg.put("state", (Object)"suspend");
            } else {
                processMsg.put("state", (Object)NOW_STATE);
            }
        } else {
            processMsg.put("state", (Object)FINISH_STATE);
        }
        allProcessMsg.add((Object)processMsg);
        List callProcessInstances = this.historyService.createHistoricProcessInstanceQuery().superProcessInstanceId(processInstance.getId()).list();
        List allActivityInstances = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInsId).list();
        JSONObject callProcessMsg = new JSONObject();
        result.put("callProcessMsg", (Object)callProcessMsg);
        if (!callProcessInstances.isEmpty()) {
            block0: for (HistoricProcessInstance callProcessInstance : callProcessInstances) {
                JSONObject callProcessMessage = new JSONObject();
                callProcessMessage.put("businessId", (Object)callProcessInstance.getBusinessKey());
                callProcessMessage.put("processDefinitionName", (Object)callProcessInstance.getProcessDefinitionName());
                callProcessMessage.put("startTime", (Object)callProcessInstance.getStartTime());
                callProcessMessage.put("endTime", (Object)callProcessInstance.getEndTime());
                callProcessMessage.put("processDefinitionId", (Object)callProcessInstance.getProcessDefinitionId());
                callProcessMessage.put("processInsId", (Object)callProcessInstance.getId());
                for (HistoricActivityInstance historicActivityInstance : allActivityInstances) {
                    if (!callProcessInstance.getId().equals(historicActivityInstance.getCalledProcessInstanceId())) continue;
                    JSONArray jsonArray = callProcessMsg.getJSONArray(historicActivityInstance.getActivityId());
                    if (jsonArray == null) {
                        jsonArray = new JSONArray();
                        callProcessMsg.put(historicActivityInstance.getActivityId(), (Object)jsonArray);
                    }
                    jsonArray.add((Object)callProcessMessage);
                    continue block0;
                }
            }
        }
        HashMap<String, List> taskListMap = new HashMap<String, List>();
        HashMap<String, List<BpmActRuIdentitylink>> taskUserMap = new HashMap<String, List<BpmActRuIdentitylink>>();
        HashMap<String, List> hisListMap = new HashMap<String, List>();
        HashMap<String, String> commentMap = new HashMap<String, String>();
        HashMap<String, List> runningNodeMap = new HashMap<String, List>();
        HashMap<String, List> finishedNodeMap = new HashMap<String, List>();
        HashMap<String, List> hiLineIdMap = new HashMap<String, List>();
        String processDefinitonId = processInstance.getProcessDefinitionId();
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinitonId);
        this.prepareBpmnModel(bpmnModel);
        List allTasks = ((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().queryChildTask()).processInstanceId(processInsId)).includeTaskLocalVariables()).includeProcessVariables()).list();
        ArrayList<Long> taskIds = new ArrayList<Long>();
        for (Task task : allTasks) {
            String subProcessKey = task.getSubProcessKey();
            List taskList = taskListMap.computeIfAbsent(subProcessKey, k -> new ArrayList());
            taskList.add(task);
            taskIds.add(Long.valueOf(task.getId()));
        }
        HashSet<String> userList = new HashSet<String>();
        List users = new ArrayList();
        if (!taskIds.isEmpty()) {
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.in(BpmActRuIdentitylink::getTaskId, taskIds);
            lambdaQueryWrapper.eq(BpmActRuIdentitylink::getType, (Object)"candidate");
            users = this.bpmActRuIdentitylinkMapper.selectList((Wrapper)lambdaQueryWrapper);
        }
        for (BpmActRuIdentitylink identityLink : users) {
            List list = taskUserMap.computeIfAbsent(String.valueOf(identityLink.getTaskId()), k -> new ArrayList());
            list.add(identityLink);
            if (TaskStateType.isEntrust((String)identityLink.getTaskState())) {
                userList.add(identityLink.getMandator());
            }
            userList.add(identityLink.getUserId());
        }
        List hisLists = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().queryChildTask()).processInstanceId(processInsId)).orderByHistoricTaskInstanceEndTime().asc()).finished().list();
        ArrayList<Long> hisTaskIds = new ArrayList<Long>();
        for (Object historicTaskInstance : hisLists) {
            hisTaskIds.add(Long.valueOf(historicTaskInstance.getId()));
            if (TaskStateType.isEntrust((HistoricTaskInstance)historicTaskInstance) && HussarUtils.isNotEmpty((Object)historicTaskInstance.getOwner())) {
                userList.add(historicTaskInstance.getOwner());
            }
            if (HussarUtils.isNotEmpty((Object)historicTaskInstance.getAssignee())) {
                userList.add(historicTaskInstance.getAssignee());
            }
            String subProcessKey = historicTaskInstance.getSubProcessKey();
            List hisList = hisListMap.computeIfAbsent(subProcessKey, k -> new ArrayList());
            hisList.add(historicTaskInstance);
        }
        List<Object> comments = new ArrayList();
        if (HussarUtils.isNotEmpty(hisTaskIds)) {
            comments = this.taskEngineMapper.getTaskComments(hisTaskIds);
        }
        for (TaskCommentVO taskCommentVO : comments) {
            commentMap.put(taskCommentVO.getTaskId(), taskCommentVO.getFullMessage() == null ? taskCommentVO.getMessage() : taskCommentVO.getFullMessage());
        }
        Map finalUsersMap = this.iAssigneeChooseService.getUserListByUserId(new ArrayList(userList));
        HashMap<String, String> nodeState = new HashMap<String, String>();
        HashMap<String, Map> subProcessNodeState = new HashMap<String, Map>();
        boolean containsRunningCallActivity = false;
        for (Object historicActivityInstance : allActivityInstances) {
            List nodeList;
            if (historicActivityInstance.getEndTime() == null) {
                if ("callActivity".equals(historicActivityInstance.getActivityType())) {
                    containsRunningCallActivity = true;
                    nodeList = runningNodeMap.computeIfAbsent(historicActivityInstance.getSubProcessKey(), k -> new ArrayList());
                    nodeList.add(historicActivityInstance.getActivityId());
                    continue;
                }
                if ("subProcess".equals(historicActivityInstance.getActivityType())) {
                    nodeList = runningNodeMap.computeIfAbsent(historicActivityInstance.getSubProcessKey(), k -> new ArrayList());
                    nodeList.add(historicActivityInstance.getActivityId());
                    continue;
                }
                if (!"receiveTask".equals(historicActivityInstance.getActivityType())) continue;
                nodeList = runningNodeMap.computeIfAbsent(historicActivityInstance.getSubProcessKey(), k -> new ArrayList());
                nodeList.add(historicActivityInstance.getActivityId());
                if (historicActivityInstance.getEndTime() != null || historicActivityInstance.getDueDate() == null || historicActivityInstance.getDueDate().getTime() >= System.currentTimeMillis()) continue;
                if (historicActivityInstance.getSubProcessKey() == null) {
                    nodeState.put(historicActivityInstance.getActivityId(), "overtime");
                    continue;
                }
                subProcessNodeState.computeIfAbsent(historicActivityInstance.getSubProcessKey(), k -> new HashMap()).put(historicActivityInstance.getActivityId(), "overtime");
                continue;
            }
            nodeList = finishedNodeMap.computeIfAbsent(historicActivityInstance.getSubProcessKey(), k -> new ArrayList());
            nodeList.add(historicActivityInstance.getActivityId());
        }
        List sysActHiLines = this.iSysActHiLineService.getSysActHiLineByProcessinsId(processInsId, null, false);
        for (Object sysActHiLine : sysActHiLines) {
            List list = hiLineIdMap.computeIfAbsent(sysActHiLine.getSubProcessKey(), k -> new ArrayList());
            list.add(sysActHiLine.getLineId());
        }
        if (containsRunningCallActivity) {
            List<Map<String, String>> mapList = this.getCallNodeType(processInsId);
            for (Map map : mapList) {
                nodeState.put((String)map.get("node"), HussarUtils.isEmpty(map.get("type")) ? NOW_STATE : (String)map.get("type"));
            }
        }
        Map extensionElementsNode = bpmnModel.getMainProcess().getExtensionElements();
        String width = ((ExtensionAttribute)((List)((ExtensionElement)((List)extensionElementsNode.get("canvasWidth")).get(0)).getAttributes().get("canvasWidth")).get(0)).getValue();
        String string = ((ExtensionAttribute)((List)((ExtensionElement)((List)extensionElementsNode.get("canvasHeight")).get(0)).getAttributes().get("canvasHeight")).get(0)).getValue();
        JSONObject processInfo = new JSONObject();
        processInfo.put("width", (Object)width);
        processInfo.put("height", (Object)string);
        processInfo.put("data", (Object)this.getMergeProcessInfo(processInsId, suspended, bpmnModel, bpmnModel.getMainProcess().getFlowElements(), taskListMap.getOrDefault(null, new ArrayList()), runningNodeMap.getOrDefault(null, new ArrayList()), finishedNodeMap.getOrDefault(null, new ArrayList()), nodeState, hiLineIdMap.getOrDefault(null, new ArrayList())));
        result.put("processInfo", (Object)processInfo);
        result.put("processCompleteInfo", (Object)this.getMergeProcessCompleteInfo(taskUserMap, commentMap, finalUsersMap, taskListMap.getOrDefault(null, new ArrayList()), bpmnModel, bpmnModel.getMainProcess().getFlowElements(), hisListMap.getOrDefault(null, new ArrayList())));
        ArrayList subProcessKeys = new ArrayList(finishedNodeMap.keySet());
        subProcessKeys.remove(null);
        JSONObject subProcessMsg = new JSONObject();
        for (String subProcessKey : subProcessKeys) {
            if (HussarUtils.isEmpty((Object)subProcessKey)) continue;
            JSONObject jsonObject = new JSONObject();
            String taskDefinitionKey = subProcessKey.split(":")[0];
            SubProcess subProcess = (SubProcess)bpmnModel.getFlowElement(taskDefinitionKey);
            jsonObject.put("subProcessInfo", (Object)this.getMergeProcessInfo(processInsId, suspended, bpmnModel, subProcess.getFlowElements(), taskListMap.getOrDefault(subProcessKey, new ArrayList()), runningNodeMap.getOrDefault(subProcessKey, new ArrayList()), finishedNodeMap.getOrDefault(subProcessKey, new ArrayList()), subProcessNodeState.getOrDefault(subProcessKey, new HashMap()), hiLineIdMap.getOrDefault(subProcessKey, new ArrayList())));
            jsonObject.put("subProcessCompleteInfo", (Object)this.getMergeProcessCompleteInfo(taskUserMap, commentMap, finalUsersMap, taskListMap.getOrDefault(subProcessKey, new ArrayList()), bpmnModel, subProcess.getFlowElements(), hisListMap.getOrDefault(subProcessKey, new ArrayList())));
            subProcessMsg.put(subProcessKey, (Object)jsonObject);
        }
        result.put("subProcessMsg", (Object)subProcessMsg);
        return result;
    }

    private void prepareBpmnModel(BpmnModel bpmnModel) {
        ArrayList allGraphicInfos = new ArrayList();
        if (bpmnModel.getLocationMap() != null) {
            allGraphicInfos.addAll(bpmnModel.getLocationMap().values());
        }
        if (bpmnModel.getLabelLocationMap() != null) {
            allGraphicInfos.addAll(bpmnModel.getLabelLocationMap().values());
        }
        if (bpmnModel.getFlowLocationMap() != null) {
            for (List flowGraphicInfos : bpmnModel.getFlowLocationMap().values()) {
                allGraphicInfos.addAll(flowGraphicInfos);
            }
        }
        if (!allGraphicInfos.isEmpty()) {
            boolean needsTranslationX = false;
            boolean needsTranslationY = false;
            double lowestX = 0.0;
            double lowestY = 0.0;
            for (GraphicInfo graphicInfo : allGraphicInfos) {
                double x = graphicInfo.getX();
                double y = graphicInfo.getY();
                if (x < lowestX) {
                    needsTranslationX = true;
                    lowestX = x;
                }
                if (!(y < lowestY)) continue;
                needsTranslationY = true;
                lowestY = y;
            }
            if (needsTranslationX || needsTranslationY) {
                double translationX = Math.abs(lowestX);
                double translationY = Math.abs(lowestY);
                for (GraphicInfo graphicInfo : allGraphicInfos) {
                    if (needsTranslationX) {
                        graphicInfo.setX(graphicInfo.getX() + translationX);
                    }
                    if (!needsTranslationY) continue;
                    graphicInfo.setY(graphicInfo.getY() + translationY);
                }
            }
        }
    }

    private JSONArray getMergeProcessInfo(String processInsId, boolean suspended, BpmnModel bpmnModel, Collection<FlowElement> flowElements, List<Task> tasks, List<String> runningNodeList, List<String> finishedNodeList, Map<String, String> nodeState, List<String> lineList) {
        for (Task task : tasks) {
            String completeType;
            runningNodeList.add(task.getTaskDefinitionKey());
            if (HussarUtils.isNotEmpty((Object)task.getDueDate()) && task.getDueDate().getTime() < System.currentTimeMillis()) {
                nodeState.put(task.getTaskDefinitionKey(), "overtime");
                continue;
            }
            String string = completeType = task.getTaskLocalVariables().get("complete_type") == null ? NOW_STATE : task.getTaskLocalVariables().get("complete_type").toString();
            if ("reject_revoke".equals(completeType)) {
                completeType = NOW_STATE;
            }
            nodeState.put(task.getTaskDefinitionKey(), completeType);
        }
        JSONArray nodeMessage = new JSONArray();
        for (FlowElement flowElement : flowElements) {
            if (!(flowElement instanceof FlowNode)) continue;
            FlowNode flowNode = (FlowNode)flowElement;
            JSONObject object = new JSONObject();
            String flowNodeId = flowNode.getId();
            object.put("id", (Object)flowNodeId);
            object.put("name", (Object)flowNode.getName());
            GraphicInfo graphicInfo = bpmnModel.getGraphicInfo(flowNode.getId());
            object.put("x", (Object)graphicInfo.getX());
            object.put("y", (Object)graphicInfo.getY());
            object.put("width", (Object)graphicInfo.getWidth());
            object.put("height", (Object)graphicInfo.getHeight());
            object.put("type", (Object)this.getNodeType(flowNode));
            if (flowElement instanceof SubProcess) {
                object.put("subProcessElements", (Object)this.getSubProcessMsg((SubProcess)flowElement, bpmnModel, processInsId));
            }
            object.put("processInsId", (Object)processInsId);
            if (runningNodeList.contains(flowNodeId)) {
                if (suspended) {
                    object.put("state", (Object)"suspend");
                } else {
                    object.put("state", (Object)nodeState.getOrDefault(flowNodeId, NOW_STATE));
                }
            } else if (finishedNodeList.contains(flowNodeId)) {
                object.put("state", (Object)FINISH_STATE);
            } else {
                object.put("state", (Object)"next");
            }
            nodeMessage.add((Object)object);
            for (SequenceFlow sequenceFlow : flowNode.getOutgoingFlows()) {
                List graphicInfoList;
                Map maps;
                List extendFlowNameElement;
                JSONObject obj = new JSONObject();
                obj.put("id", (Object)sequenceFlow.getId());
                obj.put("name", (Object)sequenceFlow.getName());
                obj.put("type", (Object)"sequenceFlow");
                obj.put("dx", null);
                obj.put("rotate", null);
                obj.put("lineName", null);
                obj.put("x", null);
                obj.put("y", null);
                obj.put("height", null);
                obj.put("width", null);
                Map stringListMap = sequenceFlow.getExtensionElements();
                if (stringListMap != null && !stringListMap.isEmpty() && (extendFlowNameElement = (List)stringListMap.get("extendSequenceflow")) != null && !extendFlowNameElement.isEmpty() && HussarUtils.isNotEmpty((Object)(maps = ((ExtensionElement)extendFlowNameElement.get(0)).getAttributes()))) {
                    for (Map.Entry map : maps.entrySet()) {
                        if ("lineName".equals(map.getKey())) {
                            String lineNamesStr = ((ExtensionAttribute)((List)map.getValue()).get(0)).getValue();
                            String[] lineNames = lineNamesStr.split("/n");
                            obj.put("lineName", (Object)lineNames);
                            continue;
                        }
                        if ("x".equals(map.getKey()) || "y".equals(map.getKey()) || "width".equals(map.getKey()) || "height".equals(map.getKey())) {
                            obj.put((String)map.getKey(), (Object)Double.parseDouble(((ExtensionAttribute)((List)map.getValue()).get(0)).getValue()));
                            continue;
                        }
                        obj.put((String)map.getKey(), (Object)((ExtensionAttribute)((List)map.getValue()).get(0)).getValue());
                    }
                }
                if ((graphicInfoList = bpmnModel.getFlowLocationGraphicInfo(sequenceFlow.getId())) != null && !graphicInfoList.isEmpty()) {
                    int[] xPoints = new int[graphicInfoList.size()];
                    int[] yPoints = new int[graphicInfoList.size()];
                    for (int i = 1; i < graphicInfoList.size(); ++i) {
                        GraphicInfo gi = (GraphicInfo)graphicInfoList.get(i);
                        GraphicInfo previousGraphicInfo = (GraphicInfo)graphicInfoList.get(i - 1);
                        if (i == 1) {
                            xPoints[0] = (int)previousGraphicInfo.getX();
                            yPoints[0] = (int)previousGraphicInfo.getY();
                        }
                        xPoints[i] = (int)gi.getX();
                        yPoints[i] = (int)gi.getY();
                    }
                    obj.put("xPoints", (Object)xPoints);
                    obj.put("yPoints", (Object)yPoints);
                }
                if (lineList.contains(sequenceFlow.getId())) {
                    obj.put("state", (Object)FINISH_STATE);
                } else {
                    obj.put("state", (Object)"next");
                }
                nodeMessage.add((Object)obj);
            }
        }
        return nodeMessage;
    }

    private String getNodeType(FlowNode flowNode) {
        String type = "";
        if (flowNode instanceof UserTask) {
            type = HussarUtils.isNotEmpty((Object)((UserTask)flowNode).getLoopCharacteristics()) ? "multiUserTask" : "userTask";
        } else if (flowNode instanceof ServiceTask) {
            type = "serviceTask";
        } else if (flowNode instanceof ReceiveTask) {
            type = "receiveTask";
        } else if (flowNode instanceof StartEvent) {
            EventDefinition eventDefinition;
            StartEvent startEvent = (StartEvent)flowNode;
            type = startEvent.getEventDefinitions() != null && !startEvent.getEventDefinitions().isEmpty() ? ((eventDefinition = (EventDefinition)startEvent.getEventDefinitions().get(0)) instanceof TimerEventDefinition ? "startTimerEvent" : (eventDefinition instanceof ErrorEventDefinition ? "errorEvent" : (eventDefinition instanceof SignalEventDefinition ? "signalEvent" : (eventDefinition instanceof MessageEventDefinition ? "messageEvent" : "noneEvent")))) : "startEvent";
        } else if (flowNode instanceof EndEvent) {
            type = "endEvent";
        } else if (flowNode instanceof ParallelGateway) {
            type = "parallelGateway";
        } else if (flowNode instanceof InclusiveGateway) {
            type = "inclusiveGateway";
        } else if (flowNode instanceof ExclusiveGateway) {
            type = "exclusiveGateway";
        } else if (flowNode instanceof SubProcess) {
            type = "subProcess";
        } else if (flowNode instanceof BoundaryEvent) {
            type = "boundaryEvent";
        } else if (flowNode instanceof CallActivity) {
            type = "callActivity";
        }
        return type;
    }

    private JSONArray getMergeProcessCompleteInfo(Map<String, List<BpmActRuIdentitylink>> taskUserMap, Map<String, String> commentMap, Map<String, String> finalUsersMap, List<Task> tasks, BpmnModel bpmnModel, Collection<FlowElement> flowElements, List<HistoricTaskInstance> hisList) {
        JSONArray subProcessCompleteInfo = new JSONArray();
        for (FlowElement flowElement : flowElements) {
            if (flowElement instanceof SequenceFlow) continue;
            GraphicInfo graphicInfo = bpmnModel.getGraphicInfo(flowElement.getId());
            JSONObject object = new JSONObject();
            object.put("width", (Object)graphicInfo.getWidth());
            object.put("height", (Object)graphicInfo.getHeight());
            object.put("x", (Object)graphicInfo.getX());
            object.put("y", (Object)graphicInfo.getY());
            object.put("id", (Object)flowElement.getId());
            List taskList = null;
            if (tasks != null && !tasks.isEmpty()) {
                taskList = tasks.stream().filter(t -> t.getTaskDefinitionKey().equals(flowElement.getId())).collect(Collectors.toList());
            }
            if (taskList != null && !taskList.isEmpty()) {
                ArrayList<BpmActRuIdentitylink> user = new ArrayList<BpmActRuIdentitylink>();
                for (Task task : taskList) {
                    List<BpmActRuIdentitylink> taskUser = taskUserMap.get(task.getId());
                    if (taskUser == null) continue;
                    user.addAll(taskUser);
                }
                List nowHisActivitList = hisList.stream().filter(hai -> hai.getTaskDefinitionKey().equals(flowElement.getId())).collect(Collectors.toList());
                List ts = taskList.stream().filter(t -> t.getTaskDefinitionKey().equals(flowElement.getId())).collect(Collectors.toList());
                object.put("startTime", (Object)((Task)ts.get(0)).getCreateTime());
                Map map = ((Task)ts.get(0)).getTaskLocalVariables();
                if (map != null) {
                    object.put("rejectFrom", (Object)(map.get("reject_name") == null ? "" : map.get("reject_name").toString()));
                    object.put("completeType", (Object)(map.get("complete_type") == null ? "" : map.get("complete_type").toString()));
                } else {
                    object.put("rejectFrom", (Object)"");
                    object.put("completeType", (Object)"");
                }
                if (!user.isEmpty()) {
                    ArrayList<String> result = new ArrayList<String>();
                    for (BpmActRuIdentitylink identityLink : user) {
                        if (finalUsersMap.get(identityLink.getUserId()) == null) continue;
                        if (TaskStateType.isEntrust((String)identityLink.getTaskState()) && finalUsersMap.get(identityLink.getMandator()) != null) {
                            result.add(finalUsersMap.get(identityLink.getUserId()) + "(" + finalUsersMap.get(identityLink.getMandator()) + ")");
                            continue;
                        }
                        result.add(finalUsersMap.get(identityLink.getUserId()));
                    }
                    if (result.isEmpty()) {
                        object.put("assignee", (Object)this.bpmConstantProperties.getNullAssignee());
                    } else {
                        String assignee = String.join((CharSequence)",", result);
                        object.put("assignee", (Object)assignee);
                    }
                } else {
                    object.put("assignee", (Object)this.bpmConstantProperties.getNullAssignee());
                }
                object.put("state", (Object)NOW_STATE);
                if (!nowHisActivitList.isEmpty()) {
                    nowHisActivitList.sort((o1, o2) -> {
                        if (!o1.getStartTime().equals(o2.getStartTime())) {
                            return o1.getStartTime().compareTo(o2.getStartTime());
                        }
                        if (HussarUtils.isAllEmpty((Object[])new Object[]{o1.getEndTime(), o2.getEndTime()})) {
                            return o1.getTaskDefinitionKey().compareTo(o2.getTaskDefinitionKey());
                        }
                        if (o1.getEndTime() == null && o2.getEndTime() != null) {
                            return o2.getEndTime().compareTo(new Date(0L));
                        }
                        if (o1.getEndTime() != null && o2.getEndTime() == null) {
                            return new Date(0L).compareTo(o1.getEndTime());
                        }
                        if (o1.getEndTime().equals(o2.getEndTime())) {
                            return o1.getTaskDefinitionKey().compareTo(o2.getTaskDefinitionKey());
                        }
                        return o1.getEndTime().compareTo(o2.getEndTime());
                    });
                    JSONArray json = new JSONArray();
                    for (HistoricTaskInstance historicActivityInstance : nowHisActivitList) {
                        String comment;
                        JSONObject o = new JSONObject();
                        String nowUser = this.bpmConstantProperties.getNullComplete();
                        if (historicActivityInstance.getAssignee() != null && finalUsersMap.get(historicActivityInstance.getAssignee()) != null) {
                            nowUser = TaskStateType.isEntrust((HistoricTaskInstance)historicActivityInstance) && HussarUtils.isNotEmpty((Object)historicActivityInstance.getOwner()) && finalUsersMap.get(historicActivityInstance.getOwner()) != null ? finalUsersMap.get(historicActivityInstance.getAssignee()) + "(" + finalUsersMap.get(historicActivityInstance.getOwner()) + ")" : finalUsersMap.get(historicActivityInstance.getAssignee());
                        }
                        o.put("comments", (Object)((comment = commentMap.get(historicActivityInstance.getId())) == null ? this.bpmConstantProperties.getNullComment() : comment));
                        o.put("assignee", (Object)nowUser);
                        o.put("endTime", (Object)historicActivityInstance.getEndTime());
                        o.put("startTime", (Object)historicActivityInstance.getStartTime());
                        o.put("taskType", (Object)historicActivityInstance.getTaskType());
                        json.add((Object)o);
                    }
                    object.put("completeInfo", (Object)json);
                }
            } else {
                object.put("state", (Object)FINISH_STATE);
                List hisActivitList = null;
                if (HussarUtils.isNotEmpty(hisList)) {
                    hisActivitList = hisList.stream().filter(hai -> hai.getTaskDefinitionKey().equals(flowElement.getId())).collect(Collectors.toList());
                }
                if (hisActivitList == null || hisActivitList.isEmpty()) continue;
                hisActivitList.sort((m1, m2) -> m1.getStartTime().compareTo(m2.getStartTime()));
                JSONArray json = new JSONArray();
                for (HistoricTaskInstance historicActivityInstance : hisActivitList) {
                    String comment;
                    JSONObject o = new JSONObject();
                    String user = "";
                    if (historicActivityInstance.getAssignee() != null) {
                        user = TaskStateType.isEntrust((HistoricTaskInstance)historicActivityInstance) ? finalUsersMap.get(historicActivityInstance.getAssignee()) + "(" + finalUsersMap.get(historicActivityInstance.getOwner()) + ")" : finalUsersMap.get(historicActivityInstance.getAssignee());
                    }
                    if (StringUtils.isEmpty((CharSequence)user)) {
                        user = this.bpmConstantProperties.getNullComplete();
                    }
                    o.put("comments", (Object)((comment = commentMap.get(historicActivityInstance.getId())) == null ? this.bpmConstantProperties.getNullComment() : comment));
                    o.put("assignee", (Object)user);
                    o.put("endTime", (Object)historicActivityInstance.getEndTime());
                    o.put("startTime", (Object)historicActivityInstance.getStartTime());
                    o.put("taskType", (Object)historicActivityInstance.getTaskType());
                    json.add((Object)o);
                }
                object.put("completeInfo", (Object)json);
            }
            subProcessCompleteInfo.add((Object)object);
        }
        return subProcessCompleteInfo;
    }

    private JSONArray getSubProcessMsg(SubProcess subProcess, BpmnModel bpmnModel, String processInsId) {
        JSONArray jsonArray = new JSONArray();
        for (FlowElement flowElement : subProcess.getFlowElements()) {
            if (!(flowElement instanceof FlowNode)) continue;
            FlowNode flowNode = (FlowNode)flowElement;
            JSONObject object = new JSONObject();
            String flowNodeId = flowNode.getId();
            object.put("id", (Object)flowNodeId);
            object.put("name", (Object)flowNode.getName());
            GraphicInfo graphicInfo = bpmnModel.getGraphicInfo(flowNode.getId());
            object.put("x", (Object)graphicInfo.getX());
            object.put("y", (Object)graphicInfo.getY());
            object.put("width", (Object)graphicInfo.getWidth());
            object.put("height", (Object)graphicInfo.getHeight());
            object.put("type", (Object)this.getNodeType(flowNode));
            object.put("processInsId", (Object)processInsId);
            object.put("state", (Object)"next");
            jsonArray.add((Object)object);
            for (SequenceFlow sequenceFlow : flowNode.getOutgoingFlows()) {
                List graphicInfoList;
                Map maps;
                List extendFlowNameElement;
                JSONObject obj = new JSONObject();
                obj.put("id", (Object)sequenceFlow.getId());
                obj.put("name", (Object)sequenceFlow.getName());
                obj.put("type", (Object)"sequenceFlow");
                obj.put("dx", null);
                obj.put("rotate", null);
                obj.put("lineName", null);
                obj.put("x", null);
                obj.put("y", null);
                obj.put("height", null);
                obj.put("width", null);
                Map stringListMap = sequenceFlow.getExtensionElements();
                if (stringListMap != null && !stringListMap.isEmpty() && (extendFlowNameElement = (List)stringListMap.get("extendSequenceflow")) != null && !extendFlowNameElement.isEmpty() && HussarUtils.isNotEmpty((Object)(maps = ((ExtensionElement)extendFlowNameElement.get(0)).getAttributes()))) {
                    for (Map.Entry map : maps.entrySet()) {
                        if ("lineName".equals(map.getKey())) {
                            String lineNamesStr = ((ExtensionAttribute)((List)map.getValue()).get(0)).getValue();
                            String[] lineNames = lineNamesStr.split("/n");
                            obj.put("lineName", (Object)lineNames);
                            continue;
                        }
                        if ("x".equals(map.getKey()) || "y".equals(map.getKey()) || "width".equals(map.getKey()) || "height".equals(map.getKey())) {
                            obj.put((String)map.getKey(), (Object)Double.parseDouble(((ExtensionAttribute)((List)map.getValue()).get(0)).getValue()));
                            continue;
                        }
                        obj.put((String)map.getKey(), (Object)((ExtensionAttribute)((List)map.getValue()).get(0)).getValue());
                    }
                }
                if ((graphicInfoList = bpmnModel.getFlowLocationGraphicInfo(sequenceFlow.getId())) != null && !graphicInfoList.isEmpty()) {
                    int[] xPoints = new int[graphicInfoList.size()];
                    int[] yPoints = new int[graphicInfoList.size()];
                    for (int i = 1; i < graphicInfoList.size(); ++i) {
                        GraphicInfo gi = (GraphicInfo)graphicInfoList.get(i);
                        GraphicInfo previousGraphicInfo = (GraphicInfo)graphicInfoList.get(i - 1);
                        if (i == 1) {
                            xPoints[0] = (int)previousGraphicInfo.getX();
                            yPoints[0] = (int)previousGraphicInfo.getY();
                        }
                        xPoints[i] = (int)gi.getX();
                        yPoints[i] = (int)gi.getY();
                    }
                    obj.put("xPoints", (Object)xPoints);
                    obj.put("yPoints", (Object)yPoints);
                }
                obj.put("state", (Object)"next");
                jsonArray.add((Object)obj);
            }
        }
        return jsonArray;
    }

    public BpmResponseResult getProcessShowMsg(FlowChartCommonDto flowChartCommonDto) {
        JSONObject jsonObject = this.getProcessShowMsg(flowChartCommonDto.getProcessInsId(), flowChartCommonDto.getBusinessId(), flowChartCommonDto.getFirstQuery());
        return InstallResult.success((Object)jsonObject);
    }

    public BpmResponseResult getProcessHistoryMsg(FlowChartCommonDto flowChartCommonDto) {
        JSONObject jsonObject = this.getProcessHistoryMsg(flowChartCommonDto.getProcessInsId(), flowChartCommonDto.getBusinessId(), flowChartCommonDto.getProcessCycleCount(), flowChartCommonDto.getFirstQuery(), flowChartCommonDto.getInitialProcessInsId(), flowChartCommonDto.getInitialBusinessId(), flowChartCommonDto.getNeedGetCallActivity());
        return InstallResult.success((Object)jsonObject);
    }
}

