/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.check.util;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.workflow.engine.bpm.check.model.NodeMessage;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowElements;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowObject;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowSequence;
import com.jxdinfo.hussar.workflow.engine.flowmodel.enums.BpmNodeTypeEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class ParallelRelationshipCheckUtil {
    private static final BpmConstantProperties bpmConstantProperties = (BpmConstantProperties)SpringContextHolder.getBean(BpmConstantProperties.class);

    public static ApiResponse<String> checkWorkflowNodesPlusTest(FlowElements flowElements, FlowElements oldFlowElements) {
        ApiResponse response = ApiResponse.success();
        Map<String, NodeMessage> oldNodeMessageMap = ParallelRelationshipCheckUtil.getNodeMessageMap(oldFlowElements);
        HashSet<String> allNodeIds = new HashSet<String>(oldNodeMessageMap.keySet());
        HashSet<String> startEndNodeIds = new HashSet<String>();
        ArrayList<Set<String>> oldGoneNodeIdsList = new ArrayList<Set<String>>();
        for (NodeMessage nodeMessage : oldNodeMessageMap.values()) {
            if (nodeMessage.getNextNodeIds().isEmpty()) {
                startEndNodeIds.add(nodeMessage.getNodeId());
                ParallelRelationshipCheckUtil.getAllPath(oldNodeMessageMap, oldGoneNodeIdsList, nodeMessage.getNodeId(), false, new HashSet<String>(), nodeMessage.getNodeId());
                continue;
            }
            if (!nodeMessage.getPrevNodeIds().isEmpty()) continue;
            startEndNodeIds.add(nodeMessage.getNodeId());
            ParallelRelationshipCheckUtil.getAllPath(oldNodeMessageMap, oldGoneNodeIdsList, nodeMessage.getNodeId(), true, new HashSet<String>(), nodeMessage.getNodeId());
        }
        HashMap<String, Set> oldSerialNodeIdMap = new HashMap<String, Set>();
        for (Set set : oldGoneNodeIdsList) {
            for (Object nodeId : set) {
                oldSerialNodeIdMap.computeIfAbsent((String)nodeId, k -> new HashSet()).addAll(set);
            }
        }
        allNodeIds.removeAll(startEndNodeIds);
        HashMap hashMap = new HashMap();
        oldSerialNodeIdMap.forEach((key, value) -> {
            HashSet parallelNode = new HashSet(allNodeIds);
            parallelNode.removeAll((Collection<?>)value);
            oldParallelNodeMap.put(key, parallelNode);
        });
        Map<String, NodeMessage> map = ParallelRelationshipCheckUtil.getNodeMessageMap(flowElements);
        ArrayList<Set<String>> goneNodeIdsList = new ArrayList<Set<String>>();
        for (NodeMessage nodeMessage : map.values()) {
            if (nodeMessage.getNextNodeIds().isEmpty()) {
                startEndNodeIds.add(nodeMessage.getNodeId());
                ParallelRelationshipCheckUtil.getAllPath(map, goneNodeIdsList, nodeMessage.getNodeId(), false, new HashSet<String>(), nodeMessage.getNodeId());
                continue;
            }
            if (!nodeMessage.getPrevNodeIds().isEmpty()) continue;
            startEndNodeIds.add(nodeMessage.getNodeId());
            ParallelRelationshipCheckUtil.getAllPath(map, goneNodeIdsList, nodeMessage.getNodeId(), true, new HashSet<String>(), nodeMessage.getNodeId());
        }
        HashMap<String, Set> serialNodeIdMap = new HashMap<String, Set>();
        for (Set set : goneNodeIdsList) {
            for (String nodeId : set) {
                serialNodeIdMap.computeIfAbsent(nodeId, k -> new HashSet()).addAll(set);
            }
        }
        for (String string : hashMap.keySet()) {
            Set parallelNodes = (Set)hashMap.get(string);
            Set serialNodes = (Set)serialNodeIdMap.get(string);
            if (serialNodes == null) continue;
            parallelNodes.retainAll(serialNodes);
            if (parallelNodes.isEmpty()) continue;
            return ApiResponse.fail((String)bpmConstantProperties.getCanNotModifyNodeParallelRelationshipToSerial());
        }
        return response;
    }

    private static void getAllPath(Map<String, NodeMessage> newNodeMessageMap, List<Set<String>> goneNodeIdsList, String currentNodeId, boolean inOrder, Set<String> goneNodeIds, String startNodeId) {
        NodeMessage nodeMessage = newNodeMessageMap.get(currentNodeId);
        if (inOrder) {
            if (!nodeMessage.getNextNodeIds().isEmpty()) {
                goneNodeIds.add(currentNodeId);
                for (String nextNodeId : nodeMessage.getNextNodeIds()) {
                    if (goneNodeIds.contains(nextNodeId)) {
                        goneNodeIds.remove(startNodeId);
                        goneNodeIdsList.add(goneNodeIds);
                        continue;
                    }
                    ParallelRelationshipCheckUtil.getAllPath(newNodeMessageMap, goneNodeIdsList, nextNodeId, inOrder, new HashSet<String>(goneNodeIds), startNodeId);
                }
            } else {
                goneNodeIds.remove(startNodeId);
                goneNodeIdsList.add(goneNodeIds);
            }
        } else if (!nodeMessage.getPrevNodeIds().isEmpty()) {
            goneNodeIds.add(currentNodeId);
            for (String prevNodeId : nodeMessage.getPrevNodeIds()) {
                if (goneNodeIds.contains(prevNodeId)) {
                    goneNodeIds.remove(startNodeId);
                    goneNodeIdsList.add(goneNodeIds);
                    continue;
                }
                ParallelRelationshipCheckUtil.getAllPath(newNodeMessageMap, goneNodeIdsList, prevNodeId, inOrder, new HashSet<String>(goneNodeIds), startNodeId);
            }
        } else {
            goneNodeIds.remove(startNodeId);
            goneNodeIdsList.add(goneNodeIds);
        }
    }

    public static ApiResponse<String> checkWorkflowNodes(FlowElements flowElements, FlowElements oldFlowElements) {
        ApiResponse<String> response = ApiResponse.success();
        Map<String, NodeMessage> newNodeMessgeMap = ParallelRelationshipCheckUtil.getNodeMessageMap(flowElements);
        HashSet<String> endNodeIds = new HashSet<String>();
        for (NodeMessage nodeMessage : newNodeMessgeMap.values()) {
            if (!BpmNodeTypeEnum.BPM_END.getType().equals(nodeMessage.getNodeType())) continue;
            endNodeIds.add(nodeMessage.getNodeId());
        }
        Map<String, NodeMessage> nodeMessgeMap = ParallelRelationshipCheckUtil.getNodeMessageMap(oldFlowElements);
        HashMap<String, List<List<String>>> distributeGateWayNextNodeListMap = new HashMap<String, List<List<String>>>();
        ArrayList<String> distributeGateWayNodeIds = new ArrayList<String>();
        for (NodeMessage nodeMessage : nodeMessgeMap.values()) {
            if (nodeMessage.isDistributeGateWay()) {
                distributeGateWayNodeIds.add(nodeMessage.getNodeId());
            }
            if (!nodeMessage.isDistributeGateWay() && !nodeMessage.isMergeGateWay()) continue;
            ParallelRelationshipCheckUtil.getNodeListBetweenGateWay(nodeMessgeMap, new ArrayList<String>(), nodeMessage.getNodeId(), distributeGateWayNextNodeListMap);
        }
        HashMap<String, ArrayList<List<String>>> nodeBetweenGateWay = new HashMap<String, ArrayList<List<String>>>();
        for (String nodeId : distributeGateWayNodeIds) {
            ArrayList<List<String>> pathBetweenGateWay;
            List<String> targets;
            boolean isSuccess = ParallelRelationshipCheckUtil.getNodeBetweenGateWay(distributeGateWayNextNodeListMap, nodeId, targets = ParallelRelationshipCheckUtil.getFinalMergeNodeId(nodeMessgeMap, nodeId, endNodeIds), new ArrayList<String>(), pathBetweenGateWay = new ArrayList<List<String>>());
            if (!isSuccess) {
                return ApiResponse.fail((String)bpmConstantProperties.getErrorUpdateWorkflow());
            }
            nodeBetweenGateWay.put(nodeId, pathBetweenGateWay);
        }
        for (String nodeId : nodeBetweenGateWay.keySet()) {
            List nodeList = (List)nodeBetweenGateWay.get(nodeId);
            response = ParallelRelationshipCheckUtil.checkNodeGetOutFromGateWay(nodeList, newNodeMessgeMap, endNodeIds);
            if (response.isSuccess()) continue;
            return response;
        }
        return response;
    }

    private static ApiResponse<String> checkNodeGetOutFromGateWay(List<List<String>> nodeList, Map<String, NodeMessage> newNodeMessgeMap, Set<String> endNodeIds) {
        String start = nodeList.get(0).get(0);
        HashMap<String, List> nodesMap = new HashMap<String, List>();
        for (List<String> nodes : nodeList) {
            String end = nodes.get(nodes.size() - 1);
            nodesMap.computeIfAbsent(end, k -> new ArrayList()).add(nodes);
        }
        for (String end : nodesMap.keySet()) {
            ApiResponse<String> response = ParallelRelationshipCheckUtil.checkNodeGetOutFromGateWay(start, end, (List)nodesMap.get(end), newNodeMessgeMap, endNodeIds);
            if (response.isSuccess()) continue;
            return response;
        }
        return ApiResponse.success();
    }

    private static ApiResponse<String> checkNodeGetOutFromGateWay(String start, String end, List<List<String>> nodeList, Map<String, NodeMessage> newNodeMessgeMap, Set<String> endNodeIds) {
        boolean isEndNode = endNodeIds.contains(end);
        Set<String> allNewNodeIds = newNodeMessgeMap.keySet();
        HashSet<String> allNodeBetweenGateWay = new HashSet<String>();
        for (List<String> list : nodeList) {
            allNodeBetweenGateWay.addAll(list);
        }
        if (!allNewNodeIds.contains(start) || !allNewNodeIds.contains(end)) {
            return ApiResponse.fail((String)bpmConstantProperties.getCanNotRemoveMergeOrDistributeNode());
        }
        if (!ParallelRelationshipCheckUtil.checkNodeGetOutFromGatWay(allNodeBetweenGateWay, start, end, true, end, newNodeMessgeMap)) {
            return ApiResponse.fail((String)bpmConstantProperties.getCanNotMoveNodeWithInTheGateWayToTheOutside());
        }
        if (!ParallelRelationshipCheckUtil.checkNodeGetOutFromGatWay(allNodeBetweenGateWay, start, end, false, start, newNodeMessgeMap)) {
            return ApiResponse.fail((String)bpmConstantProperties.getCanNotMoveNodeWithInTheGateWayToTheOutside());
        }
        ParallelRelationshipCheckUtil.getNewCheckList(nodeList, allNewNodeIds, allNodeBetweenGateWay);
        HashSet<String> newNodes = new HashSet<String>(allNewNodeIds);
        newNodes.removeAll(allNodeBetweenGateWay);
        HashSet<String> goneNode = new HashSet<String>();
        goneNode.add(start);
        ArrayList<List<String>> allPath = new ArrayList<List<String>>();
        ArrayList<String> pathNode = new ArrayList<String>();
        pathNode.add(start);
        ParallelRelationshipCheckUtil.getAllPath(newNodeMessgeMap, start, goneNode, pathNode, allPath);
        for (List list : allPath) {
            List<String> containsPath = null;
            for (List<String> node : nodeList) {
                if (!list.containsAll(node)) continue;
                containsPath = node;
                break;
            }
            if (containsPath == null) {
                if (newNodes.containsAll(list)) continue;
                HashSet nodes = new HashSet(list);
                nodes.removeAll(newNodes);
                boolean check = false;
                for (List list2 : nodeList) {
                    if (!list2.containsAll(nodes)) continue;
                    check = true;
                }
                if (check) continue;
                return ApiResponse.fail((String)bpmConstantProperties.getCanNotModifyNodeParallelRelationshipToSerial());
            }
            for (List<String> node : nodeList) {
                for (String string : node) {
                    if (!list.contains(string) || containsPath.contains(string)) continue;
                    return ApiResponse.fail((String)bpmConstantProperties.getCanNotModifyNodeParallelRelationshipToSerial());
                }
            }
        }
        return ApiResponse.success();
    }

    private static void getNewCheckList(List<List<String>> nodeList, Set<String> allNewNodeIds, Set<String> allNodeBetweenGateWay) {
        HashSet<String> delNode = new HashSet<String>(allNodeBetweenGateWay);
        delNode.removeAll(allNewNodeIds);
        for (int i = nodeList.size() - 1; i >= 0; --i) {
            nodeList.get(i).removeAll(delNode);
            if (nodeList.get(i).size() != 0) continue;
            nodeList.remove(i);
        }
    }

    private static boolean checkNodeGetOutFromGatWay(Set<String> allNode, String start, String end, boolean isGoToNext, String currentNode, Map<String, NodeMessage> newNodeMessgeMap) {
        NodeMessage nodeMessage = newNodeMessgeMap.get(currentNode);
        List<Object> nextCheckNode = new ArrayList();
        nextCheckNode = isGoToNext ? nodeMessage.getNextNodeIds() : nodeMessage.getPrevNodeIds();
        if (nextCheckNode.isEmpty()) {
            return true;
        }
        for (String string : nextCheckNode) {
            if (string.equals(start) || string.equals(end)) {
                return true;
            }
            if (allNode.contains(string)) {
                return false;
            }
            if (ParallelRelationshipCheckUtil.checkNodeGetOutFromGatWay(allNode, start, end, isGoToNext, string, newNodeMessgeMap)) continue;
            return false;
        }
        return true;
    }

    private static boolean getNodeBetweenGateWay(Map<String, List<List<String>>> distributeGateWayNextNodeListMap, String start, List<String> target, List<String> path, List<List<String>> result) {
        List<List<String>> nextNodeList = distributeGateWayNextNodeListMap.get(start);
        if (nextNodeList == null) {
            return false;
        }
        for (List<String> list : nextNodeList) {
            ArrayList<String> newPath = new ArrayList<String>(path);
            String end = list.get(list.size() - 1);
            if (target.contains(end)) {
                newPath.addAll(list);
                result.add(newPath);
                continue;
            }
            newPath.addAll(list);
            newPath.remove(newPath.size() - 1);
            boolean isSuccess = ParallelRelationshipCheckUtil.getNodeBetweenGateWay(distributeGateWayNextNodeListMap, end, target, newPath, result);
            if (isSuccess) continue;
            return isSuccess;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static List<String> getFinalMergeNodeId(Map<String, NodeMessage> nodeMessgeMap, String startNode, Set<String> endNodeIds) {
        HashSet<String> goneNode = new HashSet<String>();
        goneNode.add(startNode);
        ArrayList<List<String>> allPath = new ArrayList<List<String>>();
        ParallelRelationshipCheckUtil.getAllPath(nodeMessgeMap, startNode, goneNode, new ArrayList<String>(), allPath);
        List<String> finalPath = (List<String>)allPath.get(0);
        for (int i = 1; i < allPath.size(); ++i) {
            finalPath = ParallelRelationshipCheckUtil.getMergePath(finalPath, (List)allPath.get(i));
        }
        if (finalPath.isEmpty()) {
            ArrayList<String> finalMergeNodeIds = new ArrayList<String>();
            for (String endNode : endNodeIds) {
                void var11_15;
                ArrayList<List> paths = new ArrayList<List>();
                for (List list : allPath) {
                    if (!list.contains(endNode)) continue;
                    paths.add(list);
                }
                if (paths.isEmpty()) continue;
                if (paths.size() == 1) {
                    finalMergeNodeIds.add(endNode);
                    continue;
                }
                List<String> finalEndPath = (List<String>)paths.get(0);
                boolean bl = true;
                while (var11_15 < paths.size()) {
                    finalEndPath = ParallelRelationshipCheckUtil.getMergePath(finalEndPath, (List)paths.get((int)var11_15));
                    ++var11_15;
                }
                finalMergeNodeIds.add((String)finalEndPath.get(0));
            }
            return finalMergeNodeIds;
        }
        ArrayList<String> result = new ArrayList<String>();
        result.add(finalPath.get(0));
        return result;
    }

    private static List<String> getMergePath(List<String> pathFirst, List<String> pathSecond) {
        ArrayList<String> path1 = new ArrayList<String>(pathFirst);
        ArrayList<String> path2 = new ArrayList<String>(pathSecond);
        ArrayList<String> result = new ArrayList<String>(path1);
        path1.removeAll(path2);
        path2.removeAll(result);
        result.removeAll(path1);
        result.removeAll(path2);
        return result;
    }

    private static void getAllPath(Map<String, NodeMessage> nodeMessgeMap, String currentNode, Set<String> goneNode, List<String> path, List<List<String>> allPath) {
        List<String> list = nodeMessgeMap.get(currentNode).getNextNodeIds();
        if (list.isEmpty()) {
            allPath.add(path);
        }
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            HashSet<String> newGoneNode = new HashSet<String>(goneNode);
            String next = iterator.next();
            if (!newGoneNode.add(next)) continue;
            ArrayList<String> newPath = new ArrayList<String>(path);
            newPath.add(next);
            ParallelRelationshipCheckUtil.getAllPath(nodeMessgeMap, next, newGoneNode, newPath, allPath);
        }
    }

    private static Map<String, NodeMessage> getNodeMessageMap(FlowElements flowElements) {
        HashMap<String, NodeMessage> result = new HashMap<String, NodeMessage>();
        List elements = flowElements.getElement();
        for (FlowObject flowObject : elements) {
            result.put(flowObject.getInstanceKey(), new NodeMessage(flowObject.getInstanceKey(), flowObject.getName()));
        }
        List flowSequences = flowElements.getPath();
        for (FlowSequence flowSequence : flowSequences) {
            String start = flowSequence.getStart().getKey();
            String end = flowSequence.getEnd().getKey();
            NodeMessage startNodeMessage = (NodeMessage)result.get(start);
            startNodeMessage.getNextNodeIds().add(end);
            NodeMessage endNodeMessage = (NodeMessage)result.get(end);
            endNodeMessage.getPrevNodeIds().add(start);
        }
        return result;
    }

    private static void getNodeListBetweenGateWay(Map<String, NodeMessage> nodeMessages, List<String> goneNodeList, String currentNodeId, Map<String, List<List<String>>> result) {
        NodeMessage nodeMessage = nodeMessages.get(currentNodeId);
        List<String> nextCheckNodes = nodeMessage.getNextNodeIds();
        for (String nextCheckNode : nextCheckNodes) {
            ArrayList<String> nodeList = new ArrayList<String>(goneNodeList);
            if (nodeList.contains(currentNodeId)) {
                return;
            }
            nodeList.add(currentNodeId);
            if (nodeMessages.get(nextCheckNode).isUnRunNode()) {
                nodeList.add(nextCheckNode);
                List nodeIds = result.computeIfAbsent((String)nodeList.get(0), (Function<String, List<List<String>>>)((Function<String, List>)k -> new ArrayList()));
                nodeIds.add(nodeList);
                continue;
            }
            ParallelRelationshipCheckUtil.getNodeListBetweenGateWay(nodeMessages, nodeList, nextCheckNode, result);
        }
    }
}

