/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.check.service.impl;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.workflow.engine.bpm.check.model.ProcessCheckResult;
import com.jxdinfo.hussar.workflow.engine.bpm.check.service.ProcessCheckService;
import com.jxdinfo.hussar.workflow.engine.bpm.check.util.ParallelRelationshipCheckUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmFormdesignProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.WorkFlow;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowModel;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowObject;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowVariables;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.util.FormBpmnUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.runtime.Execution;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class ProcessCheckServiceImpl
implements ProcessCheckService {
    @Autowired
    private LcdpBpmProperties lcdpBpmProperties;
    @Resource
    private RuntimeService runtimeService;
    @Autowired
    private BpmConstantProperties bpmConstantProperties;
    @Autowired
    private BpmFormdesignProperties bpmFormdesignProperties;
    private static final List<String> CHECK_VARIABLE_NODE_TYPE_LIST = new ArrayList<String>();
    private static final List<String> CHECK_CHANGE_NODE_TYPE_LIST = new ArrayList<String>();
    private static final String USER_TASK = "com.jxdinfo.workflow.User";
    private static final String CALL_ACTIVITY = "com.jxdinfo.workflow.CallActivity";
    private static final String SUB_PROCESS = "com.jxdinfo.workflow.SubProcess";
    public static final String GOD_AXE_CHECK = "0";
    public static final String BPM_DESIGNER_CHECK = "1";
    public static final String NO_CODE_CHECK = "2";
    public static final String IMPORT_CHECK = "3";
    private static final Map<String, Set<String>> checkMap = new HashMap<String, Set<String>>();
    private static final String VARIABLE_CHECK = "VARIABLE_CHECK";
    private static final String BPM_DESIGN_VARIABLE_CHECK = "BPM_DESIGN_VARIABLE_CHECK";
    private static final String PARALLEL_RELATIONSHIP_CHECK = "PARALLEL_RELATIONSHIP_CHECK";
    private static final String RUNNING_TASK_CHANGE_CHECK = "RUNNING_TASK_CHANGE_CHECK";

    public ApiResponse<String> checkWorkflow(WorkFlow workFlow, WorkFlow oldWorkFlow, String checkType) {
        if (this.runtimeService.createProcessInstanceQuery().processDefinitionId(oldWorkFlow.getProcDefId()).count() == 0L) {
            ProcessCheckResult processCheckResult;
            if ((checkMap.get(checkType).contains(BPM_DESIGN_VARIABLE_CHECK) && "base".equals(this.lcdpBpmProperties.getTenantType()) || checkMap.get(checkType).contains(VARIABLE_CHECK)) && (processCheckResult = this.getProcessCheckResult(workFlow, oldWorkFlow, null, checkType)).isUserNewVariable()) {
                return ApiResponse.fail((String)this.bpmConstantProperties.getErrUpdateProcessWithVariables());
            }
            return ApiResponse.success();
        }
        Map<String, Set<String>> runningNodeProcessCountMsg = null;
        if (checkMap.get(checkType).contains(RUNNING_TASK_CHANGE_CHECK)) {
            runningNodeProcessCountMsg = this.getRunningNodeProcessCountMsg(oldWorkFlow.getProcDefId());
        }
        if (checkMap.get(checkType).contains(RUNNING_TASK_CHANGE_CHECK) || checkMap.get(checkType).contains(VARIABLE_CHECK) || checkMap.get(checkType).contains(BPM_DESIGN_VARIABLE_CHECK)) {
            ProcessCheckResult processCheckResult = this.getProcessCheckResult(workFlow, oldWorkFlow, runningNodeProcessCountMsg, checkType);
            if (processCheckResult.isUserNewVariable()) {
                return ApiResponse.fail((String)this.bpmConstantProperties.getErrUpdateProcessWithVariables());
            }
            if (processCheckResult.getErrorProcessInstance() > 0) {
                StringBuilder stringBuilder = new StringBuilder();
                if (IMPORT_CHECK.equals(checkType)) {
                    stringBuilder.append("\u672c\u6b21\u5bfc\u5165\u5f71\u54cd\u4e86");
                } else {
                    stringBuilder.append("\u672c\u6b21\u5fae\u8c03\u5f71\u54cd\u4e86");
                }
                stringBuilder.append(processCheckResult.getErrorProcessInstance()).append("\u6761\u6d41\u7a0b\u7684\u8fd0\u884c\u3002\u5176\u4e2d\uff1a");
                Map errorNodeNameMap = processCheckResult.getErrorNodeNameMap();
                Map deleteNodeMap = processCheckResult.getDeleteNodeMap();
                for (Object key : deleteNodeMap.keySet()) {
                    stringBuilder.append("\u5220\u9664\u8282\u70b9").append((String)(HussarUtils.isNotEmpty(errorNodeNameMap.get(key)) ? (String)errorNodeNameMap.get(key) : key)).append("\u5f71\u54cd\u4e86");
                    stringBuilder.append(deleteNodeMap.get(key)).append("\u6761\u6d41\u7a0b\u7684\u8fd0\u884c;");
                }
                Map changeNodeMap = processCheckResult.getChangeNodeMap();
                for (String key : changeNodeMap.keySet()) {
                    stringBuilder.append("\u4fee\u6539\u8282\u70b9").append(HussarUtils.isNotEmpty(errorNodeNameMap.get(key)) ? (String)errorNodeNameMap.get(key) : key).append("\u7684\u4f1a\u7b7e\u7c7b\u578b\u5f71\u54cd\u4e86");
                    stringBuilder.append(changeNodeMap.get(key)).append("\u6761\u6d41\u7a0b\u7684\u8fd0\u884c;");
                }
                String message = stringBuilder.substring(0, stringBuilder.toString().length() - 1) + "\u3002";
                return ApiResponse.fail((String)message);
            }
        }
        if (checkMap.get(checkType).contains(PARALLEL_RELATIONSHIP_CHECK)) {
            return this.checkPrallelRelationShip(workFlow, oldWorkFlow);
        }
        return ApiResponse.success();
    }

    private ApiResponse<String> checkPrallelRelationShip(WorkFlow workFlow, WorkFlow oldWorkFlow) {
        FlowModel flowModel = (FlowModel)JSON.parseObject((String)workFlow.getData(), FlowModel.class);
        FlowModel oldFlowModel = (FlowModel)JSON.parseObject((String)oldWorkFlow.getData(), FlowModel.class);
        ApiResponse<String> response = ParallelRelationshipCheckUtil.checkWorkflowNodes(flowModel.getSlots(), oldFlowModel.getSlots());
        if (!response.isSuccess()) {
            return response;
        }
        for (FlowObject flowObject : flowModel.getSlots().getElement()) {
            if (!SUB_PROCESS.equals(flowObject.getName())) continue;
            FlowObject oldSubProcess = null;
            for (FlowObject object : oldFlowModel.getSlots().getElement()) {
                if (!flowObject.getId().equals(object.getId())) continue;
                oldSubProcess = object;
                break;
            }
            if (oldSubProcess == null || (response = ParallelRelationshipCheckUtil.checkWorkflowNodes(flowObject.getSlots(), oldSubProcess.getSlots())).isSuccess()) continue;
            return response;
        }
        return response;
    }

    private ProcessCheckResult getProcessCheckResult(WorkFlow workFlow, WorkFlow oldWorkFlow, Map<String, Set<String>> runningNodeProcessCountMsg, String checkType) {
        ProcessCheckResult result = new ProcessCheckResult();
        FlowModel flowModel = (FlowModel)JSON.parseObject((String)workFlow.getData(), FlowModel.class);
        FlowModel oldFlowModel = (FlowModel)JSON.parseObject((String)oldWorkFlow.getData(), FlowModel.class);
        HashMap<String, FlowObject> nodeMap = new HashMap<String, FlowObject>();
        List elements = flowModel.getSlots().getElement();
        for (FlowObject flowObject : elements) {
            nodeMap.put(flowObject.getId(), flowObject);
            if (!SUB_PROCESS.equals(flowObject.getName())) continue;
            List subProcessNodeList = flowObject.getSlots().getElement();
            Iterator iterator = subProcessNodeList.iterator();
            while (iterator.hasNext()) {
                FlowObject subProcessNode = (FlowObject)iterator.next();
                nodeMap.put(subProcessNode.getId(), subProcessNode);
            }
        }
        HashMap<String, FlowObject> oldNodeMap = new HashMap<String, FlowObject>();
        List oldElements = oldFlowModel.getSlots().getElement();
        for (Object flowObject : oldElements) {
            oldNodeMap.put(flowObject.getId(), (FlowObject)flowObject);
            if (!SUB_PROCESS.equals(flowObject.getName())) continue;
            List subProcessNodeList = flowObject.getSlots().getElement();
            for (FlowObject subProcessNode : subProcessNodeList) {
                oldNodeMap.put(subProcessNode.getId(), subProcessNode);
            }
        }
        if (checkMap.get(checkType).contains(RUNNING_TASK_CHANGE_CHECK) && runningNodeProcessCountMsg != null) {
            HashSet errorProcessInstance = new HashSet();
            for (String nodeId : runningNodeProcessCountMsg.keySet()) {
                Object errorProcessInsIds;
                FlowObject oldFlowObject = (FlowObject)oldNodeMap.get(nodeId);
                FlowObject newFlowObject = (FlowObject)nodeMap.get(nodeId);
                if (oldFlowObject == null) continue;
                if (newFlowObject == null) {
                    errorProcessInsIds = runningNodeProcessCountMsg.get(oldFlowObject.getId());
                    errorProcessInstance.addAll(errorProcessInsIds);
                    result.getDeleteNodeMap().put(oldFlowObject.getId(), errorProcessInsIds.size());
                    result.getErrorNodeNameMap().put(oldFlowObject.getId(), oldFlowObject.getProps().getFlowName());
                    continue;
                }
                if (oldFlowObject.getProps().getFlowCountersign() == null || oldFlowObject.getProps().getFlowCountersign().isCountersign() == newFlowObject.getProps().getFlowCountersign().isCountersign()) continue;
                errorProcessInsIds = runningNodeProcessCountMsg.get(oldFlowObject.getId());
                errorProcessInstance.addAll(errorProcessInsIds);
                result.getChangeNodeMap().put(oldFlowObject.getId(), errorProcessInsIds.size());
                result.getErrorNodeNameMap().put(oldFlowObject.getId(), oldFlowObject.getProps().getFlowName());
            }
            result.setErrorProcessInstance(Integer.valueOf(errorProcessInstance.size()));
        }
        if (checkMap.get(checkType).contains(BPM_DESIGN_VARIABLE_CHECK) && "base".equals(this.lcdpBpmProperties.getTenantType()) || checkMap.get(checkType).contains(VARIABLE_CHECK)) {
            Set<String> nodeVariableNames;
            String newTableName = null;
            HashSet<String> processVariableNames = new HashSet<String>();
            HashMap nodeVariableMap = new HashMap();
            HashMap<String, String> callActivityTables = new HashMap<String, String>();
            List processVariables = flowModel.getProps().getUseVariables();
            if (processVariables != null) {
                for (FlowVariables flowVariables : processVariables) {
                    processVariableNames.add(flowVariables.getVariable());
                    if (newTableName != null || flowVariables.getTable() == null) continue;
                    newTableName = flowVariables.getTable();
                }
            }
            for (FlowObject flowObject : nodeMap.values()) {
                if (!CHECK_VARIABLE_NODE_TYPE_LIST.contains(flowObject.getName())) continue;
                HashSet<String> nodeVariableNames2 = new HashSet<String>();
                ArrayList<FlowVariables> functionUserVariables = new ArrayList<FlowVariables>();
                FormBpmnUtil.getFunctionMessage(flowObject.getProps(), new HashMap<String, String>(), functionUserVariables);
                ArrayList<FlowVariables> nodeVariables = flowObject.getProps().getUseVariables();
                if (nodeVariables == null) {
                    nodeVariables = new ArrayList<FlowVariables>();
                }
                nodeVariables.addAll(functionUserVariables);
                for (FlowVariables flowVariables : nodeVariables) {
                    nodeVariableNames2.add(flowVariables.getVariable());
                    if (newTableName != null || flowVariables.getTable() == null) continue;
                    newTableName = flowVariables.getTable();
                }
                nodeVariableNames2.addAll(processVariableNames);
                if (!nodeVariableNames2.isEmpty()) {
                    nodeVariableMap.put(flowObject.getId(), nodeVariableNames2);
                }
                if (!CALL_ACTIVITY.equals(flowObject.getName())) continue;
                callActivityTables.put(flowObject.getId(), flowObject.getProps().getCallActivityTable() != null ? flowObject.getProps().getCallActivityTable().getTableId() : "");
            }
            String oldTableName = null;
            HashSet<String> oldProcessVariableNames = new HashSet<String>();
            HashMap<String, Set<String>> oldNodeVariableMap = new HashMap<String, Set<String>>();
            HashMap<String, String> oldCallActivityTables = new HashMap<String, String>();
            List oldProcessVariables = oldFlowModel.getProps().getUseVariables();
            if (oldProcessVariables != null) {
                for (FlowVariables flowVariables : oldProcessVariables) {
                    oldProcessVariableNames.add(flowVariables.getVariable());
                    if (oldTableName != null || flowVariables.getTable() == null) continue;
                    oldTableName = flowVariables.getTable();
                }
            }
            for (FlowObject flowObject : oldNodeMap.values()) {
                if (!CHECK_VARIABLE_NODE_TYPE_LIST.contains(flowObject.getName())) continue;
                nodeVariableNames = new HashSet();
                ArrayList<FlowVariables> functionUserVariables = new ArrayList<FlowVariables>();
                FormBpmnUtil.getFunctionMessage(flowObject.getProps(), new HashMap<String, String>(), functionUserVariables);
                ArrayList<FlowVariables> nodeVariables = flowObject.getProps().getUseVariables();
                if (nodeVariables == null) {
                    nodeVariables = new ArrayList<FlowVariables>();
                }
                nodeVariables.addAll(functionUserVariables);
                for (FlowVariables flowVariables : nodeVariables) {
                    nodeVariableNames.add(flowVariables.getVariable());
                    if (oldTableName != null || flowVariables.getTable() == null) continue;
                    oldTableName = flowVariables.getTable();
                }
                nodeVariableNames.addAll(oldProcessVariableNames);
                if (!nodeVariableNames.isEmpty()) {
                    oldNodeVariableMap.put(flowObject.getId(), nodeVariableNames);
                }
                if (!CALL_ACTIVITY.equals(flowObject.getName())) continue;
                oldCallActivityTables.put(flowObject.getId(), flowObject.getProps().getCallActivityTable() != null ? flowObject.getProps().getCallActivityTable().getTableId() : "");
            }
            if (newTableName != null && !newTableName.equals(oldTableName)) {
                result.setUserNewVariable(true);
                return result;
            }
            if (checkMap.get(checkType).contains(VARIABLE_CHECK)) {
                for (String nodeId : callActivityTables.keySet()) {
                    if (((String)callActivityTables.get(nodeId)).equals(oldCallActivityTables.get(nodeId))) continue;
                    result.setUserNewVariable(true);
                    return result;
                }
            }
            for (String nodeId : nodeVariableMap.keySet()) {
                if (this.bpmFormdesignProperties.getOfflineLr().booleanValue()) {
                    if (oldNodeVariableMap.get(nodeId) != null) continue;
                    result.setUserNewVariable(true);
                    return result;
                }
                nodeVariableNames = (Set)nodeVariableMap.get(nodeId);
                nodeVariableNames.removeAll(oldNodeVariableMap.get(nodeId) != null ? (Collection)oldNodeVariableMap.get(nodeId) : new HashSet());
                if (nodeVariableNames.isEmpty()) continue;
                result.setUserNewVariable(true);
                return result;
            }
        }
        return result;
    }

    private Map<String, Set<String>> getRunningNodeProcessCountMsg(String procDefId) {
        List list = this.runtimeService.createExecutionQuery().processDefinitionId(procDefId).list();
        HashMap<String, Set<String>> runningNodeProcessCountMsg = new HashMap<String, Set<String>>();
        for (Execution execution : list) {
            if (execution.getActivityId() == null) continue;
            runningNodeProcessCountMsg.computeIfAbsent(execution.getActivityId(), k -> new HashSet()).add(execution.getProcessInstanceId());
        }
        return runningNodeProcessCountMsg;
    }

    static {
        CHECK_VARIABLE_NODE_TYPE_LIST.add(USER_TASK);
        CHECK_VARIABLE_NODE_TYPE_LIST.add(CALL_ACTIVITY);
        CHECK_VARIABLE_NODE_TYPE_LIST.add(SUB_PROCESS);
        CHECK_CHANGE_NODE_TYPE_LIST.add(USER_TASK);
        CHECK_CHANGE_NODE_TYPE_LIST.add(CALL_ACTIVITY);
        CHECK_CHANGE_NODE_TYPE_LIST.add(SUB_PROCESS);
        HashSet<String> godAxeCheck = new HashSet<String>();
        godAxeCheck.add(VARIABLE_CHECK);
        godAxeCheck.add(PARALLEL_RELATIONSHIP_CHECK);
        godAxeCheck.add(RUNNING_TASK_CHANGE_CHECK);
        checkMap.put(GOD_AXE_CHECK, godAxeCheck);
        HashSet bpmDesignCheck = new HashSet();
        godAxeCheck.add(BPM_DESIGN_VARIABLE_CHECK);
        godAxeCheck.add(PARALLEL_RELATIONSHIP_CHECK);
        godAxeCheck.add(RUNNING_TASK_CHANGE_CHECK);
        checkMap.put(BPM_DESIGNER_CHECK, godAxeCheck);
        HashSet<String> noCodeCheck = new HashSet<String>();
        noCodeCheck.add(PARALLEL_RELATIONSHIP_CHECK);
        noCodeCheck.add(RUNNING_TASK_CHANGE_CHECK);
        checkMap.put(NO_CODE_CHECK, noCodeCheck);
        HashSet<String> importCheck = new HashSet<String>();
        importCheck.add(PARALLEL_RELATIONSHIP_CHECK);
        importCheck.add(RUNNING_TASK_CHANGE_CHECK);
        checkMap.put(IMPORT_CHECK, importCheck);
    }
}

