/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.workflow.assignee.dto.AssigneeChooseDto;
import com.jxdinfo.hussar.workflow.assignee.model.AssigneeManageInfoVo;
import com.jxdinfo.hussar.workflow.assignee.model.BpmTreeModel;
import com.jxdinfo.hussar.workflow.assignee.model.BpmUserInfoVo;
import com.jxdinfo.hussar.workflow.assignee.model.GetListInfoVo;
import com.jxdinfo.hussar.workflow.assignee.model.OrganUserTree;
import com.jxdinfo.hussar.workflow.assignee.service.IWorkflowAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.model.AssigneeQueryModel;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.visitor.AssigneeVisitor;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.visitor.AssigneeVisitorBeanUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.assigneemode.service.IAssigneeModeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.bpmconfig.service.IBpmConfigService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.NodeAssigneeQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.function.model.SysActFunction;
import com.jxdinfo.hussar.workflow.engine.bpm.function.service.ISysActFunctionService;
import com.jxdinfo.hussar.workflow.engine.bpm.httpclient.HttpClient;
import com.jxdinfo.hussar.workflow.engine.bpm.model.dao.ModelMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.tenant.model.SysUser;
import com.jxdinfo.hussar.workflow.engine.bpm.tenant.service.ISysUserService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import com.jxdinfo.hussar.workflow.outside.assignee.service.AssigneeChooseService;
import com.jxdinfo.hussar.workflow.outside.assigneefunction.service.AssigneeFunctionService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.activiti.engine.HistoryService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.impl.identity.Authentication;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.TaskStateType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class AssigneeChooseServiceImpl
implements IAssigneeChooseService {
    @Autowired
    private LcdpBpmProperties lcdpBpmProperties;
    @Autowired
    private BpmConstantProperties bpmConstantProperties;
    @Autowired
    private IAssigneeModeChooseService assigneeModeChooseService;
    @Autowired
    private ISysActFunctionService sysActFunctionService;
    @Lazy
    @Autowired
    private HistoryService historyService;
    @Resource
    private ModelMapper modelMapper;
    @Autowired
    IWorkflowAssigneeChooseService workflowAssigneeChooseService;
    @Autowired
    private ISysUserService sysUserService;
    private final IBpmConfigService bpmConfigService;
    private static Logger logger = LogManager.getLogger(AssigneeChooseServiceImpl.class);
    private static final Pattern REGEX = Pattern.compile("\\@\\{([^@]|[^}]\\@)*\\}\\@");
    private static final String MICRO = "micro";
    private static final String WORKFLOW_PLATFORM = "workflow-platform";
    private static final String SINGLE = "single";
    private static final String TABLE_PREFIX = "table_prefix";
    public static final BpmTreeModel USER_NODE = new BpmTreeModel("999", "10000", "\u672a\u5173\u8054\u7ec4\u7ec7\u7528\u6237", "organ", false, false, "9999", null, null);
    public static final BpmTreeModel LEAF_USER_NODE = new BpmTreeModel("999", "10000", "\u672a\u5173\u8054\u7ec4\u7ec7\u7528\u6237", "organ", true, false, "9999", null, null);
    public static final BpmTreeModel LEAF_POST_NODE = new BpmTreeModel("1000", "10000", "\u672a\u5173\u8054\u7ec4\u7ec7\u5c97\u4f4d", "organ", true, false, "10000", null, null);

    public AssigneeChooseServiceImpl(IBpmConfigService bpmConfigService) {
        this.bpmConfigService = bpmConfigService;
    }

    private String getDeploymentModel() {
        return this.lcdpBpmProperties.getDeploymentModel();
    }

    private String getTablePrefix() {
        return this.bpmConfigService.getStringByKeyUseCache(TABLE_PREFIX);
    }

    public List<BpmTreeModel> userTree(String id, boolean isMainPost) {
        String deploymentModel = this.getDeploymentModel();
        String tablePrefix = this.getTablePrefix();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.userTree(id, isMainPost, tablePrefix);
                }
                case "micro": {
                    AssigneeChooseService remoteAssigneeChooseService = (AssigneeChooseService)SpringContextHolder.getApplicationContext().getBean(AssigneeChooseService.class);
                    AssigneeQueryModel assigneeQueryModel = new AssigneeQueryModel();
                    if (id == null) {
                        id = "10000";
                    }
                    assigneeQueryModel.setId(id);
                    assigneeQueryModel.setIsMainPost(isMainPost);
                    assigneeQueryModel.setTablePrefix(tablePrefix);
                    return remoteAssigneeChooseService.userTree(assigneeQueryModel);
                }
            }
            return this.assigneeModeChooseService.userTree(id, isMainPost, tablePrefix);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<OrganUserTree> userTreeForUserChoose(String id) {
        String deploymentModel = this.getDeploymentModel();
        String tablePrefix = this.getTablePrefix();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.userTreeForUserChoose(id, tablePrefix);
                }
                case "micro": {
                    AssigneeChooseService remoteAssigneeChooseService = (AssigneeChooseService)SpringContextHolder.getApplicationContext().getBean(AssigneeChooseService.class);
                    AssigneeQueryModel assigneeQueryModel = new AssigneeQueryModel();
                    assigneeQueryModel.setId(id);
                    assigneeQueryModel.setTablePrefix(tablePrefix);
                    return remoteAssigneeChooseService.userTreeForUserChoose(assigneeQueryModel);
                }
            }
            return this.assigneeModeChooseService.userTreeForUserChoose(id, tablePrefix);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public Page<OrganUserTree> queryUserTreeForUserChoose(Page<OrganUserTree> page, String organName) {
        String deploymentModel = this.getDeploymentModel();
        String tablePrefix = this.getTablePrefix();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.queryUserTreeForUserChoose(page, organName, tablePrefix);
                }
                case "micro": {
                    AssigneeChooseService remoteAssigneeChooseService = (AssigneeChooseService)SpringContextHolder.getApplicationContext().getBean(AssigneeChooseService.class);
                    AssigneeQueryModel assigneeQueryModel = new AssigneeQueryModel();
                    assigneeQueryModel.setName(organName);
                    assigneeQueryModel.setPage(page);
                    assigneeQueryModel.setTablePrefix(tablePrefix);
                    return remoteAssigneeChooseService.queryUserTreeForUserChoose(assigneeQueryModel);
                }
            }
            return this.assigneeModeChooseService.queryUserTreeForUserChoose(page, organName, tablePrefix);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<BpmTreeModel> postTree(String id, String postId, boolean isMainPost) {
        String deploymentModel = this.getDeploymentModel();
        String tablePrefix = this.getTablePrefix();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.postTree(id, postId, isMainPost, tablePrefix);
                }
                case "micro": {
                    AssigneeChooseService remoteAssigneeChooseService = (AssigneeChooseService)SpringContextHolder.getApplicationContext().getBean(AssigneeChooseService.class);
                    AssigneeQueryModel assigneeQueryModel = new AssigneeQueryModel();
                    if (id == null) {
                        id = "10000";
                    }
                    assigneeQueryModel.setId(id);
                    assigneeQueryModel.setPostId(postId);
                    assigneeQueryModel.setIsMainPost(isMainPost);
                    assigneeQueryModel.setTablePrefix(tablePrefix);
                    return remoteAssigneeChooseService.postTree(assigneeQueryModel);
                }
            }
            return this.assigneeModeChooseService.postTree(id, postId, isMainPost, tablePrefix);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<BpmTreeModel> deptTree(String id, String organId, boolean isInterface) {
        String deploymentModel = this.getDeploymentModel();
        String tablePrefix = this.getTablePrefix();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.deptTree(id, organId, tablePrefix);
                }
                case "micro": {
                    AssigneeChooseService remoteAssigneeChooseService = (AssigneeChooseService)SpringContextHolder.getApplicationContext().getBean(AssigneeChooseService.class);
                    AssigneeQueryModel assigneeQueryModel = new AssigneeQueryModel();
                    assigneeQueryModel.setId(id);
                    assigneeQueryModel.setOrganId(organId);
                    assigneeQueryModel.setTablePrefix(tablePrefix);
                    return remoteAssigneeChooseService.deptTree(assigneeQueryModel);
                }
            }
            return this.assigneeModeChooseService.deptTree(id, organId, tablePrefix);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<BpmTreeModel> roleTree(boolean isInterface) {
        String deploymentModel = this.getDeploymentModel();
        String tablePrefix = this.getTablePrefix();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.roleTree(tablePrefix);
                }
                case "micro": {
                    AssigneeChooseService remoteAssigneeChooseService = (AssigneeChooseService)SpringContextHolder.getApplicationContext().getBean(AssigneeChooseService.class);
                    AssigneeQueryModel assigneeQueryModel = new AssigneeQueryModel();
                    assigneeQueryModel.setTablePrefix(tablePrefix);
                    return remoteAssigneeChooseService.roleTreeWithOutId(assigneeQueryModel);
                }
            }
            return this.assigneeModeChooseService.roleTree(tablePrefix);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<BpmTreeModel> roleTree(String id, String roleId, boolean isInterface) {
        String deploymentModel = this.getDeploymentModel();
        String tablePrefix = this.getTablePrefix();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.roleTree(id, roleId, tablePrefix);
                }
                case "micro": {
                    AssigneeChooseService remoteAssigneeChooseService = (AssigneeChooseService)SpringContextHolder.getApplicationContext().getBean(AssigneeChooseService.class);
                    AssigneeQueryModel assigneeQueryModel = new AssigneeQueryModel();
                    assigneeQueryModel.setTablePrefix(tablePrefix);
                    assigneeQueryModel.setId(id);
                    assigneeQueryModel.setRoleId(roleId);
                    return remoteAssigneeChooseService.roleTree(assigneeQueryModel);
                }
            }
            return this.assigneeModeChooseService.roleTree(id, roleId, tablePrefix);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<BpmTreeModel> userDetail(List<String> userIds, boolean isInterface) {
        String deploymentModel = this.getDeploymentModel();
        String tablePrefix = this.getTablePrefix();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.userDetail(userIds, tablePrefix);
                }
                case "micro": {
                    AssigneeChooseService remoteAssigneeChooseService = (AssigneeChooseService)SpringContextHolder.getApplicationContext().getBean(AssigneeChooseService.class);
                    AssigneeQueryModel assigneeQueryModel = new AssigneeQueryModel();
                    assigneeQueryModel.setTablePrefix(tablePrefix);
                    assigneeQueryModel.setUsers(userIds);
                    return remoteAssigneeChooseService.userDetail(assigneeQueryModel);
                }
            }
            return this.assigneeModeChooseService.userDetail(userIds, tablePrefix);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    private List<BpmTreeModel> userDeptDetail(String userId, boolean isInterface) {
        String deploymentModel = this.getDeploymentModel();
        String tablePrefix = this.getTablePrefix();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.userDeptDetail(userId, tablePrefix);
                }
                case "micro": {
                    AssigneeChooseService remoteAssigneeChooseService = (AssigneeChooseService)SpringContextHolder.getApplicationContext().getBean(AssigneeChooseService.class);
                    AssigneeQueryModel assigneeQueryModel = new AssigneeQueryModel();
                    assigneeQueryModel.setTablePrefix(tablePrefix);
                    assigneeQueryModel.setUserId(userId);
                    return remoteAssigneeChooseService.userDeptDetail(assigneeQueryModel);
                }
            }
            return this.assigneeModeChooseService.userDeptDetail(userId, tablePrefix);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public String getUserNames(List<String> userIds) {
        StringBuilder result = new StringBuilder();
        List<BpmTreeModel> list = this.userDetail(userIds, false);
        if (list != null && !list.isEmpty()) {
            for (BpmTreeModel bpmTreeModel : list) {
                result.append(bpmTreeModel.getLabel()).append(",");
            }
            result = new StringBuilder(result.substring(0, result.length() - 1));
        }
        if ((list == null || list.size() < userIds.size()) && WORKFLOW_PLATFORM.equals(this.getDeploymentModel())) {
            HashMap<String, String> map = new HashMap<String, String>();
            List users = this.sysUserService.getSysUser();
            for (SysUser sysUser : users) {
                map.put(sysUser.getUserId(), sysUser.getUserName());
            }
            for (String userId : userIds) {
                String name = (String)map.get(userId);
                if (name == null) continue;
                if (list == null) {
                    result.append(name);
                    continue;
                }
                result.append(",").append(name);
            }
        }
        return result.toString();
    }

    public List<String> getEntrustUserNames(List<IdentityLink> userIds) {
        ArrayList<String> users = new ArrayList<String>();
        for (IdentityLink identityLink : userIds) {
            if (TaskStateType.isEntrust((IdentityLink)identityLink)) {
                users.add(identityLink.getUserId());
                users.add(identityLink.getMandator());
                continue;
            }
            users.add(identityLink.getUserId());
        }
        Map<String, String> map = this.getUserListByUserId(users);
        ArrayList<String> result = new ArrayList<String>();
        for (IdentityLink identityLink : userIds) {
            if (TaskStateType.isEntrust((IdentityLink)identityLink)) {
                result.add(map.get(identityLink.getUserId()) + "(" + map.get(identityLink.getMandator()) + ")");
                continue;
            }
            result.add(map.get(identityLink.getUserId()));
        }
        return result;
    }

    public List<Map<String, String>> getUserListByUserIdWithSelect(List<String> userList) {
        List<BpmTreeModel> list = this.userDetail(userList, true);
        ArrayList<Map<String, String>> resultList = new ArrayList<Map<String, String>>();
        if (list != null && !list.isEmpty()) {
            for (BpmTreeModel bpmTreeModel : list) {
                HashMap<String, String> mapSelect = new HashMap<String, String>(2);
                mapSelect.put("id", bpmTreeModel.getId());
                mapSelect.put("name", bpmTreeModel.getLabel());
                resultList.add(mapSelect);
            }
        }
        return resultList;
    }

    public Map<String, String> getUserListByUserId(List<String> userIds) {
        HashMap<String, String> map = new HashMap<String, String>();
        List<BpmTreeModel> list = this.userDetail(userIds, false);
        if (list != null && !list.isEmpty()) {
            for (BpmTreeModel bpmTreeModel : list) {
                map.put(bpmTreeModel.getId(), bpmTreeModel.getLabel());
            }
        }
        if ((list == null || list.size() < userIds.size()) && WORKFLOW_PLATFORM.equals(this.getDeploymentModel())) {
            List users = this.sysUserService.getSysUser();
            for (SysUser sysUser : users) {
                map.put(sysUser.getUserId(), sysUser.getUserName());
            }
        }
        return map;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> getCandidateUser(String condition, String processKey, Integer securityLevel, Map<String, String> processInfo) {
        if (!this.lcdpBpmProperties.isUseSecurityLevel()) {
            securityLevel = null;
        }
        if (!processInfo.containsKey("workflowStarterUserId") && processInfo.containsKey("workflowProcessInsId")) {
            historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInfo.get("workflowProcessInsId")).singleResult();
            if (historicProcessInstance != null) {
                processInfo.put("workflowStarterUserId", historicProcessInstance.getStartUserId());
                if (!processInfo.containsKey("workflowBusinessId")) {
                    processInfo.put("workflowBusinessId", historicProcessInstance.getBusinessKey());
                }
            } else {
                processInfo.put("workflowStarterUserId", Authentication.getAuthenticatedUserId());
            }
        }
        serviceName = null;
        deploymentModel = this.getDeploymentModel();
        if ("micro".equals(deploymentModel)) {
            serviceName = this.modelMapper.getServiceName(processKey);
        }
        tablePrefix = this.getTablePrefix();
        condition = this.getFunctionCondition(condition, processInfo, serviceName);
        var8_8 = deploymentModel;
        var9_10 = -1;
        switch (var8_8.hashCode()) {
            case -1663673663: {
                if (!var8_8.equals("workflow-platform")) break;
                var9_10 = 0;
                break;
            }
            case 103890628: {
                if (!var8_8.equals("micro")) break;
                var9_10 = 1;
                break;
            }
            case -902265784: {
                if (!var8_8.equals("single")) break;
                var9_10 = 2;
                break;
            }
        }
        switch (var9_10) {
            case 0: {
                return this.assigneeModeChooseService.getCandidateUsers(condition, securityLevel, tablePrefix);
            }
            case 1: {
                ** GOTO lbl46
            }
            default: {
                return this.assigneeModeChooseService.getCandidateUsers(condition, securityLevel, tablePrefix);
            }
        }
        {
            catch (Exception e) {
                e.printStackTrace();
                throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
            }
lbl46:
            // 1 sources

            try {
                assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                assigneeQueryModel = new AssigneeQueryModel();
                assigneeQueryModel.setTablePrefix(tablePrefix);
                assigneeQueryModel.setCondition(condition);
                assigneeQueryModel.setSecurityLevel(securityLevel);
                return assigneeChooseService.getCandidateUser(assigneeQueryModel);
            }
            catch (Exception e) {}
            {
                throw new PublicClientException(this.bpmConstantProperties.getErrorGetAssignee());
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<BpmTreeModel> getCandidateUserWithParent(String condition, String processKey, Integer securityLevel, Map<String, String> processInfo) {
        if (!this.lcdpBpmProperties.isUseSecurityLevel()) {
            securityLevel = null;
        }
        if (!processInfo.containsKey("workflowStarterUserId") && processInfo.containsKey("workflowProcessInsId")) {
            historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInfo.get("workflowProcessInsId")).singleResult();
            if (historicProcessInstance != null) {
                processInfo.put("workflowStarterUserId", historicProcessInstance.getStartUserId());
                if (!processInfo.containsKey("workflowBusinessId")) {
                    processInfo.put("workflowBusinessId", historicProcessInstance.getBusinessKey());
                }
            } else {
                processInfo.put("workflowStarterUserId", Authentication.getAuthenticatedUserId());
            }
        }
        serviceName = null;
        deploymentModel = this.getDeploymentModel();
        if ("micro".equals(deploymentModel)) {
            serviceName = this.modelMapper.getServiceName(processKey);
        }
        tablePrefix = this.getTablePrefix();
        condition = this.getFunctionCondition(condition, processInfo, serviceName);
        var8_8 = deploymentModel;
        var9_10 = -1;
        switch (var8_8.hashCode()) {
            case -1663673663: {
                if (!var8_8.equals("workflow-platform")) break;
                var9_10 = 0;
                break;
            }
            case 103890628: {
                if (!var8_8.equals("micro")) break;
                var9_10 = 1;
                break;
            }
            case -902265784: {
                if (!var8_8.equals("single")) break;
                var9_10 = 2;
                break;
            }
        }
        switch (var9_10) {
            case 0: {
                return this.assigneeModeChooseService.getCandidateUsersWithParent(condition, securityLevel, tablePrefix);
            }
            case 1: {
                ** GOTO lbl46
            }
            default: {
                return this.assigneeModeChooseService.getCandidateUsersWithParent(condition, securityLevel, tablePrefix);
            }
        }
        {
            catch (Exception e) {
                e.printStackTrace();
                throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
            }
lbl46:
            // 1 sources

            try {
                assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                assigneeQueryModel = new AssigneeQueryModel();
                assigneeQueryModel.setTablePrefix(tablePrefix);
                assigneeQueryModel.setCondition(condition);
                assigneeQueryModel.setSecurityLevel(securityLevel);
                return assigneeChooseService.getCandidateUserWithParent(assigneeQueryModel);
            }
            catch (Exception e) {}
            {
                throw new PublicClientException(this.bpmConstantProperties.getErrorGetAssignee());
            }
        }
    }

    private String getFunctionCondition(String realCondition, Map<String, String> processInfo, String serviceName) {
        if (realCondition.contains("@{")) {
            Matcher matcher = REGEX.matcher(realCondition);
            while (matcher.find()) {
                String message = matcher.group().substring(1, matcher.group().length() - 1);
                CharSequence[] messages = message.split(":");
                for (int j = 0; j < messages.length; ++j) {
                    String str = messages[j];
                    if (j != messages.length - 1) {
                        if (str.lastIndexOf("','") == str.indexOf("','")) continue;
                        str = str.replace("','", ",");
                        int num = str.lastIndexOf(44);
                        messages[j] = str.substring(0, num) + "','" + str.substring(num + 1);
                        continue;
                    }
                    messages[j] = str.replace("','", ",");
                }
                message = String.join((CharSequence)":", messages);
                List<String> userList = this.functionUser((Map)JSON.parse((String)message), processInfo, serviceName);
                StringBuilder users = new StringBuilder();
                String functionUsers = "";
                if (userList != null && !userList.isEmpty()) {
                    for (String user : userList) {
                        users.append(user).append("','");
                    }
                    functionUsers = users.toString().substring(0, users.toString().length() - 3);
                } else {
                    functionUsers = "";
                }
                realCondition = realCondition.replace(matcher.group(), functionUsers);
            }
        }
        return realCondition;
    }

    private List<String> functionUser(Map<String, Object> message, Map<String, String> processInfo, String serviceName) {
        String beanId = new ArrayList<String>(message.keySet()).get(0);
        if (beanId == null) {
            return new ArrayList<String>();
        }
        Map map = (Map)message.get(beanId);
        map.putAll(processInfo);
        SysActFunction function = this.sysActFunctionService.getFunctionByBeanId(beanId);
        if (HussarUtils.isEmpty((Object)function)) {
            throw new BpmException(BpmExceptionCodeEnum.ERROR_NO_EXIST_FUNCTION);
        }
        String functionType = function.getFunctionType();
        String requestMethod = function.getRequestMethod();
        String deploymentModel = this.getDeploymentModel();
        if (HussarUtils.isEmpty((Object)functionType) || "local".equals(functionType)) {
            switch (deploymentModel) {
                case "single": {
                    AssigneeVisitor hussarBpmVariablesVisitor;
                    try {
                        hussarBpmVariablesVisitor = AssigneeVisitorBeanUtil.getVisitorBean((String)beanId);
                    }
                    catch (NoSuchBeanDefinitionException e) {
                        return new ArrayList<String>();
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        return new ArrayList<String>();
                    }
                    return hussarBpmVariablesVisitor.visit(map);
                }
                case "micro": {
                    try {
                        AssigneeFunctionService assigneeFunctionService = (AssigneeFunctionService)SpringContextHolder.getBean(AssigneeFunctionService.class);
                        return assigneeFunctionService.executeListener(beanId, map, serviceName);
                    }
                    catch (NoSuchBeanDefinitionException e) {
                        return new ArrayList<String>();
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        return new ArrayList<String>();
                    }
                }
            }
            throw new BpmException(BpmExceptionCodeEnum.ERROR_FUNCTION_TYPE);
        }
        if ("remote".equals(functionType)) {
            String url = this.lcdpBpmProperties.getTenantCallAddress() + beanId;
            switch (requestMethod) {
                case "GET": {
                    String response = HttpClient.doGet((String)url, (Map)map);
                    return JSON.parseArray((String)response, String.class);
                }
                case "POST": {
                    String response = HttpClient.doPost((String)url, (String)JSON.toJSONString((Object)map));
                    return JSON.parseArray((String)response, String.class);
                }
            }
            throw new BpmException(BpmExceptionCodeEnum.ERROR_FUNCTION_REQUEST_METHOD);
        }
        throw new BpmException(BpmExceptionCodeEnum.ERROR_FUNCTION_TYPE);
    }

    public String getSameLevelDeptIdByUserId(String userId) {
        if (HussarUtils.isEmpty((Object)userId)) {
            return "";
        }
        String deploymentModel = this.getDeploymentModel();
        String tablePrefix = this.getTablePrefix();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.getSameLevelDeptIdByUserId(userId, tablePrefix);
                }
                case "micro": {
                    AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                    AssigneeQueryModel assigneeQueryModel = new AssigneeQueryModel();
                    assigneeQueryModel.setTablePrefix(tablePrefix);
                    assigneeQueryModel.setUserId(userId);
                    return assigneeChooseService.getSameLevelDeptIdByUserId(assigneeQueryModel);
                }
            }
            return this.assigneeModeChooseService.getSameLevelDeptIdByUserId(userId, tablePrefix);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public String getParentDeptIdByUserId(String userId) {
        if (HussarUtils.isEmpty((Object)userId)) {
            return "";
        }
        String deploymentModel = this.getDeploymentModel();
        String tablePrefix = this.getTablePrefix();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.getParentDeptIdByUserId(userId, tablePrefix);
                }
                case "micro": {
                    AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                    AssigneeQueryModel assigneeQueryModel = new AssigneeQueryModel();
                    assigneeQueryModel.setTablePrefix(tablePrefix);
                    assigneeQueryModel.setUserId(userId);
                    return assigneeChooseService.getParentDeptIdByUserId(assigneeQueryModel);
                }
            }
            return this.assigneeModeChooseService.getParentDeptIdByUserId(userId, tablePrefix);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public String getDeptIdByUserIds(String userId) {
        if (HussarUtils.isEmpty((Object)userId)) {
            return "";
        }
        String deploymentModel = this.getDeploymentModel();
        String tablePrefix = this.getTablePrefix();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.getDeptIdByUserIds(userId, tablePrefix);
                }
                case "micro": {
                    AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                    AssigneeQueryModel assigneeQueryModel = new AssigneeQueryModel();
                    assigneeQueryModel.setTablePrefix(tablePrefix);
                    assigneeQueryModel.setUserId(userId);
                    return assigneeChooseService.getDeptIdByUserIds(assigneeQueryModel);
                }
            }
            return this.assigneeModeChooseService.getDeptIdByUserIds(userId, tablePrefix);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public String getSameLevelDeptIdByUserIds(String userId) {
        if (HussarUtils.isEmpty((Object)userId)) {
            return "";
        }
        String deploymentModel = this.getDeploymentModel();
        String tablePrefix = this.getTablePrefix();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.getSameLevelDeptIdByUserIds(userId, tablePrefix);
                }
                case "micro": {
                    AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                    AssigneeQueryModel assigneeQueryModel = new AssigneeQueryModel();
                    assigneeQueryModel.setTablePrefix(tablePrefix);
                    assigneeQueryModel.setUserId(userId);
                    return assigneeChooseService.getSameLevelDeptIdByUserIds(assigneeQueryModel);
                }
            }
            return this.assigneeModeChooseService.getSameLevelDeptIdByUserIds(userId, tablePrefix);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public String getParentDeptIdByUserIds(String userId) {
        if (HussarUtils.isEmpty((Object)userId)) {
            return "";
        }
        String deploymentModel = this.getDeploymentModel();
        String tablePrefix = this.getTablePrefix();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.getParentDeptIdByUserIds(userId, tablePrefix);
                }
                case "micro": {
                    AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                    AssigneeQueryModel assigneeQueryModel = new AssigneeQueryModel();
                    assigneeQueryModel.setTablePrefix(tablePrefix);
                    assigneeQueryModel.setUserId(userId);
                    return assigneeChooseService.getParentDeptIdByUserIds(assigneeQueryModel);
                }
            }
            return this.assigneeModeChooseService.getParentDeptIdByUserIds(userId, tablePrefix);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public Integer getSecurityLevel(String userId, String url) {
        String deploymentModel = this.getDeploymentModel();
        String tablePrefix = this.getTablePrefix();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.getSecurityLevel(userId, tablePrefix);
                }
                case "micro": {
                    AssigneeChooseService remoteAssigneeChooseService = (AssigneeChooseService)SpringContextHolder.getApplicationContext().getBean(AssigneeChooseService.class);
                    AssigneeQueryModel assigneeQueryModel = new AssigneeQueryModel();
                    assigneeQueryModel.setTablePrefix(tablePrefix);
                    assigneeQueryModel.setUserId(userId);
                    return Integer.valueOf(remoteAssigneeChooseService.getSecurityLevel(assigneeQueryModel));
                }
            }
            return this.assigneeModeChooseService.getSecurityLevel(userId, tablePrefix);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public String getStarterDept(String userId) {
        if (HussarUtils.isEmpty((Object)userId)) {
            return null;
        }
        List<BpmTreeModel> list = this.userDeptDetail(userId, true);
        StringBuilder stringBuilder = new StringBuilder();
        for (BpmTreeModel bpmTreeModel : list) {
            if (bpmTreeModel.getParentId() == null) continue;
            stringBuilder.append(",").append(bpmTreeModel.getParentId());
        }
        String result = stringBuilder.toString();
        if (result.length() > 0) {
            result = result.substring(1);
        }
        return result;
    }

    public List<BpmTreeModel> queryDeptTreeByDeptName(String organName) {
        if (HussarUtils.isEmpty((Object)organName)) {
            return new ArrayList<BpmTreeModel>();
        }
        String deploymentModel = this.getDeploymentModel();
        String tablePrefix = this.getTablePrefix();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.queryDeptTreeByDeptName(organName, tablePrefix);
                }
                case "micro": {
                    AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                    AssigneeQueryModel assigneeQueryModel = new AssigneeQueryModel();
                    assigneeQueryModel.setTablePrefix(tablePrefix);
                    assigneeQueryModel.setName(organName);
                    return assigneeChooseService.queryDeptTreeByDeptName(assigneeQueryModel);
                }
            }
            return this.assigneeModeChooseService.queryDeptTreeByDeptName(organName, tablePrefix);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<BpmTreeModel> queryUserTreeByUserName(String organName) {
        if (HussarUtils.isEmpty((Object)organName)) {
            return new ArrayList<BpmTreeModel>();
        }
        String deploymentModel = this.getDeploymentModel();
        String tablePrefix = this.getTablePrefix();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.queryUserTreeByUserName(organName, tablePrefix);
                }
                case "micro": {
                    AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                    AssigneeQueryModel assigneeQueryModel = new AssigneeQueryModel();
                    assigneeQueryModel.setTablePrefix(tablePrefix);
                    assigneeQueryModel.setName(organName);
                    return assigneeChooseService.queryUserTreeByUserName(assigneeQueryModel);
                }
            }
            return this.assigneeModeChooseService.queryUserTreeByUserName(organName, tablePrefix);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<BpmTreeModel> queryPostTreeByPostName(String postName) {
        if (HussarUtils.isEmpty((Object)postName)) {
            return new ArrayList<BpmTreeModel>();
        }
        String deploymentModel = this.getDeploymentModel();
        String tablePrefix = this.getTablePrefix();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.queryPostTreeByPostName(postName, tablePrefix);
                }
                case "micro": {
                    AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                    AssigneeQueryModel assigneeQueryModel = new AssigneeQueryModel();
                    assigneeQueryModel.setTablePrefix(tablePrefix);
                    assigneeQueryModel.setName(postName);
                    return assigneeChooseService.queryPostTreeByPostName(assigneeQueryModel);
                }
            }
            return this.assigneeModeChooseService.queryPostTreeByPostName(postName, tablePrefix);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<BpmTreeModel> queryUserListByUserName(String organName) {
        if (HussarUtils.isEmpty((Object)organName)) {
            return new ArrayList<BpmTreeModel>();
        }
        String deploymentModel = this.getDeploymentModel();
        String tablePrefix = this.getTablePrefix();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.queryUserListByUserName(organName, tablePrefix);
                }
                case "micro": {
                    AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                    AssigneeQueryModel assigneeQueryModel = new AssigneeQueryModel();
                    assigneeQueryModel.setTablePrefix(tablePrefix);
                    assigneeQueryModel.setName(organName);
                    return assigneeChooseService.queryUserListByUserName(assigneeQueryModel);
                }
            }
            return this.assigneeModeChooseService.queryUserListByUserName(organName, tablePrefix);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<BpmTreeModel> queryRoleTreeByRoleName(String roleName) {
        if (HussarUtils.isEmpty((Object)roleName)) {
            return new ArrayList<BpmTreeModel>();
        }
        String deploymentModel = this.getDeploymentModel();
        String tablePrefix = this.getTablePrefix();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.queryRoleTreeByRoleName(roleName, tablePrefix);
                }
                case "micro": {
                    AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                    AssigneeQueryModel assigneeQueryModel = new AssigneeQueryModel();
                    assigneeQueryModel.setTablePrefix(tablePrefix);
                    assigneeQueryModel.setName(roleName);
                    return assigneeChooseService.queryRoleTreeByRoleName(assigneeQueryModel);
                }
            }
            return this.assigneeModeChooseService.queryRoleTreeByRoleName(roleName, tablePrefix);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<BpmTreeModel> queryUserTree(String organName) {
        if (HussarUtils.isEmpty((Object)organName)) {
            return new ArrayList<BpmTreeModel>();
        }
        String deploymentModel = this.getDeploymentModel();
        String tablePrefix = this.getTablePrefix();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.queryUserTree(organName, tablePrefix);
                }
                case "micro": {
                    AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                    AssigneeQueryModel assigneeQueryModel = new AssigneeQueryModel();
                    assigneeQueryModel.setTablePrefix(tablePrefix);
                    assigneeQueryModel.setName(organName);
                    return assigneeChooseService.queryUserTree(assigneeQueryModel);
                }
            }
            return this.assigneeModeChooseService.queryUserTree(organName, tablePrefix);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public Page<BpmTreeModel> queryUserTreeByPage(Page<BpmTreeModel> pages, String organName) {
        String deploymentModel = this.getDeploymentModel();
        String tablePrefix = this.getTablePrefix();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.queryUserTreeByPage(pages, organName, tablePrefix);
                }
                case "micro": {
                    AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                    AssigneeQueryModel assigneeQueryModel = new AssigneeQueryModel();
                    assigneeQueryModel.setTablePrefix(tablePrefix);
                    assigneeQueryModel.setName(organName);
                    assigneeQueryModel.setPage(pages);
                    return assigneeChooseService.queryUserTreeByPage(assigneeQueryModel);
                }
            }
            return this.assigneeModeChooseService.queryUserTreeByPage(pages, organName, tablePrefix);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public Page<BpmTreeModel> queryUserListByPage(Page<BpmTreeModel> pages, BpmTreeModel bpmTreeModel) {
        String deploymentModel = this.getDeploymentModel();
        String tablePrefix = this.getTablePrefix();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.queryUserListByPage(pages, bpmTreeModel.getId(), bpmTreeModel.getType(), tablePrefix);
                }
                case "micro": {
                    AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                    AssigneeQueryModel assigneeQueryModel = new AssigneeQueryModel();
                    assigneeQueryModel.setTablePrefix(tablePrefix);
                    assigneeQueryModel.setId(bpmTreeModel.getId());
                    assigneeQueryModel.setType(bpmTreeModel.getType());
                    assigneeQueryModel.setPage(pages);
                    return assigneeChooseService.queryUserListByPage(assigneeQueryModel);
                }
            }
            return this.assigneeModeChooseService.queryUserListByPage(pages, bpmTreeModel.getId(), bpmTreeModel.getType(), tablePrefix);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<BpmTreeModel> queryDeptTreeByChildren(BpmTreeModel bpmTreeModel) {
        String deploymentModel = this.getDeploymentModel();
        String tablePrefix = this.getTablePrefix();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.queryDeptTreeByChildren(bpmTreeModel, tablePrefix);
                }
                case "micro": {
                    AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                    AssigneeQueryModel assigneeQueryModel = new AssigneeQueryModel();
                    assigneeQueryModel.setTablePrefix(tablePrefix);
                    assigneeQueryModel.setBpmTreeModel(bpmTreeModel);
                    return assigneeChooseService.queryDeptTreeByChildren(assigneeQueryModel);
                }
            }
            return this.assigneeModeChooseService.queryDeptTreeByChildren(bpmTreeModel, tablePrefix);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<BpmTreeModel> queryAssigneeAndDept(List<String> users, String organName) {
        String deploymentModel = this.getDeploymentModel();
        String tablePrefix = this.getTablePrefix();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.queryAssigneeAndDept(users, organName, tablePrefix);
                }
                case "micro": {
                    AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                    AssigneeQueryModel assigneeQueryModel = new AssigneeQueryModel();
                    assigneeQueryModel.setTablePrefix(tablePrefix);
                    assigneeQueryModel.setUsers(users);
                    assigneeQueryModel.setName(organName);
                    return assigneeChooseService.queryAssigneeAndDept(assigneeQueryModel);
                }
            }
            return this.assigneeModeChooseService.queryAssigneeAndDept(users, organName, tablePrefix);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public Page<BpmTreeModel> queryNodeAssigneeListByPage(Page<BpmTreeModel> pages, List<String> users, NodeAssigneeQueryDto nodeAssigneeQueryDto) {
        String organId = nodeAssigneeQueryDto.getId();
        String type = nodeAssigneeQueryDto.getType();
        String deploymentModel = this.getDeploymentModel();
        String tablePrefix = this.getTablePrefix();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.queryNodeAssigneeListByPage(pages, users, organId, type, tablePrefix);
                }
                case "micro": {
                    AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                    AssigneeQueryModel assigneeQueryModel = new AssigneeQueryModel();
                    assigneeQueryModel.setTablePrefix(tablePrefix);
                    assigneeQueryModel.setUserId(JSON.toJSONString(users));
                    assigneeQueryModel.setPage(pages);
                    assigneeQueryModel.setOrganId(organId);
                    assigneeQueryModel.setType(type);
                    return assigneeChooseService.queryNodeAssigneeListWithPage(assigneeQueryModel);
                }
            }
            return this.assigneeModeChooseService.queryNodeAssigneeListByPage(pages, users, organId, type, tablePrefix);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public Page<BpmTreeModel> queryNodeAssigneeListWithParentByPage(Page<BpmTreeModel> pages, List<BpmTreeModel> users, NodeAssigneeQueryDto nodeAssigneeQueryDto) {
        String organId = nodeAssigneeQueryDto.getId();
        String type = nodeAssigneeQueryDto.getType();
        String organName = nodeAssigneeQueryDto.getOrganName();
        String deploymentModel = this.getDeploymentModel();
        String tablePrefix = this.getTablePrefix();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.queryNodeAssigneeListWithParentByPage(pages, users, organId, type, organName, tablePrefix);
                }
                case "micro": {
                    AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                    AssigneeQueryModel assigneeQueryModel = new AssigneeQueryModel();
                    assigneeQueryModel.setTablePrefix(tablePrefix);
                    assigneeQueryModel.setUserId(JSON.toJSONString(users));
                    assigneeQueryModel.setPage(pages);
                    assigneeQueryModel.setOrganId(organId);
                    assigneeQueryModel.setType(type);
                    assigneeQueryModel.setName(organName);
                    return assigneeChooseService.queryNodeAssigneeListWithParentByPage(assigneeQueryModel);
                }
            }
            return this.assigneeModeChooseService.queryNodeAssigneeListWithParentByPage(pages, users, organId, type, organName, tablePrefix);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public IPage<BpmTreeModel> queryNodeAssigneeListWithPage(Page<BpmTreeModel> pages, List<String> users, NodeAssigneeQueryDto nodeAssigneeQueryDto) {
        String organId = nodeAssigneeQueryDto.getId();
        String organName = nodeAssigneeQueryDto.getOrganName();
        String type = nodeAssigneeQueryDto.getType();
        String deploymentModel = this.getDeploymentModel();
        String tablePrefix = this.getTablePrefix();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.queryNodeAssigneeListWithPage(pages, users, organId, organName, type, tablePrefix);
                }
                case "micro": {
                    AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                    AssigneeQueryModel assigneeQueryModel = new AssigneeQueryModel();
                    assigneeQueryModel.setTablePrefix(tablePrefix);
                    assigneeQueryModel.setUserId(JSON.toJSONString(users));
                    assigneeQueryModel.setPage(pages);
                    assigneeQueryModel.setOrganId(organId);
                    assigneeQueryModel.setType(type);
                    assigneeQueryModel.setName(organName);
                    return assigneeChooseService.queryNodeAssigneeListWithPage(assigneeQueryModel);
                }
            }
            return this.assigneeModeChooseService.queryNodeAssigneeListWithPage(pages, users, organId, organName, type, tablePrefix);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<AssigneeChooseDto> getUserAndAccountListByUserId(List<String> userIds) {
        String deploymentModel = this.getDeploymentModel();
        String tablePrefix = this.getTablePrefix();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.getUserAndAccountListByUserId(userIds, tablePrefix);
                }
                case "micro": {
                    AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                    AssigneeQueryModel assigneeQueryModel = new AssigneeQueryModel();
                    assigneeQueryModel.setTablePrefix(tablePrefix);
                    assigneeQueryModel.setUsers(userIds);
                    return assigneeChooseService.getUserAndAccountListByUserId(assigneeQueryModel);
                }
            }
            return this.assigneeModeChooseService.getUserAndAccountListByUserId(userIds, tablePrefix);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<BpmUserInfoVo> getUserMsgByUserIds(List<String> userIds) {
        if (HussarUtils.isEmpty(userIds)) {
            return new ArrayList<BpmUserInfoVo>();
        }
        String deploymentModel = this.getDeploymentModel();
        String tablePrefix = this.getTablePrefix();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.getUserMsgByUserIds(userIds, tablePrefix);
                }
                case "micro": {
                    AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                    AssigneeQueryModel assigneeQueryModel = new AssigneeQueryModel();
                    assigneeQueryModel.setTablePrefix(tablePrefix);
                    assigneeQueryModel.setUsers(userIds);
                    return assigneeChooseService.getUserMsgByUserIds(assigneeQueryModel);
                }
            }
            return this.assigneeModeChooseService.getUserMsgByUserIds(userIds, tablePrefix);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public Page<BpmUserInfoVo> queryList(Page<BpmUserInfoVo> page, GetListInfoVo getListDto) {
        String deploymentModel = this.getDeploymentModel();
        String tablePrefix = this.getTablePrefix();
        switch (deploymentModel) {
            case "workflow-platform": {
                return this.assigneeModeChooseService.queryList(page, getListDto, tablePrefix);
            }
            case "micro": {
                AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                AssigneeQueryModel assigneeQueryModel = new AssigneeQueryModel();
                assigneeQueryModel.setTablePrefix(tablePrefix);
                assigneeQueryModel.setGetListInfoVo(getListDto);
                assigneeQueryModel.setCurrent(Long.valueOf(page.getCurrent()));
                assigneeQueryModel.setSize(Long.valueOf(page.getSize()));
                return assigneeChooseService.queryList(assigneeQueryModel);
            }
        }
        return this.assigneeModeChooseService.queryList(page, getListDto, tablePrefix);
    }

    public List<AssigneeManageInfoVo> queryDept(String name) {
        String deploymentModel = this.getDeploymentModel();
        String tablePrefix = this.getTablePrefix();
        switch (deploymentModel) {
            case "workflow-platform": {
                return this.assigneeModeChooseService.queryDept(name, tablePrefix);
            }
            case "micro": {
                AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                AssigneeQueryModel assigneeQueryModel = new AssigneeQueryModel();
                assigneeQueryModel.setTablePrefix(tablePrefix);
                assigneeQueryModel.setName(name);
                return assigneeChooseService.queryDept(assigneeQueryModel);
            }
        }
        return this.assigneeModeChooseService.queryDept(name, tablePrefix);
    }

    public List<AssigneeManageInfoVo> queryRole(String name) {
        String deploymentModel = this.getDeploymentModel();
        String tablePrefix = this.getTablePrefix();
        switch (deploymentModel) {
            case "workflow-platform": {
                return this.assigneeModeChooseService.queryRole(name, tablePrefix);
            }
            case "micro": {
                AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                AssigneeQueryModel assigneeQueryModel = new AssigneeQueryModel();
                assigneeQueryModel.setTablePrefix(tablePrefix);
                assigneeQueryModel.setName(name);
                return assigneeChooseService.queryRole(assigneeQueryModel);
            }
        }
        return this.assigneeModeChooseService.queryRole(name, tablePrefix);
    }

    public List<AssigneeManageInfoVo> queryPost(String name) {
        String deploymentModel = this.getDeploymentModel();
        String tablePrefix = this.getTablePrefix();
        switch (deploymentModel) {
            case "workflow-platform": {
                return this.assigneeModeChooseService.queryPost(name, tablePrefix);
            }
            case "micro": {
                AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                AssigneeQueryModel assigneeQueryModel = new AssigneeQueryModel();
                assigneeQueryModel.setTablePrefix(tablePrefix);
                assigneeQueryModel.setName(name);
                return assigneeChooseService.queryPost(assigneeQueryModel);
            }
        }
        return this.assigneeModeChooseService.queryPost(name, tablePrefix);
    }

    public String queryPlatformModel() {
        String deploymentModel = this.getDeploymentModel();
        if (WORKFLOW_PLATFORM.equals(deploymentModel)) {
            return this.lcdpBpmProperties.getAssigneeMode();
        }
        return deploymentModel;
    }
}

